from enum import IntEnum


class ProjectStatus(IntEnum):
    """项目状态枚举

    用于表示项目的当前状态：
    - ACTIVE(1): 活跃状态，项目可以正常使用
    - ARCHIVED(2): 已归档，项目暂时不可用
    - DELETED(3): 已删除，项目不可恢复
    """

    ACTIVE = 1
    ARCHIVED = 2
    DELETED = 3


class ModelStatus(IntEnum):
    """模型状态枚举

    用于表示模型的当前状态：
    - DRAFT(1): 草稿状态，模型刚创建
    - TRAINING(2): 训练中，模型正在进行训练
    - VALIDATING(3): 验证中，模型正在进行验证
    - READY(4): 就绪状态，模型可以使用
    - FAILED(5): 失败状态，模型训练或验证失败
    - ARCHIVED(6): 已归档，模型暂时不可用
    """

    DRAFT = 1
    TRAINING = 2
    VALIDATING = 3
    READY = 4
    FAILED = 5
    ARCHIVED = 6


class DatasetStatus(IntEnum):
    """数据集状态枚举

    用于表示数据集的当前状态：
    - PROCESSING(1): 处理中，数据集正在处理或转换
    - READY(2): 就绪状态，数据集可以使用
    - FAILED(3): 失败状态，数据集处理失败
    - ARCHIVED(4): 已归档，数据集暂时不可用
    """

    PROCESSING = 1
    READY = 2
    FAILED = 3
    ARCHIVED = 4


class TaskStatus(IntEnum):
    """任务状态枚举

    用于表示任务的当前状态：
    - PENDING(1): 等待中，任务已创建但未开始
    - RUNNING(2): 运行中，任务正在执行
    - COMPLETED(3): 已完成，任务成功完成
    - FAILED(4): 失败状态，任务执行失败
    - CANCELLED(5): 已取消，任务被手动取消
    """

    PENDING = 1
    RUNNING = 2
    COMPLETED = 3
    FAILED = 4
    CANCELLED = 5


class TaskType(IntEnum):
    """任务类型枚举

    用于表示任务的类型：
    - TRAINING(1): 训练任务，用于模型训练
    - VALIDATION(2): 验证任务，用于模型验证
    - INFERENCE(3): 推理任务，用于模型预测
    - EXPORT(4): 导出任务，用于模型格式转换
    """

    TRAINING = 1
    VALIDATION = 2
    INFERENCE = 3
    EXPORT = 4


class ModelFormat(IntEnum):
    """模型格式枚举

    用于表示模型的存储格式：
    - PYTORCH(1): PyTorch 原生格式
    - ONNX(2): Open Neural Network Exchange 格式
    - TENSORRT(3): NVIDIA TensorRT 格式
    - TORCHSCRIPT(4): PyTorch TorchScript 格式
    """

    PYTORCH = 1
    ONNX = 2
    TENSORRT = 3
    TORCHSCRIPT = 4


class ModelType(IntEnum):
    """模型类型枚举

    用于表示模型的用途类型：
    - CLASSIFICATION(1): 分类模型，用于图像分类
    - DETECTION(2): 检测模型，用于目标检测
    - SEGMENTATION(3): 分割模型，用于图像分割
    - POSE(4): 姿态模型，用于姿态估计
    - TRACKING(5): 跟踪模型，用于目标跟踪
    """

    CLASSIFICATION = 1
    DETECTION = 2
    SEGMENTATION = 3
    POSE = 4
    TRACKING = 5


class ComputeNodeStatus(IntEnum):
    """计算节点状态枚举

    用于表示计算节点的当前状态：
    - ONLINE(1): 在线状态，节点可以接收任务
    - OFFLINE(2): 离线状态，节点不可用
    - BUSY(3): 忙碌状态，节点正在处理任务
    - ERROR(4): 错误状态，节点出现异常
    """

    ONLINE = 1
    OFFLINE = 2
    BUSY = 3
    ERROR = 4


class ComputeNodeType(IntEnum):
    """计算节点类型枚举

    用于表示计算节点的硬件类型：
    - CPU(1): CPU 计算节点
    - GPU(2): GPU 计算节点
    - TPU(3): TPU 计算节点
    - NPU(4): NPU 计算节点
    """

    CPU = 1
    GPU = 2
    TPU = 3
    NPU = 4


class ModelExportStatus(IntEnum):
    """模型导出状态枚举

    用于表示模型导出任务的当前状态：
    - PENDING(1): 等待中，导出任务已创建但未开始
    - PROCESSING(2): 处理中，正在转换模型格式
    - COMPLETED(3): 已完成，模型导出成功
    - FAILED(4): 失败状态，模型导出失败
    """

    PENDING = 1
    PROCESSING = 2
    COMPLETED = 3
    FAILED = 4


class PipelineStepType(IntEnum):
    """管道步骤类型枚举

    用于表示管道中的步骤类型：
    - INPUT(1): 输入步骤，数据源或输入流
    """

    INPUT = 1
