# app/system/urls.py

from fastapi import APIRouter

from algo_flow.app.system.views.auth import auth_router
from algo_flow.app.system.views.file import router as file_router
from algo_flow.app.system.views.menu import menu_router
from algo_flow.app.system.views.permission import permission_router
from algo_flow.app.system.views.role import role_router
from algo_flow.app.system.views.user import user_router
from algo_flow.app.system.views.user_me import user_me_router

router = APIRouter()
router.include_router(auth_router, prefix="/auth", tags=["系统/授权"])
router.include_router(user_me_router, prefix="/users/me", tags=["系统/用户/我的"])
router.include_router(user_router, prefix="/users", tags=["系统/用户"])
router.include_router(role_router, prefix="/roles", tags=["系统/角色"])
router.include_router(permission_router, prefix="/permissions", tags=["系统/权限"])
router.include_router(menu_router, prefix="/menus", tags=["系统/菜单"])
router.include_router(file_router, prefix="/files", tags=["文件管理"])
