from datetime import datetime
from typing import List, Optional
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field


class MenuBase(BaseModel):
    """菜单基础模型"""

    name: str = Field(..., description="菜单名称", min_length=1, max_length=50)
    path: str = Field(..., description="菜单路径", min_length=1, max_length=50)
    component: str = Field(..., description="组件路径", max_length=50)
    locale: Optional[str] = Field(None, description="国际化", max_length=50)
    icon: Optional[str] = Field(None, description="图标", max_length=50)
    requires_auth: bool = Field(default=False, description="是否需要权限")
    order: int = Field(default=0, description="排序")
    hide_in_menu: bool = Field(default=False, description="是否隐藏在菜单中")
    hide_children_in_menu: bool = Field(default=False, description="是否隐藏子菜单")
    no_affix: bool = Field(default=False, description="是否不固定在标签栏")
    ignore_cache: bool = Field(default=False, description="是否不缓存")
    parent_id: Optional[UUID] = Field(None, description="父菜单ID")


class MenuCreate(MenuBase):
    """菜单创建模型"""

    pass


class MenuUpdate(BaseModel):
    """菜单更新模型"""

    name: Optional[str] = Field(None, description="菜单名称", min_length=1, max_length=50)
    path: Optional[str] = Field(None, description="菜单路径", min_length=1, max_length=50)
    component: Optional[str] = Field(None, description="组件路径", max_length=50)
    locale: Optional[str] = Field(None, description="国际化", max_length=50)
    icon: Optional[str] = Field(None, description="图标", max_length=50)
    requires_auth: Optional[bool] = Field(None, description="是否需要权限")
    order: Optional[int] = Field(None, description="排序")
    hide_in_menu: Optional[bool] = Field(None, description="是否隐藏在菜单中")
    hide_children_in_menu: Optional[bool] = Field(None, description="是否隐藏子菜单")
    no_affix: Optional[bool] = Field(None, description="是否不固定在标签栏")
    ignore_cache: Optional[bool] = Field(None, description="是否不缓存")
    parent_id: Optional[UUID] = Field(None, description="父菜单ID")


class MenuResponse(MenuBase):
    """菜单响应模型"""

    id: UUID = Field(..., description="权限ID")
    created_at: Optional[datetime] = Field(..., description="创建时间")
    updated_at: Optional[datetime] = Field(..., description="更新时间")
    children: Optional[List["MenuResponse"]] = None

    model_config = ConfigDict(from_attributes=True)


class MenuList(BaseModel):
    """菜单列表模型"""

    total: int = Field(..., description="总数")
    items: list[MenuResponse] = Field(..., description="菜单列表")

    model_config = ConfigDict(from_attributes=True)


MenuResponse.model_rebuild()
