from datetime import datetime
from typing import Any, List, Optional
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field


class ConfigBase(BaseModel):
    """配置基础模型"""

    name: str = Field(..., description="配置名称", min_length=1, max_length=100)
    description: Optional[str] = Field(None, description="配置描述")
    value: Any = Field(..., description="配置值")
    type: str = Field(..., description="配置类型")


class ConfigCreate(ConfigBase):
    """创建配置模型"""

    pass


class ConfigUpdate(BaseModel):
    """更新配置模型"""

    name: Optional[str] = Field(None, description="配置名称", min_length=1, max_length=100)
    description: Optional[str] = Field(None, description="配置描述")
    value: Optional[Any] = Field(None, description="配置值")
    type: Optional[str] = Field(None, description="配置类型")


class ConfigResponse(ConfigBase):
    """配置响应模型"""

    model_config = ConfigDict(from_attributes=True)

    id: UUID = Field(..., description="配置ID")
    created_at: Optional[datetime] = Field(..., description="创建时间")
    updated_at: Optional[datetime] = Field(..., description="更新时间")


class ConfigList(BaseModel):
    """配置列表响应模型"""

    total: int = Field(..., description="总数")
    items: List[ConfigResponse] = Field(..., description="配置列表")
