from enum import Enum
from typing import Optional

from pydantic import BaseModel


class Platform(str, Enum):
    CPU = "CPU"
    GPU = "GPU"
    NPU = "NPU"
    # 可根据实际情况继续扩展


class DeviceType(str, Enum):
    # NVIDIA RTX 系列
    RTX4090 = "RTX4090"
    RTX3090 = "RTX3090"
    RTX2080 = "RTX2080"
    RTX1080 = "RTX1080"

    # NVIDIA 计算卡
    V100 = "V100"

    # 华为昇腾系列
    ATLAS300P = "ATLAS300P"

    A100 = "A100"
    CAMBRICON = "Cambricon"
    # 可根据实际情况继续扩展


class NodeStatus(str, Enum):
    IDLE = "idle"
    BUSY = "busy"
    OFFLINE = "offline"
    # 可根据实际情况继续扩展


class NodeInfo(BaseModel):
    node_id: Optional[str] = None  # 节点ID，注册时自动生成
    device_uid: str  # 设备唯一标识，客户端生成
    platform: Platform  # 设备平台：CPU、GPU、NPU
    device_type: Optional[DeviceType] = None  # 具体型号，如 RTX3090、A100、Cambricon
    memory: int  # 单位：MB
    os: Optional[str] = None  # 操作系统
    arch: Optional[str] = None  # 架构
    hostname: Optional[str] = None  # 主机名
    ip: Optional[str] = None  # 内网IP
    cuda_version: Optional[str] = None
    driver_version: Optional[str] = None
    cpu_cores: Optional[int] = None
    gpu_count: Optional[int] = None
    status: Optional[NodeStatus] = None  # 节点状态
    extra: Optional[dict] = None  # 其他扩展信息


class Heartbeat(BaseModel):
    node_id: str


class StatusUpdate(BaseModel):
    node_id: str
    status: NodeStatus  # idle/busy/offline
