from enum import IntEnum

from tortoise import fields
from tortoise.models import Model


class VideoType(IntEnum):
    UPLOAD = 1  # 上传视频
    EXTERNAL = 2  # 外部流地址


class Resource(Model):
    id = fields.UUIDField(primary_key=True, description="视频唯一标识符")
    name = fields.CharField(max_length=255, description="视频名称")
    type = fields.IntEnumField(VideoType, description="视频类型：1-上传，2-外部流")
    origin_url = fields.CharField(max_length=1024, null=True, description="原始外部流地址")
    file = fields.ForeignKeyField("models.File", null=True, description="上传视频文件")
    status = fields.IntField(default=1, description="视频状态")
    description = fields.TextField(null=True, description="视频描述")
    config = fields.JSONField(null=True, default=dict, description="ZLMediaKit相关配置")
    created_at = fields.DatetimeField(auto_now_add=True, description="创建时间")
    updated_at = fields.DatetimeField(auto_now=True, description="更新时间")

    class Meta:
        table = "media_resources"
        ordering = ["-updated_at"]
