from fastapi import APIRouter

from algo_flow.app.algo.views.compute import router as compute_router
from algo_flow.app.algo.views.dataset import router as dataset_router
from algo_flow.app.algo.views.model import router as model_router
from algo_flow.app.algo.views.pipeline import router as pipeline_router
from algo_flow.app.algo.views.pipeline_step import router as pipeline_step_router
from algo_flow.app.algo.views.project import router as project_router

router = APIRouter()
router.include_router(router=project_router, prefix="/projects", tags=["项目管理"])
router.include_router(router=model_router, prefix="/models", tags=["模型管理"])
router.include_router(router=dataset_router, prefix="/datasets", tags=["数据集管理"])
router.include_router(router=compute_router, prefix="/compute", tags=["计算节点管理"])
router.include_router(router=pipeline_router, prefix="/pipelines", tags=["管道管理"])
router.include_router(router=pipeline_step_router, prefix="/pipeline_steps", tags=["管道步骤管理"])
