from datetime import datetime
from typing import List, Optional
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field

from algo_flow.cores.constant.algo import ProjectStatus


class ProjectBase(BaseModel):
    """项目基础模型"""

    name: str = Field(..., description="项目名称", min_length=1, max_length=100)
    description: Optional[str] = Field(None, description="项目描述")
    status: ProjectStatus = Field(default=ProjectStatus.ACTIVE, description="项目状态")


class ProjectCreate(BaseModel):
    """项目创建请求模型"""

    name: str = Field(..., description="项目名称", min_length=1, max_length=100)
    description: Optional[str] = Field(None, description="项目描述")


class ProjectUpdate(BaseModel):
    """项目更新请求模型"""

    name: Optional[str] = Field(None, description="项目名称", min_length=1, max_length=100)
    description: Optional[str] = Field(None, description="项目描述")
    status: Optional[ProjectStatus] = Field(None, description="项目状态")


class ProjectResponse(ProjectBase):
    """项目响应模型"""

    id: UUID = Field(..., description="项目ID")
    created_at: Optional[datetime] = Field(..., description="创建时间")
    updated_at: Optional[datetime] = Field(..., description="更新时间")

    model_config = ConfigDict(from_attributes=True)


class ProjectList(BaseModel):
    """项目列表响应模型"""

    total: int = Field(..., description="总数")
    items: List[ProjectResponse] = Field(..., description="项目列表")
