# AlgoFlow PyPI 发布快速指南

## 使用 uv 发布到 PyPI

### 1. 安装发布工具

```bash
uv add build twine
```

> **注意**: 本项目使用现代的 `pyproject.toml` 配置，不需要 `setup.py` 文件。

### 2. 构建包

```bash
uv build
```

### 3. 检查包

```bash
uv run twine check dist/*
```

### 4. 发布到 TestPyPI（推荐先测试）

```bash
# 使用 Makefile（推荐）
make testpypi

# 或手动执行
uv run twine upload --repository testpypi dist/*
```

### 5. 发布到 PyPI

```bash
# 使用 Makefile（推荐）
make pypi

# 或手动执行
uv run twine upload dist/*
```

## 配置 PyPI 认证

创建 `~/.pypirc` 文件：

```ini
[distutils]
index-servers =
    pypi
    testpypi

[pypi]
username = __token__
password = pypi-your-api-token-here

[testpypi]
repository = https://test.pypi.org/legacy/
username = __token__
password = pypi-your-test-api-token-here
```

## 测试安装

从 TestPyPI 测试安装：

```bash
uv pip install --index-url https://test.pypi.org/simple/ algoflow
```

从 PyPI 安装：

```bash
uv pip install algoflow
```

## 常用命令

```bash
# 清理构建文件
rm -rf build/ dist/ *.egg-info/

# 查看包内容
tar -tzf dist/algoflow-0.1.0.tar.gz

# 查看包信息
uv pip show algoflow
```

## 注意事项

1. 确保在 `pyproject.toml` 中更新版本号
2. 确保所有代码已提交到 Git
3. 建议先发布到 TestPyPI 进行测试
4. PyPI 不允许重复上传相同版本 