# AlgoFlow PyPI 发布指南

本文档介绍如何将 AlgoFlow 发布到 PyPI。

## 前提条件

1. **Python 环境**: 确保你使用的是 Python 3.12.9 或更高版本
2. **PyPI 账户**: 在 [PyPI](https://pypi.org/account/register/) 注册账户
3. **TestPyPI 账户**: 在 [TestPyPI](https://test.pypi.org/account/register/) 注册账户（用于测试）

## 安装必要的工具

```bash
# 安装构建工具
pip install build twine

# 或者使用 uv
uv add build twine
```

## 配置 PyPI 认证

### 方法 1: 使用 API Token（推荐）

1. 在 PyPI 账户设置中创建 API Token
2. 创建 `~/.pypirc` 文件：

```ini
[distutils]
index-servers =
    pypi
    testpypi

[pypi]
username = __token__
password = pypi-your-api-token-here

[testpypi]
repository = https://test.pypi.org/legacy/
username = __token__
password = pypi-your-test-api-token-here
```

### 方法 2: 使用环境变量

```bash
export TWINE_USERNAME=your-username
export TWINE_PASSWORD=your-password
```

## 发布流程

### 1. 准备工作

在发布之前，请确保：

- [ ] 更新版本号（在 `pyproject.toml` 中）
- [ ] 更新 `CHANGELOG.md`（如果有）
- [ ] 确保所有测试通过
- [ ] 确保代码已提交到 Git

### 2. 测试发布到 TestPyPI

首先发布到 TestPyPI 进行测试：

```bash
# 使用自动化脚本
python scripts/publish.py --test

# 或者手动执行
python -m build
twine check dist/*
twine upload --repository testpypi dist/*
```

### 3. 测试安装

从 TestPyPI 安装并测试：

```bash
pip install --index-url https://test.pypi.org/simple/ algoflow
```

### 4. 发布到 PyPI

确认测试版本正常后，发布到正式 PyPI：

```bash
# 使用自动化脚本
python scripts/publish.py --pypi

# 或者手动执行
python -m build
twine check dist/*
twine upload dist/*
```

## 版本管理

### 更新版本号

在 `pyproject.toml` 中更新版本号：

```toml
[project]
version = "0.1.1"  # 从 0.1.0 更新到 0.1.1
```

### 版本号规范

遵循 [语义化版本控制](https://semver.org/lang/zh-CN/)：

- **主版本号** (MAJOR): 不兼容的 API 修改
- **次版本号** (MINOR): 向下兼容的功能性新增
- **修订号** (PATCH): 向下兼容的问题修正

## 常见问题

### 1. 包名冲突

如果包名 `algoflow` 已被占用，可以：

- 使用不同的包名（如 `algo-flow`）
- 联系包名所有者
- 使用带前缀的包名（如 `your-username-algoflow`）

### 2. 依赖冲突

如果遇到依赖冲突：

1. 检查 `pyproject.toml` 中的依赖版本
2. 使用更宽松的版本约束（如 `~=` 或 `>=`）
3. 测试在不同 Python 版本下的兼容性

### 3. 构建失败

如果构建失败：

1. 检查 `MANIFEST.in` 文件是否正确
2. 确保所有必要的文件都被包含
3. 检查 `pyproject.toml` 语法是否正确

### 4. 上传失败

如果上传失败：

1. 检查 PyPI 认证配置
2. 确保网络连接正常
3. 检查包是否已存在（PyPI 不允许重复上传相同版本）

## 自动化发布

### GitHub Actions

可以设置 GitHub Actions 来自动发布：

```yaml
name: Publish to PyPI

on:
  release:
    types: [published]

jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v2
    - name: Set up Python
      uses: actions/setup-python@v2
      with:
        python-version: '3.12'
    - name: Install dependencies
      run: |
        python -m pip install --upgrade pip
        pip install build twine
    - name: Build and publish
      env:
        TWINE_USERNAME: ${{ secrets.PYPI_USERNAME }}
        TWINE_PASSWORD: ${{ secrets.PYPI_PASSWORD }}
      run: |
        python -m build
        twine upload dist/*
```

## 维护

### 更新包

1. 修改代码
2. 更新版本号
3. 运行测试
4. 发布新版本

### 删除包

PyPI 不允许删除已发布的包，但可以：

1. 标记为已弃用
2. 发布新版本说明弃用
3. 联系 PyPI 管理员（仅在特殊情况下）

## 有用的命令

```bash
# 检查包内容
tar -tzf dist/algoflow-0.1.0.tar.gz

# 验证包
twine check dist/*

# 查看包信息
pip show algoflow

# 卸载包
pip uninstall algoflow
```

## 联系信息

如果在发布过程中遇到问题，请：

1. 查看 [PyPI 文档](https://packaging.python.org/tutorials/packaging-projects/)
2. 在项目 Issues 中报告问题
3. 联系维护者 