# generated by datamodel-codegen:
#   filename:  bundled.py-filtered.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import AnyUrl, BaseModel, EmailStr, Extra, Field
from typing_extensions import Literal


class PingResponse(BaseModel):
    message: str
    success: bool


class GetNpmCredentialsResponse(BaseModel):
    authToken: str = Field(..., description="Temporary auth token")
    repositoryEndpoint: str = Field(..., description="The npm repository endpoint")


class DataAssetResourceName(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique identifier of the data asset. It follows the pattern '{data_asset_type}://{data_asset_source}:{data_asset_name}'",
        regex="^(protobuf|avro|json_schema|postgres|mysql|mssql|snowflake|bigquery|python|pyspark|typescript|s3)://(?=.*[a-zA-Z0-9])[a-zA-Z0-9_@\\.:/-]+[:/](?=.*[a-zA-Z0-9])[a-zA-Z0-9 _\\./-\\{\\}\\-]+$",
    )

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GableSchemaNull(BaseModel):
    type: Literal["null"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaBool(BaseModel):
    type: Literal["bool"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class Logical(str, Enum):
    Date = "Date"
    Time = "Time"
    Duration = "Duration"
    Timestamp = "Timestamp"


class GableSchemaInt(BaseModel):
    type: Literal["int"]
    bits: int = Field(..., ge=1, le=2147483647)
    signed: Optional[bool] = True
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[Logical] = None


class GableSchemaFloat(BaseModel):
    type: Literal["float"]
    bits: int = Field(..., ge=1, le=2147483647)
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaString(BaseModel):
    type: Literal["string"]
    bytes: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = True
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[Literal["UUID"]] = None


class Logical1(str, Enum):
    Decimal = "Decimal"
    Interval = "Interval"


class Unit(str, Enum):
    year = "year"
    month = "month"
    day = "day"
    hour = "hour"
    minute = "minute"
    second = "second"
    millisecond = "millisecond"
    microsecond = "microsecond"
    nanosecond = "nanosecond"
    picosecond = "picosecond"


class GableSchemaBytes(BaseModel):
    type: Literal["bytes"]
    bytes: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = None
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[Logical1] = None
    precision: Optional[int] = Field(default=None, ge=1, le=2147483647)
    scale: Optional[int] = Field(default=None, ge=0, le=2147483647)
    unit: Optional[Unit] = None


class GableSchemaTypeName(str, Enum):
    null = "null"
    bool = "bool"
    int = "int"
    float = "float"
    string = "string"
    bytes = "bytes"
    list = "list"
    map = "map"
    struct = "struct"
    enum = "enum"
    union = "union"


class GableSchemaEnum(BaseModel):
    type: Literal["enum"]
    symbols: List[str]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaAliasReference(BaseModel):
    class Config:
        extra = Extra.allow

    type: str
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaUnknown(BaseModel):
    type: Literal["unknown"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaField1(BaseModel):
    name: Optional[str] = None
    optional: Optional[bool] = None


class GableSchemaField3(GableSchemaNull, GableSchemaField1):
    pass


class GableSchemaField4(GableSchemaBool, GableSchemaField1):
    pass


class GableSchemaField5(GableSchemaInt, GableSchemaField1):
    pass


class GableSchemaField6(GableSchemaFloat, GableSchemaField1):
    pass


class GableSchemaField7(GableSchemaString, GableSchemaField1):
    pass


class GableSchemaField8(GableSchemaBytes, GableSchemaField1):
    pass


class GableSchemaField11(GableSchemaEnum, GableSchemaField1):
    pass


class GableSchemaField13(GableSchemaAliasReference, GableSchemaField1):
    pass


class GableSchemaField14(GableSchemaUnknown, GableSchemaField1):
    pass


class GableSchemaContractField1(BaseModel):
    name: Optional[str] = None
    optional: Optional[bool] = None
    constraints: Optional[Dict[str, Any]] = None


class GableSchemaContractField3(GableSchemaNull, GableSchemaContractField1):
    pass


class GableSchemaContractField4(GableSchemaBool, GableSchemaContractField1):
    pass


class GableSchemaContractField5(GableSchemaInt, GableSchemaContractField1):
    pass


class GableSchemaContractField6(GableSchemaFloat, GableSchemaContractField1):
    pass


class GableSchemaContractField7(GableSchemaString, GableSchemaContractField1):
    pass


class GableSchemaContractField8(GableSchemaBytes, GableSchemaContractField1):
    pass


class GableSchemaContractField11(GableSchemaEnum, GableSchemaContractField1):
    pass


class GableSchemaContractField13(GableSchemaAliasReference, GableSchemaContractField1):
    pass


class GableSchemaContractField14(GableSchemaUnknown, GableSchemaContractField1):
    pass


class Status(str, Enum):
    ACTIVE = "ACTIVE"
    DEPRECATED = "DEPRECATED"


class EnforcementLevel(str, Enum):
    RECORD = "RECORD"
    NOTIFY = "NOTIFY"
    ALERT = "ALERT"
    BLOCK = "BLOCK"
    INACTIVE = "INACTIVE"


class CheckResponse(BaseModel):
    message: str
    success: bool


class ChangelogEventBase(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the changelog event.")
    eventTitle: Optional[str] = Field(
        default=None, description="The LLM-generated text of the changelog event."
    )
    timestamp: datetime = Field(
        ..., description="The timestamp of the changelog event."
    )
    userId: Optional[UUID] = Field(
        default=None,
        description="The unique identifier for the User who made a changelog event.",
    )


class ContractViolationType(str, Enum):
    MISSING_DATA_ASSET = "MISSING_DATA_ASSET"
    MISSING_REQUIRED_PROPERTY = "MISSING_REQUIRED_PROPERTY"
    INCOMPATIBLE_TYPE = "INCOMPATIBLE_TYPE"
    GREATER_THAN = "GREATER_THAN"
    GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO"
    LESS_THAN = "LESS_THAN"
    LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO"
    IS_NULL = "IS_NULL"
    IS_NULL_THRESHOLD = "IS_NULL_THRESHOLD"
    IS_NOT_EMPTY = "IS_NOT_EMPTY"
    LENGTH = "LENGTH"
    LENGTH_GREATER_THAN = "LENGTH_GREATER_THAN"
    LENGTH_GREATER_THAN_OR_EQUAL_TO = "LENGTH_GREATER_THAN_OR_EQUAL_TO"
    LENGTH_LESS_THAN = "LENGTH_LESS_THAN"
    LENGTH_LESS_THAN_OR_EQUAL_TO = "LENGTH_LESS_THAN_OR_EQUAL_TO"


class ContractViolation(ChangelogEventBase):
    contractId: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    contractVersion: str = Field(..., description="Version of the contract")
    contractFieldName: str = Field(
        ..., description="Field of the contract where violation occured"
    )
    dataAssetFieldProfileId: UUID = Field(
        ..., description="Unique identifier for the data asset field in UUID format"
    )
    entityType: Literal["CONTRACT_VIOLATION"] = Field(
        ...,
        description="The type of entity that the changelog event is associated with.",
    )
    violationType: ContractViolationType = Field(..., description="Type of violation")
    dataAssetResourceName: DataAssetResourceName
    expectedValue: str = Field(..., description="Expected value of the field")
    actualValue: str = Field(..., description="actual value of the field")


class SourceType(str, Enum):
    postgres = "postgres"
    mysql = "mysql"
    mssql = "mssql"
    json_schema = "json_schema"
    avro = "avro"
    protobuf = "protobuf"
    python = "python"
    pyspark = "pyspark"
    typescript = "typescript"
    s3 = "s3"


class ErrorResponse(BaseModel):
    id: Optional[float] = None
    title: Optional[str] = None
    message: str


class DataCount(BaseModel):
    count: float = Field(..., description="Total number of rows")


class PostContractResponse(BaseModel):
    message: str
    contractIds: List[UUID] = Field(
        ...,
        description="List of contract IDs that were updated, if no contracts were updated this will be an empty list",
    )


class ContractActivityUpdateEvent(BaseModel):
    type: Literal["CONTRACT_UPDATED"] = Field(..., description="type of the event")
    datetime: datetime = Field(
        ..., description="date time at which the contract was updated"
    )
    fileUri: AnyUrl = Field(
        ...,
        description="full link to the file and commit in the repo that contains this updated contract",
    )
    gitUser: Optional[str] = Field(
        default=None, description="the git user who edited the contract"
    )


class ContractActivityCreateEvent(BaseModel):
    type: Literal["CONTRACT_CREATED"] = Field(..., description="type of the event")
    datetime: datetime = Field(
        ..., description="date time at which the contract was created"
    )
    fileUri: AnyUrl = Field(
        ...,
        description="full link to the file and commit in the repo that contains this created contract",
    )
    gitUser: Optional[str] = Field(
        default=None, description="the git user who created the contract"
    )


class ContractActivityResponse(BaseModel):
    __root__: List[Union[ContractActivityUpdateEvent, ContractActivityCreateEvent]] = (
        Field(
            ...,
            description="List of contract activity events in chronological order (oldest first)",
            min_items=1,
        )
    )

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class ContractSubscription(BaseModel):
    id: UUID = Field(..., description="The unique identifier of the subscription")
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the subscriber if provided"
    )
    slackChannel: Optional[str] = Field(
        default=None,
        description="The Slack channel where contract violations will be sent",
    )


class UpdateContractSubscriptionRequest(BaseModel):
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle for the subscriber if provided"
    )
    slackChannel: Optional[str] = Field(
        default=None,
        description="The Slack channel where contract violations will be sent",
    )


class CreateContractSubscriptionRequest(BaseModel):
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the subscriber"
    )
    slackChannel: Optional[str] = Field(
        default=None,
        description="The Slack channel where contract violations will be sent",
    )


class GetContractSubscriptionsResponse(BaseModel):
    __root__: List[ContractSubscription]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class ContractViolationInput(BaseModel):
    contractId: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    contractVersion: str = Field(..., description="Version of the contract")
    contractFieldName: str = Field(
        ..., description="Field of the contract where the violation occurred"
    )
    dataAssetFieldProfileId: UUID = Field(
        ..., description="Unique identifier for the data asset field in UUID format"
    )
    expectedValue: str = Field(..., description="Expected value of the field")
    actualValue: Optional[str] = Field(
        default=None, description="Actual value of the field"
    )
    violationType: ContractViolationType = Field(..., description="Type of violation")


class CreateContractViolationRequest(BaseModel):
    __root__: Union[ContractViolationInput, List[ContractViolationInput]]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class CreateContractViolationResponse(BaseModel):
    contractViolationIds: List[UUID] = Field(
        ..., description="List of contract violations IDs that were create"
    )


class BaseSnowflakeLineageIntegrationConfig(BaseModel):
    type: Literal["SNOWFLAKE"] = Field(
        ..., description="Type of the lineage integration"
    )
    account_id: str = Field(..., description="Snowflake account id")
    warehouse: str = Field(..., description="Snowflake warehouse", regex="^\\S{1,255}$")
    role: str = Field(..., description="Snowflake role", regex="^\\S{1,255}$")
    table_ignore_patterns: Optional[List[str]] = Field(
        default=None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetSnowflakeCredentials(BaseModel):
    username: str = Field(..., description="Snowflake username", regex="^\\S{1,255}$")


class SnowflakePasswordCredentials(GetSnowflakeCredentials):
    password: str = Field(
        ...,
        description="Password for the Snowflake user",
        regex="^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$",
    )


class SnowflakeKeyPairCredentials(GetSnowflakeCredentials):
    private_key_base64: str = Field(..., description="Base64 encoded private key")
    private_key_passphrase: Optional[str] = Field(
        default=None, description="Optional private key passphrase"
    )


class CreateOrUpdateSnowflakeLineageIntegrationConfig1(
    BaseSnowflakeLineageIntegrationConfig
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig2(
    SnowflakePasswordCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig3(
    SnowflakeKeyPairCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig(BaseModel):
    __root__: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig2,
        CreateOrUpdateSnowflakeLineageIntegrationConfig3,
    ]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class BaseBigQueryLineageIntegrationConfig(BaseModel):
    type: Literal["BIG_QUERY"] = Field(
        ..., description="Type of the lineage integration"
    )
    project_id: str = Field(
        ...,
        description="BigQuery project id",
        regex="^[a-z][-a-z0-9]{4,28}[a-z0-9]{1}$",
    )
    table_ignore_patterns: Optional[List[str]] = Field(
        default=None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetBigQueryCredentials(BaseModel):
    service_account_email: str = Field(
        ...,
        description="BigQuery service account email",
        regex="^[a-z0-9-]{6,30}@[a-z][-a-z0-9]{4,28}[a-z0-9]{1}\\.iam\\.gserviceaccount\\.com$",
    )
    service_account_id: str = Field(
        ..., description="BigQuery service account id", regex="^[a-z0-9-]{6,30}$"
    )
    service_account_private_key_id: str = Field(
        ..., description="BigQuery service account private key id"
    )


class BigQueryServiceAccountKeyCredentials(GetBigQueryCredentials):
    service_account_private_key_base64: str = Field(
        ...,
        description="Base64 encoded private key",
        regex="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$",
    )


class CreateOrUpdateBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, BigQueryServiceAccountKeyCredentials
):
    pass


class CreateOrUpdateLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
        regex="^((((\\d+,)+\\d+|(\\d+(/|-|#)\\d+)|\\d+L?|\\*(/\\d+)?|L(-\\d+)?|\\?|[A-Z]{3}(-[A-Z]{3})?) ?){5,7})$",
    )
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class CreateOrUpdateLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the created or updated lineage integration")


class GetSnowflakeLineageIntegrationConfig(
    BaseSnowflakeLineageIntegrationConfig, GetSnowflakeCredentials
):
    pass


class GetBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, GetBigQueryCredentials
):
    pass


class GetLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the lineage integration")
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
    )
    config: Union[
        GetSnowflakeLineageIntegrationConfig, GetBigQueryLineageIntegrationConfig
    ] = Field(..., description="Configuration for the lineage integration")


class GetLineageIntegrationsResponse(BaseModel):
    __root__: List[GetLineageIntegrationResponse]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class TestLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class TestLineageIntegrationResponse(BaseModel):
    success: bool = Field(
        ..., description="a boolean indicating if the lineage integration is valid"
    )
    message: Optional[str] = Field(
        default=None,
        description="a message indicating why the lineage integration is invalid",
    )


class DataAssetSearchResult(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset.")
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ...,
        description='The domain to which the data asset belongs. Previously referred to as "namespace."',
    )
    path: str = Field(
        ...,
        description='The name or path identifying the data asset. Previously referred to as "name."',
    )
    type: SourceType
    contractId: Optional[str] = Field(
        default=None, description="The contract ID associated with the data asset."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp of the most recent update to the data asset."
    )


class DataAssetSearchResultPaginated(BaseModel):
    data: Optional[List[DataAssetSearchResult]] = None
    totalCount: Optional[float] = None


class CreateOrUpdateDataAssetFieldRequest(BaseModel):
    name: str = Field(..., description="The name of the field.")
    description: Optional[str] = Field(
        default=None, description="A brief description of the field."
    )
    order: Optional[int] = Field(
        default=None,
        description="The order or position of the field in the data asset.",
    )
    nativeDataType: str = Field(
        ..., description="The native data type of the field in the source system."
    )
    type: Optional[Dict[str, Any]] = Field(
        default=None,
        description="A custom or specific attribute to represent the Gable type of the field.",
    )
    parentFieldId: Optional[UUID] = Field(
        default=None,
        description="For nested fields, this is the ID of the parent field.",
    )


class CreateOrUpdateDataAssetRequest(BaseModel):
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ..., description="The domain or category to which the data asset belongs."
    )
    path: str = Field(..., description="The name or path identifying the data asset.")
    type: SourceType
    description: Optional[str] = Field(
        default=None,
        description="A brief description of this particular version of the data asset.",
    )
    rawSchema: Optional[str] = Field(
        default=None,
        description="The raw schema of the data asset from the source system. This can be the contents of a schema file or data from the information  schema of a database. This is used to regenerate the schema of the data asset if needed.",
    )
    fields: List[CreateOrUpdateDataAssetFieldRequest] = Field(
        ..., description="The fields of the data asset."
    )


class CreateOrUpdateDataAssetResponse(BaseModel):
    id: UUID = Field(..., description="ID of the created or updated data asset")
    versionId: Optional[UUID] = Field(
        default=None, description="Version ID of the now current data asset"
    )
    dataAssetResourceName: Optional[DataAssetResourceName] = None
    newVersionCreated: Optional[bool] = Field(
        default=None, description="Indicates whether a new version was created"
    )


class Input(BaseModel):
    sourceName: str
    sourceType: SourceType
    schemaContents: str
    realDbName: Optional[str] = None
    realDbSchema: Optional[str] = None


class ResponseType(str, Enum):
    DETAILED = "DETAILED"
    COMMENT_MARKDOWN = "COMMENT_MARKDOWN"


class CheckDataAssetsRequest(BaseModel):
    inputs: List[Input]
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )
    prLink: Optional[str] = Field(
        default=None,
        description="Link to the pull request the proposed changes to the data asset are part of",
    )


class CheckDataAssetNoContractResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: DataAssetResourceName = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    responseType: Literal["NO_CONTRACT"]


class Violation(BaseModel):
    message: str
    field: str
    fieldType: str
    violationType: ContractViolationType
    expected: str
    actual: Optional[str] = None


class Subscriber(BaseModel):
    email: Optional[str] = None
    githubHandle: Optional[str] = None
    slackChannel: Optional[str] = None


class CheckDataAssetDetailedResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: DataAssetResourceName = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    contractId: UUID
    contractUrl: str = Field(..., description="Link to the contract in the Gable UI")
    contractNamespace: str
    contractName: str
    contractOwner: str
    contractOwnerGithubHandle: Optional[str] = None
    violations: Optional[List[Violation]] = None
    subscribers: List[Subscriber]
    responseType: Literal["DETAILED"]
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default="INACTIVE", description="alert level for contract"
    )


class CheckDataAssetErrorResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: Optional[DataAssetResourceName] = Field(
        default=None,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: Optional[str] = Field(
        default=None,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    message: str = Field(..., description="The error message")
    responseType: Literal["ERROR"]
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default=None, description="notification tier of error response"
    )


class CheckDataAssetCommentMarkdownResponse(BaseModel):
    markdown: Optional[str] = None
    shouldAlert: bool = Field(
        ...,
        description="Whether or not to comment on the PR - true if at least one contract with a contract violation has its enforcement level set to ALERT or BLOCK.",
    )
    shouldBlock: bool = Field(
        ...,
        description="Whether or not to block the PR - true if at least one contract with a contract violation has its enforcement level set to BLOCK.",
    )
    errors: Optional[List[CheckDataAssetErrorResponse]] = None
    responseType: Literal["COMMENT_MARKDOWN"]


class PySparkAsset(BaseModel):
    schema_: Dict[str, Any] = Field(
        ..., alias="schema", description="The schema of the data asset"
    )
    git_host: str = Field(
        ...,
        description="The git host where the schema is stored (must match the format of <domain>:<org>/<repo> or <domain>:<org>/<group(s)/<repo>)",
        example="github.com:gable/repo",
        regex="^[a-zA-Z0-9-\\.]+\\.[a-zA-Z]{2,3}:[a-zA-Z0-9-]+\\/[a-zA-Z0-9-_\\/]+$",
    )
    spark_entrypoint: str = Field(
        ..., description="The entrypoint of the spark job which produced this asset"
    )
    spark_table: str = Field(..., description="The table name for this asset")
    project_name: str = Field(
        ..., description="The project name in which the asset is defined"
    )


class CheckComplianceDataAssetsPySparkRequest(BaseModel):
    assets: List[PySparkAsset] = Field(
        ..., description="Array of data assets to check for compliance"
    )
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )
    prLink: Optional[str] = Field(
        default=None,
        description="Link to the pull request the proposed changes to the data asset are part of",
    )


class Library(str, Enum):
    brandviews = "brandviews"
    segment = "segment"
    udf = "udf"
    amplitude = "amplitude"


class TypeScriptAsset(BaseModel):
    schema_: Dict[str, Any] = Field(
        ..., alias="schema", description="The schema of the data asset"
    )
    git_host: str = Field(
        ...,
        description="The git host where the schema is stored (must match the format of <domain>:<org>/<repo> or <domain>:<org>/<group(s)/<repo>)",
        example="github.com:gable/repo",
        regex="^[a-zA-Z0-9-\\.]+\\.[a-zA-Z]{2,3}:[a-zA-Z0-9-]+\\/[a-zA-Z0-9-_\\/]+$",
    )
    library: Library = Field(..., description="Name of TypeScript library")
    event_name: str = Field(..., description="Name of the event")
    project_root: str = Field(
        ..., description="root directory of the TypeScript project"
    )


class CheckComplianceDataAssetsTypeScriptRequest(BaseModel):
    assets: List[TypeScriptAsset] = Field(
        ..., description="Array of data assets to check for compliance"
    )
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )
    prLink: Optional[str] = Field(
        default=None,
        description="Link to the pull request the proposed changes to the data asset are part of",
    )


class SamplingParameters(BaseModel):
    rowSampleCount: int = Field(..., description="Number of rows sampled per file")


class DataAssetFieldProfileBase(BaseModel):
    id: Optional[UUID] = Field(
        default=None,
        description="Unique identifier for the data asset field profile in UUID format",
    )
    sampledRecordsCount: int = Field(..., description="Number of samples")
    nullable: bool = Field(..., description="Whether the data is nullable")
    nullCount: Optional[int] = Field(
        default=None, description="Number of nulls (only defined if nullable is true)"
    )
    sampledFiles: List[str] = Field(
        ..., description="List of sampled files", min_items=1
    )
    sampledDate: Optional[datetime] = Field(
        default=None, description="The date the sample was taken"
    )
    samplingParameters: SamplingParameters = Field(
        ..., description="Sampling parameters"
    )


class DataAssetFieldProfileBoolean(DataAssetFieldProfileBase):
    profileType: Literal["boolean"]
    trueCount: int = Field(..., description="Number of true values")
    falseCount: int = Field(..., description="Number of false values")


class DataAssetFieldProfileNumber(DataAssetFieldProfileBase):
    profileType: Literal["number"]
    uniqueCount: int = Field(..., description="Number of unique values")
    min: float = Field(..., description="Minimum value")
    max: float = Field(..., description="Maximum value")


class DataAssetFieldProfileOther(DataAssetFieldProfileBase):
    profileType: Literal["other"]


class DataAssetFieldProfileString(DataAssetFieldProfileBase):
    profileType: Literal["string"]
    uniqueCount: int = Field(..., description="Number of unique values")
    minLength: int = Field(..., description="Minimum length")
    maxLength: int = Field(..., description="Maximum length")
    emptyCount: int = Field(..., description="Number of empty values")


class DataAssetFieldProfileUUID(DataAssetFieldProfileBase):
    profileType: Literal["uuid"]
    uniqueCount: int = Field(..., description="Number of unique values")
    minLength: int = Field(..., description="Minimum length")
    maxLength: int = Field(..., description="Maximum length")
    emptyCount: int = Field(..., description="Number of empty values")
    format: Optional[str] = Field(default=None, description="UUID format")
    uuidVersion: Optional[int] = Field(default=None, description="UUID version")


class DataAssetFieldProfileTemporal(DataAssetFieldProfileBase):
    profileType: Literal["temporal"]
    min: datetime = Field(..., description="Minimum value")
    max: datetime = Field(..., description="Maximum value")
    format: str = Field(..., description="Temporal format")


class DataAssetFieldProfileList(DataAssetFieldProfileBase):
    profileType: Literal["list"]
    minLength: int = Field(..., description="Minimum length")
    maxLength: int = Field(..., description="Maximum length")


class IngestDataAssetRequest(BaseModel):
    sourceType: SourceType
    sourceNames: List[str] = Field(..., description="The names of the sources")
    databaseSchema: str = Field(..., description="The name of the database schema")
    schema_: List[str] = Field(
        ...,
        alias="schema",
        description="Array of schemas. Each schema could be from a db information schema or the contents of a schema file.",
    )
    dryRun: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class IngestDataAssetResponse(BaseModel):
    message: str = Field(..., description="Response message")
    registered: List[str] = Field(
        ..., description="List of the registered data asset ids"
    )
    success: bool = Field(..., description="Whether the request was successful")


class ErrorResponseDeprecated(BaseModel):
    id: Optional[float] = None
    title: Optional[str] = None
    message: str
    success: Optional[bool] = None


class Diff(BaseModel):
    fieldName: str = Field(..., description="The name of the field being added.")
    type: str = Field(..., description="The type of the field being added.")


class FieldAddedEvent(BaseModel):
    eventType: Literal["FIELD_ADDED"] = Field(
        ..., description="The type of event that occurred."
    )
    diff: Diff = Field(..., description="Details of the modified field.")


class Diff1(BaseModel):
    fieldName: str = Field(..., description="The name of the field being deleted.")
    type: str = Field(..., description="The type of the field being deleted.")


class FieldDeletedEvent(BaseModel):
    eventType: Literal["FIELD_DELETED"] = Field(
        ..., description="The type of event that occurred."
    )
    diff: Diff1 = Field(..., description="Details of the modified field.")


class AttributeName(str, Enum):
    PRECISION_BITS = "PRECISION_BITS"
    SIGNED = "SIGNED"
    TYPE = "TYPE"
    LOGICAL_TYPE = "LOGICAL_TYPE"
    ENUM_VALUES = "ENUM_VALUES"
    NULLABLE = "NULLABLE"
    STRUCTURAL = "STRUCTURAL"


class Diff2(BaseModel):
    fieldName: str = Field(..., description="The name of the field being modified.")
    attributeName: AttributeName = Field(
        ..., description="The name of the attribute being modified."
    )
    previousValue: str = Field(
        ..., description="The type of the field before the change."
    )
    newValue: str = Field(..., description="The type of the field after the change.")


class FieldModifiedEvent(BaseModel):
    eventType: Literal["FIELD_MODIFIED"] = Field(
        ..., description="The type of event that occurred."
    )
    diff: Diff2 = Field(..., description="Details of the modified field.")


class Difference(BaseModel):
    fieldDifferences: List[
        Union[FieldAddedEvent, FieldDeletedEvent, FieldModifiedEvent]
    ] = Field(
        ..., description="List of differences between the previous and new data assets"
    )


class DiffDataAssetResponse(BaseModel):
    differences: List[Difference]


class RegisterDataAssetPySparkRequest(BaseModel):
    assets: List[PySparkAsset] = Field(
        ..., description="Array of data assets to register"
    )
    dry_run: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class RegisterDataAssetTypeScriptRequest(BaseModel):
    assets: List[TypeScriptAsset] = Field(
        ..., description="Array of data assets to register"
    )
    dry_run: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class GetAvailableLineageIntegrationsResponse(BaseModel):
    __root__: List[str]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GetAvailableLineageIntegrationDetailsResponseItem(BaseModel):
    instructions: Optional[str] = Field(
        default=None, description="Instructions for setting up the lineage integration"
    )
    requiredInputs: Optional[List[str]] = Field(
        default=None,
        description="Required inputs for setting up the lineage integration",
    )


class GetAvailableLineageIntegrationDetailsResponse(BaseModel):
    __root__: List[GetAvailableLineageIntegrationDetailsResponseItem]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GetApiKeysResponseItem(BaseModel):
    id: Optional[str] = Field(default=None, description="The identifier of the API key")
    name: Optional[str] = Field(default=None, description="The name of the API key")
    value: Optional[str] = Field(default=None, description="The value of the API key")


class GetApiKeysResponse(BaseModel):
    __root__: List[GetApiKeysResponseItem]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GetSsoSamlSetupDetailsResponse(BaseModel):
    ssoUrl: str = Field(
        ...,
        description="The location where the SAML assertion is sent with a HTTP POST, also referred to as the SAML Assertion Consumer Service (ACS) URL.",
    )
    audienceUri: str = Field(
        ...,
        description="(SP Entity Id) The application-defined unique identifier that is the intended audience of the SAML assertion. This is most often the SP Entity ID of your application.",
    )


class SsoSamlUrlConfig(BaseModel):
    type: Literal["SAML"] = Field(
        ...,
        description="The type of SSO integration, currently only SAML is supported.",
    )
    identityProvider: str = Field(
        ...,
        description='The name of your identity provider. This value will be displayed to users when they log in. \n\nNote: This value cannot be the strings "Google" or "SAML" as they\'re reserved words in our identity management platform.\n',
        examples=["Okta", "GoogleWorkspace", "OneLogin", "JumpCloud"],
        regex="^(?=[a-zA-Z0-9\\(\\)\\.\\-!@]+$)(?!Google|SAML$).*$",
    )
    metadataDocumentEndpointUrl: str = Field(
        ...,
        description="The URL of the SAML metadata document. Either this or metadataFileContents must be provided.",
        example="https://company.okta.com/app/123456789/sso/saml/metadata",
    )


class SsoSamlFileConfig(BaseModel):
    type: Literal["SAML"] = Field(
        ...,
        description="The type of SSO integration, currently only SAML is supported.",
    )
    identityProvider: str = Field(
        ...,
        description='The name of your identity provider. This value will be displayed to users when they log in. \n\nNote: This value cannot be the strings "Google" or "SAML" as they\'re reserved words in our identity management platform.\n',
        examples=["Okta", "GoogleWorkspace", "OneLogin", "JumpCloud"],
        regex="^(?=[a-zA-Z0-9\\(\\)\\.\\-!@]+$)(?!Google|SAML$).*$",
    )
    metadataFileContents: str = Field(
        ...,
        description="The contents of the metadata document. Either this or metadataDocumentEndpointUrl must be provided.",
    )


class SsoConfig(BaseModel):
    __root__: Union[SsoSamlUrlConfig, SsoSamlFileConfig]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GetUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )


class UserStatus(str, Enum):
    ACTIVE = "ACTIVE"
    INVITED = "INVITED"
    DELETED = "DELETED"


class User(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user, if available"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user, if available"
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the user or team, if available"
    )
    status: UserStatus = Field(..., description="The status of the user")


class UpdateUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )
    githubHandle: Optional[str] = Field(
        default=None,
        description="The GitHub handle of the user",
        regex="^[a-zA-Z0-9-]*$",
    )


class UpdateUserResponse(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the user"
    )


class GetUsersResponse(BaseModel):
    __root__: List[User]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class InviteUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )
    resendInvite: Optional[bool] = Field(
        default=None,
        description="The flag which determines whether the invitation should be resent",
    )


class DeleteUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )


class ChangelogEventType(str, Enum):
    CREATED = "CREATED"
    MODIFIED = "MODIFIED"
    DELETED = "DELETED"


class AssetCreatedEvent(ChangelogEventBase):
    entityType: Literal["DATA_ASSET"] = Field(
        ...,
        description="The type of entity that the changelog event is associated with.",
    )
    dataAssetResourceName: DataAssetResourceName
    eventType: ChangelogEventType


class AssetDeletedEvent(AssetCreatedEvent):
    pass


class AssetModifiedEvent(AssetCreatedEvent):
    modifications: List[
        Union[FieldAddedEvent, FieldModifiedEvent, FieldDeletedEvent]
    ] = Field(
        ...,
        description="List of changelog modifications in chronological order (newest first)",
    )


class GetChangelogResponse(BaseModel):
    changelogEvents: List[
        Union[
            AssetCreatedEvent, AssetDeletedEvent, AssetModifiedEvent, ContractViolation
        ]
    ] = Field(
        ...,
        description="List of changelog events in chronological order (oldest first)",
    )


class Channel(BaseModel):
    id: Optional[str] = Field(default=None, description="The channel id")
    name: Optional[str] = Field(default=None, description="The channel name")


class GetSlackChannelsResponse(BaseModel):
    channels: List[Channel]
    workspaceName: Optional[str] = Field(
        default=None, description="Slack workspace name"
    )


class PostTestSlackMessageRequest(BaseModel):
    channelId: str = Field(
        ...,
        description="The slack channel id name to which the test message will be sent",
    )


class PostTestSlackMessageResponse(BaseModel):
    message: Optional[str] = Field(
        default=None, description="Message that indicates successful action"
    )


class GableSchemaStruct(BaseModel):
    type: Literal["struct"]
    name: Optional[str] = None
    fields: Optional[List[GableSchemaField]] = None
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaList(BaseModel):
    type: Literal["list"]
    values: GableSchemaType
    length: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = True
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None


class GableSchemaType(BaseModel):
    __root__: Union[
        GableSchemaTypeName,
        Union[
            GableSchemaStruct,
            GableSchemaNull,
            GableSchemaBool,
            GableSchemaInt,
            GableSchemaFloat,
            GableSchemaString,
            GableSchemaBytes,
            GableSchemaList,
            GableSchemaMap,
            GableSchemaEnum,
            GableSchemaUnion,
            GableSchemaAliasReference,
            GableSchemaUnknown,
        ],
    ]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GableSchemaMap(BaseModel):
    type: Literal["map"]
    keys: GableSchemaType
    values: GableSchemaType
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaUnion(BaseModel):
    type: Literal["union"]
    types: List[GableSchemaType]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaField(BaseModel):
    __root__: Union[
        GableSchemaField2,
        GableSchemaField3,
        GableSchemaField4,
        GableSchemaField5,
        GableSchemaField6,
        GableSchemaField7,
        GableSchemaField8,
        GableSchemaField9,
        GableSchemaField10,
        GableSchemaField11,
        GableSchemaField12,
        GableSchemaField13,
        GableSchemaField14,
    ]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class GableSchemaContractField(BaseModel):
    __root__: Union[
        GableSchemaContractField2,
        GableSchemaContractField3,
        GableSchemaContractField4,
        GableSchemaContractField5,
        GableSchemaContractField6,
        GableSchemaContractField7,
        GableSchemaContractField8,
        GableSchemaContractField9,
        GableSchemaContractField10,
        GableSchemaContractField11,
        GableSchemaContractField12,
        GableSchemaContractField13,
        GableSchemaContractField14,
    ]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class ContractSpec(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    dataAssetResourceName: DataAssetResourceName
    doc: str = Field(..., description="Description of the contract")
    name: str = Field(
        ...,
        description="The name of the contract. When combined with the contract namespace, it represents a unique name in the Gable platform.  Only alphanumeric characters (upper and lowercase) and underscores are allowed",
        regex="^(?=.*[a-zA-Z0-9])[ a-zA-Z0-9_\\\\s]+$",
    )
    namespace: str = Field(
        ...,
        description="The namespace of the contract. When combined with the contract name, it represents a unique name in the Gable platform.  Only alphanumeric characters (upper and lowercase) and underscores are allowed",
        regex="^(?=.*[a-zA-Z0-9])[a-zA-Z0-9_\\-\\\\s]+$",
    )
    owner: EmailStr = Field(..., description="The owner of the contract")
    schema_: List[GableSchemaContractField] = Field(..., alias="schema")


class ContractInput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: str = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added this contract")
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    filePath: str = Field(
        ...,
        description="path to the contract file from the root of the git repository",
        regex="^([^/]+\\/)*[^/]+$",
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default=None, description="alert level for contract"
    )
    contractSpec: ContractSpec = Field(
        ...,
        description="This is the possible contract specification. If it is valid, it will  match the contract specification schema. However, we have to allow  for invalid contracts to be passed to Gable even if we reject them.",
    )
    lastEditorUserId: Optional[UUID] = Field(
        default=None,
        description="Unique identifier for the user who last edited the contract through the UI",
    )
    lastEditorEmail: Optional[str] = Field(
        default=None,
        description="Email of the user who last edited the contract through the UI",
    )
    lastEditorFirstName: Optional[str] = Field(
        default=None,
        description="First name of the user who last edited the contract through the UI",
    )
    lastEditorLastName: Optional[str] = Field(
        default=None,
        description="Last name of the user who last edited the contract through the UI",
    )
    lastEditorGithubHandle: Optional[str] = Field(
        default=None,
        description="GitHub handle of the user who last edited the contract through the UI",
    )


class PostContractRequest(BaseModel):
    __root__: Union[ContractInput, List[ContractInput]]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class ContractOutput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: str = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added/updated this contract")
    fileUri: AnyUrl = Field(
        ..., description="full link to the file in the repo that contains this contract"
    )
    filePath: Optional[str] = Field(
        default=None,
        description="path to the contract file from the root of the git repository",
    )
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    createdAt: datetime = Field(
        ..., description="date time at which the contract was created"
    )
    updatedAt: datetime = Field(
        ..., description="date time at which the contract was last updated"
    )
    contractSpec: ContractSpec = Field(..., description="contract spec")
    contractSpecRaw: str = Field(..., description="contract spec raw json")
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default="INACTIVE", description="alert level for contract"
    )
    lastEditorUserId: Optional[UUID] = Field(
        default=None,
        description="Unique identifier for the user who last edited the contract through the UI",
    )
    lastEditorEmail: Optional[str] = Field(
        default=None,
        description="Email of the user who last edited the contract through the UI",
    )
    lastEditorFirstName: Optional[str] = Field(
        default=None,
        description="First name of the user who last edited the contract through the UI",
    )
    lastEditorLastName: Optional[str] = Field(
        default=None,
        description="Last name of the user who last edited the contract through the UI",
    )
    lastEditorGithubHandle: Optional[str] = Field(
        default=None,
        description="GitHub handle of the user who last edited the contract through the UI",
    )
    violations: List[ContractViolation] = Field(
        ..., description="List of contract violations"
    )
    contractSpecFieldToViolationStatusMapping: Optional[
        Dict[str, List[ContractViolationType]]
    ] = Field(
        default=None,
        description="Mapping of contract spec fields to a list of the violations currently applicable to them",
    )


class GetContractsResponse(BaseModel):
    __root__: List[ContractOutput]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class CheckDataAssetMissingAssetResponse(BaseModel):
    dataAssetResourceName: DataAssetResourceName = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    contract: ContractOutput
    contractOwner: str
    contractOwnerGithubHandle: Optional[str] = None
    subscribers: List[Subscriber]
    responseType: Literal["MISSING_DATA_ASSET"]


class CheckDataAssetsResponse(BaseModel):
    __root__: Union[
        List[
            Union[
                CheckDataAssetNoContractResponse,
                CheckDataAssetDetailedResponse,
                CheckDataAssetErrorResponse,
                CheckDataAssetMissingAssetResponse,
            ]
        ],
        CheckDataAssetCommentMarkdownResponse,
    ]

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class DataAssetFieldProfile(BaseModel):
    __root__: Union[
        DataAssetFieldProfileBoolean,
        DataAssetFieldProfileNumber,
        DataAssetFieldProfileOther,
        DataAssetFieldProfileString,
        DataAssetFieldProfileUUID,
        DataAssetFieldProfileTemporal,
        DataAssetFieldProfileUnion,
        DataAssetFieldProfileList,
    ] = Field(..., discriminator="profileType")

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class DataAssetFieldProfileUnion(DataAssetFieldProfileBase):
    profileType: Literal["union"]
    profiles: List[DataAssetFieldProfile] = Field(
        ..., description="List of constituent data asset field profiles"
    )


class DataAssetFieldsToProfilesMapping(BaseModel):
    __root__: Optional[Dict[str, DataAssetFieldProfile]] = None

    @classmethod
    def construct_error(cls, e):
        from pydantic import ValidationError
        from pydantic.error_wrappers import ErrorWrapper

        class ExceptionProxy(Exception):
            def __init__(self, name, msg):
                self.__class__.__name__ = name
                self.msg = msg

            def __str__(self):
                res = self.msg
                del self.__dict__[
                    "msg"
                ]  # don't render msg twice in pydantic's error reporting
                return res

        filtered_errors = []
        for error in e.errors():
            new_error = {
                **error,
                "loc": tuple(f for f in error["loc"] if f != "__root__"),
            }
            if new_error not in filtered_errors:
                filtered_errors.append(new_error)
        error_wrappers = []
        for error in filtered_errors:
            msg = error["msg"]
            name = ".".join(error["type"].split(".")[1:])
            exc = ExceptionProxy(name, msg)
            error_wrapper = ErrorWrapper(
                exc=exc,
                loc=tuple(error["loc"]),
            )
            error_wrappers.append(error_wrapper)
        return ValidationError(error_wrappers, cls)

    @classmethod
    def validate(cls, value) -> "BaseModel":
        from pydantic import ValidationError

        try:
            return super().validate(value)
        except ValidationError as e:
            raise cls.construct_error(e)


class S3Asset(BaseModel):
    schema_: Dict[str, Any] = Field(
        ..., alias="schema", description="The schema of the data asset"
    )
    pattern: str = Field(..., description="The pattern of the data asset")
    bucket: str = Field(..., description="The bucket of the data asset")
    fieldNameToDataAssetFieldProfileMap: Optional[DataAssetFieldsToProfilesMapping] = (
        Field(
            default=None,
            description="A mapping of the field name within the recap struct schema to its corresponding data profile",
        )
    )


class CheckComplianceDataAssetsS3Request(BaseModel):
    assets: List[S3Asset] = Field(
        ..., description="Array of data assets to check for compliance"
    )
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )
    prLink: Optional[str] = Field(
        default=None,
        description="Link to the pull request the proposed changes to the data asset are part of",
    )


class DataAssetField(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset field.")
    dataAssetVersionId: UUID = Field(
        ...,
        description="The identifier of the data asset version this field belongs to.",
    )
    name: str = Field(..., description="The name of the field.")
    description: Optional[str] = Field(
        default=None, description="A brief description of the field."
    )
    order: Optional[int] = Field(
        default=None,
        description="The order or position of the field in the data asset.",
    )
    nativeDataType: str = Field(
        ..., description="The native data type of the field in the source system."
    )
    type: Optional[Dict[str, Any]] = Field(
        default=None,
        description="A custom or specific attribute to represent the Gable type of the field.",
    )
    displayType: str = Field(..., description="The display name of the field.")
    parentFieldId: Optional[UUID] = Field(
        default=None,
        description="For nested fields, this is the ID of the parent field.",
    )
    createdAt: datetime = Field(
        ..., description="The timestamp when the field was created."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp when the field was last updated."
    )
    deletedAt: Optional[datetime] = Field(
        default=None, description="The timestamp when the field was marked as deleted."
    )
    profile: Optional[DataAssetFieldProfile] = None


class DataAssetFieldVersion(BaseModel):
    previousDataAssetFields: List[DataAssetField]
    newDataAssetFields: List[DataAssetField]


class DiffDataAssetRequest(BaseModel):
    dataAssetFieldVersions: List[DataAssetFieldVersion]


class RegisterDataAssetS3Request(BaseModel):
    assets: List[S3Asset] = Field(..., description="Array of data assets to register")
    dry_run: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class DataAssetVersion(BaseModel):
    id: UUID = Field(
        ..., description="The unique identifier for the version of the data asset."
    )
    dataAssetId: UUID = Field(
        ...,
        description="The identifier of the parent data asset to which this version belongs.",
    )
    description: Optional[str] = Field(
        default=None,
        description="A brief description of this particular version of the data asset.",
    )
    rawSchema: Optional[str] = Field(
        default=None,
        description="The raw schema of the data asset from the source system. This can be the contents of a schema file or data from the information  schema of a database. This is used to regenerate the schema of the data asset if needed.",
    )
    fields: List[DataAssetField] = Field(
        ..., description="The fields of the data asset."
    )
    createdAt: datetime = Field(
        ...,
        description="The timestamp when this version of the data asset was created.",
    )
    updatedAt: datetime = Field(
        ...,
        description="The timestamp when this version of the data asset was last updated.",
    )
    deletedAt: Optional[datetime] = Field(
        default=None,
        description="The timestamp when this version of the data asset was marked as deleted, if applicable.",
    )
    violations: List[ContractViolation] = Field(
        ...,
        description="List of contract violations associated with the data asset version.",
    )


class DataAsset(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset.")
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ...,
        description='The domain to which the data asset belongs. Previously referred to as "namespace."',
    )
    path: str = Field(
        ...,
        description='The name or path identifying the data asset. Previously referred to as "name."',
    )
    type: SourceType
    contractId: Optional[str] = Field(
        default=None, description="The contract ID associated with the data asset."
    )
    versionDetail: DataAssetVersion = Field(
        ..., description="The version details of the data asset."
    )
    createdAt: datetime = Field(
        ..., description="The timestamp of when the data asset was initially created."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp of the most recent update to the data asset."
    )
    deletedAt: Optional[datetime] = Field(
        default=None,
        description="The timestamp indicating when the data asset was deleted, if applicable.",
    )
    schema_: Optional[Dict[str, Any]] = Field(default=None, alias="schema")


class InferContractFromDataAssetResponse(BaseModel):
    contractId: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: Optional[str] = Field(
        default=None, description="Version of the contract (semantic versioning)"
    )
    status: Optional[Status] = Field(default=None, description="status of the contract")
    gitHash: Optional[str] = Field(
        default=None,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: Optional[AnyUrl] = Field(
        default=None, description="full link to the git repo this contract lives in"
    )
    gitUser: Optional[str] = Field(
        default=None, description="git user who added/updated this contract"
    )
    fileUri: Optional[AnyUrl] = Field(
        default=None,
        description="full link to the file in the repo that contains this contract",
    )
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    mergedAt: Optional[datetime] = Field(
        default=None,
        description="date time at which the PR that added/updated this contract was merged",
    )
    createdAt: Optional[datetime] = Field(
        default=None, description="date time at which the contract was created"
    )
    updatedAt: Optional[datetime] = Field(
        default=None, description="date time at which the contract was last updated"
    )
    contractSpec: ContractSpec = Field(..., description="contract spec")
    contractSpecRaw: str = Field(..., description="contract spec raw json")


class CreateDataAssetProfileRequest(BaseModel):
    darn: str = Field(
        ..., description="the Data Asset Resource Name (DARN) of the data asset"
    )
    data_asset_id: UUID = Field(..., description="ID for the data asset")
    fieldsToProfilesMapping: DataAssetFieldsToProfilesMapping = Field(
        ...,
        description="The mapping of data asset fields to data asset field profiles associated with the data asset",
    )


class CreateDataAssetProfileResponse(BaseModel):
    fieldsToProfilesMapping: DataAssetFieldsToProfilesMapping


class GableSchemaField2(GableSchemaStruct, GableSchemaField1):
    pass


class GableSchemaContractField2(GableSchemaStruct, GableSchemaContractField1):
    pass


class GableSchemaField9(GableSchemaList, GableSchemaField1):
    pass


class GableSchemaContractField9(GableSchemaList, GableSchemaContractField1):
    pass


class GableSchemaField10(GableSchemaMap, GableSchemaField1):
    pass


class GableSchemaContractField10(GableSchemaMap, GableSchemaContractField1):
    pass


class GableSchemaField12(GableSchemaUnion, GableSchemaField1):
    pass


class GableSchemaContractField12(GableSchemaUnion, GableSchemaContractField1):
    pass


GableSchemaStruct.update_forward_refs()
GableSchemaList.update_forward_refs()
GableSchemaType.update_forward_refs()
GableSchemaField.update_forward_refs()
GableSchemaContractField.update_forward_refs()
DataAssetFieldProfile.update_forward_refs()
GableSchemaField2.update_forward_refs()
GableSchemaContractField2.update_forward_refs()
GableSchemaField9.update_forward_refs()
GableSchemaContractField9.update_forward_refs()
