#!/bin/bash

# Questions MCP Server 启动脚本 (Linux/macOS)

set -e

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${GREEN}启动 Questions MCP Server...${NC}"

# 激活虚拟环境
if [ -d ".venv" ]; then
    source .venv/bin/activate
    echo -e "${GREEN}✓ 虚拟环境已激活${NC}"
else
    echo -e "${YELLOW}警告: 虚拟环境不存在，请先运行 ./deploy.sh${NC}"
    exit 1
fi

# 检查配置文件
if [ ! -f ".env" ]; then
    echo -e "${YELLOW}警告: .env 文件不存在，使用默认配置${NC}"
fi

# 启动服务
echo -e "${GREEN}正在启动服务...${NC}"
python -m src.main

# 脚本退出时的清理
trap 'echo -e "${YELLOW}服务已停止${NC}"' EXIT
