"""
Questions MCP Server - 题目管理与检索系统

基于 FastMCP 框架的 MCP Server，实现题目的全生命周期管理、智能检索和统计分析功能。
"""

__version__ = "1.0.0"
__author__ = "Questions MCP Server Team"
__description__ = "题目管理与检索系统 MCP Server"

# 导出核心模块
from src.core.config import Config, get_config, reload_config
from src.core.logger import (
    Logger,
    clear_request_id,
    get_logger,
    get_request_id,
    set_request_id,
    setup_logger,
)

__all__ = [
    "__version__",
    "__author__",
    "__description__",
    "Config",
    "get_config",
    "reload_config",
    "Logger",
    "get_logger",
    "setup_logger",
    "set_request_id",
    "get_request_id",
    "clear_request_id",
]
