#!/bin/bash

# 使用 uv 构建和发布 Questions MCP Server

set -e

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

echo "================================"
echo "Questions MCP Server - UV 构建"
echo "================================"

# 检查 uv 是否安装
if ! command -v uv &> /dev/null; then
    echo -e "${RED}错误: 未找到 uv${NC}"
    echo -e "${YELLOW}请先安装 uv: pip install uv${NC}"
    exit 1
fi
echo -e "${GREEN}✓ uv 已安装${NC}"

# 清理旧的构建文件
echo -e "${YELLOW}清理旧的构建文件...${NC}"
rm -rf dist/ build/ src/*.egg-info

# 使用 uv 构建包
echo -e "${YELLOW}使用 uv 构建包...${NC}"
uv build

echo -e "${GREEN}================================"
echo "构建完成！"
echo "================================${NC}"
echo ""
echo "生成的文件："
ls -lh dist/
echo ""
echo "安装命令："
echo -e "${YELLOW}  uv pip install dist/questions_mcp_server-1.0.0-py3-none-any.whl${NC}"
echo ""
echo "或使用 uvx 直接运行："
echo -e "${YELLOW}  uvx --from dist/questions_mcp_server-1.0.0-py3-none-any.whl questions-mcp-server${NC}"
echo ""
