# Repository Guidelines

## 项目结构与模块组织

- `src/core/`：配置加载与日志工具
- `src/database/`：数据模型、DAO 与数据库管理器
- `src/services/`：Embedding、棰樼洰管理与搜索服务
- `src/utils/`：通用工具函数与缓存组件
- `tests/`：与 `src` 结构对应的 pytest 测试
- `config/config.yaml` 与 `.env`：服务与环境配置
- `data/` 与 `logs/`：SQLite/Chroma 数据与日志（本地状态，勿提交）

## 构建、测试与开发命令

- 安装依赖：`pip install -r requirements.txt`（或 `uv sync`）
- 本地启动服务：`uv run python src/main.py`
- 运行完整测试：`uv run python -m pytest tests -v`
- 一键测试脚本：`uv run python run_all_tests.py`
- 阶段验证（如需）：`uv run python verify_stage5.py`

## 代码风格与命名约定

- 使用 Python 3，4 空格缩进，按需添加类型标注
- 命名规范：模块/函数/变量用 `snake_case`，类用 `PascalCase`，常量用 `UPPER_SNAKE_CASE`
- 数据持久化逻辑放在 `src/database`，业务逻辑放在 `src/services`，通用工具放在 `src/utils`
- 提交前尽量格式化和静态检查：`uv run black src tests`，`uv run flake8 src tests`

## 测试规范

- 测试框架：`pytest`（支持 `pytest-asyncio` 用于异步代码）
- 测试文件：`tests/test_*.py`，测试类如 `TestSearchService`
- 测试命名按行为描述，例如：`test_search_by_keyword_returns_matches`
- 对数据库和外部 API 使用 fixture 与 mock（参考现有 `Mock`、`patch` 用法）
- 提交 PR 前请确保：`uv run python run_all_tests.py` 在本机全部通过

## 提交与 Pull Request 规范

- 提交信息简短聚焦，沿用当前历史中的风格，例如：`完成第五阶段测试`
- 尽量将相关代码、测试和配置修改放在同一提交中
- PR 描述应包含：目标、主要改动点、影响模块、测试方式
- 如有 schema、数据或配置变更，请在 PR 中单独说明，并附上关键日志或截图

## 面向智能体的注意事项

- 遵循既有分层结构（core/database/services/utils），避免大规模重构
- 自动化修改时不要动 `data/` 与 `logs/` 下的内容，将其视为本地运行状态
- 新增工具或服务时先补充或扩展测试，再按现有命名和模块布局集成

### 注意，你必须使用utf-8编码，用utf-8编码读取文件，代码等!!!
