"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.processProjectGraph = void 0;
/* eslint-disable @typescript-eslint/no-require-imports */
const fs = require("fs");
const path = require("path");
const { ProjectGraphBuilder } = require("@nrwl/devkit");
exports.processProjectGraph = (graph) => {
    const builder = new ProjectGraphBuilder(graph);
    const nx = JSON.parse(fs
        .readFileSync(path.resolve(findRoot(__dirname), "nx.json"))
        .toString("utf-8"));
    const implicitDependencies = nx.implicitDependencies;
    Object.entries(implicitDependencies).forEach(([dependant, dependees]) => {
        dependees.forEach((dependee) => builder.addImplicitDependency(dependant, dependee));
    });
    return builder.getUpdatedProjectGraph();
};
const findRoot = (dir) => {
    if (path.dirname(dir) === dir) {
        return process.cwd();
    }
    else if (fs.existsSync(path.join(dir, "nx.json"))) {
        return dir;
    }
    else {
        return findRoot(path.dirname(dir));
    }
};
//# sourceMappingURL=data:application/json;base64,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