## Sql Data Lineage Example

### Run
```bash
datalineage -i example/test-query.sql --schema-path example/test-schema.json
```

An mermaid flowchart code will be printed into the console. We can copy the graph and paste to the Mermaid Live Editor to preview the result.

### Display [[live editor](https://mermaid.live/edit#pako:eNqFVtGOmzoQ_RWEtFIrpVnbGEPyUGnV27fbVuruQ9WlQg44CS1gCuberqL8e8fepmo9eJcn8Az2nDNnxnOKK12reBtfXZ2avjHb6FTE-1b_Xx3laIrYfddqL-fWfFR9rUY12tUiVu23Ij6fo_PVVdEfRjkco38_Fv007x4_KBOEsZymPBObDYvui_hO7lq1jSppZKsP66k6qk7SdTVPRndqjG5uo8t7EX8p-j-3yDcCdmhqbOA5GHrZKd-UkdyahqPukU1QZm2yrkc1Tdia2dNaDaE2undmAF_0AXw5IRbfm7u3gM4oapEYiuPhZBlDwkgAg0hEGAOnwsPggvRoi169eh15YSAKfScbEiITO4kcsYqcIMogcSR5ShjzpMayVp12PzbVZHlFiz4tabZhizSnm0QEaE5zlxp5wBbhhLeYgDTjHGwXzZZf9Q7_TuzGgxxVb57VERf8t45MN5SgJSelx1eMJ-fLQEWwJpLMKXsJaJqyIFCeiiWgvtws9X7-bZQoDcgJIkYJ8Z1s7Cg3aCeAgZKEnABPMAmQsj-LmbkMMEwXCZCfiFAxp5zky-QnGQuWeZpQm5gg58AvJoFwpAjkBIEibWCmSI5kghPDcqQXfBxlYc6p6wO38-77rMaHbVR-LwkiKc-WC5sTwQOUc0KD5QuNiYTvAE4d7fu5bcvFnZmriU7-KC8J9VNjOy3iCkCg5u87WUDoGsBOVKD7ADlRL8kWVql-DPdW4h_ev7m5e2Ho2gJcgcrdy0sA8wU2gify_nw-ct_JquxZJ8vlJah3N59eQCDAaSgOlgpUVugI9kSFk9xV-K1qVQUTT6lnM8ymRBlO0oDeGAn1V564trCst8z165DeuLtownpL3bX2lN6sthARidcPrbYwW16VW23hnbymYrWFnLKcI70hJ4CK8o-cAG-8iuG66WRTw4R6KvoI5k4Ds4F6HEGrh50ah7mHQbToz-AsZ6NvH_oq3ppxVqt41PPhePmYh1oa9U8jQRDd34tv68boMd7uZTvBYqslDLrx9hSbh8EOx4dmMrB9pft9c7Dr89jC8tGYYdpeX1vz-tCY47xbV7q7npraTs_H_zbiWjCRS5YokSUyTZK62tFNvmec7uuMUCZhhF7Fyp3_7nESdwP5CkaG_rPW3a-gzj8BvuAUxg) - [view only](https://mermaid.live/view#pako:eNqFVtGOmzoQ_RWEtFIrpVnbGEPyUGnV27fbVuruQ9WlQg44CS1gCuberqL8e8fepmo9eJcn8Az2nDNnxnOKK12reBtfXZ2avjHb6FTE-1b_Xx3laIrYfddqL-fWfFR9rUY12tUiVu23Ij6fo_PVVdEfRjkco38_Fv007x4_KBOEsZymPBObDYvui_hO7lq1jSppZKsP66k6qk7SdTVPRndqjG5uo8t7EX8p-j-3yDcCdmhqbOA5GHrZKd-UkdyahqPukU1QZm2yrkc1Tdia2dNaDaE2undmAF_0AXw5IRbfm7u3gM4oapEYiuPhZBlDwkgAg0hEGAOnwsPggvRoi169eh15YSAKfScbEiITO4kcsYqcIMogcSR5ShjzpMayVp12PzbVZHlFiz4tabZhizSnm0QEaE5zlxp5wBbhhLeYgDTjHGwXzZZf9Q7_TuzGgxxVb57VERf8t45MN5SgJSelx1eMJ-fLQEWwJpLMKXsJaJqyIFCeiiWgvtws9X7-bZQoDcgJIkYJ8Z1s7Cg3aCeAgZKEnABPMAmQsj-LmbkMMEwXCZCfiFAxp5zky-QnGQuWeZpQm5gg58AvJoFwpAjkBIEibWCmSI5kghPDcqQXfBxlYc6p6wO38-77rMaHbVR-LwkiKc-WC5sTwQOUc0KD5QuNiYTvAE4d7fu5bcvFnZmriU7-KC8J9VNjOy3iCkCg5u87WUDoGsBOVKD7ADlRL8kWVql-DPdW4h_ev7m5e2Ho2gJcgcrdy0sA8wU2gify_nw-ct_JquxZJ8vlJah3N59eQCDAaSgOlgpUVugI9kSFk9xV-K1qVQUTT6lnM8ymRBlO0oDeGAn1V564trCst8z165DeuLtownpL3bX2lN6sthARidcPrbYwW16VW23hnbymYrWFnLKcI70hJ4CK8o-cAG-8iuG66WRTw4R6KvoI5k4Ds4F6HEGrh50ah7mHQbToz-AsZ6NvH_oq3ppxVqt41PPhePmYh1oa9U8jQRDd34tv68boMd7uZTvBYqslDLrx9hSbh8EOx4dmMrB9pft9c7Dr89jC8tGYYdpeX1vz-tCY47xbV7q7npraTs_H_zbiWjCRS5YokSUyTZK62tFNvmec7uuMUCZhhF7Fyp3_7nESdwP5CkaG_rPW3a-gzj8BvuAUxg)]

```mermaid
%%{init: {"flowchart": {"defaultRenderer": "elk"}} }%%
graph LR
subgraph 126022815476992 ["Table: catalog.schema1.customer AS customer"]
126022815476896["id"]
126022815476848["name"]
126022815477088["phone"]
126022815476128["address"]
126022815476176["location"]
end

subgraph 126022815476800 ["CTE: cte1 AS t1"]
126022815477040["id"]
126022815476320["name"]
126022815476368["phone"]
126022815476416["address"]
end
126022815476896 --> 126022815477040
126022815476848 --> 126022815476320
126022815477088 --> 126022815476368
126022815476128 --> 126022815476416

subgraph 126022815476032 ["Table: catalog.schema1.user_demographics AS user_demographics"]
126022815475792["id"]
126022815475936["name"]
126022815475840["age"]
126022815475696["phone"]
126022815475744["customer_job"]
126022815475600["parent"]
end

subgraph 126022815476464 ["CTE: tmp_cte AS tmp_cte"]
126022815475984["id"]
126022815475648["name"]
126022815473776["age"]
126022815475552["phone"]
126022815475456["customer_job"]
end
126022815475792 --> 126022815475984
126022815475936 --> 126022815475648
126022815475840 --> 126022815473776
126022815475696 --> 126022815475552
126022815475744 --> 126022815475456

subgraph 126022815476560 ["CTE: cte2 AS t2"]
126022815475504["id"]
126022815475360["name"]
126022815475408["age"]
126022815473728["phone"]
126022815475312["job"]
end
126022815475984 --> 126022815475504
126022815475648 --> 126022815475360
126022815473776 --> 126022815475408
126022815475552 --> 126022815473728
126022815475456 --> 126022815475312

subgraph 126022815476512 ["Subquery: _q_0"]
126022815473872["id"]
126022815474064["name"]
126022815474016["phone"]
126022815474160["address"]
126022815474112["full_name"]
126022815474256["max_age"]
end
126022815477040 --> 126022815473872
126022815476320 --> 126022815474064
126022815476368 --> 126022815474016
126022815476416 --> 126022815474160
126022815474112_exp[["CONCAT(t1.name, t2.name)"]] ----- 126022815474112
126022815476320 --> 126022815474112
126022815475360 --> 126022815474112
126022815474256_exp[["MAX(t2.age)"]] ----- 126022815474256
126022815475408 --> 126022815474256

subgraph 126022815476080 ["Select: _output_"]
126022815474352["id"]
126022815474208["name"]
126022815474304["phone"]
126022815474784["address"]
126022815474496["full_name"]
126022815474592["max_age"]
end
126022815473872 --> 126022815474352
126022815474064 --> 126022815474208
126022815474016 --> 126022815474304
126022815474160 --> 126022815474784
126022815474112 --> 126022815474496
126022815474256 --> 126022815474592
```
