"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Namespaces = exports.Namespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
const pod = require("./pod");
/**
 * In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.
 * Names of resources need to be unique within a namespace, but not across namespaces.
 * Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
 * not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
 */
class Namespace extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'namespaces';
        this.apiObject = new k8s.KubeNamespace(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this._pods = pod.Pods.all(this, 'Pods', {
            namespaces: Namespaces.select(this, 'Namespaces', { names: [this.name] }),
        });
    }
    /**
     * @see INamespaceSelector.toNamespaceSelectorConfig()
     */
    toNamespaceSelectorConfig() {
        return { names: [this.name] };
    }
    /**
     * @see INetworkPolicyPeer.toNetworkPolicyPeerConfig()
     */
    toNetworkPolicyPeerConfig() {
        return this._pods.toNetworkPolicyPeerConfig();
    }
    /**
     * @see INetworkPolicyPeer.toPodSelector()
     */
    toPodSelector() {
        return this._pods.toPodSelector();
    }
    /**
     * @internal
     */
    _toKube() {
        return {};
    }
}
exports.Namespace = Namespace;
_a = JSII_RTTI_SYMBOL_1;
Namespace[_a] = { fqn: "cdk8s-plus-22.Namespace", version: "2.0.0-rc.110" };
/**
 * @see https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
 */
Namespace.NAME_LABEL = 'kubernetes.io/metadata.name';
/**
 * Represents a group of namespaces.
 */
class Namespaces extends constructs_1.Construct {
    constructor(scope, id, expressions, names, labels) {
        super(scope, id);
        this.expressions = expressions;
        this.names = names;
        this.labels = labels;
        this._pods = pod.Pods.all(this, 'Pods', { namespaces: this });
    }
    /**
     * Select specific namespaces.
     */
    static select(scope, id, options) {
        return new Namespaces(scope, id, options.expressions, options.names, options.labels);
    }
    /**
     * Select all namespaces.
     */
    static all(scope, id) {
        return Namespaces.select(scope, id, { expressions: [], labels: {} });
    }
    /**
     * @see INamespaceSelector.toNamespaceSelectorConfig()
     */
    toNamespaceSelectorConfig() {
        return {
            labelSelector: pod.LabelSelector.of({ expressions: this.expressions, labels: this.labels }),
            names: this.names,
        };
    }
    /**
     * @see INetworkPolicyPeer.toNetworkPolicyPeerConfig()
     */
    toNetworkPolicyPeerConfig() {
        return this._pods.toNetworkPolicyPeerConfig();
    }
    /**
     * @see INetworkPolicyPeer.toPodSelector()
     */
    toPodSelector() {
        return this._pods.toPodSelector();
    }
}
exports.Namespaces = Namespaces;
_b = JSII_RTTI_SYMBOL_1;
Namespaces[_b] = { fqn: "cdk8s-plus-22.Namespaces", version: "2.0.0-rc.110" };
//# sourceMappingURL=data:application/json;base64,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