import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-cdk.aws-codestar",
    "version": "1.18.0",
    "description": "The CDK Construct Library for AWS::CodeStar",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_codestar",
        "aws_cdk.aws_codestar._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_codestar._jsii": [
            "aws-codestar@1.18.0.jsii.tgz"
        ],
        "aws_cdk.aws_codestar": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii~=0.20.8",
        "publication>=0.0.3",
        "aws-cdk.core~=1.18,>=1.18.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
