# bizerror

Collections of common business errors.

## Install

```shell
pip install bizerror
```

## Installed command utils

- bizerror-generator

## Shipped exception classes

- OK
- SysError
    - UndefinedError
    - DatabaseError
    - CacheError
    - MessageQueueError
    - AnotherServiceError
- HttpError
    - RequestExpired
    - NotSupportedHttpMethod
    - ConfigError
    - MissingConfigItem
- DataError
    - TargetNotFound
- AuthError
    - AccountLockedError
    - AccountTemporaryLockedError
    - UserPasswordError
    - AppAuthFailed
    - TsExpiredError
    - AccountDisabledError
    - AccountStatusError
    - AccountRemovedError
    - LoginRequired
    - AccessDenied
- TypeError
    - CastToIntegerFailed
    - CastToFloatFailed
    - CastToNumbericFailed
    - CastToBooleanFailed
    - CastToStringFailed
    - ParseJsonError
    - NotSupportedTypeToCast
- ParamError
    - MissingParameter
    - BadParameter
    - BadParameterType
- FormError
    - CaptchaOnlyAllowedOnce
    - CaptchaValidateFailed
    - RepeatedlySubmitForm
- LogicError

## Bug report

Please report any issues at https://github.com/zencore-cn/zencore-issues.

## Release Notes

### v0.3.1 2020-07-19

- Fix xlsxhelper dependencies problem.

### v0.3.0 2020-07-19

- Add message parameters support.
- Add exception classes.
- Add class generator and tempalte maker.

### v0.2.3 2019-12-08

- Add NotSupportedTypeToCast error.

### v0.2.0 2019-11-07

- Fix get_error_message always use default language problem.
- Add BizError.MESSAGE classproperty.

### V0.2.0 2019-11-07

- Add auto generate mechanism.
- Add language support.


### v0.1.0

- Add BizError base class.
- Add some common errors.
