"""
Removed unique constraint on role name

Revision ID: d0e0700dcd8e
Revises: 00757b557b02
Create Date: 2022-07-05 15:14:24.598238

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "d0e0700dcd8e"
down_revision = "00757b557b02"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if conn.dialect.name == "postgresql":
        op.drop_constraint("roles_name_key", "roles", type_="unique")
    else:
        op.add_column(
            "roles", sa.Column("name_temp", sa.String(length=128), nullable=True)
        )
        op.execute("UPDATE roles SET name_temp = name")
        with op.batch_alter_table("roles") as batch_op:
            batch_op.drop_column("name")

        op.add_column("roles", sa.Column("name", sa.String(length=128), nullable=True))
        op.execute("UPDATE roles SET name = name_temp")
        with op.batch_alter_table("roles") as batch_op:
            batch_op.drop_column("name_temp")
            batch_op.alter_column("name", nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if conn.dialect.name == "postgresql":
        op.create_unique_constraint("roles_name_key", "roles", ["name"])
    else:
        with op.batch_alter_table(
            "roles",
            table_args=(sa.UniqueConstraint("name"),),
        ) as batch_op:
            batch_op.alter_column("name", nullable=False)
    # ### end Alembic commands ###
