# mypy-boto3-datasync

[![PyPI - mypy-boto3-datasync](https://img.shields.io/pypi/v/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-datasync?color=blue)](https://pypistats.org/packages/mypy-boto3-datasync)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DataSync 1.17.62](https://boto3.amazonaws.com/v1/documentation/api/1.17.62/reference/services/datasync.html#DataSync) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.7.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-datasync](#mypy-boto3-datasync)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `DataSync` service.

```bash
python -m pip install boto3-stubs[datasync]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[datasync]` in your environment: `python -m pip install 'boto3-stubs[datasync]'`

Both type checking and auto-complete should work for `DataSync` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[datasync]` in your environment: `python -m pip install 'boto3-stubs[datasync]'`

Both type checking and auto-complete should work for `DataSync` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[datasync]` in your environment: `python -m pip install 'boto3-stubs[datasync]'`
- Run `mypy` as usual

Type checking should work for `DataSync` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[datasync]` in your environment: `python -m pip install 'boto3-stubs[datasync]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DataSync` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DataSyncClient` provides annotations for `boto3.client("datasync")`.

```python
import boto3

from mypy_boto3_datasync import DataSyncClient

client: DataSyncClient = boto3.client("datasync")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataSyncClient = session.client("datasync")
```

### Paginators annotations

`mypy_boto3_datasync.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_datasync import DataSyncClient
from mypy_boto3_datasync.paginator import (
    ListAgentsPaginator,
    ListLocationsPaginator,
    ListTagsForResourcePaginator,
    ListTaskExecutionsPaginator,
    ListTasksPaginator,
)

client: DataSyncClient = boto3.client("datasync")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_agents_paginator: ListAgentsPaginator = client.get_paginator("list_agents")
list_locations_paginator: ListLocationsPaginator = client.get_paginator("list_locations")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_task_executions_paginator: ListTaskExecutionsPaginator = client.get_paginator("list_task_executions")
list_tasks_paginator: ListTasksPaginator = client.get_paginator("list_tasks")
```







### Literals

`mypy_boto3_datasync.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_datasync.literals import (
    AgentStatus,
    Atime,
    EndpointType,
    FilterType,
    Gid,
    ListAgentsPaginatorName,
    ListLocationsPaginatorName,
    ListTagsForResourcePaginatorName,
    ListTaskExecutionsPaginatorName,
    ListTasksPaginatorName,
    LocationFilterName,
    LogLevel,
    Mtime,
    NfsVersion,
    ObjectStorageServerProtocol,
    Operator,
    OverwriteMode,
    PhaseStatus,
    PosixPermissions,
    PreserveDeletedFiles,
    PreserveDevices,
    S3StorageClass,
    SmbVersion,
    TaskExecutionStatus,
    TaskFilterName,
    TaskQueueing,
    TaskStatus,
    TransferMode,
    Uid,
    VerifyMode,
)

def check_value(value: AgentStatus) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_datasync.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_datasync.type_defs import (
    AgentListEntryTypeDef,
    Ec2ConfigTypeDef,
    FilterRuleTypeDef,
    LocationListEntryTypeDef,
    NfsMountOptionsTypeDef,
    OnPremConfigTypeDef,
    OptionsTypeDef,
    PrivateLinkConfigTypeDef,
    S3ConfigTypeDef,
    SmbMountOptionsTypeDef,
    TagListEntryTypeDef,
    TaskExecutionListEntryTypeDef,
    TaskExecutionResultDetailTypeDef,
    TaskListEntryTypeDef,
    TaskScheduleTypeDef,
    CreateAgentResponseTypeDef,
    CreateLocationEfsResponseTypeDef,
    CreateLocationFsxWindowsResponseTypeDef,
    CreateLocationNfsResponseTypeDef,
    CreateLocationObjectStorageResponseTypeDef,
    CreateLocationS3ResponseTypeDef,
    CreateLocationSmbResponseTypeDef,
    CreateTaskResponseTypeDef,
    DescribeAgentResponseTypeDef,
    DescribeLocationEfsResponseTypeDef,
    DescribeLocationFsxWindowsResponseTypeDef,
    DescribeLocationNfsResponseTypeDef,
    DescribeLocationObjectStorageResponseTypeDef,
    DescribeLocationS3ResponseTypeDef,
    DescribeLocationSmbResponseTypeDef,
    DescribeTaskExecutionResponseTypeDef,
    DescribeTaskResponseTypeDef,
    ListAgentsResponseTypeDef,
    ListLocationsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTaskExecutionsResponseTypeDef,
    ListTasksResponseTypeDef,
    LocationFilterTypeDef,
    PaginatorConfigTypeDef,
    StartTaskExecutionResponseTypeDef,
    TaskFilterTypeDef,
)

def get_structure() -> AgentListEntryTypeDef:
    return {
      ...
    }
```
