"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToDynamoDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class FargateToDynamoDB extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckFargateProps(props);
        defaults.CheckDynamoDBProps(props);
        defaults.CheckVpcProps(props);
        // Other permissions for constructs are accepted as arrays, turning tablePermissions into
        // an array to use the same validation function.
        if (props.tablePermissions) {
            const allowedPermissions = ['ALL', 'READ', 'READWRITE', 'WRITE'];
            defaults.CheckListValues(allowedPermissions, [props.tablePermissions.toUpperCase()], 'tablePermission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.DYNAMODB);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, {
                constructVpc: this.vpc,
                clientClusterProps: props.clusterProps,
                ecrRepositoryArn: props.ecrRepositoryArn,
                ecrImageVersion: props.ecrImageVersion,
                clientFargateTaskDefinitionProps: props.fargateTaskDefinitionProps,
                clientContainerDefinitionProps: props.containerDefinitionProps,
                clientFargateServiceProps: props.fargateServiceProps
            });
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        const response = defaults.buildDynamoDBTable(this, {
            dynamoTableProps: props.dynamoTableProps,
            existingTableInterface: props.existingTableInterface
        });
        this.dynamoTableInterface = response.tableInterface;
        this.dynamoTable = response.tableObject;
        // Add the requested or default table permissions
        if (props.tablePermissions) {
            const permission = props.tablePermissions.toUpperCase();
            if (permission === 'ALL') {
                this.dynamoTableInterface.grantFullAccess(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'READ') {
                this.dynamoTableInterface.grantReadData(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'READWRITE') {
                this.dynamoTableInterface.grantReadWriteData(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'WRITE') {
                this.dynamoTableInterface.grantWriteData(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.dynamoTableInterface.grantReadWriteData(this.service.taskDefinition.taskRole);
        }
        // Add environment variables
        const tableArnEnvironmentVariableName = props.tableArnEnvironmentVariableName || 'DYNAMODB_TABLE_ARN';
        this.container.addEnvironment(tableArnEnvironmentVariableName, this.dynamoTableInterface.tableArn);
        const tableEnvironmentVariableName = props.tableEnvironmentVariableName || 'DYNAMODB_TABLE_NAME';
        this.container.addEnvironment(tableEnvironmentVariableName, this.dynamoTableInterface.tableName);
    }
}
exports.FargateToDynamoDB = FargateToDynamoDB;
_a = JSII_RTTI_SYMBOL_1;
FargateToDynamoDB[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-dynamodb.FargateToDynamoDB", version: "2.63.0" };
//# sourceMappingURL=data:application/json;base64,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