"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreTask = exports.RestoreTaskProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dbs_generated_1 = require("./dbs.generated");
Object.defineProperty(exports, "RestoreTaskProperty", { enumerable: true, get: function () { return dbs_generated_1.RosRestoreTask; } });
/**
 * A ROS resource type:  `ALIYUN::DBS::RestoreTask`
 */
class RestoreTask extends ros.Resource {
    /**
     * Create a new `ALIYUN::DBS::RestoreTask`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRestoreTask = new dbs_generated_1.RosRestoreTask(this, id, {
            startTask: props.startTask === undefined || props.startTask === null ? true : props.startTask,
            restoreDir: props.restoreDir,
            duplicateConflict: props.duplicateConflict,
            restoreHome: props.restoreHome,
            destinationEndpointPassword: props.destinationEndpointPassword,
            destinationEndpointIp: props.destinationEndpointIp,
            destinationEndpointPort: props.destinationEndpointPort,
            destinationEndpointOracleSid: props.destinationEndpointOracleSid,
            backupSetId: props.backupSetId,
            destinationEndpointInstanceType: props.destinationEndpointInstanceType,
            restoreTime: props.restoreTime,
            destinationEndpointRegion: props.destinationEndpointRegion,
            destinationEndpointDatabaseName: props.destinationEndpointDatabaseName,
            destinationEndpointUserName: props.destinationEndpointUserName,
            restoreObjects: props.restoreObjects,
            restoreTaskName: props.restoreTaskName,
            backupPlanId: props.backupPlanId,
            backupGatewayId: props.backupGatewayId,
            destinationEndpointInstanceId: props.destinationEndpointInstanceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRestoreTask;
        this.attrRestoreTaskId = rosRestoreTask.attrRestoreTaskId;
    }
}
exports.RestoreTask = RestoreTask;
//# sourceMappingURL=data:application/json;base64,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