# generated by datamodel-codegen:
#   filename:  bundled.py-filtered.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import AnyUrl, BaseModel, Field
from typing_extensions import Literal


class PingResponse(BaseModel):
    message: str
    success: bool


class GetNpmCredentialsResponse(BaseModel):
    authToken: str = Field(..., description="Temporary auth token")
    repositoryEndpoint: str = Field(..., description="The npm repository endpoint")


class Status(Enum):
    ACTIVE = "ACTIVE"
    DEPRECATED = "DEPRECATED"


class EnforcementLevel(Enum):
    RECORD = "RECORD"
    NOTIFY = "NOTIFY"
    ALERT = "ALERT"
    BLOCK = "BLOCK"
    INACTIVE = "INACTIVE"


class ContractInput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: str = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added this contract")
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    filePath: str = Field(
        ...,
        description="path to the contract file from the root of the git repository",
        regex="^([^/]+\\/)*[^/]+$",
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default=None, description="alert level for contract"
    )
    contractSpec: Dict[str, Any] = Field(
        ...,
        description="This is the possible contract specification. If it is valid, it will  match the contract specification schema. However, we have to allow  for invalid contracts to be passed to Gable even if we reject them.",
    )
    lastEditorUserId: Optional[UUID] = Field(
        default=None,
        description="Unique identifier for the user who last edited the contract through the UI",
    )
    lastEditorEmail: Optional[str] = Field(
        default=None,
        description="Email of the user who last edited the contract through the UI",
    )
    lastEditorFirstName: Optional[str] = Field(
        default=None,
        description="First name of the user who last edited the contract through the UI",
    )
    lastEditorLastName: Optional[str] = Field(
        default=None,
        description="Last name of the user who last edited the contract through the UI",
    )
    lastEditorGithubHandle: Optional[str] = Field(
        default=None,
        description="GitHub handle of the user who last edited the contract through the UI",
    )


class PostContractRequest(BaseModel):
    __root__: Union[ContractInput, List[ContractInput]]


class CheckResponse(BaseModel):
    message: str
    success: bool


class ContractOutput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: str = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added/updated this contract")
    fileUri: AnyUrl = Field(
        ..., description="full link to the file in the repo that contains this contract"
    )
    filePath: Optional[str] = Field(
        default=None,
        description="path to the contract file from the root of the git repository",
    )
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    createdAt: datetime = Field(
        ..., description="date time at which the contract was created"
    )
    updatedAt: datetime = Field(
        ..., description="date time at which the contract was last updated"
    )
    contractSpec: Dict[str, Any] = Field(..., description="contract spec")
    contractSpecRaw: str = Field(..., description="contract spec raw json")
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default="INACTIVE", description="alert level for contract"
    )
    lastEditorUserId: Optional[UUID] = Field(
        default=None,
        description="Unique identifier for the user who last edited the contract through the UI",
    )
    lastEditorEmail: Optional[str] = Field(
        default=None,
        description="Email of the user who last edited the contract through the UI",
    )
    lastEditorFirstName: Optional[str] = Field(
        default=None,
        description="First name of the user who last edited the contract through the UI",
    )
    lastEditorLastName: Optional[str] = Field(
        default=None,
        description="Last name of the user who last edited the contract through the UI",
    )
    lastEditorGithubHandle: Optional[str] = Field(
        default=None,
        description="GitHub handle of the user who last edited the contract through the UI",
    )


class GetContractsResponse(BaseModel):
    __root__: List[ContractOutput]


class ErrorResponse(BaseModel):
    id: Optional[float] = None
    title: Optional[str] = None
    message: str


class PostContractResponse(BaseModel):
    message: str
    contractIds: List[UUID] = Field(
        ...,
        description="List of contract IDs that were updated, if no contracts were updated this will be an empty list",
    )


class ContractActivityUpdateEvent(BaseModel):
    type: Literal["CONTRACT_UPDATED"] = Field(..., description="type of the event")
    datetime: datetime = Field(
        ..., description="date time at which the contract was updated"
    )
    fileUri: AnyUrl = Field(
        ...,
        description="full link to the file and commit in the repo that contains this updated contract",
    )
    gitUser: Optional[str] = Field(
        default=None, description="the git user who edited the contract"
    )


class ContractActivityCreateEvent(BaseModel):
    type: Literal["CONTRACT_CREATED"] = Field(..., description="type of the event")
    datetime: datetime = Field(
        ..., description="date time at which the contract was created"
    )
    fileUri: AnyUrl = Field(
        ...,
        description="full link to the file and commit in the repo that contains this created contract",
    )
    gitUser: Optional[str] = Field(
        default=None, description="the git user who created the contract"
    )


class ContractActivityResponse(BaseModel):
    __root__: List[
        Union[ContractActivityUpdateEvent, ContractActivityCreateEvent]
    ] = Field(
        ...,
        description="List of contract activity events in chronological order (oldest first)",
        min_items=1,
    )


class ContractSubscription(BaseModel):
    id: UUID = Field(..., description="The unique identifier of the subscription")
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the subscriber if provided"
    )


class UpdateContractSubscriptionRequest(BaseModel):
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle for the subscriber if provided"
    )


class CreateContractSubscriptionRequest(BaseModel):
    dataContractId: UUID = Field(..., description="Unique identifier of the contract")
    userId: Optional[UUID] = Field(
        default=None, description="The unique identifier of the user"
    )
    email: Optional[str] = Field(
        default=None,
        description="The email address of the subscriber if provided",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the subscriber if provided"
    )


class GetContractSubscriptionsResponse(BaseModel):
    __root__: List[ContractSubscription]


class BaseSnowflakeLineageIntegrationConfig(BaseModel):
    type: Literal["SNOWFLAKE"] = Field(
        ..., description="Type of the lineage integration"
    )
    account_id: str = Field(..., description="Snowflake account id")
    warehouse: str = Field(..., description="Snowflake warehouse", regex="^\\S{1,255}$")
    role: str = Field(..., description="Snowflake role", regex="^\\S{1,255}$")
    table_ignore_patterns: Optional[List[str]] = Field(
        default=None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetSnowflakeCredentials(BaseModel):
    username: str = Field(..., description="Snowflake username", regex="^\\S{1,255}$")


class SnowflakePasswordCredentials(GetSnowflakeCredentials):
    password: str = Field(
        ...,
        description="Password for the Snowflake user",
        regex="^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$",
    )


class SnowflakeKeyPairCredentials(GetSnowflakeCredentials):
    private_key_base64: str = Field(..., description="Base64 encoded private key")
    private_key_passphrase: Optional[str] = Field(
        default=None, description="Optional private key passphrase"
    )


class CreateOrUpdateSnowflakeLineageIntegrationConfig1(
    BaseSnowflakeLineageIntegrationConfig
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig2(
    SnowflakePasswordCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig3(
    SnowflakeKeyPairCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig(BaseModel):
    __root__: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig2,
        CreateOrUpdateSnowflakeLineageIntegrationConfig3,
    ]


class BaseBigQueryLineageIntegrationConfig(BaseModel):
    type: Literal["BIG_QUERY"] = Field(
        ..., description="Type of the lineage integration"
    )
    project_id: str = Field(
        ...,
        description="BigQuery project id",
        regex="^[a-z][-a-z0-9]{4,28}[a-z0-9]{1}$",
    )
    table_ignore_patterns: Optional[List[str]] = Field(
        default=None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetBigQueryCredentials(BaseModel):
    service_account_email: str = Field(
        ...,
        description="BigQuery service account email",
        regex="^[a-z0-9-]{6,30}@[a-z][-a-z0-9]{4,28}[a-z0-9]{1}\\.iam\\.gserviceaccount\\.com$",
    )
    service_account_id: str = Field(
        ..., description="BigQuery service account id", regex="^[a-z0-9-]{6,30}$"
    )
    service_account_private_key_id: str = Field(
        ..., description="BigQuery service account private key id"
    )


class BigQueryServiceAccountKeyCredentials(GetBigQueryCredentials):
    service_account_private_key_base64: str = Field(
        ...,
        description="Base64 encoded private key",
        regex="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$",
    )


class CreateOrUpdateBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, BigQueryServiceAccountKeyCredentials
):
    pass


class CreateOrUpdateLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
        regex="^((((\\d+,)+\\d+|(\\d+(/|-|#)\\d+)|\\d+L?|\\*(/\\d+)?|L(-\\d+)?|\\?|[A-Z]{3}(-[A-Z]{3})?) ?){5,7})$",
    )
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class CreateOrUpdateLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the created or updated lineage integration")


class GetSnowflakeLineageIntegrationConfig(
    BaseSnowflakeLineageIntegrationConfig, GetSnowflakeCredentials
):
    pass


class GetBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, GetBigQueryCredentials
):
    pass


class GetLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the lineage integration")
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
    )
    config: Union[
        GetSnowflakeLineageIntegrationConfig, GetBigQueryLineageIntegrationConfig
    ] = Field(..., description="Configuration for the lineage integration")


class GetLineageIntegrationsResponse(BaseModel):
    __root__: List[GetLineageIntegrationResponse]


class TestLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class TestLineageIntegrationResponse(BaseModel):
    success: bool = Field(
        ..., description="a boolean indicating if the lineage integration is valid"
    )
    message: Optional[str] = Field(
        default=None,
        description="a message indicating why the lineage integration is invalid",
    )


class DataAssetResourceName(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique identifier of the data asset. It follows the pattern '{data_asset_type}://{data_asset_source}:{data_asset_name}'",
        regex="^(protobuf|avro|json_schema|postgres|mysql|snowflake|bigquery|python|pyspark|typescript)://(?=.*[a-zA-Z0-9])[a-zA-Z0-9_@\\.:/-]+:(?=.*[a-zA-Z0-9 ])[a-zA-Z0-9 _\\./-]+$",
    )


class DataAssetSearchResult(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset.")
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ...,
        description='The domain to which the data asset belongs. Previously referred to as "namespace."',
    )
    path: str = Field(
        ...,
        description='The name or path identifying the data asset. Previously referred to as "name."',
    )
    type: str = Field(
        ...,
        description="The type of the data asset, indicating its source or format (e.g., Postgres, Protobuf).",
    )
    contractId: Optional[str] = Field(
        default=None, description="The contract ID associated with the data asset."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp of the most recent update to the data asset."
    )


class CreateOrUpdateDataAssetFieldRequest(BaseModel):
    name: str = Field(..., description="The name of the field.")
    description: Optional[str] = Field(
        default=None, description="A brief description of the field."
    )
    order: int = Field(
        ..., description="The order or position of the field in the data asset."
    )
    nativeDataType: str = Field(
        ..., description="The native data type of the field in the source system."
    )
    type: Optional[Dict[str, Any]] = Field(
        default=None,
        description="A custom or specific attribute to represent the Gable type of the field.",
    )
    parentFieldId: Optional[UUID] = Field(
        default=None,
        description="For nested fields, this is the ID of the parent field.",
    )


class CreateOrUpdateDataAssetRequest(BaseModel):
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ..., description="The domain or category to which the data asset belongs."
    )
    path: str = Field(..., description="The name or path identifying the data asset.")
    type: str = Field(
        ...,
        description="The type of the data asset, indicating its source or format (e.g., Postgres, Protobuf).",
    )
    description: Optional[str] = Field(
        default=None,
        description="A brief description of this particular version of the data asset.",
    )
    rawSchema: Optional[str] = Field(
        default=None,
        description="The raw schema of the data asset from the source system. This can be the contents of a schema file or data from the information  schema of a database. This is used to regenerate the schema of the data asset if needed.",
    )
    fields: List[CreateOrUpdateDataAssetFieldRequest] = Field(
        ..., description="The fields of the data asset."
    )


class CreateOrUpdateDataAssetResponse(BaseModel):
    id: UUID = Field(..., description="ID of the created or updated data asset")
    versionId: Optional[UUID] = Field(
        default=None, description="Version ID of the now current data asset"
    )
    dataAssetResourceName: Optional[DataAssetResourceName] = None
    newVersionCreated: Optional[bool] = Field(
        default=None, description="Indicates whether a new version was created"
    )


class Input(BaseModel):
    sourceName: str
    sourceType: str
    schemaContents: str
    realDbName: Optional[str] = None
    realDbSchema: Optional[str] = None


class ResponseType(Enum):
    DETAILED = "DETAILED"
    COMMENT_MARKDOWN = "COMMENT_MARKDOWN"


class CheckDataAssetsRequest(BaseModel):
    inputs: List[Input]
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )


class CheckDataAssetNoContractResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: str = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    responseType: Literal["NO_CONTRACT"]


class ContractViolationType(Enum):
    MISSING_DATA_ASSET = "MISSING_DATA_ASSET"
    MISSING_REQUIRED_PROPERTY = "MISSING_REQUIRED_PROPERTY"
    INCOMPATIBLE_TYPE = "INCOMPATIBLE_TYPE"


class Violation(BaseModel):
    message: str
    field: str
    fieldType: str
    violationType: ContractViolationType
    expected: str
    actual: Optional[str] = None


class Subscriber(BaseModel):
    email: Optional[str] = None
    githubHandle: Optional[str] = None


class CheckDataAssetDetailedResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: str = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    contractId: UUID
    contractUrl: str = Field(..., description="Link to the contract in the Gable UI")
    contractNamespace: str
    contractName: str
    contractOwner: str
    contractOwnerGithubHandle: Optional[str] = None
    violations: Optional[List[Violation]] = None
    subscribers: List[Subscriber]
    responseType: Literal["DETAILED"]
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default="INACTIVE", description="alert level for contract"
    )


class CheckDataAssetErrorResponse(BaseModel):
    dataAssetNamespace: str = Field(
        ...,
        description="The namespace of the data asset",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432",
            "protobuf://github.com/org/repo/path/to/file.proto",
        ],
    )
    dataAssetResourceName: Optional[str] = Field(
        default=None,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: Optional[str] = Field(
        default=None,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    message: str = Field(..., description="The error message")
    responseType: Literal["ERROR"]
    enforcementLevel: Optional[EnforcementLevel] = Field(
        default=None, description="notification tier of error response"
    )


class CheckDataAssetMissingAssetResponse(BaseModel):
    dataAssetResourceName: str = Field(
        ...,
        description="The full resource name of the data asset, see [Data Assets](https://docs.gable.ai/data_assets_and_lineage/data_assets)",
        examples=[
            "postgres://service-one.aaa.eu-west-1.rds.amazonaws.com:5432:serviceone.public.sales",
            "protobuf://git@github.com/org/repo/path/to/file.proto:company.serviceone.Sales",
        ],
    )
    dataAssetPath: str = Field(
        ...,
        description="The relative path of the data asset within its data store",
        examples=["serviceone.public.sales", "company.serviceone.Sales"],
    )
    contract: ContractOutput
    contractOwner: str
    contractOwnerGithubHandle: Optional[str] = None
    subscribers: List[Subscriber]
    responseType: Literal["MISSING_DATA_ASSET"]


class CheckDataAssetCommentMarkdownResponse(BaseModel):
    markdown: Optional[str] = None
    shouldAlert: bool = Field(
        ...,
        description="Whether or not to comment on the PR - true if at least one contract with a contract violation has its enforcement level set to ALERT or BLOCK.",
    )
    shouldBlock: bool = Field(
        ...,
        description="Whether or not to block the PR - true if at least one contract with a contract violation has its enforcement level set to BLOCK.",
    )
    errors: Optional[List[CheckDataAssetErrorResponse]] = None
    responseType: Literal["COMMENT_MARKDOWN"]


class CheckDataAssetsResponse(BaseModel):
    __root__: Union[
        List[
            Union[
                CheckDataAssetNoContractResponse,
                CheckDataAssetDetailedResponse,
                CheckDataAssetErrorResponse,
                CheckDataAssetMissingAssetResponse,
            ]
        ],
        CheckDataAssetCommentMarkdownResponse,
    ]


class GableSchemaLogicalTypes(BaseModel):
    pass


class GableSchemaNull(BaseModel):
    type: Literal["null"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaBool(BaseModel):
    type: Literal["bool"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaInt(BaseModel):
    type: Literal["int"]
    bits: int = Field(..., ge=1, le=2147483647)
    signed: Optional[bool] = None
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaFloat(BaseModel):
    type: Literal["float"]
    bits: int = Field(..., ge=1, le=2147483647)
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaString(BaseModel):
    type: Literal["string"]
    bytes: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = True
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaBytes(BaseModel):
    type: Literal["bytes"]
    bytes: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = None
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaType(GableSchemaLogicalTypes):
    pass


class GableSchemaList(BaseModel):
    type: Literal["list"]
    values: GableSchemaType
    length: Optional[int] = Field(default=None, ge=1, le=9223372036854776000)
    variable: Optional[bool] = True
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaMap(BaseModel):
    type: Literal["map"]
    keys: GableSchemaType
    values: GableSchemaType
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaEnum(BaseModel):
    type: Literal["enum"]
    symbols: List[str]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaUnion(BaseModel):
    type: Literal["union"]
    types: List[GableSchemaType]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaAliasReference(BaseModel):
    type: str
    doc: Optional[str] = None
    logical: Optional[str] = None


class GableSchemaUnknown(BaseModel):
    type: Literal["unknown"]
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None


class PySparkAsset(BaseModel):
    schema_: Dict[str, Any] = Field(
        ..., alias="schema", description="The schema of the data asset"
    )
    git_host: str = Field(
        ...,
        description="The git host where the schema is stored (must match the format of <domain>:<org>/<repo>, e.g. github.com:gable/repo)",
        regex="^[a-zA-Z0-9-]+\\.[a-zA-Z]{2,3}:[a-zA-Z0-9-]+\\/[a-zA-Z0-9-_]+$",
    )
    spark_entrypoint: str = Field(
        ..., description="The entrypoint of the spark job which produced this asset"
    )
    spark_table: str = Field(..., description="The table name for this asset")
    project_name: str = Field(
        ..., description="The project name in which the asset is defined"
    )


class CheckComplianceDataAssetsPySparkRequest(BaseModel):
    assets: List[PySparkAsset] = Field(
        ..., description="Array of data assets to check for compliance"
    )
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )


class Library(Enum):
    brandviews = "brandviews"
    segment = "segment"


class TypeScriptAsset(BaseModel):
    schema_: Dict[str, Any] = Field(
        ..., alias="schema", description="The schema of the data asset"
    )
    git_host: str = Field(
        ...,
        description="The git host where the schema is stored (must match the format of <domain>:<org>/<repo>, e.g. github.com:gable/repo)",
        regex="^[a-zA-Z0-9-]+\\.[a-zA-Z]{2,3}:[a-zA-Z0-9-]+\\/[a-zA-Z0-9-_]+$",
    )
    library: Library = Field(..., description="Name of TypeScript library")
    event_name: str = Field(..., description="Name of the event")
    project_root: str = Field(
        ..., description="root directory of the TypeScript project"
    )


class CheckComplianceDataAssetsTypeScriptRequest(BaseModel):
    assets: List[TypeScriptAsset] = Field(
        ..., description="Array of data assets to check for compliance"
    )
    responseType: ResponseType = Field(
        ...,
        description="Determines the format of the response from the API. Specifying 'DETAILED' will return a detailed JSON object for each data asset checked. If 'COMMENT_MARKDOWN' is specified, the response will be a markdown string intended to be used as a comment in a pull request.",
    )


class SourceType(Enum):
    postgres = "postgres"
    mysql = "mysql"
    json_schema = "json_schema"
    avro = "avro"
    protobuf = "protobuf"
    python = "python"
    pyspark = "pyspark"


class IngestDataAssetRequest(BaseModel):
    sourceType: SourceType = Field(..., description="The type of the source data asset")
    sourceNames: List[str] = Field(..., description="The names of the sources")
    databaseSchema: str = Field(..., description="The name of the database schema")
    schema_: List[str] = Field(
        ...,
        alias="schema",
        description="Array of schemas. Each schema could be from a db information schema or the contents of a schema file.",
    )
    dryRun: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class IngestDataAssetResponse(BaseModel):
    message: str = Field(..., description="Response message")
    registered: List[str] = Field(
        ..., description="List of the registered data asset ids"
    )
    success: bool = Field(..., description="Whether the request was successful")


class ErrorResponseDeprecated(BaseModel):
    id: Optional[float] = None
    title: Optional[str] = None
    message: str
    success: Optional[bool] = None


class RegisterDataAssetPySparkRequest(BaseModel):
    assets: List[PySparkAsset] = Field(
        ..., description="Array of data assets to register"
    )
    dry_run: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class RegisterDataAssetTypeScriptRequest(BaseModel):
    assets: List[TypeScriptAsset] = Field(
        ..., description="Array of data assets to register"
    )
    dry_run: Optional[bool] = Field(
        default=False, description="If true, no data asset will be registered"
    )


class DataAssetField(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset field.")
    dataAssetVersionId: UUID = Field(
        ...,
        description="The identifier of the data asset version this field belongs to.",
    )
    name: str = Field(..., description="The name of the field.")
    description: Optional[str] = Field(
        default=None, description="A brief description of the field."
    )
    order: int = Field(
        ..., description="The order or position of the field in the data asset."
    )
    nativeDataType: str = Field(
        ..., description="The native data type of the field in the source system."
    )
    type: Optional[Dict[str, Any]] = Field(
        default=None,
        description="A custom or specific attribute to represent the Gable type of the field.",
    )
    displayType: str = Field(..., description="The display name of the field.")
    parentFieldId: Optional[UUID] = Field(
        default=None,
        description="For nested fields, this is the ID of the parent field.",
    )
    createdAt: datetime = Field(
        ..., description="The timestamp when the field was created."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp when the field was last updated."
    )
    deletedAt: Optional[datetime] = Field(
        default=None, description="The timestamp when the field was marked as deleted."
    )


class DataAssetVersion(BaseModel):
    id: UUID = Field(
        ..., description="The unique identifier for the version of the data asset."
    )
    dataAssetId: UUID = Field(
        ...,
        description="The identifier of the parent data asset to which this version belongs.",
    )
    description: Optional[str] = Field(
        default=None,
        description="A brief description of this particular version of the data asset.",
    )
    rawSchema: Optional[str] = Field(
        default=None,
        description="The raw schema of the data asset from the source system. This can be the contents of a schema file or data from the information  schema of a database. This is used to regenerate the schema of the data asset if needed.",
    )
    fields: List[DataAssetField] = Field(
        ..., description="The fields of the data asset."
    )
    createdAt: datetime = Field(
        ...,
        description="The timestamp when this version of the data asset was created.",
    )
    updatedAt: datetime = Field(
        ...,
        description="The timestamp when this version of the data asset was last updated.",
    )
    deletedAt: Optional[datetime] = Field(
        default=None,
        description="The timestamp when this version of the data asset was marked as deleted, if applicable.",
    )


class DataAsset(BaseModel):
    id: UUID = Field(..., description="The unique identifier for the data asset.")
    dataAssetResourceName: DataAssetResourceName
    domain: str = Field(
        ...,
        description='The domain to which the data asset belongs. Previously referred to as "namespace."',
    )
    path: str = Field(
        ...,
        description='The name or path identifying the data asset. Previously referred to as "name."',
    )
    type: str = Field(
        ...,
        description="The type of the data asset, indicating its source or format (e.g., Postgres, Protobuf).",
    )
    contractId: Optional[str] = Field(
        default=None, description="The contract ID associated with the data asset."
    )
    versionDetail: DataAssetVersion = Field(
        ..., description="The version details of the data asset."
    )
    createdAt: datetime = Field(
        ..., description="The timestamp of when the data asset was initially created."
    )
    updatedAt: datetime = Field(
        ..., description="The timestamp of the most recent update to the data asset."
    )
    deletedAt: Optional[datetime] = Field(
        default=None,
        description="The timestamp indicating when the data asset was deleted, if applicable.",
    )
    schema_: Optional[Dict[str, Any]] = Field(default=None, alias="schema")


class InferContractFromDataAssetResponse(BaseModel):
    contractId: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: Optional[str] = Field(
        default=None, description="Version of the contract (semantic versioning)"
    )
    status: Optional[Status] = Field(default=None, description="status of the contract")
    gitHash: Optional[str] = Field(
        default=None,
        description="full length git hash corresponding to the commit this contract was added/updated",
        max_length=40,
        min_length=40,
    )
    gitRepo: Optional[AnyUrl] = Field(
        default=None, description="full link to the git repo this contract lives in"
    )
    gitUser: Optional[str] = Field(
        default=None, description="git user who added/updated this contract"
    )
    fileUri: Optional[AnyUrl] = Field(
        default=None,
        description="full link to the file in the repo that contains this contract",
    )
    reviewers: Optional[List[str]] = Field(
        default=None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    mergedAt: Optional[datetime] = Field(
        default=None,
        description="date time at which the PR that added/updated this contract was merged",
    )
    createdAt: Optional[datetime] = Field(
        default=None, description="date time at which the contract was created"
    )
    updatedAt: Optional[datetime] = Field(
        default=None, description="date time at which the contract was last updated"
    )
    contractSpec: Dict[str, Any] = Field(..., description="contract spec")
    contractSpecRaw: str = Field(..., description="contract spec raw json")


class GetAvailableLineageIntegrationsResponse(BaseModel):
    __root__: List[str]


class GetAvailableLineageIntegrationDetailsResponseItem(BaseModel):
    instructions: Optional[str] = Field(
        default=None, description="Instructions for setting up the lineage integration"
    )
    requiredInputs: Optional[List[str]] = Field(
        default=None,
        description="Required inputs for setting up the lineage integration",
    )


class GetAvailableLineageIntegrationDetailsResponse(BaseModel):
    __root__: List[GetAvailableLineageIntegrationDetailsResponseItem]


class GetApiKeysResponseItem(BaseModel):
    id: Optional[str] = Field(default=None, description="The identifier of the API key")
    name: Optional[str] = Field(default=None, description="The name of the API key")
    value: Optional[str] = Field(default=None, description="The value of the API key")


class GetApiKeysResponse(BaseModel):
    __root__: List[GetApiKeysResponseItem]


class GetSsoSamlSetupDetailsResponse(BaseModel):
    ssoUrl: str = Field(
        ...,
        description="The location where the SAML assertion is sent with a HTTP POST, also referred to as the SAML Assertion Consumer Service (ACS) URL.",
    )
    audienceUri: str = Field(
        ...,
        description="(SP Entity Id) The application-defined unique identifier that is the intended audience of the SAML assertion. This is most often the SP Entity ID of your application.",
    )


class SsoSamlUrlConfig(BaseModel):
    type: Literal["SAML"] = Field(
        ...,
        description="The type of SSO integration, currently only SAML is supported.",
    )
    identityProvider: str = Field(
        ...,
        description='The name of your identity provider. This value will be displayed to users when they log in. \n\nNote: This value cannot be the strings "Google" or "SAML" as they\'re reserved words in our identity management platform.\n',
        examples=["Okta", "GoogleWorkspace", "OneLogin", "JumpCloud"],
        regex="^(?=[a-zA-Z0-9\\(\\)\\.\\-!@]+$)(?!Google|SAML$).*$",
    )
    metadataDocumentEndpointUrl: str = Field(
        ...,
        description="The URL of the SAML metadata document. Either this or metadataFileContents must be provided.",
        example="https://company.okta.com/app/123456789/sso/saml/metadata",
    )


class SsoSamlFileConfig(BaseModel):
    type: Literal["SAML"] = Field(
        ...,
        description="The type of SSO integration, currently only SAML is supported.",
    )
    identityProvider: str = Field(
        ...,
        description='The name of your identity provider. This value will be displayed to users when they log in. \n\nNote: This value cannot be the strings "Google" or "SAML" as they\'re reserved words in our identity management platform.\n',
        examples=["Okta", "GoogleWorkspace", "OneLogin", "JumpCloud"],
        regex="^(?=[a-zA-Z0-9\\(\\)\\.\\-!@]+$)(?!Google|SAML$).*$",
    )
    metadataFileContents: str = Field(
        ...,
        description="The contents of the metadata document. Either this or metadataDocumentEndpointUrl must be provided.",
    )


class SsoConfig(BaseModel):
    __root__: Union[SsoSamlUrlConfig, SsoSamlFileConfig]


class GetUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )


class GetUserResponse(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user, if available"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user, if available"
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the user or team, if available"
    )


class UpdateUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )
    githubHandle: Optional[str] = Field(
        default=None,
        description="The GitHub handle of the user",
        regex="^[a-zA-Z0-9-]*$",
    )


class UpdateUserResponse(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )
    githubHandle: Optional[str] = Field(
        default=None, description="The GitHub handle of the user"
    )


class GetUsersResponseItem(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user, if available"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user, if available"
    )


class GetUsersResponse(BaseModel):
    __root__: List[GetUsersResponseItem]


class InviteUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )
    firstName: Optional[str] = Field(
        default=None, description="The first name of the user"
    )
    lastName: Optional[str] = Field(
        default=None, description="The last name of the user"
    )


class DeleteUserRequest(BaseModel):
    email: str = Field(
        ...,
        description="The email address of the user, which is the primary ID in Gable",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$",
    )


class FieldModel(GableSchemaType):
    name: Optional[str] = None
    default: Optional[str] = None


class GableSchemaStruct(BaseModel):
    type: Literal["struct"]
    name: Optional[str] = None
    fields: Optional[List[FieldModel]] = None
    alias: Optional[str] = Field(
        default=None, regex="^[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+$"
    )
    doc: Optional[str] = None
    logical: Optional[str] = None
