# LaTeX Generator

A Python library to generate LaTeX code for tables and images.

## Installation

You can install the library using `pip`:

```bash
pip install latex_generator
```

If you want to install it directly from the source, clone the repository and run:

```bash
pip install .
```

## Usage

The library provides functions to generate LaTeX code for tables and images. You can combine them to create a complete LaTeX document.

### Example 1: Generating a Table

```python
from latex_generator import generate_latex

data = [
    ["ID", "Name", "POWER"],
    [1, "Ann", 9],
    [2, "Boris", 30],
    [3, "C. A. T.", 1000000000]
]

latex_code = generate_latex(data=data)
print(latex_code)
```

### Example 2: Generating an Image

```python
from latex_generator import generate_latex

latex_code = generate_latex(image_path="example.png")
print(latex_code)
```

### Example 3: Combining Table and Image

```python
from latex_generator import generate_latex

data = [
    ["ID", "Name", "POWER"],
    [1, "Ann", 9],
    [2, "Boris", 30],
    [3, "C. A. T.", 1000000000]
]

latex_code = generate_latex(data=data, image_path="example.png")
print(latex_code)
```

### Output

The output will be a complete LaTeX document:

```latex
\documentclass{article}
\usepackage{booktabs}
\usepackage{graphicx}
\begin{document}

\begin{table}[h]
\centering
\begin{tabular}{| c | c | c |}
\hline
ID & Name & POWER \\
\hline
1 & Ann & 9 \\
\hline
2 & Boris & 30 \\
\hline
3 & C. A. T. & 1000000000 \\
\hline
\end{tabular}
\caption{Table}
\label{tab:example}
\end{table}

\begin{figure}[h]
    \centering
    \includegraphics[width=0.5\textwidth]{example.png}
    \caption{Example Image}
    \label{fig:example}
\end{figure}

\end{document}
```

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## Contributing

No contributing.

## Author

[https://github.com/jeck5iv](https://github.com/jeck5iv)
