from tests import IntegrationTest

class TestAnswersPerUser(IntegrationTest):

    def setUp(self):
        super().setUp()
        self.user1_id = self.create_user('user1', self.instru1_id, [])
        self.user2_id = self.create_user('user2', self.instru2_id, [])
        self.date1_id = self.create_date(date='2025-03-10', time='15:00:00', title='firstDate')
        self.date2_id = self.create_date(date='2025-03-11', time='18:00:00', title='secondDate')
        self.date3_id = self.create_date(date='2025-03-12', time=None, title='thirdDate')
        self.answer1_id = self.create_answer(user_id=self.user1_id, date_id=self.date1_id)
        self.answer2_id = self.create_answer(user_id=self.user1_id, date_id=self.date2_id)
        self.answer3_id = self.create_answer(user_id=self.user1_id, date_id=self.date3_id)
        self.answer4_id = self.create_answer(user_id=self.user2_id, date_id=self.date1_id)
        self.answer5_id = self.create_answer(user_id=self.user2_id, date_id=self.date2_id)
        self.answer6_id = self.create_answer(user_id=self.user2_id, date_id=self.date3_id)
        
    def test_get_answers_user(self):            
        _json = self.get_user(self.user1_id)
        assert _json['user']['user']['id'] == self.user1_id
        assert len(_json['dates']) == 3
        assert _json['dates'][0].get('answer', None) != None
        assert _json['dates'][0]['answer']['response'] == True
        
        assert _json['dates'][1].get('answer', None) != None
        assert _json['dates'][1]['answer']['response'] == True
        
        assert _json['dates'][2].get('answer', None) != None
        assert _json['dates'][2]['answer']['response'] == True

    # def test_get_answer_answerId(self):
    #     _json = self.toJSON(self.get_answer(self.answer1_id))
    #     assert len(_json['answers']) == 1
    #     assert _json['answers'][0]['user_id'] == self.user1_id
    #     assert _json['answers'][0]['date_id'] == self.date1_id
    #     assert _json['answers'][0]['response'] == True

    #     _json = self.toJSON(self.get_answer(999))
    #     assert len(_json['answers']) == 0