import requests
import json

class Callback(object):

    def __init__(self):
        self.validation_data = None

    def set_params(self, params):
        self.params = params

    def set_model(self, model):
        self.model = model

    def on_epoch_begin(self, epoch, logs=None):
        pass

    def on_epoch_end(self, epoch, logs=None):
        pass

    def on_batch_begin(self, batch, logs=None):
        pass

    def on_batch_end(self, batch, logs=None):
        pass

    def on_train_begin(self, logs=None):
        pass

    def on_train_end(self, logs=None):
        pass
    
    def on_train_batch_begin(self, epoch, logs=None):
        pass

    def on_train_batch_end(self, epoch, logs=None):
        pass

class Messenger():

    def __init__(self, conv_id):
        self.conv_id = conv_id
        self.send_message("All ready!")

    def send_message(self, message):
        requests.post("https://code-monitor.herokuapp.com/sendMessage",
                      data=json.dumps({"text":message,"id":self.conv_id}),
                      headers={'Content-type': 'application/json', 'Accept': 'text/plain'})

class FitMonitor(Callback):

    def __init__(self, conv_id, log_keys="all"):
        super(FitMonitor, self).__init__()
        self.log_keys = log_keys
        self.messenger = Messenger(conv_id)

    def on_train_begin(self, logs=None):
        self.epochs = self.params['epochs']
        self.messenger.send_message("the training started")

    def on_epoch_end(self, epoch, logs=None):
        self.messenger.send_message(self.__format_message(epoch, logs))

    def on_train_end(self, logs=None):
        self.messenger.send_message("the training is over")

    def __format_message(self, epoch, logs, l=6):
        
        append_message = "\n\n"
        
        message = "Epoch " + str(epoch + 1) + " of " + str(self.epochs)
        
        if(self.log_keys == "all"):
            self.log_keys = logs.keys()
        elif(str(type(self.log_keys)) != "<class 'list'>"):
            raise Exception("Only list objects can be used as log_kays")
            
        for log_key in self.log_keys:
            if log_key in logs:
                append_message += f"{log_key} = " + str(logs[log_key])[:l] + "\n"
            else:
                raise Exception(f"The key \'{log_key}\' does not exist on the logs generated by the model, the only keys available are {list(logs.keys())}, if you want to show all of them use \'log_keys=\"all\"\'")

        if(len(append_message) > 2):
            message += append_message

        return message