"""Module ensight_api
Autogenerated from: ensight_api.xml at 2023-09-01T12:01:23.812844
"""
from ansys.pyensight.core import Session
from ansys.pyensight.core.ensobj import ENSOBJ
from ansys.pyensight.core import ensobjlist
from ansys.api.pyensight.ens_annot import ENS_ANNOT
from ansys.api.pyensight.ens_annot_text import ENS_ANNOT_TEXT
from ansys.api.pyensight.ens_annot_line import ENS_ANNOT_LINE
from ansys.api.pyensight.ens_annot_logo import ENS_ANNOT_LOGO
from ansys.api.pyensight.ens_annot_lgnd import ENS_ANNOT_LGND
from ansys.api.pyensight.ens_annot_marker import ENS_ANNOT_MARKER
from ansys.api.pyensight.ens_annot_arrow import ENS_ANNOT_ARROW
from ansys.api.pyensight.ens_annot_dial import ENS_ANNOT_DIAL
from ansys.api.pyensight.ens_annot_gauge import ENS_ANNOT_GAUGE
from ansys.api.pyensight.ens_annot_shape import ENS_ANNOT_SHAPE
from ansys.api.pyensight.ens_camera import ENS_CAMERA
from ansys.api.pyensight.ens_case import ENS_CASE
from ansys.api.pyensight.ens_flipbook import ENS_FLIPBOOK
from ansys.api.pyensight.ens_frame import ENS_FRAME
from ansys.api.pyensight.ens_globals import ENS_GLOBALS
from ansys.api.pyensight.ens_group import ENS_GROUP
from ansys.api.pyensight.ens_lightsource import ENS_LIGHTSOURCE
from ansys.api.pyensight.ens_lpart import ENS_LPART
from ansys.api.pyensight.ens_mat import ENS_MAT
from ansys.api.pyensight.ens_palette import ENS_PALETTE
from ansys.api.pyensight.ens_part import ENS_PART
from ansys.api.pyensight.ens_part_model import ENS_PART_MODEL
from ansys.api.pyensight.ens_part_clip import ENS_PART_CLIP
from ansys.api.pyensight.ens_part_contour import ENS_PART_CONTOUR
from ansys.api.pyensight.ens_part_discrete_particle import ENS_PART_DISCRETE_PARTICLE
from ansys.api.pyensight.ens_part_frame import ENS_PART_FRAME
from ansys.api.pyensight.ens_part_isosurface import ENS_PART_ISOSURFACE
from ansys.api.pyensight.ens_part_particle_trace import ENS_PART_PARTICLE_TRACE
from ansys.api.pyensight.ens_part_profile import ENS_PART_PROFILE
from ansys.api.pyensight.ens_part_vector_arrow import ENS_PART_VECTOR_ARROW
from ansys.api.pyensight.ens_part_elevated_surface import ENS_PART_ELEVATED_SURFACE
from ansys.api.pyensight.ens_part_developed_surface import ENS_PART_DEVELOPED_SURFACE
from ansys.api.pyensight.ens_part_built_up import ENS_PART_BUILT_UP
from ansys.api.pyensight.ens_part_tensor_glyph import ENS_PART_TENSOR_GLYPH
from ansys.api.pyensight.ens_part_fx_vortex_core import ENS_PART_FX_VORTEX_CORE
from ansys.api.pyensight.ens_part_fx_shock import ENS_PART_FX_SHOCK
from ansys.api.pyensight.ens_part_fx_sep_att import ENS_PART_FX_SEP_ATT
from ansys.api.pyensight.ens_part_mat_interface import ENS_PART_MAT_INTERFACE
from ansys.api.pyensight.ens_part_point import ENS_PART_POINT
from ansys.api.pyensight.ens_part_axisymmetric import ENS_PART_AXISYMMETRIC
from ansys.api.pyensight.ens_part_vof import ENS_PART_VOF
from ansys.api.pyensight.ens_part_aux_geom import ENS_PART_AUX_GEOM
from ansys.api.pyensight.ens_part_filter import ENS_PART_FILTER
from ansys.api.pyensight.ens_plotter import ENS_PLOTTER
from ansys.api.pyensight.ens_polyline import ENS_POLYLINE
from ansys.api.pyensight.ens_probe import ENS_PROBE
from ansys.api.pyensight.ens_query import ENS_QUERY
from ansys.api.pyensight.ens_scene import ENS_SCENE
from ansys.api.pyensight.ens_source import ENS_SOURCE
from ansys.api.pyensight.ens_spec import ENS_SPEC
from ansys.api.pyensight.ens_state import ENS_STATE
from ansys.api.pyensight.ens_texture import ENS_TEXTURE
from ansys.api.pyensight.ens_tool import ENS_TOOL
from ansys.api.pyensight.ens_tool_cursor import ENS_TOOL_CURSOR
from ansys.api.pyensight.ens_tool_line import ENS_TOOL_LINE
from ansys.api.pyensight.ens_tool_plane import ENS_TOOL_PLANE
from ansys.api.pyensight.ens_tool_box import ENS_TOOL_BOX
from ansys.api.pyensight.ens_tool_cylinder import ENS_TOOL_CYLINDER
from ansys.api.pyensight.ens_tool_cone import ENS_TOOL_CONE
from ansys.api.pyensight.ens_tool_sphere import ENS_TOOL_SPHERE
from ansys.api.pyensight.ens_tool_revolution import ENS_TOOL_REVOLUTION
from ansys.api.pyensight.ens_var import ENS_VAR
from ansys.api.pyensight.ens_vport import ENS_VPORT
from ansys.api.pyensight.ens_animobj import ens_animobj
from ansys.api.pyensight.ens_emitterobj import ens_emitterobj
from typing import Any, List, Type, Union, Optional, Tuple, TYPE_CHECKING
import types

if TYPE_CHECKING:
    from ansys.pyensight.core.utils.views import Views
    from ansys.pyensight.core.utils.query import Query
    from ansys.pyensight.core.utils.export import Export
    from ansys.pyensight.core.utils.parts import Parts
    from ansys.pyensight.core.utils.support import Support


class UtilsNameSpace(types.SimpleNamespace):
    def __init__(self, *args, **kwargs):
        super(*args, **kwargs)
        self.views: 'Views'
        self.query: 'Query'
        self.export: 'Export'
        self.parts: 'Parts'
        self.support: 'Support'


class vortexcore:
    """Class wrapper for EnSight vortexcore module

    This class acts as a proxy for the EnSight Python module ensight.vortexcore
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Delimit the modifications for vortexcore attributes.
        
        | These commands are used to set the attributes for a vortex core creation.
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the vortex cores
                #
                ensight.part.select_begin(1)
                #
                # Compute the vortex cores part
                #
                ensight.vortexcore.begin()
                ensight.vortexcore.end()
                ensight.vortexcore.create()
                #
                # Now select the newly created vortex part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.begin()'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Create a vortex core part with the currently defined attributes and the selected 3D parent parts.
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the vortex cores
                #
                ensight.part.select_begin(1)
                #
                # Compute the vortex cores part
                #
                ensight.vortexcore.begin()
                ensight.vortexcore.end()
                ensight.vortexcore.create()
                #
                # Now select the newly created vortex part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.create()'''
        return self._session.cmd(cmd)

    def density(self, p0: Any) -> int:
        """Specify the density variable to use in creating/updating a vortex core part or the default attributes.
        
        | This variable is assigned automatically if the variable name <Density> exists. 
        | Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' the name of the density variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Density")
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.density("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.density({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for vortexcore attributes.
        
        | These commands are used to set the attributes for a vortex core creation.
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the vortex cores
                #
                ensight.part.select_begin(1)
                #
                # Compute the vortex cores part
                #
                ensight.vortexcore.begin()
                ensight.vortexcore.end()
                ensight.vortexcore.create()
                #
                # Now select the newly created vortex part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.end()'''
        return self._session.cmd(cmd)

    def method(self, p0: str) -> int:
        """Specify the algorithm to use to compute the vortex core parts.
        
        Args:
            p0:
                'algorithm'
        
                * vorticity
                * eigen_analysis
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.method("vorticity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.method({repr(p0)})'''
        return self._session.cmd(cmd)

    def momentum(self, p0: Any) -> int:
        """Specify the momentum variable to use in creating/updating a vortex core part or the default attributes.
        
        | This variable is assigned automatically if the variable name <Momentum> exists.
        | Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the momentum variable (the default name <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Momentum")
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.momentum("Momentum")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.momentum({repr(p0)})'''
        return self._session.cmd(cmd)

    def ratio_of_spec_heat(self, args: Any) -> int:
        """Specify the ratio of specific heat constant value or  variable name to use in creating/updating a vortex core part or the default attributes.
        
        Args:
            p0:
                'name' scalar field variable name for the ratio of specific heats
            p1:
                'value' constant value (default = 1.4) for the ratio of specific heats
        
        Examples:
            ::
        
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.ratio_of_spec_heat(1.4)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.ratio_of_spec_heat({repr(args)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Specify that the default attributes of the vortex core part are to be set for all subsequent vortex core creates and updates.
        
        Examples:
            ::
        
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.momentum("none")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.select_default()'''
        return self._session.cmd(cmd)

    def threshold(self, p0: Any) -> int:
        """Specify the threshold variable description by which to filter the segments of the selected vortex cores part.
        
        | The default threshold variable for vortex cores is "fx_vortcore_streng".
        
        Args:
            p0:
                'variable_name' name of the scalar variable by which to filter the vortex core segments
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.threshold("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.threshold({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_filter(self, p0: str) -> int:
        """Specify how to filter out segments of the specified vortex cores part, according to the specified threshold variable and value.
        
        Args:
            p0:
                'option'
        
                * <=
                * >=
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.threshold_filter(">=")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.threshold_filter({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_max(self, p0: float) -> int:
        """Specify the maximum threshold limit under which to filter the threshold value of the selected vortex cores part(s).
        
        | This value must be greater than the threshold_min value, and be a valid threshold variable value. This value is initially automatically adjusted usually to an order of magnitude above the threshold value.
        
        Args:
            p0:
                'threshold_value' maximum threshold variable range limit below which to threshold the vortex cores part
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.threshold_max(1.0000e+01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.threshold_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_min(self, p0: float) -> int:
        """Specify the minimum threshold limit above which to filter the threshold value of the selected vortex cores part(s).
        
        | This value must be less than the threshold_max value, and be a valid threshold variable value. This value is initially adjusted to the threshold value.
        
        Args:
            p0:
                'threshold_value' minimum threshold variable range limit above which to threshold the vortex cores part
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.threshold_min(1.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.threshold_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_value(self, p0: float) -> int:
        """Specify the threshold value by which to filter the segments from the selected vortex cores part(s). 
        
        | This value is automatically set to the minimum vortex core strength variable value of the vortex cores part.  This value must lie within the threshold variable interval [threshold_min,theshold_max].
        
        Args:
            p0:
                'threshold_value' variable value by which to apply the threshold filter to the vortex core segments
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.vortexcore.threshold_value(5.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.threshold_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def velocity(self, p0: Any) -> int:
        """Specify the velocity variable to use in creating/updating a vortex core part or the default attributes.
        
        | This variable is automatically assigned if the variable name <velocity> exists. 
        | Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the velocity variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Velocity")
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.velocity("Velocity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vortexcore.velocity({repr(p0)})'''
        return self._session.cmd(cmd)


class vof:
    """Class wrapper for EnSight vof module

    This class acts as a proxy for the EnSight Python module ensight.vof
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Vof: begin

        """
        cmd = f'''ensight.vof.begin()'''
        return self._session.cmd(cmd)

    def blanking_algorithm(self, p0: str) -> int:
        """Vof: blanking_algorithm

        """
        cmd = f'''ensight.vof.blanking_algorithm({repr(p0)})'''
        return self._session.cmd(cmd)

    def blanking_clip_alg(self, p0: float) -> int:
        """Vof: blanking_clip_alg

        """
        cmd = f'''ensight.vof.blanking_clip_alg({repr(p0)})'''
        return self._session.cmd(cmd)

    def blanking_threshold(self, p0: float) -> int:
        """Vof: blanking_threshold

        """
        cmd = f'''ensight.vof.blanking_threshold({repr(p0)})'''
        return self._session.cmd(cmd)

    def blanking_variable1(self, p0: Any) -> int:
        """Vof: blanking_variable1

        """
        cmd = f'''ensight.vof.blanking_variable1({repr(p0)})'''
        return self._session.cmd(cmd)

    def blanking_variable2(self, p0: Any) -> int:
        """Vof: blanking_variable2

        """
        cmd = f'''ensight.vof.blanking_variable2({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_xmax(self, p0: str) -> int:
        """Vof: boundary_flag_xmax

        """
        cmd = f'''ensight.vof.boundary_flag_xmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_xmin(self, p0: str) -> int:
        """Vof: boundary_flag_xmin

        """
        cmd = f'''ensight.vof.boundary_flag_xmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_ymax(self, p0: str) -> int:
        """Vof: boundary_flag_ymax

        """
        cmd = f'''ensight.vof.boundary_flag_ymax({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_ymin(self, p0: str) -> int:
        """Vof: boundary_flag_ymin

        """
        cmd = f'''ensight.vof.boundary_flag_ymin({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_zmax(self, p0: str) -> int:
        """Vof: boundary_flag_zmax

        """
        cmd = f'''ensight.vof.boundary_flag_zmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def boundary_flag_zmin(self, p0: str) -> int:
        """Vof: boundary_flag_zmin

        """
        cmd = f'''ensight.vof.boundary_flag_zmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def cell_comp_num(self, p0: int) -> int:
        """Vof: cell_comp_num

        """
        cmd = f'''ensight.vof.cell_comp_num({repr(p0)})'''
        return self._session.cmd(cmd)

    def cell_type(self, p0: Any) -> int:
        """Vof: cell_type

        """
        cmd = f'''ensight.vof.cell_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def cell_volume_fraction(self, p0: Any) -> int:
        """Vof: cell_volume_fraction

        """
        cmd = f'''ensight.vof.cell_volume_fraction({repr(p0)})'''
        return self._session.cmd(cmd)

    def clip_blanking_variable(self, p0: Any) -> int:
        """Vof: clip_blanking_variable

        """
        cmd = f'''ensight.vof.clip_blanking_variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def clip_lctw(self, p0: str) -> int:
        """Vof: clip_lctw

        """
        cmd = f'''ensight.vof.clip_lctw({repr(p0)})'''
        return self._session.cmd(cmd)

    def clip_periodic_flagx(self, p0: str) -> int:
        """Vof: clip_periodic_flagx

        """
        cmd = f'''ensight.vof.clip_periodic_flagx({repr(p0)})'''
        return self._session.cmd(cmd)

    def clip_periodic_flagy(self, p0: str) -> int:
        """Vof: clip_periodic_flagy

        """
        cmd = f'''ensight.vof.clip_periodic_flagy({repr(p0)})'''
        return self._session.cmd(cmd)

    def clip_type(self, p0: str) -> int:
        """Vof: clip_type

        """
        cmd = f'''ensight.vof.clip_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Vof: component

        """
        cmd = f'''ensight.vof.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def component_num_in_cell(self, p0: Any) -> int:
        """Vof: component_num_in_cell

        """
        cmd = f'''ensight.vof.component_num_in_cell({repr(p0)})'''
        return self._session.cmd(cmd)

    def cooling_channel_comp(self, p0: Any) -> int:
        """Vof: cooling_channel_comp

        """
        cmd = f'''ensight.vof.cooling_channel_comp({repr(p0)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Vof: create

        """
        cmd = f'''ensight.vof.create()'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Vof: end

        """
        cmd = f'''ensight.vof.end()'''
        return self._session.cmd(cmd)

    def epsilon(self, p0: float) -> int:
        """Vof: epsilon

        """
        cmd = f'''ensight.vof.epsilon({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_area_fraction(self, p0: Any) -> int:
        """Vof: face_area_fraction

        """
        cmd = f'''ensight.vof.face_area_fraction({repr(p0)})'''
        return self._session.cmd(cmd)

    def geometric_type(self, p0: str) -> int:
        """Vof: geometric_type

        """
        cmd = f'''ensight.vof.geometric_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_rangemax(self, p0: float) -> int:
        """Vof: interactive_rangemax

        """
        cmd = f'''ensight.vof.interactive_rangemax({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_rangemin(self, p0: float) -> int:
        """Vof: interactive_rangemin

        """
        cmd = f'''ensight.vof.interactive_rangemin({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_step(self, p0: float) -> int:
        """Vof: interactive_step

        """
        cmd = f'''ensight.vof.interactive_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_xmax(self, p0: float) -> int:
        """Vof: interactive_xmax

        """
        cmd = f'''ensight.vof.interactive_xmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_xmin(self, p0: float) -> int:
        """Vof: interactive_xmin

        """
        cmd = f'''ensight.vof.interactive_xmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_ymax(self, p0: float) -> int:
        """Vof: interactive_ymax

        """
        cmd = f'''ensight.vof.interactive_ymax({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_ymin(self, p0: float) -> int:
        """Vof: interactive_ymin

        """
        cmd = f'''ensight.vof.interactive_ymin({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_zmax(self, p0: float) -> int:
        """Vof: interactive_zmax

        """
        cmd = f'''ensight.vof.interactive_zmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def interactive_zmin(self, p0: float) -> int:
        """Vof: interactive_zmin

        """
        cmd = f'''ensight.vof.interactive_zmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def mesh_planeloc(self, p0: str) -> int:
        """Vof: mesh_planeloc

        """
        cmd = f'''ensight.vof.mesh_planeloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Vof: select_default

        """
        cmd = f'''ensight.vof.select_default()'''
        return self._session.cmd(cmd)

    def specify_cell_comp_num(self, p0: str) -> int:
        """Vof: specify_cell_comp_num

        """
        cmd = f'''ensight.vof.specify_cell_comp_num({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry(self, p0: str) -> int:
        """Vof: symmetry

        """
        cmd = f'''ensight.vof.symmetry({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Vof: type

        """
        cmd = f'''ensight.vof.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def value(self, p0: float) -> int:
        """Vof: value

        """
        cmd = f'''ensight.vof.value({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Vof: variable

        """
        cmd = f'''ensight.vof.variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def ztest(self, p0: float) -> int:
        """Vof: ztest

        """
        cmd = f'''ensight.vof.ztest({repr(p0)})'''
        return self._session.cmd(cmd)


class views:
    """Class wrapper for EnSight views module

    This class acts as a proxy for the EnSight Python module ensight.views
    """
    def __init__(self, session: Session):
        self._session = session

    def apply(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.apply()'''
        return self._session.cmd(cmd)

    def load(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.load({repr(p0)})'''
        return self._session.cmd(cmd)

    def load_dir(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.load_dir({repr(p0)})'''
        return self._session.cmd(cmd)

    def new(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.new()'''
        return self._session.cmd(cmd)

    def remove(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.remove()'''
        return self._session.cmd(cmd)

    def remove_all(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.remove_all()'''
        return self._session.cmd(cmd)

    def rename(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.rename({repr(p0)})'''
        return self._session.cmd(cmd)

    def rename_all(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.rename_all({repr(p0)})'''
        return self._session.cmd(cmd)

    def replace(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.replace()'''
        return self._session.cmd(cmd)

    def rescale_views(self, p0: str) -> int:
        """Views: rescale_views

        """
        cmd = f'''ensight.views.rescale_views({repr(p0)})'''
        return self._session.cmd(cmd)

    def save(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.save()'''
        return self._session.cmd(cmd)

    def save_as(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.save_as({repr(p0)})'''
        return self._session.cmd(cmd)

    def select(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.select({repr(p0)})'''
        return self._session.cmd(cmd)

    def update(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.update()'''
        return self._session.cmd(cmd)

    def use_stored_image(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.views.use_stored_image({repr(p0)})'''
        return self._session.cmd(cmd)


class viewport_bounds:
    """Class wrapper for EnSight viewport_bounds module

    This class acts as a proxy for the EnSight Python module ensight.viewport_bounds
    """
    def __init__(self, session: Session):
        self._session = session

    def auto_size(self, p0: str) -> int:
        """When geometry changes the bounds display will resize if this toggle is set
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.auto_size("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.auto_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_height(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_height({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_linewidth(self, p0: int) -> int:
        """Set the line width for the bounds axis
        
        Args:
            p0:
                'line_width' the pixel width for the axis
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.axis_linewidth(2)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the bounds axis
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_width(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_displayonedge(self, p0: str) -> int:
        """Viewport_bounds: axis_x_displayonedge

        """
        cmd = f'''ensight.viewport_bounds.axis_x_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_format(self, p0: str) -> int:
        """Specifies the format to be used for labels along the x/y/z axis
        
        Args:
            p0:
                'format' may be any valid C language format string
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_format("%.2f")
                ensight.viewport_bounds.axis_y_format("%g")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_gridextentloc(self, p0: str) -> int:
        """Specifies which bounds will receive grids and subgrid lines
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridextentloc("both")
                ensight.viewport_bounds.axis_y_gridextentloc("min")
                ensight.viewport_bounds.axis_z_gridextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_gridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z grid bounds
        
        | If grid, the line type is specified via the viewport_bounds: grid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridtype("solid")
                ensight.viewport_bounds.axis_y_gridtype("none")
                ensight.viewport_bounds.axis_z_gridtype("tick")
                ensight.viewport_bounds.grid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelaxisloc(self, p0: str) -> int:
        """Specifies the location for the x/y/z axis labels for bounds display
        
        | When label_location is "all", the number of labels is controlled by the viewport_bounds: axis_x/y/z_numgrid command
        
        Args:
            p0:
                'label_location'
        
                * Can be any of the following:
                * none
                * all
                * beg_end
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.)
                ensight.viewport_bounds.axis_x_max(1.)
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_x_labelaxisloc("beg_end")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelextentloc(self, p0: str) -> int:
        """Specifies which bounds axis will receive labels
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelextentloc("both")
                ensight.viewport_bounds.axis_y_labelextentloc("min")
                ensight.viewport_bounds.axis_z_labelextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelfilter(self, p0: str) -> int:
        """Viewport_bounds: axis_x_labelfilter

        """
        cmd = f'''ensight.viewport_bounds.axis_x_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the x/y/z axis labels
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelrgb(4.0000e-01,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_x_max(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_min(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numgrid(self, p0: float) -> int:
        """Set the number of grid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of grid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of grid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_y_numgrid(3)
                ensight.viewport_bounds.axis_z_numgrid(7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numsubgrid(self, p0: float) -> int:
        """Set the number of subgrid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of subgrid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of subgrid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numsubgrid(2)
                ensight.viewport_bounds.axis_y_numsubgrid(2)
                ensight.viewport_bounds.axis_z_numsubgrid(3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_orig(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_orig({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_sgridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z subgrid bounds
        
        | If "grid", the line type is specified via the viewport_bounds: subgrid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_sgridtype("solid")
                ensight.viewport_bounds.axis_y_sgridtype("none")
                ensight.viewport_bounds.axis_z_sgridtype("tick")
                ensight.viewport_bounds.subgrid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_x_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_subtick(self, p0: str) -> int:
        """Viewport_bounds: axis_x_subtick

        """
        cmd = f'''ensight.viewport_bounds.axis_x_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_tick(self, p0: str) -> int:
        """Viewport_bounds: axis_x_tick

        """
        cmd = f'''ensight.viewport_bounds.axis_x_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_title(self, p0: str) -> int:
        """Viewport_bounds: axis_x_title

        """
        cmd = f'''ensight.viewport_bounds.axis_x_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_titlesize(self, p0: int) -> int:
        """Viewport_bounds: axis_x_titlesize

        """
        cmd = f'''ensight.viewport_bounds.axis_x_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_ymaxzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_x_ymaxzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_x_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_ymaxzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_x_ymaxzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_x_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_yminzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_x_yminzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_x_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_yminzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_x_yminzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_x_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_displayonedge(self, p0: str) -> int:
        """Viewport_bounds: axis_y_displayonedge

        """
        cmd = f'''ensight.viewport_bounds.axis_y_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_format(self, p0: str) -> int:
        """Specifies the format to be used for labels along the x/y/z axis
        
        Args:
            p0:
                'format' may be any valid C language format string
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_format("%.2f")
                ensight.viewport_bounds.axis_y_format("%g")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_gridextentloc(self, p0: str) -> int:
        """Specifies which bounds will receive grids and subgrid lines
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridextentloc("both")
                ensight.viewport_bounds.axis_y_gridextentloc("min")
                ensight.viewport_bounds.axis_z_gridextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_gridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z grid bounds
        
        | If grid, the line type is specified via the viewport_bounds: grid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridtype("solid")
                ensight.viewport_bounds.axis_y_gridtype("none")
                ensight.viewport_bounds.axis_z_gridtype("tick")
                ensight.viewport_bounds.grid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelaxisloc(self, p0: str) -> int:
        """Specifies the location for the x/y/z axis labels for bounds display
        
        | When label_location is "all", the number of labels is controlled by the viewport_bounds: axis_x/y/z_numgrid command
        
        Args:
            p0:
                'label_location'
        
                * Can be any of the following:
                * none
                * all
                * beg_end
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.)
                ensight.viewport_bounds.axis_x_max(1.)
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_x_labelaxisloc("beg_end")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelextentloc(self, p0: str) -> int:
        """Specifies which bounds axis will receive labels
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelextentloc("both")
                ensight.viewport_bounds.axis_y_labelextentloc("min")
                ensight.viewport_bounds.axis_z_labelextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelfilter(self, p0: str) -> int:
        """Viewport_bounds: axis_y_labelfilter

        """
        cmd = f'''ensight.viewport_bounds.axis_y_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the x/y/z axis labels
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelrgb(4.0000e-01,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_y_max(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_min(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numgrid(self, p0: float) -> int:
        """Set the number of grid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of grid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of grid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_y_numgrid(3)
                ensight.viewport_bounds.axis_z_numgrid(7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numsubgrid(self, p0: float) -> int:
        """Set the number of subgrid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of subgrid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of subgrid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numsubgrid(2)
                ensight.viewport_bounds.axis_y_numsubgrid(2)
                ensight.viewport_bounds.axis_z_numsubgrid(3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_orig(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_orig({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_sgridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z subgrid bounds
        
        | If "grid", the line type is specified via the viewport_bounds: subgrid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_sgridtype("solid")
                ensight.viewport_bounds.axis_y_sgridtype("none")
                ensight.viewport_bounds.axis_z_sgridtype("tick")
                ensight.viewport_bounds.subgrid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_y_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_subtick(self, p0: str) -> int:
        """Viewport_bounds: axis_y_subtick

        """
        cmd = f'''ensight.viewport_bounds.axis_y_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_tick(self, p0: str) -> int:
        """Viewport_bounds: axis_y_tick

        """
        cmd = f'''ensight.viewport_bounds.axis_y_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_title(self, p0: str) -> int:
        """Viewport_bounds: axis_y_title

        """
        cmd = f'''ensight.viewport_bounds.axis_y_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_titlesize(self, p0: int) -> int:
        """Viewport_bounds: axis_y_titlesize

        """
        cmd = f'''ensight.viewport_bounds.axis_y_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_ymaxzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_y_ymaxzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_y_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_ymaxzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_y_ymaxzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_y_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_yminzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_y_yminzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_y_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_yminzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_y_yminzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_y_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_displayonedge(self, p0: str) -> int:
        """Viewport_bounds: axis_z_displayonedge

        """
        cmd = f'''ensight.viewport_bounds.axis_z_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_format(self, p0: str) -> int:
        """Specifies the format to be used for labels along the x/y/z axis
        
        Args:
            p0:
                'format' may be any valid C language format string
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_format("%.2f")
                ensight.viewport_bounds.axis_y_format("%g")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_gridextentloc(self, p0: str) -> int:
        """Specifies which bounds will receive grids and subgrid lines
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridextentloc("both")
                ensight.viewport_bounds.axis_y_gridextentloc("min")
                ensight.viewport_bounds.axis_z_gridextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_gridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z grid bounds
        
        | If grid, the line type is specified via the viewport_bounds: grid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_gridtype("solid")
                ensight.viewport_bounds.axis_y_gridtype("none")
                ensight.viewport_bounds.axis_z_gridtype("tick")
                ensight.viewport_bounds.grid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelaxisloc(self, p0: str) -> int:
        """Specifies the location for the x/y/z axis labels for bounds display
        
        | When label_location is "all", the number of labels is controlled by the viewport_bounds: axis_x/y/z_numgrid command
        
        Args:
            p0:
                'label_location'
        
                * Can be any of the following:
                * none
                * all
                * beg_end
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.)
                ensight.viewport_bounds.axis_x_max(1.)
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_x_labelaxisloc("beg_end")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelextentloc(self, p0: str) -> int:
        """Specifies which bounds axis will receive labels
        
        Args:
            p0:
                'extent'
        
                * Can be any of the following:
                * min
                * max
                * both
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelextentloc("both")
                ensight.viewport_bounds.axis_y_labelextentloc("min")
                ensight.viewport_bounds.axis_z_labelextentloc("max")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelfilter(self, p0: str) -> int:
        """Viewport_bounds: axis_z_labelfilter

        """
        cmd = f'''ensight.viewport_bounds.axis_z_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the x/y/z axis labels
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_labelrgb(4.0000e-01,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_z_max(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_min(self, p0: float) -> int:
        """Sets the minimum value for the x/y/z axis
        
        | If the length attribute is set to rounded the resulting min/max x/y/z value will be modified from the specified value
        
        Args:
            p0:
                'min' the minimum axis value
            p1:
                'max' the maximum axis value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_min(0.2)
                ensight.viewport_bounds.axis_x_max(0.6)
                ensight.viewport_bounds.axis_y_min(0.0)
                ensight.viewport_bounds.axis_y_max(1.0)
                ensight.viewport_bounds.axis_z_min(-1.)
                ensight.viewport_bounds.axis_z_max(1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_numgrid(self, p0: float) -> int:
        """Set the number of grid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of grid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of grid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.axis_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numgrid(5)
                ensight.viewport_bounds.axis_y_numgrid(3)
                ensight.viewport_bounds.axis_z_numgrid(7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_numsubgrid(self, p0: float) -> int:
        """Set the number of subgrid marks along the x/y/z axis
        
        | If the length attribute is set to rounded the resulting number of subgrid marks will be modified from the specified value.
        
        Args:
            p0:
                'num' the number of subgrid marks to be used
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.length("as_specified")
                ensight.viewport_bounds.axis_x_numsubgrid(2)
                ensight.viewport_bounds.axis_y_numsubgrid(2)
                ensight.viewport_bounds.axis_z_numsubgrid(3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_sgridtype(self, p0: str) -> int:
        """Set the line type for the x/y/z subgrid bounds
        
        | If "grid", the line type is specified via the viewport_bounds: subgrid_linetype command
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.axis_x_sgridtype("solid")
                ensight.viewport_bounds.axis_y_sgridtype("none")
                ensight.viewport_bounds.axis_z_sgridtype("tick")
                ensight.viewport_bounds.subgrid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.axis_z_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_subtick(self, p0: str) -> int:
        """Viewport_bounds: axis_z_subtick

        """
        cmd = f'''ensight.viewport_bounds.axis_z_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_tick(self, p0: str) -> int:
        """Viewport_bounds: axis_z_tick

        """
        cmd = f'''ensight.viewport_bounds.axis_z_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_title(self, p0: str) -> int:
        """Viewport_bounds: axis_z_title

        """
        cmd = f'''ensight.viewport_bounds.axis_z_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_titlesize(self, p0: int) -> int:
        """Viewport_bounds: axis_z_titlesize

        """
        cmd = f'''ensight.viewport_bounds.axis_z_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_ymaxzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_z_ymaxzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_z_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_ymaxzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_z_ymaxzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_z_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_yminzmax(self, p0: str) -> int:
        """Viewport_bounds: axis_z_yminzmax

        """
        cmd = f'''ensight.viewport_bounds.axis_z_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_yminzmin(self, p0: str) -> int:
        """Viewport_bounds: axis_z_yminzmin

        """
        cmd = f'''ensight.viewport_bounds.axis_z_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def dimension(self, p0: str) -> int:
        """Set the bounds display to 2D or 3D.
        
        | The 2D option is only available for 2D viewports and 3D viewports display in orthographic mode.
        
        Args:
            p0:
                'dimension'
        
                * 2D
                * 3D
        
        Examples:
            ::
        
                # 
                # turn on bounds display and make the bounds for
                # viewport 0 2D
                #
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.dimension("2D")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.dimension({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_grid(self, p0: str) -> int:
        """Viewport_bounds: face_xmax_grid

        """
        cmd = f'''ensight.viewport_bounds.face_xmax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_xmax_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_xmax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_xmax_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_xmax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_grid(self, p0: str) -> int:
        """Viewport_bounds: face_xmin_grid

        """
        cmd = f'''ensight.viewport_bounds.face_xmin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_xmin_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_xmin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_xmin_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_xmin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_grid(self, p0: str) -> int:
        """Viewport_bounds: face_ymax_grid

        """
        cmd = f'''ensight.viewport_bounds.face_ymax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_ymax_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_ymax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_ymax_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_ymax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_grid(self, p0: str) -> int:
        """Viewport_bounds: face_ymin_grid

        """
        cmd = f'''ensight.viewport_bounds.face_ymin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_ymin_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_ymin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_ymin_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_ymin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_grid(self, p0: str) -> int:
        """Viewport_bounds: face_zmax_grid

        """
        cmd = f'''ensight.viewport_bounds.face_zmax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_zmax_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_zmax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_zmax_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_zmax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_grid(self, p0: str) -> int:
        """Viewport_bounds: face_zmin_grid

        """
        cmd = f'''ensight.viewport_bounds.face_zmin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_gridfilter(self, p0: str) -> int:
        """Viewport_bounds: face_zmin_gridfilter

        """
        cmd = f'''ensight.viewport_bounds.face_zmin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_subgrid(self, p0: str) -> int:
        """Viewport_bounds: face_zmin_subgrid

        """
        cmd = f'''ensight.viewport_bounds.face_zmin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linetype(self, p0: str) -> int:
        """Specifies the type of grid lines that will be drawn for bounds display.
        
        Args:
            p0:
                'line_type'
        
                * Can be any of the following:
                * solid
                * dotted
                * dash
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.grid_linewidth(2)
                ensight.viewport_bounds.grid_linetype("dotted")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.grid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linewidth(self, p0: int) -> int:
        """Set the bounds axis grid line width
        
        Args:
            p0:
                'width' specifies the width in pixels
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.grid_linewidth(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.grid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the bounds grid lines
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.grid_linewidth(2)
                ensight.viewport_bounds.grid_rgb(0.5,1,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.grid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def label_size(self, p0: float) -> int:
        """Viewport_bounds: label_size

        """
        cmd = f'''ensight.viewport_bounds.label_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_size_2d(self, p0: int) -> int:
        """Viewport_bounds: label_size_2d

        """
        cmd = f'''ensight.viewport_bounds.label_size_2d({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_size_3d(self, p0: int) -> int:
        """Viewport_bounds: label_size_3d

        """
        cmd = f'''ensight.viewport_bounds.label_size_3d({repr(p0)})'''
        return self._session.cmd(cmd)

    def length(self, p0: str) -> int:
        """Use min/max information as specified or use round numbers
        
        Args:
            p0:
                'size_option'
        
                * as_specified
                * rounded
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.axis_linewidth(1)
                ensight.viewport_bounds.length("as_specified")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.length({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_linetype(self, p0: str) -> int:
        """Specifies the type of subgrid lines that will be drawn for bounds display.
        
        Args:
            p0:
                'line_type'
        
                * Can be any of the following:
                * solid
                * dotted
                * dash
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.subgrid_linewidth(2)
                ensight.viewport_bounds.subgrid_linetype("dotted")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.subgrid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_linewidth(self, p0: int) -> int:
        """Set the bounds axis subgrid line width
        
        Args:
            p0:
                'width' specifies the width in pixels
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.subgrid_linewidth(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.subgrid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the bounds subgrid lines
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.visible("ON")
                ensight.viewport_bounds.subgrid_linewidth(2)
                ensight.viewport_bounds.subgrid_rgb(0.5,0.5,0.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.subgrid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def subtick_scale_factor(self, p0: float) -> int:
        """Viewport_bounds: subtick_scale_factor

        """
        cmd = f'''ensight.viewport_bounds.subtick_scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def tick_scale_factor(self, p0: float) -> int:
        """Viewport_bounds: tick_scale_factor

        """
        cmd = f'''ensight.viewport_bounds.tick_scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def transparency(self, p0: float) -> int:
        """Sets the opaqueness for the bounds display
        
        Args:
            p0:
                'value' opaqueness value
            p1:
                'value' opaqueness value
        
        Examples:
            ::
        
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(0)
                ensight.viewport_bounds.transparency(0.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.transparency({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Turn on bounds display for a viewport
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # turn on bounds display but turn the bounds off for viewport 1
                #
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(1)
                ensight.viewport_bounds.visible("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport_bounds.visible({repr(p0)})'''
        return self._session.cmd(cmd)


class viewport_axis:
    """Class wrapper for EnSight viewport_axis module

    This class acts as a proxy for the EnSight Python module ensight.viewport_axis
    """
    def __init__(self, session: Session):
        self._session = session

    def auto_size(self, p0: str) -> int:
        """Viewport_axis: auto_size

        """
        cmd = f'''ensight.viewport_axis.auto_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_height(self, p0: float) -> int:
        """Viewport_axis: axis_height

        """
        cmd = f'''ensight.viewport_axis.axis_height({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_linewidth(self, p0: int) -> int:
        """Viewport_axis: axis_linewidth

        """
        cmd = f'''ensight.viewport_axis.axis_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: axis_rgb

        """
        cmd = f'''ensight.viewport_axis.axis_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_width(self, p0: float) -> int:
        """Viewport_axis: axis_width

        """
        cmd = f'''ensight.viewport_axis.axis_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_displayonedge(self, p0: str) -> int:
        """Viewport_axis: axis_x_displayonedge

        """
        cmd = f'''ensight.viewport_axis.axis_x_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_format(self, p0: str) -> int:
        """Viewport_axis: axis_x_format

        """
        cmd = f'''ensight.viewport_axis.axis_x_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_gridextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_x_gridextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_x_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_gridtype(self, p0: str) -> int:
        """Viewport_axis: axis_x_gridtype

        """
        cmd = f'''ensight.viewport_axis.axis_x_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelaxisloc(self, p0: str) -> int:
        """Viewport_axis: axis_x_labelaxisloc

        """
        cmd = f'''ensight.viewport_axis.axis_x_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_x_labelextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_x_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelfilter(self, p0: str) -> int:
        """Viewport_axis: axis_x_labelfilter

        """
        cmd = f'''ensight.viewport_axis.axis_x_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: axis_x_labelrgb

        """
        cmd = f'''ensight.viewport_axis.axis_x_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_x_max(self, p0: float) -> int:
        """Viewport_axis: axis_x_max

        """
        cmd = f'''ensight.viewport_axis.axis_x_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_min(self, p0: float) -> int:
        """Viewport_axis: axis_x_min

        """
        cmd = f'''ensight.viewport_axis.axis_x_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numgrid(self, p0: float) -> int:
        """Viewport_axis: axis_x_numgrid

        """
        cmd = f'''ensight.viewport_axis.axis_x_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numsubgrid(self, p0: float) -> int:
        """Viewport_axis: axis_x_numsubgrid

        """
        cmd = f'''ensight.viewport_axis.axis_x_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_orig(self, p0: float) -> int:
        """Viewport_axis: axis_x_orig

        """
        cmd = f'''ensight.viewport_axis.axis_x_orig({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_sgridtype(self, p0: str) -> int:
        """Viewport_axis: axis_x_sgridtype

        """
        cmd = f'''ensight.viewport_axis.axis_x_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_subtick(self, p0: str) -> int:
        """Viewport_axis: axis_x_subtick

        """
        cmd = f'''ensight.viewport_axis.axis_x_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_tick(self, p0: str) -> int:
        """Viewport_axis: axis_x_tick

        """
        cmd = f'''ensight.viewport_axis.axis_x_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_title(self, p0: str) -> int:
        """Viewport_axis: axis_x_title

        """
        cmd = f'''ensight.viewport_axis.axis_x_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_titlesize(self, p0: int) -> int:
        """Viewport_axis: axis_x_titlesize

        """
        cmd = f'''ensight.viewport_axis.axis_x_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_ymaxzmax(self, p0: str) -> int:
        """Viewport_axis: axis_x_ymaxzmax

        """
        cmd = f'''ensight.viewport_axis.axis_x_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_ymaxzmin(self, p0: str) -> int:
        """Viewport_axis: axis_x_ymaxzmin

        """
        cmd = f'''ensight.viewport_axis.axis_x_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_yminzmax(self, p0: str) -> int:
        """Viewport_axis: axis_x_yminzmax

        """
        cmd = f'''ensight.viewport_axis.axis_x_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_yminzmin(self, p0: str) -> int:
        """Viewport_axis: axis_x_yminzmin

        """
        cmd = f'''ensight.viewport_axis.axis_x_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_displayonedge(self, p0: str) -> int:
        """Viewport_axis: axis_y_displayonedge

        """
        cmd = f'''ensight.viewport_axis.axis_y_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_format(self, p0: str) -> int:
        """Viewport_axis: axis_y_format

        """
        cmd = f'''ensight.viewport_axis.axis_y_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_gridextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_y_gridextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_y_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_gridtype(self, p0: str) -> int:
        """Viewport_axis: axis_y_gridtype

        """
        cmd = f'''ensight.viewport_axis.axis_y_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelaxisloc(self, p0: str) -> int:
        """Viewport_axis: axis_y_labelaxisloc

        """
        cmd = f'''ensight.viewport_axis.axis_y_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_y_labelextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_y_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelfilter(self, p0: str) -> int:
        """Viewport_axis: axis_y_labelfilter

        """
        cmd = f'''ensight.viewport_axis.axis_y_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: axis_y_labelrgb

        """
        cmd = f'''ensight.viewport_axis.axis_y_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_y_max(self, p0: float) -> int:
        """Viewport_axis: axis_y_max

        """
        cmd = f'''ensight.viewport_axis.axis_y_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_min(self, p0: float) -> int:
        """Viewport_axis: axis_y_min

        """
        cmd = f'''ensight.viewport_axis.axis_y_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numgrid(self, p0: float) -> int:
        """Viewport_axis: axis_y_numgrid

        """
        cmd = f'''ensight.viewport_axis.axis_y_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numsubgrid(self, p0: float) -> int:
        """Viewport_axis: axis_y_numsubgrid

        """
        cmd = f'''ensight.viewport_axis.axis_y_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_orig(self, p0: float) -> int:
        """Viewport_axis: axis_y_orig

        """
        cmd = f'''ensight.viewport_axis.axis_y_orig({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_sgridtype(self, p0: str) -> int:
        """Viewport_axis: axis_y_sgridtype

        """
        cmd = f'''ensight.viewport_axis.axis_y_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_subtick(self, p0: str) -> int:
        """Viewport_axis: axis_y_subtick

        """
        cmd = f'''ensight.viewport_axis.axis_y_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_tick(self, p0: str) -> int:
        """Viewport_axis: axis_y_tick

        """
        cmd = f'''ensight.viewport_axis.axis_y_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_title(self, p0: str) -> int:
        """Viewport_axis: axis_y_title

        """
        cmd = f'''ensight.viewport_axis.axis_y_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_titlesize(self, p0: int) -> int:
        """Viewport_axis: axis_y_titlesize

        """
        cmd = f'''ensight.viewport_axis.axis_y_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_ymaxzmax(self, p0: str) -> int:
        """Viewport_axis: axis_y_ymaxzmax

        """
        cmd = f'''ensight.viewport_axis.axis_y_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_ymaxzmin(self, p0: str) -> int:
        """Viewport_axis: axis_y_ymaxzmin

        """
        cmd = f'''ensight.viewport_axis.axis_y_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_yminzmax(self, p0: str) -> int:
        """Viewport_axis: axis_y_yminzmax

        """
        cmd = f'''ensight.viewport_axis.axis_y_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_yminzmin(self, p0: str) -> int:
        """Viewport_axis: axis_y_yminzmin

        """
        cmd = f'''ensight.viewport_axis.axis_y_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_displayonedge(self, p0: str) -> int:
        """Viewport_axis: axis_z_displayonedge

        """
        cmd = f'''ensight.viewport_axis.axis_z_displayonedge({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_format(self, p0: str) -> int:
        """Viewport_axis: axis_z_format

        """
        cmd = f'''ensight.viewport_axis.axis_z_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_gridextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_z_gridextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_z_gridextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_gridtype(self, p0: str) -> int:
        """Viewport_axis: axis_z_gridtype

        """
        cmd = f'''ensight.viewport_axis.axis_z_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelaxisloc(self, p0: str) -> int:
        """Viewport_axis: axis_z_labelaxisloc

        """
        cmd = f'''ensight.viewport_axis.axis_z_labelaxisloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelextentloc(self, p0: str) -> int:
        """Viewport_axis: axis_z_labelextentloc

        """
        cmd = f'''ensight.viewport_axis.axis_z_labelextentloc({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelfilter(self, p0: str) -> int:
        """Viewport_axis: axis_z_labelfilter

        """
        cmd = f'''ensight.viewport_axis.axis_z_labelfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: axis_z_labelrgb

        """
        cmd = f'''ensight.viewport_axis.axis_z_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_z_max(self, p0: float) -> int:
        """Viewport_axis: axis_z_max

        """
        cmd = f'''ensight.viewport_axis.axis_z_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_min(self, p0: float) -> int:
        """Viewport_axis: axis_z_min

        """
        cmd = f'''ensight.viewport_axis.axis_z_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_numgrid(self, p0: float) -> int:
        """Viewport_axis: axis_z_numgrid

        """
        cmd = f'''ensight.viewport_axis.axis_z_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_numsubgrid(self, p0: float) -> int:
        """Viewport_axis: axis_z_numsubgrid

        """
        cmd = f'''ensight.viewport_axis.axis_z_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_sgridtype(self, p0: str) -> int:
        """Viewport_axis: axis_z_sgridtype

        """
        cmd = f'''ensight.viewport_axis.axis_z_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_subtick(self, p0: str) -> int:
        """Viewport_axis: axis_z_subtick

        """
        cmd = f'''ensight.viewport_axis.axis_z_subtick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_tick(self, p0: str) -> int:
        """Viewport_axis: axis_z_tick

        """
        cmd = f'''ensight.viewport_axis.axis_z_tick({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_title(self, p0: str) -> int:
        """Viewport_axis: axis_z_title

        """
        cmd = f'''ensight.viewport_axis.axis_z_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_titlesize(self, p0: int) -> int:
        """Viewport_axis: axis_z_titlesize

        """
        cmd = f'''ensight.viewport_axis.axis_z_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_ymaxzmax(self, p0: str) -> int:
        """Viewport_axis: axis_z_ymaxzmax

        """
        cmd = f'''ensight.viewport_axis.axis_z_ymaxzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_ymaxzmin(self, p0: str) -> int:
        """Viewport_axis: axis_z_ymaxzmin

        """
        cmd = f'''ensight.viewport_axis.axis_z_ymaxzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_yminzmax(self, p0: str) -> int:
        """Viewport_axis: axis_z_yminzmax

        """
        cmd = f'''ensight.viewport_axis.axis_z_yminzmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_z_yminzmin(self, p0: str) -> int:
        """Viewport_axis: axis_z_yminzmin

        """
        cmd = f'''ensight.viewport_axis.axis_z_yminzmin({repr(p0)})'''
        return self._session.cmd(cmd)

    def dimension(self, p0: str) -> int:
        """Viewport_axis: dimension

        """
        cmd = f'''ensight.viewport_axis.dimension({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_grid(self, p0: str) -> int:
        """Viewport_axis: face_xmax_grid

        """
        cmd = f'''ensight.viewport_axis.face_xmax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_xmax_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_xmax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmax_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_xmax_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_xmax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_grid(self, p0: str) -> int:
        """Viewport_axis: face_xmin_grid

        """
        cmd = f'''ensight.viewport_axis.face_xmin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_xmin_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_xmin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_xmin_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_xmin_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_xmin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_grid(self, p0: str) -> int:
        """Viewport_axis: face_ymax_grid

        """
        cmd = f'''ensight.viewport_axis.face_ymax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_ymax_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_ymax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymax_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_ymax_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_ymax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_grid(self, p0: str) -> int:
        """Viewport_axis: face_ymin_grid

        """
        cmd = f'''ensight.viewport_axis.face_ymin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_ymin_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_ymin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_ymin_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_ymin_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_ymin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_grid(self, p0: str) -> int:
        """Viewport_axis: face_zmax_grid

        """
        cmd = f'''ensight.viewport_axis.face_zmax_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_zmax_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_zmax_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmax_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_zmax_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_zmax_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_grid(self, p0: str) -> int:
        """Viewport_axis: face_zmin_grid

        """
        cmd = f'''ensight.viewport_axis.face_zmin_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_gridfilter(self, p0: str) -> int:
        """Viewport_axis: face_zmin_gridfilter

        """
        cmd = f'''ensight.viewport_axis.face_zmin_gridfilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def face_zmin_subgrid(self, p0: str) -> int:
        """Viewport_axis: face_zmin_subgrid

        """
        cmd = f'''ensight.viewport_axis.face_zmin_subgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linetype(self, p0: str) -> int:
        """Viewport_axis: grid_linetype

        """
        cmd = f'''ensight.viewport_axis.grid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linewidth(self, p0: int) -> int:
        """Viewport_axis: grid_linewidth

        """
        cmd = f'''ensight.viewport_axis.grid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: grid_rgb

        """
        cmd = f'''ensight.viewport_axis.grid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def label_size(self, p0: float) -> int:
        """Viewport_axis: label_size

        """
        cmd = f'''ensight.viewport_axis.label_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_size_2d(self, p0: int) -> int:
        """Viewport_axis: label_size_2d

        """
        cmd = f'''ensight.viewport_axis.label_size_2d({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_size_3d(self, p0: int) -> int:
        """Viewport_axis: label_size_3d

        """
        cmd = f'''ensight.viewport_axis.label_size_3d({repr(p0)})'''
        return self._session.cmd(cmd)

    def length(self, p0: str) -> int:
        """Viewport_axis: length

        """
        cmd = f'''ensight.viewport_axis.length({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_linetype(self, p0: str) -> int:
        """Viewport_axis: subgrid_linetype

        """
        cmd = f'''ensight.viewport_axis.subgrid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_linewidth(self, p0: int) -> int:
        """Viewport_axis: subgrid_linewidth

        """
        cmd = f'''ensight.viewport_axis.subgrid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Viewport_axis: subgrid_rgb

        """
        cmd = f'''ensight.viewport_axis.subgrid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def subtick_scale_factor(self, p0: float) -> int:
        """Viewport_axis: subtick_scale_factor

        """
        cmd = f'''ensight.viewport_axis.subtick_scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def tick_scale_factor(self, p0: float) -> int:
        """Viewport_axis: tick_scale_factor

        """
        cmd = f'''ensight.viewport_axis.tick_scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def transparency(self, p0: float) -> int:
        """Viewport_axis: transparency

        """
        cmd = f'''ensight.viewport_axis.transparency({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Viewport_axis: visible

        """
        cmd = f'''ensight.viewport_axis.visible({repr(p0)})'''
        return self._session.cmd(cmd)


class viewport:
    """Class wrapper for EnSight viewport module

    This class acts as a proxy for the EnSight Python module ensight.viewport
    """
    def __init__(self, session: Session):
        self._session = session

    def _raise(self) -> int:
        """Viewport: raise

        """
        cmd = f'''ensight.viewport._raise()'''
        return self._session.cmd(cmd)

    def auto_centering(self, p0: str) -> int:
        """Viewport: auto_centering

        """
        cmd = f'''ensight.viewport.auto_centering({repr(p0)})'''
        return self._session.cmd(cmd)

    def background_image(self, p0: str) -> int:
        """Specify the image file to be used as the background for the selected viewport(s).
        
        | Image file types supported are:  xpm and bmp
        
        Args:
            p0:
                'filename' the image file to use as the background
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.background_type("image")
                ensight.viewport.background_image("/tmp/mybackground.xpm")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.background_image({repr(p0)})'''
        return self._session.cmd(cmd)

    def background_type(self, p0: str) -> int:
        """Specify the type of background to be displayed for the selected viewport(s).
        
        Args:
            p0:
                'type'
        
                * the following types are applied to the selected viewports
                * blended
                * constant
                * inherit
                * image
                * transparent
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.background_type("blended")
                ensight.viewport.blend_levels(3)
                ensight.viewport.blend_editlevel(1)
                ensight.viewport.blend_rgb(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.viewport.blend_editlevel(2)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport.blend_editlevel(3)
                ensight.viewport.blend_position(3.2000e-01)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,0.0000e+00)
                ensight.viewport.select_begin(1)
                ensight.viewport.background_type("inherit")
                ensight.viewport.select_begin(2)
                ensight.viewport.background_type("constant")
                ensight.viewport.constant_rgb(0.0000e+00,0.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.background_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def blend_editlevel(self, p0: int) -> int:
        """Specify the level to edit of the corresponding blended background type for the selected viewport(s), i.e. used to edit either the position or color of the level.
        
        Args:
            p0:
                'level_num' specified level number for the blended background type
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.background_type("blended")
                ensight.viewport.blend_levels(3)
                ensight.viewport.blend_editlevel(1)
                ensight.viewport.blend_rgb(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.viewport.blend_editlevel(2)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,1.0000e+00)
                ensight.viewport.blend_editlevel(3)
                ensight.viewport.blend_position(3.2000e-01)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.blend_editlevel({repr(p0)})'''
        return self._session.cmd(cmd)

    def blend_levels(self, p0: int) -> int:
        """Specify the number of (vertical) levels of the corresponding blended background type for the selected viewport(s).
        
        Args:
            p0:
                'num' number of levels in I[1,n] for the blended background type
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.blend_levels(3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.blend_levels({repr(p0)})'''
        return self._session.cmd(cmd)

    def blend_position(self, p0: float) -> int:
        """Specify the position of the specified blend level of the corresponding blended background type for the selected viewport(s).
        
        | Blend level 0 must be located at 0.
        | Blend level N must be locted at 1.
        | Blend level N must be > N-1.
        
        Args:
            p0:
                'position' normalized position in I[0.,1.] for the blended background level
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.background_type("blended")
                ensight.viewport.blend_levels(3)
                ensight.viewport.blend_editlevel(2)
                ensight.viewport.blend_position(3.2000e-01)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.blend_position({repr(p0)})'''
        return self._session.cmd(cmd)

    def blend_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specify the red, green and blue components of the blended background color for the specified level of the selected viewport(s).
        
        Args:
            p0:
                'red_val' red, green, blue color component values given in I[0.,1.]
            p1:
                'grn_val' red, green, blue color component values given in I[0.,1.]
            p2:
                'blu_val' red, green, blue color component values given in I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.background_type("blended")
                ensight.viewport.blend_levels(3)
                ensight.viewport.blend_editlevel(2)
                ensight.viewport.blend_position(3.2000e-01)
                ensight.viewport.blend_rgb(0.0000e+00,0.0000e+00,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.blend_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def border_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Set the color for the viewport border.
        
        | By default the border color is white.
        | Used only if viewport: border_visible is ON.
        
        Args:
            p0:
                'red_val' red, green, blue color component values given in I[0.,1.]
            p1:
                'grn_val' red, green, blue color component values given in I[0.,1.]
            p2:
                'blu_val' red, green, blue color component values given in I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(1)
                ensight.viewport.border_rgb(1.,0.,1.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.border_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def border_visible(self, p0: str) -> int:
        """Set visibility of viewport border.
        
        | Viewport borders are on by default.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF 
        
        Examples:
            ::
        
                ensight.viewport.select_begin(1)
                ensight.viewport.border_visible("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.border_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def constant_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specify the red, green and blue components of the constant background color for the selected viewport(s)
        
        Args:
            p0:
                'red_val' red, green, blue color component values given in I[0.,1.]
            p1:
                'grn_val' red, green, blue color component values given in I[0.,1.]
            p2:
                'blu_val' red, green, blue color component values given in I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(2)
                ensight.viewport.background_type("constant")
                ensight.viewport.constant_rgb(0.0000e+00,0.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.constant_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """Delete all selected viewports.
        
        | After selected viewports have been deleted, the main viewport (0) will be selected.
        | The main viewport (0) cannot be deleted.
        
        Examples:
            ::
        
                ensight.viewport.select_begin(2,5)
                ensight.viewport.delete()
                ensight.viewport.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.delete()'''
        return self._session.cmd(cmd)

    def exchange_with_largest(self, p0: int) -> int:
        """Viewport: exchange_with_largest

        """
        cmd = f'''ensight.viewport.exchange_with_largest({repr(p0)})'''
        return self._session.cmd(cmd)

    def global_axis_location(self, p0: float, p1: float) -> int:
        """Viewport: global_axis_location

        """
        cmd = f'''ensight.viewport.global_axis_location({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def global_axis_visible(self, p0: str) -> int:
        """Viewport: global_axis_visible

        """
        cmd = f'''ensight.viewport.global_axis_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def global_axis_xlabel(self, p0: str) -> int:
        """Viewport: global_axis_xlabel

        """
        cmd = f'''ensight.viewport.global_axis_xlabel({repr(p0)})'''
        return self._session.cmd(cmd)

    def global_axis_ylabel(self, p0: str) -> int:
        """Viewport: global_axis_ylabel

        """
        cmd = f'''ensight.viewport.global_axis_ylabel({repr(p0)})'''
        return self._session.cmd(cmd)

    def global_axis_zlabel(self, p0: str) -> int:
        """Viewport: global_axis_zlabel

        """
        cmd = f'''ensight.viewport.global_axis_zlabel({repr(p0)})'''
        return self._session.cmd(cmd)

    def height(self, p0: float) -> int:
        """Specify the normalized height for the selected viewport(s).
        
        Args:
            p0:
                'height' normalized height I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.origin_x(3.3333e-01)
                ensight.viewport.origin_y(0.0000e+00)
                ensight.viewport.width(5.1712e-01)
                ensight.viewport.height(1.0000e+00)
                ensight.viewport.select_begin(1,2)
                ensight.viewport.height(2.5000e-01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.height({repr(p0)})'''
        return self._session.cmd(cmd)

    def hidden_line(self, p0: str) -> int:
        """Toggle whether hidden line meshes are to be overlaid onto parts in active viewport(s).
        
        | A part will be displayed with hidden lines if:
        | (a) view: hidden-line  ON
        | (b) viewport: hidden_line  ON
        | (c) part: hidden_line  ON
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.hidden_line("OFF")
                ensight.viewport.select_begin(1)
                ensight.viewport.hidden_line("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.hidden_line({repr(p0)})'''
        return self._session.cmd(cmd)

    def hidden_surface(self, p0: str) -> int:
        """Toggle whether hidden surfaces are to be removed from parts in active viewport(s).
        
        | A part will be displayed with shading if:
        | (a) view: hidden-surface  ON
        | (b) viewport: hidden_surface  ON
        | (c) part: hidden_surface  ON
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.hidden_surface("OFF")
                ensight.viewport.select_begin(1)
                ensight.viewport.hidden_surface("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.hidden_surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def light1_azimuth(self, p0: float) -> int:
        """Defines the azimuth angle of light source 1.
        
        | This command needs to be used in conjunction with the viewport: light1_elevation <angle>  and viewport: light1_position <option> commands.
        
        Args:
            p0:
                'angle' azimuth angle for light source 1
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3)
                ensight.viewport.light1_position("Relative")
                ensight.viewport.light1_azimuth(-9.702e+01)
                ensight.viewport.light1_elevation(3.750e+01)
                ensight.viewport.light_converttoabs()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.light1_azimuth({repr(p0)})'''
        return self._session.cmd(cmd)

    def light1_elevation(self, p0: float) -> int:
        """Defines the elevation angle of light source 1.
        
        | This command needs to be used in conjunction with the viewport: light1_azimuth <angle> and viewport: light1_position <option> commands.
        
        Args:
            p0:
                'angle' elevation angle for light source 1
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3)
                ensight.viewport.light1_position("Relative")
                ensight.viewport.light1_azimuth(-9.702e+01)
                ensight.viewport.light1_elevation(3.750e+01)
                ensight.viewport.light_converttoabs()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.light1_elevation({repr(p0)})'''
        return self._session.cmd(cmd)

    def light1_position(self, p0: str) -> int:
        """Defines whether light source 1 is defined in the model coordinate system (absolute) or in reference to the viewer.
        
        | This command needs to be used in conjunction with the viewport: light1_azimuth <angle>  and viewport: light1_elevation <angle> commands.
        
        Args:
            p0:
                'option'
        
                * Absolute
                * Relative
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3)
                ensight.viewport.light1_position("Relative")
                ensight.viewport.light1_azimuth(-9.702e+01)
                ensight.viewport.light1_elevation(3.750e+01)
                ensight.viewport.light_converttoabs()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.light1_position({repr(p0)})'''
        return self._session.cmd(cmd)

    def light2_intensity(self, p0: float) -> int:
        """Defines the intensity of light source 2, which is always at the location of the viewer (camera).
        
        | None 
        
        Args:
            p0:
                'amount' intensity of light source 2 (between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3)
                ensight.viewport.light1_position("Relative")
                ensight.viewport.light1_azimuth(-9.702e+01)
                ensight.viewport.light1_elevation(3.750e+01)
                ensight.viewport.light_converttoabs()
                ensight.viewport.light2_intensity(3.100e-01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.light2_intensity({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_converttoabs(self) -> int:
        """Converts light coordinates which are relative to the viewport to be absolute (relative to the model coordinate system) and thus have a static lighting effect.
        
        | none
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3)
                ensight.viewport.light1_position("Relative")
                ensight.viewport.light1_azimuth(-9.702e+01)
                ensight.viewport.light1_elevation(3.750e+01)
                ensight.viewport.light_converttoabs()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.light_converttoabs()'''
        return self._session.cmd(cmd)

    def lower(self) -> int:
        """Lower the selected viewport(s) to be located beneath all the other viewports - except the main viewport.
        
        | The main viewport (0) always remains beneath all viewports; and thus, is neither raised or lowered.
        
        Examples:
            ::
        
                ensight.viewport.select_begin(3,4)
                ensight.viewport.lower()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.lower()'''
        return self._session.cmd(cmd)

    def new(self) -> int:
        """Specify a new viewport to be created.
        
        | New viewport indexing sequentially increments in the range I[1,16].
        
        Examples:
            ::
        
                ensight.viewport.new()
                ensight.viewport.select_begin(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.new()'''
        return self._session.cmd(cmd)

    def new_or_mod(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.new_or_mod({repr(p0)})'''
        return self._session.cmd(cmd)

    def not_used(self, p0: str) -> int:
        """Viewport: not_used

        """
        cmd = f'''ensight.viewport.not_used({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin_x(self, p0: float) -> int:
        """Specify the normalized x/y-coordinate value of the origin for the selected viewport(s).
        
        Args:
            p0:
                'coord' lower left/bottom of viewport with range I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.origin_x(3.3333e-01)
                ensight.viewport.origin_y(0.0000e+00)
                ensight.viewport.width(5.1712e-01)
                ensight.viewport.height(1.0000e+00)
                ensight.viewport.select_begin(1,2)
                ensight.viewport.origin_x(1.0000e-01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.origin_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin_y(self, p0: float) -> int:
        """Specify the normalized x/y-coordinate value of the origin for the selected viewport(s).
        
        Args:
            p0:
                'coord' lower left/bottom of viewport with range I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.origin_x(3.3333e-01)
                ensight.viewport.origin_y(0.0000e+00)
                ensight.viewport.width(5.1712e-01)
                ensight.viewport.height(1.0000e+00)
                ensight.viewport.select_begin(1,2)
                ensight.viewport.origin_x(1.0000e-01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.origin_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def perspective(self, p0: str) -> int:
        """Toggle whether viewing frustrum is to be perspective or orthographic in selected viewport(s).
        
        | Geometry will be shown with perspective if:
        | (a) view: perspective  ON
        | (b) viewport: perspective  ON
        
        Args:
            p0:
                'toggle'
        
                * one of following toggle values:
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.perspective("OFF")
                ensight.viewport.select_begin(1)
                ensight.viewport.perspective("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.perspective({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Viewport: query_count

        """
        cmd = f'''ensight.viewport.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Viewport: query_display_attributes

        """
        cmd = f'''ensight.viewport.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_location(self, args: Any) -> int:
        """Viewport: query_location

        """
        cmd = f'''ensight.viewport.query_location({repr(args)})'''
        return self._session.cmd(cmd)

    def query_mouse_info(self, args: Any) -> int:
        """Viewport: query_mouse_info

        """
        cmd = f'''ensight.viewport.query_mouse_info({repr(args)})'''
        return self._session.cmd(cmd)

    def query_object_atwindowxy(self, args: Any) -> int:
        """Viewport: query_object_atwindowxy

        """
        cmd = f'''ensight.viewport.query_object_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_size(self, args: Any) -> int:
        """Viewport: query_size

        """
        cmd = f'''ensight.viewport.query_size({repr(args)})'''
        return self._session.cmd(cmd)

    def query_window_depth(self, args: Any) -> int:
        """Viewport: query_window_depth

        """
        cmd = f'''ensight.viewport.query_window_depth({repr(args)})'''
        return self._session.cmd(cmd)

    def query_window_mousepress(self, args: Any) -> int:
        """Viewport: query_window_mousepress

        """
        cmd = f'''ensight.viewport.query_window_mousepress({repr(args)})'''
        return self._session.cmd(cmd)

    def query_window_rgba(self, args: Any) -> int:
        """Viewport: query_window_rgba

        """
        cmd = f'''ensight.viewport.query_window_rgba({repr(args)})'''
        return self._session.cmd(cmd)

    def query_window_size(self, args: Any) -> int:
        """Viewport: query_window_size

        """
        cmd = f'''ensight.viewport.query_window_size({repr(args)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """Select all created viewports for editing.
        
        Examples:
            ::
        
                ensight.viewport.select_all()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.select_all()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Set active viewport(s) selection construct for subsequent viewport modification.
        
        | All other "viewport:" commands operate off this setting.
        
        Args:
            p0:
                'idn' list of viewport number(s) to be active for editing. 
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.view_transf.function("global")
                ensight.viewport.viewport_layout("two_vertical")
                ensight.viewport.select_begin(1,2)
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.viewport.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Allows the setting of default viewport attributes prior to creating the next viewport.
        
        Examples:
            ::
        
                ensight.viewport.select_default()
                ensight.viewport.perspective("OFF")
                ensight.viewport.background_type("constant")
                ensight.viewport.constant_rgb(0.0000e+00,0.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.select_default()'''
        return self._session.cmd(cmd)

    def track(self, p0: str) -> int:
        """Specify the location of the position to track (if any tracking is to be used).  Tracking causes the viewer (camera) to stay tuned on the position chosen as the model moves.
        
        | None
        
        Args:
            p0:
                'location'
        
                * Off
                * part_centroid
                * part_xmin
                * part_xmax
                * part_ymin
                * part_ymax
                * part_zmin 
                * part_zmax
                * node_number
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.track("part_centroid")
                ensight.viewport.tracking_part_id(9)
                ensight.viewport.select_begin(2)
                ensight.viewport.track("node_number")
                ensight.viewport.tracking_part_id(21)
                ensight.viewport.tracking_node_id(983)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.track({repr(p0)})'''
        return self._session.cmd(cmd)

    def tracking_node_id(self, p0: int) -> int:
        """Specify the node id to track.  Tracking causes the viewer (camera) to stay tuned on the position chosen as the model moves.
        
        | One should also specify the part that contains this node id, because node ids are only unique within parts in EnSight.
        
        Args:
            p0:
                'nid' The id of the node that will be tracked
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.track("part_centroid")
                ensight.viewport.tracking_part_id(9)
                ensight.viewport.select_begin(2)
                ensight.viewport.track("node_number")
                ensight.viewport.tracking_part_id(21)
                ensight.viewport.tracking_node_id(983)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.tracking_node_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def tracking_part_id(self, args: Any) -> int:
        """Specify the part id to use for the other location options for tracking.  Tracking causes the viewer (camera) to stay tuned on the position chosen as the model moves.
        
        | One must specify the part that will be used for the part centroid, min/max, or node number tracking option chosen in viewport: track <location> command
        
        Args:
            p0:
                'pid' The id of the part that will be tracked by one of the options
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.track("part_centroid")
                ensight.viewport.tracking_part_id(9)
                ensight.viewport.select_begin(2)
                ensight.viewport.track("node_number")
                ensight.viewport.tracking_part_id(21)
                ensight.viewport.tracking_node_id(983)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.tracking_part_id({repr(args)})'''
        return self._session.cmd(cmd)

    def tracking_partbyname(self, args: Any) -> int:
        """Specify the part name to use for the other location options for tracking.  Tracking causes the viewer (camera) to stay tuned on the position chosen as the model moves.
        
        | One must specify the part that will be used for the part centroid, min/max, or node number tracking option chosen in viewport: track <location> command
        
        Args:
            p0:
                'partname' The name of the part that will be tracked by one of the options
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.track("part_centroid")
                ensight.viewport.tracking_partbyname("flowfield")
                ensight.viewport.select_begin(2)
                ensight.viewport.track("node_number")
                ensight.viewport.tracking_partbyname("outflow")
                ensight.viewport.tracking_node_id(983)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.tracking_partbyname({repr(args)})'''
        return self._session.cmd(cmd)

    def view_dimension(self, p0: str) -> int:
        """Set the dimension of the viewport.
        
        | Dimension 2D is handy for displaying 2D clips and/or developed surfaces.
        | A 2D viewport can only be transformed in 2D.
        
        Args:
            p0:
                'option'
        
                * includes the following viewport dimensions:
                * 3D (default)
                * 2D
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0,1)
                ensight.viewport.view_dimension("3D")
                ensight.viewport.select_begin(2)
                ensight.viewport.view_dimension("2D")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.view_dimension({repr(p0)})'''
        return self._session.cmd(cmd)

    def viewport_layout(self, p0: str) -> int:
        """Specify the type of layout to be used in dividing the graphics window into viewports.
        
        | When creating a layout of viewports, the active viewport defaults to the last viewport created, i.e. if creating four_equal viewports, the active viewport is the last of the four created.
        
        Args:
            p0:
                'option'
        
                * includes the following types of viewport layouts:
                * one
                * two_vertical
                * two_horizontal
                * four_equal
                * four_withthreeleft
                * four_withthreebottom 
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.view_transf.function("global")
                ensight.viewport.viewport_layout("two_vertical")
                ensight.viewport.select_begin(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.viewport_layout({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Toggle whether selected viewports are visible.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.visible("OFF")
                ensight.viewport.select_begin(1)
                ensight.viewport.visible("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def width(self, p0: float) -> int:
        """Specify the normalized width for the selected viewport(s).
        
        Args:
            p0:
                'width' normalized width I[0.,1.]
        
        Examples:
            ::
        
                ensight.viewport.select_begin(0)
                ensight.viewport.origin_x(3.3333e-01)
                ensight.viewport.origin_y(0.0000e+00)
                ensight.viewport.width(5.1712e-01)
                ensight.viewport.height(1.0000e+00)
                ensight.viewport.select_begin(1,2)
                ensight.viewport.width(2.5000e-01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.viewport.width({repr(p0)})'''
        return self._session.cmd(cmd)


class view_transf:
    """Class wrapper for EnSight view_transf module

    This class acts as a proxy for the EnSight Python module ensight.view_transf
    """
    def __init__(self, session: Session):
        self._session = session

    def action(self, p0: str) -> int:
        """Sets the transformation method for interaction in the user interface.
        
        | This is not a necessary command.  It is used to change the user interface to reflect the transformation currently attached to the mouse button tied to the transformation action (by default the left mouse button).
        
        Args:
            p0:
                'method'
        
                * rotate
                * translate
                * scale
                * zoom
                * band_zoom
                * select_tool_pos
        
        Examples:
            ::
        
                ensight.view_transf.action("translate")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.action({repr(p0)})'''
        return self._session.cmd(cmd)

    def align2D(self, p0: int, p1: int, p2: int, p3: int) -> int:
        """View_transf: align2D

        """
        cmd = f'''ensight.view_transf.align2D({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def axis(self, p0: str) -> int:
        """Sets the axis to use for rotate, translate, and scale transformations.
        
        | Used in the transformation dialog to control the axis about which transformational values are applied.
        | The axis is either the global system or, if in Frame mode, the selected frame's axis system.
        
        Args:
            p0:
                'which'
        
                * x
                * y
                * z
                * all
        
        Examples:
            ::
        
                # 
                # Set the axis to x 
                # and rotate about the x axis 15 degrees 
                # 
                ensight.view_transf.axis("x")
                ensight.view_transf.rotate(15.000000,0.000000,0.000000)
                # 
                # Set the axis to be y 
                # and translate one unit in the -negative y direction 
                # 
                ensight.view_transf.axis("y")
                ensight.view_transf.translate(0.0000e+00,-1.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def band_zoom_expand_from(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.band_zoom_expand_from({repr(p0)})'''
        return self._session.cmd(cmd)

    def box_axis(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Specify the direction vectors for a box tool. 
        
        | The direction vectors are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'axis'
        
                * x
                * y
                * z
            p1:
                'x_comp' The x component of the direction vector
            p2:
                'y_comp' The y component of the direction vector
            p3:
                'z_comp' The z component of the direction vector
        
        Examples:
            ::
        
                ensight.tools.box("ON")
                ensight.view_transf.function("box")
                ensight.view_transf.box_length(3.000000e+00,4.000000e+00,5.000000e+00)
                ensight.view_transf.box_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("x",1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("y",0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("z",0.000000e+00,0.000000e+00,1.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.box_axis({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def box_length(self, p0: float, p1: float, p2: float) -> int:
        """Specify the size of the box tool in the x, y, and z directions.
        
        | The lengths are in relation to the box axis directions.
        
        Args:
            p0:
                'x_len' The length of box tool in the x, y, z direction
            p1:
                'y_len' The length of box tool in the x, y, z direction
            p2:
                'z_len' The length of box tool in the x, y, z direction
        
        Examples:
            ::
        
                ensight.tools.box("ON")
                ensight.view_transf.function("box")
                ensight.view_transf.box_length(3.000000e+00,4.000000e+00,5.000000e+00)
                ensight.view_transf.box_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("x",1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("y",0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("z",0.000000e+00,0.000000e+00,1.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.box_length({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def box_origin(self, p0: float, p1: float, p2: float) -> int:
        """Specify the origin of the box tool in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_ori' The x, y, z origin of the box tool
            p1:
                'y_ori' The x, y, z origin of the box tool
            p2:
                'z_ori' The x, y, z origin of the box tool
        
        Examples:
            ::
        
                ensight.tools.box("ON")
                ensight.view_transf.function("box")
                ensight.view_transf.box_length(3.000000e+00,4.000000e+00,5.000000e+00)
                ensight.view_transf.box_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("x",1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("y",0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.box_axis("z",0.000000e+00,0.000000e+00,1.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.box_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_desc(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_desc({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_direction_xyz(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_direction_xyz({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_focus(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_focus({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_focus_distprojpln(self, p0: float) -> int:
        """View_transf: camera_focus_distprojpln

        """
        cmd = f'''ensight.view_transf.camera_focus_distprojpln({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_focus_forwardxyz(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_focus_forwardxyz({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_focus_partnode(self, p0: int, p1: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_focus_partnode({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def camera_lens(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_lens({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_location_fromfile(self, p0: str) -> int:
        """View_transf: camera_location_fromfile

        """
        cmd = f'''ensight.view_transf.camera_location_fromfile({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_origin(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_origin_offset(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin_offset({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_origin_partnode(self, p0: int, p1: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin_partnode({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def camera_origin_scalefactor(self, p0: float) -> int:
        """View_transf: camera_origin_scalefactor

        """
        cmd = f'''ensight.view_transf.camera_origin_scalefactor({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_origin_spline(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin_spline({repr(args)})'''
        return self._session.cmd(cmd)

    def camera_origin_splinevalue(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin_splinevalue({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_origin_xyz(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_origin_xyz({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_size(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_up_xyz(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_up_xyz({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def camera_view_angle(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_view_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera_visible(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.camera_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def cameraselect_byname_begin(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cameraselect_byname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def cameraselect_byname_end(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cameraselect_byname_end()'''
        return self._session.cmd(cmd)

    def cameratoview_compute(self) -> int:
        """View_transf: cameratoview_compute

        """
        cmd = f'''ensight.view_transf.cameratoview_compute()'''
        return self._session.cmd(cmd)

    def cameratoview_direction(self, p0: float, p1: float, p2: float) -> int:
        """View_transf: cameratoview_direction

        """
        cmd = f'''ensight.view_transf.cameratoview_direction({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cameratoview_focaldist(self, p0: float) -> int:
        """View_transf: cameratoview_focaldist

        """
        cmd = f'''ensight.view_transf.cameratoview_focaldist({repr(p0)})'''
        return self._session.cmd(cmd)

    def cameratoview_focalpoint(self, p0: float, p1: float, p2: float) -> int:
        """View_transf: cameratoview_focalpoint

        """
        cmd = f'''ensight.view_transf.cameratoview_focalpoint({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cameratoview_readfile(self, p0: str) -> int:
        """View_transf: cameratoview_readfile

        """
        cmd = f'''ensight.view_transf.cameratoview_readfile({repr(p0)})'''
        return self._session.cmd(cmd)

    def cameratoview_rotation(self, p0: float) -> int:
        """View_transf: cameratoview_rotation

        """
        cmd = f'''ensight.view_transf.cameratoview_rotation({repr(p0)})'''
        return self._session.cmd(cmd)

    def center_of_transform(self, p0: float, p1: float, p2: float) -> int:
        """Set the point in space that will be the origin for transformations. 
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        | Cannot be set during keyframe animation.
        
        Args:
            p0:
                'x_coord' model x coordinate of the desired transformation origin
            p1:
                'y_coord' model y coordinate of the desired transformation origin
            p2:
                'z_coord' model z coordinate of the desired transformation origin
        
        Examples:
            ::
        
                # 
                # Selecting two viewports 
                # 
                ensight.viewport.select_begin(2,3)
                # 
                # Setting the center of transformations to be 
                # at (.5 .6 1) for each of these viewports 
                # 
                ensight.view_transf.center_of_transform(5.0000e-01,6.0000e-01,1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.center_of_transform({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def clipping(self, p0: str) -> int:
        """View_transf: clipping

        """
        cmd = f'''ensight.view_transf.clipping({repr(p0)})'''
        return self._session.cmd(cmd)

    def cone(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """View_transf: cone

        """
        cmd = f'''ensight.view_transf.cone({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def cone_angle(self, p0: float) -> int:
        """Set the angle for the cone tool.
        
        | Use with view_transf: cone_axis and view_transf: cone_origin to specify the cone tool location and orientation
        
        Args:
            p0:
                'angle' the cone angle (in degrees)
        
        Examples:
            ::
        
                # 
                # Turns the display of the quadric cone on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cone")
                # 
                # Sets the angle and other attributes of the cone tool 
                # 
                ensight.view_transf.cone_angle(25.000000)
                ensight.view_transf.cone_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cone_origin(-0.750000,0.700000,1.000000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cone_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def cone_axis(self, p0: float, p1: float, p2: float) -> int:
        """Sets the axis for the cone tool.
        
        | Use with view_transf: cone_angle and view_transf: cone_origin to specify the cone tool location and orientation.
        | The components are in reference to the selected frame.
        
        Args:
            p0:
                'x_comp' x, y, z directional components for the cone tool axis
            p1:
                'y_comp' x, y, z directional components for the cone tool axis
            p2:
                'z_comp' x, y, z directional components for the cone tool axis
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric cone on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cone")
                # 
                # Sets the axis and other attributes of the cone tool 
                # 
                ensight.view_transf.cone_angle(25.000000)
                ensight.view_transf.cone_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cone_origin(-0.750000,0.700000,1.000000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cone_axis({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cone_origin(self, p0: float, p1: float, p2: float) -> int:
        """Sets the origin point for the tip of the cone tool.
        
        | Use with view_transf: cone_angle and view_transf: cone_axis to specify the cone tool location and orientation
        | The components are in reference to the selected frame.
        
        Args:
            p0:
                'x_coord' x, y, z coordinates of the cone tool origin
            p1:
                'y_coord' x, y, z coordinates of the cone tool origin
            p2:
                'z_coord' x, y, z coordinates of the cone tool origin
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric cone on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cone")
                # 
                # Sets the origin and other attributes of the cone tool 
                # 
                ensight.view_transf.cone_angle(25.000000)
                ensight.view_transf.cone_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cone_origin(-0.750000,0.700000,1.000000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cone_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cursor(self, p0: float, p1: float, p2: float) -> int:
        """Sets the location of the cursor tool.
        
        | The components are in reference to the selected frame.
        
        Args:
            p0:
                'x_coord ' x, y, z coordinates of the cursor
            p1:
                'y_coord ' x, y, z coordinates of the cursor
            p2:
                'z_coord ' x, y, z coordinates of the cursor
        
        Examples:
            ::
        
                # 
                # Sets the cursor to the point (.79563 1 .8554) 
                # 
                ensight.view_transf.cursor(0.795630,1.000000,0.855400)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cursor({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cursor_by_partijk(self, p0: int, p1: int, p2: int, p3: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cursor_by_partijk({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def cursor_by_partnameijk(self, p0: str, p1: str, p2: str, p3: str) -> int:
        """View_transf: cursor_by_partnameijk

        """
        cmd = f'''ensight.view_transf.cursor_by_partnameijk({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def cylinder(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """View_transf: cylinder

        """
        cmd = f'''ensight.view_transf.cylinder({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def cylinder_axis(self, p0: float, p1: float, p2: float) -> int:
        """Sets the axis for the cylinder tool.
        
        | Use with view_transf: cylinder_origin and view_transf: cylinder_radius to fully define the cylinder tool
        | The components are in reference to the selected frame.
        
        Args:
            p0:
                'x_comp' x, y, z directional components for the cylinder tool axis
            p1:
                'y_comp' x, y, z directional components for the cylinder tool axis
            p2:
                'z_comp' x, y, z directional components for the cylinder tool axis
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric cylinder on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cylinder")
                # 
                # Sets the axis and other attributes of the cylinder tool 
                # 
                ensight.view_transf.cylinder_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cylinder_origin(-0.750000,0.700000,1.000000)
                ensight.view_transf.cylinder_radius(1.500000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cylinder_axis({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cylinder_length(self, p0: float) -> int:
        """View_transf: cylinder_length

        """
        cmd = f'''ensight.view_transf.cylinder_length({repr(p0)})'''
        return self._session.cmd(cmd)

    def cylinder_origin(self, p0: float, p1: float, p2: float) -> int:
        """Sets the origin point for one end of the cylinder tool.
        
        | Use with view_transf: cylinder_axis and view_transf: cylinder_radius to fully define the cylinder tool.
        | The components are in reference to the selected frame.
        
        Args:
            p0:
                'x_coord' x, y, z coordinates of the cylinder tool origin 
            p1:
                'y_coord' x, y, z coordinates of the cylinder tool origin 
            p2:
                'z_coord' x, y, z coordinates of the cylinder tool origin 
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric cylinder on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cylinder")
                # 
                # Sets the origin and other attributes of the cylinder tool 
                # 
                ensight.view_transf.cylinder_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cylinder_origin(-0.750000,0.700000,1.000000)
                ensight.view_transf.cylinder_radius(1.500000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cylinder_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def cylinder_radius(self, p0: float) -> int:
        """Set the radius value for the cylinder tool.
        
        | Use with view_transf: cylinder_origin and view_transf: cylinder_axis to fully define the cylinder tool.
        
        Args:
            p0:
                'rad' cylinder radius value (in model coordinates)
        
        Examples:
            ::
        
                # 
                # Turns the display of the quadric cylinder on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("cylinder")
                # 
                # Sets the radius and other attributes of the cylinder tool 
                # 
                ensight.view_transf.cylinder_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.cylinder_origin(-0.750000,0.700000,1.000000)
                ensight.view_transf.cylinder_radius(1.500000)
                # 
                # Turns off the display of the quadric tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.cylinder_radius({repr(p0)})'''
        return self._session.cmd(cmd)

    def dialog_visible(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.dialog_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def distance(self, p0: float) -> int:
        """Sets the distance from the look_from to the look_at point.
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used. 
        | This command causes the look_from point to move along the line between the look_from and the look_at point to the desired distance. The look_at point does not move.
        
        Args:
            p0:
                'dist' distance between the look_from and the look_at point (in model system)
        
        Examples:
            ::
        
                # 
                # Selecting two viewports 
                # 
                ensight.viewport.select_begin(1,3)
                # 
                # Setting the look_at and look_from points 
                # for each of these viewports 
                # 
                ensight.view_transf.look_at(1.0000e+00,5.0000e-01,1.0000e+00)
                ensight.view_transf.look_from(5.0000e-01,5.0000e-01,2.0000e+01)
                # 
                # Changing the distance between the look_at and the look_from 
                # points. The look_at point will not change, but the 
                # look_from point will be moved appropriately 
                # 
                ensight.view_transf.distance(2.5000e+01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.distance({repr(p0)})'''
        return self._session.cmd(cmd)

    def fit(self, p0: int) -> int:
        """Appropriate scaling and translations are done so that the visible parts fit in the selected viewport.
        
        Args:
            p0:
                'viewport' viewport number in which the model will be fit.  (0, 1, ...)
        
        Examples:
            ::
        
                #
                # too fit the model in viewport 0
                #
                ensight.view_transf.fit(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.fit({repr(p0)})'''
        return self._session.cmd(cmd)

    def fit_current_viewport(self) -> int:
        """View_transf: fit_current_viewport

        """
        cmd = f'''ensight.view_transf.fit_current_viewport()'''
        return self._session.cmd(cmd)

    def function(self, p0: str) -> int:
        """Sets the transformation mode.
        
        Args:
            p0:
                'mode'
        
                * box
                * cone
                * cursor
                * cylinder
                * frame
                * global
                * line
                * local
                * plane
                * revolution
                * select_tool
                * sphere
                * spline
                * camera
        
        Examples:
            ::
        
                # 
                # Sets the function to cursor mode 
                # and translates the cursor 
                # 
                ensight.view_transf.function("cursor")
                ensight.view_transf.translate(0.295634,-0.014792,-0.144601)
                # 
                # Return to global transformation mode 
                # 
                ensight.view_transf.function("global")
                # 
                # Does some global transformations 
                # 
                ensight.view_transf.zoom(1.431051)
                ensight.view_transf.rotate(-1.071430,21.547768,0.000000)
                ensight.view_transf.translate(0.620558,0.000000,0.000000)
                # 
                # Sets Frame transform mode (local) 
                # 
                ensight.view_transf.function("local")
                # 
                # Selects the viewport and frame to use 
                # 
                ensight.viewport.select_begin(3)
                ensight.frame.select_begin(1)
                # 
                # And translate the parts attached to frame 1 
                # 
                ensight.view_transf.translate(0.0000E+00,-4.0000e+00,0.0000e+00)
                # 
                # Return to global transformation mode 
                # 
                ensight.view_transf.function("global")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.function({repr(p0)})'''
        return self._session.cmd(cmd)

    def initialize_viewports(self) -> int:
        """Resets transformations, look_at viewing parameters, and z clipping to the original values applied when model was first displayed.
        
        | Since transformations can be different per viewport, this can be applied to each viewport. Thus, a viewport selection is needed if more than one viewport is being used.
        
        Examples:
            ::
        
                # 
                # Selecting two viewports 
                # 
                ensight.viewport.select_begin(1,3)
                # 
                # Reinitializing these 2 viewports 
                # 
                ensight.view_transf.initialize_viewports()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.initialize_viewports()'''
        return self._session.cmd(cmd)

    def limit(self, p0: float) -> int:
        """Sets value represented by the extreme ends of the transformation slider in the transformation dialog.
        
        | This is a control for the user interface. Moving the slider all the way to the right will apply this value once positively. Moving it all the way to the left will apply this value once negatively. The slider is self centering, so one can continue to apply these amounts to the selected transformations. 
        | Associated with this is the Increment, which is the value that is applied (positively or negatively) by clicking the stepper button once.
        
        Args:
            p0:
                'value' the value to set as the limit for a complete movement of the cursor in the positive or negative directions
        
        Examples:
            ::
        
                ensight.view_transf.limit(5.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.limit({repr(p0)})'''
        return self._session.cmd(cmd)

    def line(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Sets the location of the line tool by setting two endpoints.
        
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'end_pt'
        
                * 1 - for the first end of the line
                * 2 - for the second end of the line
            p1:
                'x_coord' the x coordinate of the end point
            p2:
                'y_coord' the y coordinate of the end point
            p3:
                'z_coord' the z coordinate of the end point
        
        Examples:
            ::
        
                # 
                # Set the line tool endpoints 
                # 
                ensight.view_transf.line(1,-0.723300,0.700000,1.000000)
                ensight.view_transf.line(2,1.723300,0.500000,1.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.line({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def line_by_nodeids(self, p0: int, p1: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.line_by_nodeids({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def line_length(self, p0: float) -> int:
        """Changes the line tool length.
        
        | When this is applied, the location of endpoint 1 will not change, but endpoint 2 will be moved along the line through endpoint 1 and endpoint 2, until the points are separated by the length desired.
        
        Args:
            p0:
                'length' desired length of the line tool
        
        Examples:
            ::
        
                # 
                # Set the line tool endpoints 
                # 
                ensight.view_transf.line(1,-0.723300,0.700000,1.000000)
                ensight.view_transf.line(2,1.723300,0.500000,1.000000)
                # 
                # Now make the tool 10 units long 
                # (endpoint 2 will be moved) 
                # 
                ensight.view_transf.line_length(10.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.line_length({repr(p0)})'''
        return self._session.cmd(cmd)

    def look_at(self, p0: float, p1: float, p2: float) -> int:
        """Sets the look_at point for the selected viewport(s).
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        | Coordinates are in reference to the model coordinate system.
        
        Args:
            p0:
                'x_coord' model x, y, z coordinates of the look_at point
            p1:
                'y_coord' model x, y, z coordinates of the look_at point
            p2:
                'z_coord' model x, y, z coordinates of the look_at point
        
        Examples:
            ::
        
                # 
                # Selecting two viewports 
                # 
                ensight.viewport.select_begin(1,3)
                # 
                # Setting the look_at and look_from points 
                # for each of these viewports 
                # 
                ensight.view_transf.look_at(1.0000e+00,5.0000e-01,1.0000e+00)
                ensight.view_transf.look_from(5.0000e-01,5.0000e-01,2.0000e+01)
                # 
                # Changing the distance between the look_at and the look_from 
                # points. The look_at point will not change, but the 
                # look_from point will be moved appropriately 
                # 
                ensight.view_transf.distance(2.5000e+01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.look_at({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def look_from(self, p0: float, p1: float, p2: float) -> int:
        """Sets the look_from point for the selected viewport(s).
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        | Coordinates are in reference to the model coordinate system.
        
        Args:
            p0:
                'x_coord' model x, y, z coordinates of the look_from point
            p1:
                'y_coord' model x, y, z coordinates of the look_from point
            p2:
                'z_coord' model x, y, z coordinates of the look_from point
        
        Examples:
            ::
        
                # 
                # Selecting two viewports 
                # 
                ensight.viewport.select_begin(1,3)
                # 
                # Setting the look_at and look_from points 
                # for each of these viewports 
                # 
                ensight.view_transf.look_at(1.0000e+00,5.0000e-01,1.0000e+00)
                ensight.view_transf.look_from(5.0000e-01,5.0000e-01,2.0000e+01)
                # 
                # Changing the distance between the look_at and the look_from 
                # points. The look_at point will not change, but the 
                # look_from point will be moved appropriately 
                # 
                ensight.view_transf.distance(2.5000e+01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.look_from({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def mode(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def plane(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Sets the location of the plane tool by setting three corner points.
        
        | These points are best thought of as 1 being the lower left corner, 2 being the lower right corner, and 3 being the upper right corner.
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'corner_pt'
        
                * 1 - for the first corner of the plane tool
                * 2 - for the second corner of the plane tool 
                * 3 - for the third corner of the plane tool
            p1:
                'x_coord '
        
                * x coordinate of the corner point
            p2:
                'y_coord '
        
                * y coordinate of the corner point
            p3:
                'z_coord '
        
                * z coordinate of the corner point
        
        Examples:
            ::
        
                # 
                # Set the plane tool corner points 
                # 
                ensight.view_transf.plane(1,-0.750000,-0.750000,0.900000)
                ensight.view_transf.plane(2,1.750000,-0.750000,1.100000)
                ensight.view_transf.plane(3,1.750000,2.000000,1.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def plane_by_nodeids(self, p0: int, p1: int, p2: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane_by_nodeids({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def plane_equation(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Sets the location of the plane tool by specifying the coefficients of the plane equation (Ax + By + Cz = D).
        
        | Coefficients are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'A' the x coefficient
            p1:
                'B' the y coefficient
            p2:
                'C' the z coefficient
            p3:
                'D' the constant term
        
        Examples:
            ::
        
                # 
                # Set the plane tool by the plane equation 
                # 
                ensight.view_transf.plane_equation(-1.000000,0.500000,12.499997,11.659089)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane_equation({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def plane_normal(self, p0: float, p1: float, p2: float) -> int:
        """Specify the plane tool orientation.
        
        | The normal is in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_dir' x, y, z component of the plane tool normal
            p1:
                'y_dir' x, y, z component of the plane tool normal
            p2:
                'z_dir' x, y, z component of the plane tool normal
        
        Examples:
            ::
        
                ensight.tools.plane("ON")
                ensight.view_transf.function("plane")
                #
                # define the plane to be located at 0,1,0 with the z-axis (plane normal)
                # pointing in the x direction.  The plane is 3 units in X and 4 units in Y
                # (x and y according to the plane definition)
                #
                ensight.view_transf.plane_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.plane_normal(1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.plane_size(3.000000e+00,4.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane_normal({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def plane_origin(self, p0: float, p1: float, p2: float) -> int:
        """Specify the plane tool origin.
        
        | The origin is in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_ori' The x, y, z origin of the plane tool
            p1:
                'y_ori' The x, y, z origin of the plane tool
            p2:
                'z_ori' The x, y, z origin of the plane tool
        
        Examples:
            ::
        
                ensight.tools.plane("ON")
                ensight.view_transf.function("plane")
                #
                # define the plane to be located at 0,1,0 with the z-axis (plane normal)
                # pointing in the x direction.  The plane is 3 units in X and 4 units in Y
                # (x and y according to the plane definition)
                #
                ensight.view_transf.plane_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.plane_normal(1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.plane_size(3.000000e+00,4.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def plane_size(self, p0: float, p1: float) -> int:
        """Specify the plane tool size.
        
        | X and Y directions are according to the plane tool definition.
        
        Args:
            p0:
                'x_size' Size of the plane tool in the x, y direction
            p1:
                'y_size' Size of the plane tool in the x, y direction
        
        Examples:
            ::
        
                ensight.tools.plane("ON")
                ensight.view_transf.function("plane")
                #
                # define the plane to be located at 0,1,0 with the z-axis (plane normal)
                # pointing in the x direction.  The plane is 3 units in X and 4 units in Y
                # (x and y according to the plane definition)
                #
                ensight.view_transf.plane_origin(0.000000e+00,1.000000e+00,0.000000e+00)
                ensight.view_transf.plane_normal(1.000000e+00,0.000000e+00,0.000000e+00)
                ensight.view_transf.plane_size(3.000000e+00,4.000000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.plane_size({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def query_composite_matrix(self, args: Any) -> int:
        """View_transf: query_composite_matrix

        """
        cmd = f'''ensight.view_transf.query_composite_matrix({repr(args)})'''
        return self._session.cmd(cmd)

    def query_lookat_position(self, args: Any) -> int:
        """View_transf: query_lookat_position

        """
        cmd = f'''ensight.view_transf.query_lookat_position({repr(args)})'''
        return self._session.cmd(cmd)

    def query_lookfrom_position(self, args: Any) -> int:
        """View_transf: query_lookfrom_position

        """
        cmd = f'''ensight.view_transf.query_lookfrom_position({repr(args)})'''
        return self._session.cmd(cmd)

    def query_perang(self, args: Any) -> int:
        """View_transf: query_perang

        """
        cmd = f'''ensight.view_transf.query_perang({repr(args)})'''
        return self._session.cmd(cmd)

    def query_proj_matrix(self, args: Any) -> int:
        """View_transf: query_proj_matrix

        """
        cmd = f'''ensight.view_transf.query_proj_matrix({repr(args)})'''
        return self._session.cmd(cmd)

    def query_rotate_matrix(self, args: Any) -> int:
        """View_transf: query_rotate_matrix

        """
        cmd = f'''ensight.view_transf.query_rotate_matrix({repr(args)})'''
        return self._session.cmd(cmd)

    def query_scale_matrix(self, args: Any) -> int:
        """View_transf: query_scale_matrix

        """
        cmd = f'''ensight.view_transf.query_scale_matrix({repr(args)})'''
        return self._session.cmd(cmd)

    def query_transform_center(self, args: Any) -> int:
        """View_transf: query_transform_center

        """
        cmd = f'''ensight.view_transf.query_transform_center({repr(args)})'''
        return self._session.cmd(cmd)

    def query_translate_matrix(self, args: Any) -> int:
        """View_transf: query_translate_matrix

        """
        cmd = f'''ensight.view_transf.query_translate_matrix({repr(args)})'''
        return self._session.cmd(cmd)

    def query_zclip(self, args: Any) -> int:
        """View_transf: query_zclip

        """
        cmd = f'''ensight.view_transf.query_zclip({repr(args)})'''
        return self._session.cmd(cmd)

    def redo(self) -> int:
        """Redo the undo.
        
        Examples:
            ::
        
                ensight.view_transf.function("global")
                ensight.view_transf.rotate(2.510301e+01,7.117291e+01,0.000000e+00)
                ensight.view_transf.undo()
                ensight.view_transf.redo()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.redo()'''
        return self._session.cmd(cmd)

    def redraw_idle(self, args: Any) -> int:
        """View_transf: redraw_idle

        """
        cmd = f'''ensight.view_transf.redraw_idle({repr(args)})'''
        return self._session.cmd(cmd)

    def region_tool_close(self) -> int:
        """View_transf: region_tool_close

        """
        cmd = f'''ensight.view_transf.region_tool_close()'''
        return self._session.cmd(cmd)

    def region_tool_deletepoint(self, p0: int) -> int:
        """View_transf: region_tool_deletepoint

        """
        cmd = f'''ensight.view_transf.region_tool_deletepoint({repr(p0)})'''
        return self._session.cmd(cmd)

    def region_tool_point(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """View_transf: region_tool_point

        """
        cmd = f'''ensight.view_transf.region_tool_point({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def reset_by_action(self) -> int:
        """Initializes the current action transformation, thus removing the effect of that transformation.
        
        | Since transformations can be different per viewport, this command can be used for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Examples:
            ::
        
                # 
                # Set the action to rotate 
                # and the axis to be x 
                # 
                ensight.view_transf.action("rotate")
                ensight.view_transf.axis("x")
                # 
                # Select the viewport(s) desired 
                # 
                ensight.viewport.select_begin(0,2)
                # 
                # perform a couple of rotates 
                # 
                ensight.view_transf.rotate(0.500000,0.000000,0.00000)
                ensight.view_transf.rotate(-30.00000,0.000000,0.00000)
                # 
                # Now remove both rotates using this command 
                # because the action is rotate. 
                # 
                ensight.view_transf.reset_by_action()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.reset_by_action()'''
        return self._session.cmd(cmd)

    def reset_rot_trn_scl(self) -> int:
        """Removes the rotation, translation, and scale transformations in the selected viewports.
        
        | Since transformations can be different per viewport, this command can be used for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        | In Frame mode initializes the selected frames.
        
        Examples:
            ::
        
                # 
                # Select the viewport(s) desired 
                # 
                ensight.viewport.select_begin(0,2)
                # 
                # perform some rotations, translations and/or scales 
                # 
                ensight.view_transf.rotate(15.535719,-27.859741,0.000000)
                ensight.view_transf.translate(0.620558,0.000000,0.000000)
                ensight.view_transf.scale(1.2000e+00,1.2000e+00,1.2000e+00)
                # 
                # Now remove these transformations using this command 
                # 
                ensight.view_transf.reset_rot_trn_scl()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.reset_rot_trn_scl()'''
        return self._session.cmd(cmd)

    def reset_tool_constrain(self, p0: str) -> int:
        """Sets scope for the resetting of tool locations. The reset can cause the tool to be placed at its initial default location or at the center of the parts in the current viewport. 
        
        | The state set here applies to all future tool resets.
        
        Args:
            p0:
                'option'
        
                * by_global 
                * by_viewport 
        
        Examples:
            ::
        
                # 
                # Set the tool reset state to be "by viewport" 
                # 
                ensight.view_transf.reset_tool_constrain("by_viewport")
                # 
                # Select the viewport(s) desired 
                # 
                ensight.viewport.select_begin(0)
                # 
                # Reset the plane tool to the center of parts 
                # parts in viewport 0 
                # 
                ensight.view_transf.function("plane")
                ensight.view_transf.reset_rot_trn_scl()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.reset_tool_constrain({repr(p0)})'''
        return self._session.cmd(cmd)

    def reset_viewer(self) -> int:
        """View_transf: reset_viewer

        """
        cmd = f'''ensight.view_transf.reset_viewer()'''
        return self._session.cmd(cmd)

    def restore_view(self, p0: str) -> int:
        """Restores a previously saved view state file.
        
        | Since transformations are viewport independent, you need to select the desired viewport before restoring a view state (if you are using multiple viewports).
        
        Args:
            p0:
                'filename' name of the file containing the saved view
        
        Examples:
            ::
        
                # 
                # Select the viewport(s) desired 
                # 
                ensight.viewport.select_begin(0)
                # 
                # Save the current view state into the file 
                # /usr/tmp/view1 
                # 
                ensight.view_transf.save_view("/usr/tmp/view1")
                # 
                # You could now do other transformations etc... 
                # 
                # And then when you want to restore to the view state 
                # we saved, do the following 
                # 
                ensight.view_transf.restore_view("/usr/tmp/view1")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.restore_view({repr(p0)})'''
        return self._session.cmd(cmd)

    def revolution_axis(self, p0: float, p1: float, p2: float) -> int:
        """Sets the axis for the revolution tool.
        
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_comp' x, y, z directional components of the revolution tool axis
            p1:
                'y_comp' x, y, z directional components of the revolution tool axis
            p2:
                'z_comp' x, y, z directional components of the revolution tool axis
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric surface of revolution on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("revolution")
                # 
                # Sets the axis and other attributes of the revolution tool 
                # 
                ensight.view_transf.revolution_origin(0.500000,0.700000,1.000000)
                ensight.view_transf.revolution_axis(0.995040,0.099504,0.000000)
                ensight.view_transf.revolution_number_of_points(7)
                ensight.view_transf.revolution_point(1,-1.250000,0.500000)
                ensight.view_transf.revolution_point(2,-0.625000,0.500000)
                ensight.view_transf.revolution_point(3,0.000000,1.000000)
                ensight.view_transf.revolution_point(4,0.301802,0.720000)
                ensight.view_transf.revolution_point(5,0.319820,0.710000)
                ensight.view_transf.revolution_point(6,0.625000,0.500000)
                ensight.view_transf.revolution_point(7,1.250000,0.500000)
                # 
                # Turns off the display of the revolution tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.revolution_axis({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def revolution_number_of_points(self, p0: int) -> int:
        """View_transf: revolution_#_of_points

        """
        cmd = f'''ensight.view_transf.revolution_number_of_points({repr(p0)})'''
        return self._session.cmd(cmd)

    def revolution_origin(self, p0: float, p1: float, p2: float) -> int:
        """Sets the origin point for the first end of the revolution tool.
        
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_coord' x, y, z coordinates of 1st end of the revolution tool
            p1:
                'y_coord' x, y, z coordinates of 1st end of the revolution tool
            p2:
                'z_coord' x, y, z coordinates of 1st end of the revolution tool
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric surface of revolution on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("revolution")
                # 
                # Sets the axis and other attributes of the revolution tool 
                # 
                ensight.view_transf.revolution_origin(0.500000,0.700000,1.000000)
                ensight.view_transf.revolution_axis(0.995040,0.099504,0.000000)
                ensight.view_transf.revolution_number_of_points(7)
                ensight.view_transf.revolution_point(1,-1.250000,0.500000)
                ensight.view_transf.revolution_point(2,-0.625000,0.500000)
                ensight.view_transf.revolution_point(3,0.000000,1.000000)
                ensight.view_transf.revolution_point(4,0.301802,0.720000)
                ensight.view_transf.revolution_point(5,0.319820,0.710000)
                ensight.view_transf.revolution_point(6,0.625000,0.500000)
                ensight.view_transf.revolution_point(7,1.250000,0.500000)
                # 
                # Turns off the display of the revolution tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.revolution_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def revolution_point(self, p0: float, p1: float, p2: float) -> int:
        """Defines the location of the given point in relation to the revolution axis.
        
        Args:
            p0:
                'pt_number' revolution tool point number for which the coordinates are being given
            p1:
                'x_coord' x coordinate of the point on the revolution tool. Namely, the distance parallel to the revolution axis from the origin of the tool
            p2:
                'y_coord' y coordinate of the point on the revolution tool. Namely, the distance perpendicular to the revolution axis from the origin of the tool
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric surface of revolution on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("revolution")
                # 
                # Sets the axis and other attributes of the revolution tool 
                # 
                ensight.view_transf.revolution_origin(0.500000,0.700000,1.000000)
                ensight.view_transf.revolution_axis(0.995040,0.099504,0.000000)
                ensight.view_transf.revolution_number_of_points(7)
                ensight.view_transf.revolution_point(1,-1.250000,0.500000)
                ensight.view_transf.revolution_point(2,-0.625000,0.500000)
                ensight.view_transf.revolution_point(3,0.000000,1.000000)
                ensight.view_transf.revolution_point(4,0.301802,0.720000)
                ensight.view_transf.revolution_point(5,0.319820,0.710000)
                ensight.view_transf.revolution_point(6,0.625000,0.500000)
                ensight.view_transf.revolution_point(7,1.250000,0.500000)
                # 
                # Turns off the display of the revolution tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.revolution_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def rotate(self, p0: float, p1: float, p2: float) -> int:
        """Specifies a rotation (in degrees about each of the axes). Used for global, frame, and tool transformations.
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'x_ang' number of degrees to rotate about the x,y,z axes. (sign is according to the right-hand rule)
            p1:
                'y_ang' number of degrees to rotate about the x,y,z axes. (sign is according to the right-hand rule)
            p2:
                'z_ang' number of degrees to rotate about the x,y,z axes. (sign is according to the right-hand rule)
        
        Examples:
            ::
        
                # 
                # Selecting viewport(s) 
                # 
                ensight.viewport.select_begin(2)
                # 
                # Set the axis to x 
                # and rotate about the x axis 15 degrees 
                # 
                ensight.view_transf.axis("x")
                ensight.view_transf.rotate(15.000000,0.000000,0.000000)
                # 
                # Set the axis to be y 
                # and translate one unit in the -negative y direction 
                # 
                ensight.view_transf.axis("y")
                ensight.view_transf.translate(0.0000e+00,-1.0000e+00,0.0000e+00)
                # 
                # Now showing it with a plane tool rotation 
                # 
                ensight.tools.plane("ON")
                ensight.view_transf.function("plane")
                ensight.view_transf.rotate(0.000000,-39.575481,0.000000)
                ensight.view_transf.function("global")
                # 
                # And now with a local transformation 
                # 
                ensight.part.select_default()
                ensight.frame.create()
                ensight.frame.select_begin(1)
                ensight.part.select_begin(1)
                ensight.frame.assign(1)
                ensight.view_transf.function("local")
                ensight.view_transf.axis("y")
                ensight.view_transf.rotate(0.000000,27.000000,0.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.rotate({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def save_view(self, p0: str) -> int:
        """Save the current view state into a file.
        
        Args:
            p0:
                'filename' the name (including the path) of the file in which to save the view state
        
        Examples:
            ::
        
                # 
                # Select the viewport(s) desired 
                # 
                ensight.viewport.select_begin(0)
                # 
                # Save the current view state into the file 
                # /usr/tmp/view1 
                # 
                ensight.view_transf.save_view("/usr/tmp/view1")
                # 
                # You could now do other transformations etc... 
                # 
                # And then when you want to restore to the view state 
                # we saved, do the following 
                # 
                ensight.view_transf.restore_view("/usr/tmp/view1")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.save_view({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale(self, p0: float, p1: float, p2: float) -> int:
        """Defines a scaling in each of the axis directions. Used for global, frame, and tool transformation.
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'x_scale' scale factor to apply to x, y, z coordinates
            p1:
                'y_scale' scale factor to apply to x, y, z coordinates
            p2:
                'z_scale' scale factor to apply to x, y, z coordinates
        
        Examples:
            ::
        
                # 
                # Selecting viewport(s) 
                # 
                ensight.viewport.select_begin(2)
                # 
                # Applying a global scaling 
                # (evenly in all directions) 
                # 
                ensight.view_transf.scale(1.2000e+00,1.2000e+00,1.2000e+00)
                # 
                # Now with a local transformation 
                # (Scaling only in the z direction) 
                # 
                ensight.frame.select_begin(1)
                ensight.view_transf.function("local")
                ensight.view_transf.scale(0.0000e+00,0.0000e+00,5.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.scale({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def select_tool(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Sets the location of the selection tool by setting normalized screen min and max values.
        
        | The screen is considered normalized as 0 to 1 in both x and y directions, with the origin in the bottom left.
        
        Args:
            p0:
                'xmin'
        
                * minimum x screen coordinate  (0 to 1)
            p1:
                'xmax'
        
                * maximum x screen coordinate  (0 to 1)
            p2:
                'ymin'
        
                * minimum y screen coordinate  (0 to 1)
            p3:
                'ymax'
        
                * maximum y screen coordinate  (0 to 1)
        
        Examples:
            ::
        
                # 
                # Set select tool location
                # 
                ensight.tools.select_tool("ON")
                ensight.view_transf.select_tool(0.25,0.25,0.75,0.75)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.select_tool({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def sensitivity(self, p0: float) -> int:
        """View_transf: sensitivity

        """
        cmd = f'''ensight.view_transf.sensitivity({repr(p0)})'''
        return self._session.cmd(cmd)

    def sphere_axis(self, p0: float, p1: float, p2: float) -> int:
        """Sets the axis components for the sphere tool.
        
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_comp' x, y, z components of the sphere tool axis
            p1:
                'y_comp' x, y, z components of the sphere tool axis
            p2:
                'z_comp' x, y, z components of the sphere tool axis
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric sphere tool on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("sphere")
                # 
                # Sets the axis and other attributes of the sphere tool 
                # 
                ensight.view_transf.sphere_radius(1.500000)
                ensight.view_transf.sphere_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.sphere_origin(0.500000,0.700000,1.000000)
                # 
                # Turns off the display of the sphere tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.sphere_axis({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def sphere_origin(self, p0: float, p1: float, p2: float) -> int:
        """Sets the origin point for the first end of the sphere tool.
        
        | Coordinates are in reference to the selected coordinate frame.
        
        Args:
            p0:
                'x_coord' x, y, z coordinates of 1st end of the sphere tool
            p1:
                'y_coord' x, y, z coordinates of 1st end of the sphere tool
            p2:
                'z_coord' x, y, z coordinates of 1st end of the sphere tool
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric sphere tool on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("sphere")
                # 
                # Sets the origin and other attributes of the sphere tool 
                # 
                ensight.view_transf.sphere_radius(1.500000)
                ensight.view_transf.sphere_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.sphere_origin(0.500000,0.700000,1.000000)
                # 
                # Turns off the display of the sphere tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.sphere_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def sphere_radius(self, p0: float) -> int:
        """Defines the radius of the sphere tool.
        
        Args:
            p0:
                'value' radius of the sphere tool
        
        Examples:
            ::
        
                # 
                # Turns display of the quadric sphere tool on 
                # (only one quadric tool at a time can be on) 
                # 
                ensight.tools.quadric("sphere")
                # 
                # Sets the axis and other attributes of the sphere tool 
                # 
                ensight.view_transf.sphere_radius(1.500000)
                ensight.view_transf.sphere_axis(1.000000,0.100000,0.000000)
                ensight.view_transf.sphere_origin(0.500000,0.700000,1.000000)
                # 
                # Turns off the display of the sphere tool 
                # 
                ensight.tools.quadric("none")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.sphere_radius({repr(p0)})'''
        return self._session.cmd(cmd)

    def spin(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Applies a global rotation multiple times.
        
        | Interactively, the model will continue to spin until the user stops it. Once stopped, the command language contains the number of times the rotation was applied.
        
        Args:
            p0:
                'num' number of times that the rotation is to be applied
            p1:
                'x_ang' number of degrees to rotate about the x, y, z axes. (sign is according to the right-hand rule)
            p2:
                'y_ang' number of degrees to rotate about the x, y, z axes. (sign is according to the right-hand rule)
            p3:
                'z_ang' number of degrees to rotate about the x, y, z axes. (sign is according to the right-hand rule)
        
        Examples:
            ::
        
                # 
                # Selecting viewport(s) 
                # 
                ensight.viewport.select_begin(2)
                # 
                # Spin only works with global rotations 
                # 
                ensight.view_transf.function("global")
                # 
                # Apply the rotation specified 
                # (In this case, 105 times)
                # 
                ensight.view_transf.spin(105,0.602679,-10.175333,0.000000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spin({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def spline_color(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_color({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def spline_copy(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_copy()'''
        return self._session.cmd(cmd)

    def spline_delete(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_delete()'''
        return self._session.cmd(cmd)

    def spline_description(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_description({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_id(self, p0: int, p1: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_id({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def spline_invert(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_invert()'''
        return self._session.cmd(cmd)

    def spline_line_style(self, p0: str) -> int:
        """View_transf: spline_line_style

        """
        cmd = f'''ensight.view_transf.spline_line_style({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_load_fromfile(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_load_fromfile({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_load_frompart(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_load_frompart({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_new(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_new()'''
        return self._session.cmd(cmd)

    def spline_offset(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_offset({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def spline_point_size(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_point_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_point_visibility(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_point_visibility({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_save(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_save({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_select(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_select({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_select_begin(self, *args, **kwargs) -> Any:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.view_transf.spline_select_begin({arg_string})"
        return self._session.cmd(cmd)

    def spline_visibility(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_visibility({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_width(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.spline_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def splinepoint_copy(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_copy()'''
        return self._session.cmd(cmd)

    def splinepoint_create(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_create({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def splinepoint_delete(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_delete()'''
        return self._session.cmd(cmd)

    def splinepoint_edit(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_edit({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def splinepoint_offset(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_offset({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def splinepoint_paste(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_paste()'''
        return self._session.cmd(cmd)

    def splinepoint_select_all(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.splinepoint_select_all()'''
        return self._session.cmd(cmd)

    def splinepoint_select_begin(self, *args, **kwargs) -> Any:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.view_transf.splinepoint_select_begin({arg_string})"
        return self._session.cmd(cmd)

    def translate(self, p0: float, p1: float, p2: float) -> int:
        """Specifies a translation in each of the coordinate directions. Used for global, frame, and tool transformations.
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'x_dist' distance to translate in the x, y, z directions
            p1:
                'y_dist' distance to translate in the x, y, z directions
            p2:
                'z_dist' distance to translate in the x, y, z directions
        
        Examples:
            ::
        
                # 
                # Sets the function to cursor mode 
                # and translates the cursor 
                # 
                ensight.view_transf.function("cursor")
                ensight.view_transf.translate(0.295634,-0.014792,-0.144601)
                # 
                # Return to global transformation mode 
                # 
                ensight.view_transf.function("global")
                # 
                # Does some global transformations 
                # (one of which is a translate) 
                # 
                ensight.view_transf.zoom(1.431051)
                ensight.view_transf.rotate(-1.071430,21.547768,0.000000)
                ensight.view_transf.translate(0.620558,0.000000,0.000000)
                # 
                # Sets Frame transform mode (local) 
                # 
                ensight.view_transf.function("local")
                # 
                # Selects the viewport and frame to use 
                # 
                ensight.viewport.select_begin(3)
                ensight.frame.select_begin(1)
                # 
                # And translate the parts attached to frame 1 
                # 
                ensight.view_transf.translate(0.0000E+00,-4.0000e+00,0.0000e+00)
                # 
                # Return to global transformation mode 
                # 
                ensight.view_transf.function("global")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.translate({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def undo(self) -> int:
        """Undo the last transformation or tool definition.
        
        Examples:
            ::
        
                ensight.view_transf.function("global")
                ensight.view_transf.rotate(2.510301e+01,7.117291e+01,0.000000e+00)
                ensight.view_transf.undo()
                ensight.view_transf.redo()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.undo()'''
        return self._session.cmd(cmd)

    def view_center(self, p0: float, p1: float, p2: float) -> int:
        """View_transf: view_center

        """
        cmd = f'''ensight.view_transf.view_center({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def view_center_and_direction(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float) -> int:
        """View_transf: view_center_and_direction

        """
        cmd = f'''ensight.view_transf.view_center_and_direction({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)})'''
        return self._session.cmd(cmd)

    def view_center_var_max(self, p0: Any) -> int:
        """View_transf: view_center_var_max

        """
        cmd = f'''ensight.view_transf.view_center_var_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def view_center_var_min(self, p0: Any) -> int:
        """View_transf: view_center_var_min

        """
        cmd = f'''ensight.view_transf.view_center_var_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def view_from_triad_axis(self, p0: str) -> int:
        """View_transf: view_from_triad_axis

        """
        cmd = f'''ensight.view_transf.view_from_triad_axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def view_recall(self, p0: str) -> int:
        """View the model from a standard (or customized) view position.
        
        | The F5, F6, F7 views have standard right, top, and front views for a default. These can be altered by the user using the "view_transf: view_store" command. Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'option'
        
                * F5
                * F6
                * F7
                * F8
                * +X
                * +Y
                * +Z
                * -X
                * -Y
                * -Z
        
        Examples:
            ::
        
                # 
                # Select viewport for which you wish 
                # to modify the view 
                # 
                ensight.viewport.select_begin(1)
                ensight.view_transf.view_recall("F5")
                # 
                # Selecting a different viewport 
                # to show another example 
                # 
                ensight.viewport.select_begin(2)
                ensight.view_transf.view_recall("+Y")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.view_recall({repr(p0)})'''
        return self._session.cmd(cmd)

    def view_store(self, p0: str) -> int:
        """Stores a current View state as a state attached to one of the four customizable function keys.
        
        | The F5, F6, F7 views have standard right, top, and front views for a default. These can be altered by the user using this command. The views stored here can be recalled using the "view_transf: view_recall" command. 
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'option'
        
                * F5
                * F6
                * F7
                * F8
        
        Examples:
            ::
        
                # 
                # Select viewport that contains the 
                # view that you wish to store. 
                # 
                ensight.viewport.select_begin(1)
                # 
                # Store it into the desired F key 
                # 
                ensight.view_transf.view_store("F5")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.view_store({repr(p0)})'''
        return self._session.cmd(cmd)

    def viewport_camera(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.viewport_camera({repr(p0)})'''
        return self._session.cmd(cmd)

    def viewport_link(self, p0: str) -> int:
        """Link the interactive global transformations of multiple viewports. This causes any transformations applied to one of the viewports to be applied to all the other linked viewports as well.
        
        | Only interactive transforms are linked.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                # 
                # Selecting three viewports, and linking them 
                # 
                ensight.viewport.select_begin(0,1,2)
                ensight.view_transf.viewport_link("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.viewport_link({repr(p0)})'''
        return self._session.cmd(cmd)

    def viewport_state_copy(self) -> int:
        """Save the transformation state of the currently selected viewport (for the purpose of applying it to a different viewport with the "view_transf: viewport_state_paste" command.
        
        Examples:
            ::
        
                # 
                # Select viewport for which you wish 
                # to save the transformation state 
                # 
                ensight.viewport.select_begin(1)
                ensight.view_transf.viewport_state_copy()
                # 
                # Select the viewport you wish to 
                # apply this state to 
                # 
                ensight.viewport.select_begin(2)
                ensight.view_transf.viewport_state_paste()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.viewport_state_copy()'''
        return self._session.cmd(cmd)

    def viewport_state_paste(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.viewport_state_paste()'''
        return self._session.cmd(cmd)

    def viewports(self, p0: int) -> int:
        """View_transf: viewports

        """
        cmd = f'''ensight.view_transf.viewports({repr(p0)})'''
        return self._session.cmd(cmd)

    def vr_scale(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.vr_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def vr_worldcenter(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.vr_worldcenter({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def vr_worlddiagonal(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.vr_worlddiagonal({repr(p0)})'''
        return self._session.cmd(cmd)

    def zclip_back(self, p0: float) -> int:
        """Sets the position of the back/front z-clip plane
        
        | This value is used only when "view_transf: zclip_float" is OFF.  Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'z_loc' z coordinate of the back/front z-clipping plane
        
        Examples:
            ::
        
                # 
                # Select viewport 
                # 
                ensight.viewport.select_begin(1)
                # 
                # Set z-clip float OFF and set the location 
                # the front and back clipping planes 
                # 
                ensight.view_transf.zclip_float("OFF")
                ensight.view_transf.zclip_front(7.2296e+00)
                ensight.view_transf.zclip_back(3.5459e+01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zclip_back({repr(p0)})'''
        return self._session.cmd(cmd)

    def zclip_float(self, p0: str) -> int:
        """Sets the z-clipping state. The front and back z-clipping planes can "float" so that they are always outside the model - causing no z-clipping to occur, or they can be set once initially and are then subject to manual modification. 
        
        | Since the z-buffer uses the resolution between the front and back clipping planes, it is desirable to have these planes "near" the model. However, unless you specifically want to perform z-clipping, these by default "float" as needed to avoid any z-clipping. If you want z-clipping control, you can turn this "floating" behavior off and set the front and back plane locations yourself.  During the float mode, near clipping will occur if it must be at the specified minimum z-clip location. A minimum is needed to avoid z reflection.Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                # 
                # Select viewport 
                # 
                ensight.viewport.select_begin(1)
                # 
                # Set z-clip float OFF and set the location 
                # of the front and back clipping planes 
                # 
                ensight.view_transf.zclip_float("OFF")
                ensight.view_transf.zclip_front(7.2296e+00)
                ensight.view_transf.zclip_back(3.5459e+01)
                # 
                # To have them float instead 
                # 
                ensight.view_transf.zclip_float("ON")
                ensight.view_transf.zclip_min(4.00000e-04)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zclip_float({repr(p0)})'''
        return self._session.cmd(cmd)

    def zclip_front(self, p0: float) -> int:
        """Sets the position of the back/front z-clip plane
        
        | This value is used only when "view_transf: zclip_float" is OFF.  Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'z_loc' z coordinate of the back/front z-clipping plane
        
        Examples:
            ::
        
                # 
                # Select viewport 
                # 
                ensight.viewport.select_begin(1)
                # 
                # Set z-clip float OFF and set the location 
                # the front and back clipping planes 
                # 
                ensight.view_transf.zclip_float("OFF")
                ensight.view_transf.zclip_front(7.2296e+00)
                ensight.view_transf.zclip_back(3.5459e+01)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zclip_front({repr(p0)})'''
        return self._session.cmd(cmd)

    def zclip_min(self, p0: float) -> int:
        """Sets the minimum to which the front z-clipping plane is allowed to "float".
        
        | Since the z-buffer uses the resolution between the front and back clipping planes, it is desirable to have these planes "near" the model. However, unless you specifically want to perform z-clipping, these by default "float" as needed to avoid any z-clipping. If you want z-clipping control, you can turn this "floating" behavior off and set the front and back plane locations yourself.  During the float mode, near clipping will occur if it must be at the specified minimum z-clip location. A minimum is needed to avoid z reflection. Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'z_min' minimum allowable z location for the front z-clipping plane
        
        Examples:
            ::
        
                # 
                # Select viewport 
                # 
                ensight.viewport.select_begin(1)
                # 
                # Set z-clip float OFF and set the location 
                # of the front and back clipping planes 
                # 
                ensight.view_transf.zclip_float("OFF")
                ensight.view_transf.zclip_front(7.2296e+00)
                ensight.view_transf.zclip_back(3.5459e+01)
                # 
                # To have them float instead 
                # (note the minimum being set) 
                # 
                ensight.view_transf.zclip_float("ON")
                ensight.view_transf.zclip_min(4.00000e-04)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zclip_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def zoom(self, p0: float) -> int:
        """Move the viewer closer or farther away.
        
        | Since transformations can be different per viewport, this can be set for each viewport, thus a viewport selection is needed if more than one viewport is being used.
        
        Args:
            p0:
                'factor' amount of zoom scaling
        
        Examples:
            ::
        
                # 
                # Selecting viewport(s) 
                # 
                ensight.viewport.select_begin(2)
                # 
                # Applying a zoom factor 
                # 
                ensight.view_transf.zoom(1.431051)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zoom({repr(p0)})'''
        return self._session.cmd(cmd)

    def zoom_style(self, p0: str) -> int:
        """Select the zoom user interaction style.
        
        Args:
            p0:
                'style'
        
                * automatic_slide
                * manual_drag
        
        Examples:
            ::
        
                ensight.view_transf.zoom_style("automatic_slide")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zoom_style({repr(p0)})'''
        return self._session.cmd(cmd)

    def zoom_to_selectregion(self) -> int:
        """Perform the zoom according to the current location of the selection tool.
        
        Examples:
            ::
        
                ensight.tools.select_tool("ON")
                ensight.view_transf.function("global")
                ensight.view_transf.select_tool(.25,.25,.75,.75)
                ensight.view_transf.zoom_to_selectregion()
                ensight.view_transf.undo()
                ensight.view_transf.redo()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view_transf.zoom_to_selectregion()'''
        return self._session.cmd(cmd)


class view:
    """Class wrapper for EnSight view module

    This class acts as a proxy for the EnSight Python module ensight.view
    """
    def __init__(self, session: Session):
        self._session = session

    def _2d3d_grid(self, p0: str) -> int:
        """View: 2d3d_grid

        """
        cmd = f'''ensight.view._2d3d_grid({repr(p0)})'''
        return self._session.cmd(cmd)

    def bounding_box(self, p0: str) -> int:
        """View: bounding_box

        """
        cmd = f'''ensight.view.bounding_box({repr(p0)})'''
        return self._session.cmd(cmd)

    def bounding_mode(self, p0: str) -> int:
        """View: bounding_mode

        """
        cmd = f'''ensight.view.bounding_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def bounds(self, p0: str) -> int:
        """Toggles on or off the global bounds display
        
        | Bounds display will be visible in a viewport if this toggle is ON and the "viewport_bounds: visible ON" is also set.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # turn on bounds display but turn the bounds off for viewport 1
                #
                ensight.view.bounds("ON")
                ensight.viewport.select_begin(1)
                ensight.viewport_bounds.visible("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.bounds({repr(p0)})'''
        return self._session.cmd(cmd)

    def camera(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.camera({repr(p0)})'''
        return self._session.cmd(cmd)

    def clipping(self, p0: str) -> int:
        """Toggles on or off the auxiliary clipping plane
        
        | When auxiliary clipping is on, objects on the negative side of the plane tool are not drawn. By toggling on or off parts individual auxiliary clipping attribute (part: clip), some parts can be clipped while others are not.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.tools.plane("ON")
                ensight.view.clipping("ON")
                # WARNING: following line includes OBSOLETE call (ensight.part.select_partname_begin).
                ensight.part.select_partname_begin("(CASE:Case 1)ami-x hypersonic body")
                ensight.part.modify_begin()
                ensight.part.clip("OFF")
                ensight.part.modify_end()
                ensight.view_transf.function("plane")
                ensight.view_transf.rotate(106.516396,0.000000,0.000000)
                ensight.view_transf.function("global")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.clipping({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_orientation(self, p0: str) -> int:
        """Sets the default view orientation.
        
        | Must be executed before data is read.
        | The default is +z
        
        Args:
            p0:
                'direction'
        
                * +x
                * -x
                * +y
                * -y
                * +z
                * -z
        
        Examples:
            ::
        
                ensight.view.default_orientation("+x")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.default_orientation({repr(p0)})'''
        return self._session.cmd(cmd)

    def detail_mode(self, p0: str) -> int:
        """View: detail_mode

        """
        cmd = f'''ensight.view.detail_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_mode(self, p0: str) -> int:
        """View: display_mode

        """
        cmd = f'''ensight.view.display_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def fast_display(self, p0: str) -> int:
        """Toggles the fast display setting. When on, parts can be rendered using an alternative representation while being interactively moved.
        
        | Each part has an attribute that indicates how it will be drawn when fast display is on. See 'part: bounding_rep'.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.fast_display("ON")
                # WARNING: following line includes OBSOLETE call (ensight.part.select_partname_begin).
                ensight.part.select_partname_begin("(CASE:Case 1)external flow field")
                ensight.part.modify_begin()
                ensight.part.bounding_rep("points")
                ensight.part.modify_end()
                ensight.view_transf.rotate(-3.021584,51.034481,0.000000)
                ensight.view_transf.function("global")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.fast_display({repr(p0)})'''
        return self._session.cmd(cmd)

    def feature_qia(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.feature_qia({repr(p0)})'''
        return self._session.cmd(cmd)

    def full_color(self, p0: str) -> int:
        """View: full_color

        """
        cmd = f'''ensight.view.full_color({repr(p0)})'''
        return self._session.cmd(cmd)

    def full_screen(self, p0: str) -> int:
        """Toggles full screen rendering
        
        | During full screen rendering, the graphics window fills the screen hiding the rest of the user interface and other windows.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.full_screen("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.full_screen({repr(p0)})'''
        return self._session.cmd(cmd)

    def hardware_line_offset(self, p0: str) -> int:
        """Toggles on or off the use of hardware line offset
        
        | This command is only used for view preferences.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.hardware_line_offset("ON")
                ensight.view.default_orientation("+Z")
                ensight.view.hidden_surface("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.hardware_line_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def hidden_line(self, *args, **kwargs) -> Any:
        """Toggles global hidden line drawing.
        
        | Each part has a part attribute that determines whether or not it will be drawn with hidden lines if the global setting is on (See part: hidden_line).  
        | If the optional RGB values are specified, they must be values between 0.0 and 1.0. If none are specified, then 0.0, 0.0, 0.0 are used.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
            p1:
                'red_val' optional red, green, blue color values (range 0.0 to 1.0) for the hidden lines when hidden surface (See view: hidden_surface) is also ON
            p2:
                'grn_val' optional red, green, blue color values (range 0.0 to 1.0) for the hidden lines when hidden surface (See view: hidden_surface) is also ON
            p3:
                'blu_val' optional red, green, blue color values (range 0.0 to 1.0) for the hidden lines when hidden surface (See view: hidden_surface) is also ON
        
        Examples:
            ::
        
                ensight.sendmesgoptions(version="8.20 ")
                ensight.view.hidden_line("ON",1.0000e+00,0.0000e+00,0.0000e+00)
                ensight.part.modify_begin()
                ensight.part.hidden_line("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.view.hidden_line({arg_string})"
        return self._session.cmd(cmd)

    def hidden_surface(self, p0: str) -> int:
        """Toggles display of shaded surfaces.
        
        | Each part has an attribute that determines whether it will be drawn in shaded or in line mode (part: hidden_surface).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.hidden_surface("ON")
                # WARNING: following line includes OBSOLETE call (ensight.part.select_partname_begin).
                ensight.part.select_partname_begin("(CASE:Case 1)ami-x hypersonic body")
                ensight.part.modify_begin()
                ensight.part.hidden_surface("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.hidden_surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def highlight_parts(self, p0: str) -> int:
        """Toggles display of highlighted parts.
        
        | This is a global toggle for all parts.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.highlight_parts("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.highlight_parts({repr(p0)})'''
        return self._session.cmd(cmd)

    def perspective(self, p0: str) -> int:
        """Toggles global perspective rendering.
        
        | Perspective rendering causes things further in distance to appear smaller than closer objects. If this setting is off then objects will be rendered in orthographic mode which does not use perspective foreshortening.
        | Each viewport has a local setting.  See viewport: perspective
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.perspective("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.perspective({repr(p0)})'''
        return self._session.cmd(cmd)

    def pick_method(self, p0: str) -> int:
        """Chooses whether picking occurs in software or on the graphics hardware card.
        
        Args:
            p0:
                'value'
        
                * hardware
                * software
        
        Examples:
            ::
        
                ensight.view.pick_method("hardware")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.pick_method({repr(p0)})'''
        return self._session.cmd(cmd)

    def pick_mode(self, p0: str) -> int:
        """Sets what type of pick will be performed when the 'p' key is pressed.
        
        | See the EnSight User's Manual for instructions on how to operate each of these picks. 
        
        Args:
            p0:
                'value'
        
                * center_of_transform
                * cursor
                * line
                * look_at 
                * part
                * plane
                * plane_2pt
                * plane_normal
                * plane_origin
                * elements_to_blank
                * plane_by_3nodeids
                * line_by_2nodeids
                * line_by_surface+normal
                * color_palette_band
                * spline_point
                * camera_origin_xyz
                * camera_origin_node
                * camera_direction_xyz
                * camera_direction_node
                * frame_origin
        
        Examples:
            ::
        
                ensight.view.pick_mode("part")
                ensight.view.pick_mode("cursor")
                ensight.view_transf.cursor(-9.941673,-39.746929,3.714395)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.pick_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_mode(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.query_mode({repr(args)})'''
        return self._session.cmd(cmd)

    def raytrace_logo_visible(self, p0: str) -> int:
        """View: raytrace_logo_visible

        """
        cmd = f'''ensight.view.raytrace_logo_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale(self, p0: str) -> int:
        """View: scale

        """
        cmd = f'''ensight.view.scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def static_lighting(self, p0: str) -> int:
        """View: static_lighting

        """
        cmd = f'''ensight.view.static_lighting({repr(p0)})'''
        return self._session.cmd(cmd)

    def stereo(self, p0: str) -> int:
        """Toggles stereo rendering.
        
        | Stereo rendering will only occur if the graphics hardware supports it.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.stereo("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.view.stereo({repr(p0)})'''
        return self._session.cmd(cmd)

    def use_gamma_correction(self, p0: str) -> int:
        """View: use_gamma_correction

        """
        cmd = f'''ensight.view.use_gamma_correction({repr(p0)})'''
        return self._session.cmd(cmd)

    def varsize(self, p0: int, p1: int) -> int:
        """View: varsize

        """
        cmd = f'''ensight.view.varsize({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def varsize_toggle(self) -> int:
        """View: varsize_toggle

        """
        cmd = f'''ensight.view.varsize_toggle()'''
        return self._session.cmd(cmd)

    def watermark(self, p0: str) -> int:
        """View: watermark

        """
        cmd = f'''ensight.view.watermark({repr(p0)})'''
        return self._session.cmd(cmd)


class vctarrow:
    """Class wrapper for EnSight vctarrow module

    This class acts as a proxy for the EnSight Python module ensight.vctarrow
    """
    def __init__(self, session: Session):
        self._session = session

    def arrow_attach(self, p0: str) -> int:
        """Vctarrow: arrow_attach

        """
        cmd = f'''ensight.vctarrow.arrow_attach({repr(p0)})'''
        return self._session.cmd(cmd)

    def arrow_location(self, p0: str) -> int:
        """Control the location of the arrows
        
        | Discrete particles can only use the 'node' vector location. 
        | For linear elements 'node' and 'vertices' give the same result. 
        
        Args:
            p0:
                'location'
        
                * vertices
                * node
                * element_center
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.variables.select_varname_begin).
                ensight.variables.select_varname_begin("Area ","Area2 ","variables: select_varname_end ","# ","# Saving the areas to a file ","# ","variables: save_constants /usr/tmp/my_constants","part: select_begin ","2 ")
                ensight.part.modify_begin()
                ensight.vctarrow.arrow_location("element_center")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.arrow_location({repr(p0)})'''
        return self._session.cmd(cmd)

    def arrow_type(self, p0: str) -> int:
        """Change the visual representation of the arrow shafts
        
        Args:
            p0:
                'type'
        
                * rectilinear
                * rect_fixed
                * curved
        
        Examples:
            ::
        
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.arrow_type("curved")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.arrow_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def begin(self) -> int:
        """Delimit the modifications for vector arrow attributes
        
        | These commands are used to set the attributes for a vector arrow part creation. 
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.begin()'''
        return self._session.cmd(cmd)

    def color_by_projection(self, p0: str) -> int:
        """Vctarrow: color_by_projection

        """
        cmd = f'''ensight.vctarrow.color_by_projection({repr(p0)})'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Specify a scaling factor for each component of the vector variable,  to be used in calculating both the magnitude and direction of the vector  arrow.
        
        | Specify 1 to use the full value of a component. Specify 0 to ignore the corresponding vector components (and thus confine all vector arrows to planes  perpendicular to that axis). 
        | Values may be negative to reverse the direction of the component.  
        
        Args:
            p0:
                'x_scale' scaling for the x-component 
            p1:
                'y_scale' scaling for the y-component 
            p2:
                'z_scale' scaling for the z-component 
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.component(2.0000e+00,1.0000e+00,1.0000e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Create a new vector arrow part using the currently defined attributes and selected parent parts.
        
        | The vector variable must be set via the vctarrow: variable command before the part can be created. 
        
        Examples:
            ::
        
                ensight.variables.activate("VITESSE")
                ensight.part.select_all()
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.create()'''
        return self._session.cmd(cmd)

    def density(self, p0: float) -> int:
        """Control the fraction of the parent's nodes which will display a vector.
        
        | A value of 0.0 results in no arrows, while a value of 1.0 results in an arrow at every node. Between these two values the arrows are randomly distributed at the specified density. 
        
        Args:
            p0:
                'value' density value between 0 and 1
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.density(5.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.density({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_offset(self, p0: float) -> int:
        """Specify a visual offset for the vectors from the surface.
        
        | A positive offset moves the vector away from the surface in the direction of the normal. 
        
        Args:
            p0:
                'offset' offset in world coordinates
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.display_offset(1.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.display_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for vector arrow attributes
        
        | These commands are used to set the attributes for a vector arrow part creation. 
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.end()'''
        return self._session.cmd(cmd)

    def instant(self, p0: float) -> int:
        """Vctarrow: instant

        """
        cmd = f'''ensight.vctarrow.instant({repr(p0)})'''
        return self._session.cmd(cmd)

    def projection(self, p0: str) -> int:
        """Apply a projection to the vectors prior to display
        
        | Vector components are scaled prior to computing the projections.  
        
        Args:
            p0:
                'proj'
        
                * all
                * normal
                * tangential
                * component
        
        Examples:
            ::
        
                ensight.variables.activate("velocity")
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("velocity")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(4)
                ensight.part.modify_begin()
                ensight.vctarrow.projection("component")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.projection({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale_factor(self, p0: float) -> int:
        """Control the length of the vector arrows
        
        | If the arrow type is "Rectilinear" this parameter is a scaling multiple to change the magnitude of the vectors. If the type is "Rect_fixed" the parameter specifies the absolute magnitude for each vector. If the type is "Curved" this parameter controls the integration time for the streamlines which make up the curved part of the arrow. 
        
        Args:
            p0:
                'scale/time' scale factor or time
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.scale_factor(7.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Sets the target to the default settings for subsequent attribute modifications.
        
        Examples:
            ::
        
                ensight.vctarrow.select_default()
                ensight.part.modify_begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.select_default()'''
        return self._session.cmd(cmd)

    def threshold_high(self, p0: float) -> int:
        """Set the low or high threshold value
        
        | Used with vctarrow: thresholds
        
        Args:
            p0:
                'low' low filter threshold
            p1:
                'high' high filter threshold
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.thresholds("band")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_low(5.0000e-1)
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_high(7.5000e-1)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.threshold_high({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_low(self, p0: float) -> int:
        """Set the low or high threshold value
        
        | Used with vctarrow: thresholds
        
        Args:
            p0:
                'low' low filter threshold
            p1:
                'high' high filter threshold
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.thresholds("band")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_low(5.0000e-1)
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_high(7.5000e-1)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.threshold_low({repr(p0)})'''
        return self._session.cmd(cmd)

    def thresholds(self, p0: str) -> int:
        """Apply a threshold filter to the selection of vectors for display.
        
        | Threshold filtering occurs after density filtering. When using both forms of filtering in combination the actual vector density may not be exactly as specified. 
        
        Args:
            p0:
                'type'
        
                * none
                * low
                * band
                * high
                * low_high
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.thresholds("band")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_low(5.0000e-1)
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.threshold_high(7.5000e-1)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.thresholds({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Change the color of the arrow tips
        
        | The color of the tip is only used when the tip shape is 'tipped' 
        
        Args:
            p0:
                'red_val' red, green, blue components of the color tip (range 0.0 to 1.0)
            p1:
                'grn_val' red, green, blue components of the color tip (range 0.0 to 1.0)
            p2:
                'blu_val' red, green, blue components of the color tip (range 0.0 to 1.0)
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.tip_shape("tipped")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.tip_rgb(0.0000e00,1.0000e00,0.0000e00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.tip_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def tip_shaft(self, p0: str) -> int:
        """Vctarrow: tip_shaft

        """
        cmd = f'''ensight.vctarrow.tip_shaft({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_shape(self, p0: str) -> int:
        """Change the visual representation of the arrow tips
        
        Args:
            p0:
                'type'
        
                * none
                * cone
                * normal
                * triangles
                * tipped
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.tip_shape("cone")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.tip_shape({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size(self, p0: float) -> int:
        """Vctarrow: tip_size

        """
        cmd = f'''ensight.vctarrow.tip_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size_fixed(self, p0: float) -> int:
        """This command has not yet been documented
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.tip_size_fixed({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size_proportional(self, p0: float) -> int:
        """This command has not yet been documented
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.tip_size_proportional({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size_rep(self, p0: str) -> int:
        """Set the method for determining tip size
        
        | This parameter is only used for 'triangle' or 'normal' arrow tips. 
        
        Args:
            p0:
                'rep'
        
                * fixed
                * proportional
        
        Examples:
            ::
        
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.vctarrow.tip_shape("triangle")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.tip_size_rep("fixed")
                ensight.part.modify_end()
                ensight.part.modify_begin()
                ensight.vctarrow.tip_size(2.0000e-1)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.tip_size_rep({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Specify the vector variable to be used for vector arrow creation.
        
        | The variable must be activated before it can be used in a vector arrow plot. 
        
        Args:
            p0:
                'var_name' name of an active vector variable
        
        Examples:
            ::
        
                ensight.variables.activate("VITESSE")
                ensight.part.select_all()
                ensight.vctarrow.begin()
                ensight.vctarrow.variable("VITESSE")
                ensight.vctarrow.end()
                ensight.vctarrow.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.vctarrow.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class variables:
    """Class wrapper for EnSight variables module

    This class acts as a proxy for the EnSight Python module ensight.variables
    """
    def __init__(self, session: Session):
        self._session = session

    def activate(self, p0: str) -> int:
        """Activates a variable.
        
        | A variable must be activated before it can be used for any purpose.
        
        Args:
            p0:
                'name' name of the variable to activate
        
        Examples:
            ::
        
                #
                # Activate a variable and use it
                # to color a part
                #
                ensight.variables.activate("temperature")
                ensight.part.select_begin(1)
                ensight.part.colorby_palette("temperature")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.activate({repr(p0)})'''
        return self._session.cmd(cmd)

    def activate_all(self) -> int:
        """Activates all variables.
        
        Examples:
            ::
        
                # 
                # Activating all variables 
                # 
                ensight.variables.activate_all()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.activate_all()'''
        return self._session.cmd(cmd)

    def deactivate(self, p0: str) -> int:
        """Deactivates a variable.
        
        | A deactivated variable is not available for use, but can be activated again if needed.
        | If a computed variable is deactivated it is deleted and must be re-specified if needed at a later time.
        
        Args:
            p0:
                'name' name of the variable to deactivate
        
        Examples:
            ::
        
                ensight.variables.deactivate("temperature")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.deactivate({repr(p0)})'''
        return self._session.cmd(cmd)

    def evaluate(self, p0: str) -> int:
        """Creates a computed variable.
        
        | The expression must conform to one of the many supplied general functions or  proper math or calculator operations within EnSight. It is subject to all the  limitations of such, so please familiarize yourself with these.
        
        Args:
            p0:
                'expression' expression needed to create a computed variable
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.variables.activate_all()
                ensight.variables.evaluate("Area = Area(plist)")
                ensight.variables.evaluate("Grad = Grad(plist,temperature)")
                ensight.variables.evaluate("CmplxTransResp = CmplxTransResp(plist,c_scalar,90.0)")
        
        Returns:
            zero on success, non-zero on error
        	
        See also:
            :doc:`Calculator Functions <../calc_functions>`

        """
        cmd = f'''ensight.variables.evaluate({repr(p0)})'''
        return self._session.cmd(cmd)

    def get_mainvarlist_select(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.get_mainvarlist_select()'''
        return self._session.cmd(cmd)

    def load_constants(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.load_constants({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_parameter(self, p0: str) -> int:
        """Modifies a parameter of a general function computed variable.
        
        | Currently only used for modifying the phase angle of a complex transient response variable.
        
        Args:
            p0:
                'varname' computed variable's name
            p1:
                'num' parameter number for the computed variable
            p2:
                'string or value' proper modified string, or number for the parameter specified
        
        Examples:
            ::
        
                ensight.variables.activate_all()
                ensight.part.select_all()
                ensight.variables.evaluate("CmplxTransResp = CmplxTransResp(plist,c_scalar,90.0)")
                ensight.function.palette("CmplxTransResp")
                ensight.variables.modify_parameter("CmplxTransResp param 3=1.1700e+02")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.modify_parameter({repr(p0)})'''
        return self._session.cmd(cmd)

    def next_constant_isperpart(self, p0: str) -> int:
        """Variables: next_constant_isperpart

        """
        cmd = f'''ensight.variables.next_constant_isperpart({repr(p0)})'''
        return self._session.cmd(cmd)

    def notify_before_activate(self, p0: str) -> int:
        """A preference that can be set concerning notification when a variable will activated. Since EnSight by default activates variables automatically if needed, this command can cause a confirmation to be requested before a variable is activated. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.variables.notify_before_activate("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.notify_before_activate({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_dialog_show(self) -> int:
        """Variables: override_dialog_show

        """
        cmd = f'''ensight.variables.override_dialog_show()'''
        return self._session.cmd(cmd)

    def override_gt_active(self, p0: str) -> int:
        """Variables: override_gt_active

        """
        cmd = f'''ensight.variables.override_gt_active({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_gt_min(self, p0: float) -> int:
        """Variables: override_gt_min

        """
        cmd = f'''ensight.variables.override_gt_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_gt_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Variables: override_gt_rgb

        """
        cmd = f'''ensight.variables.override_gt_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def override_gt_useabs(self, p0: str) -> int:
        """Variables: override_gt_useabs

        """
        cmd = f'''ensight.variables.override_gt_useabs({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_lt_active(self, p0: str) -> int:
        """Variables: override_lt_active

        """
        cmd = f'''ensight.variables.override_lt_active({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_lt_min(self, p0: float) -> int:
        """Variables: override_lt_min

        """
        cmd = f'''ensight.variables.override_lt_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_lt_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Variables: override_lt_rgb

        """
        cmd = f'''ensight.variables.override_lt_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def override_lt_useabs(self, p0: str) -> int:
        """Variables: override_lt_useabs

        """
        cmd = f'''ensight.variables.override_lt_useabs({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_modify_begin(self) -> int:
        """Variables: override_modify_begin

        """
        cmd = f'''ensight.variables.override_modify_begin()'''
        return self._session.cmd(cmd)

    def override_modify_end(self) -> int:
        """Variables: override_modify_end

        """
        cmd = f'''ensight.variables.override_modify_end()'''
        return self._session.cmd(cmd)

    def override_range_active(self, p0: str) -> int:
        """Variables: override_range_active

        """
        cmd = f'''ensight.variables.override_range_active({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_range_max(self, p0: float) -> int:
        """Variables: override_range_max

        """
        cmd = f'''ensight.variables.override_range_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_range_min(self, p0: float) -> int:
        """Variables: override_range_min

        """
        cmd = f'''ensight.variables.override_range_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def override_range_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Variables: override_range_rgb

        """
        cmd = f'''ensight.variables.override_range_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def override_range_useabs(self, p0: str) -> int:
        """Variables: override_range_useabs

        """
        cmd = f'''ensight.variables.override_range_useabs({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_information(self, args: Any) -> int:
        """Variables: query_information

        """
        cmd = f'''ensight.variables.query_information({repr(args)})'''
        return self._session.cmd(cmd)

    def query_objects(self, args: Any) -> int:
        """Variables: query_objects

        """
        cmd = f'''ensight.variables.query_objects({repr(args)})'''
        return self._session.cmd(cmd)

    def save_all_constants(self, p0: str, p1: str, p2: str, p3: str) -> int:
        """Saves all active constant variable values to a file.
        
        Args:
            p0:
                'filename' name of the file in which to save the constants
        
        Examples:
            ::
        
                # 
                # Activating all variables 
                # 
                ensight.variables.activate_all()
                # 
                # Computing area of one part 
                # 
                ensight.part.select_begin(1)
                ensight.variables.evaluate("Area = Area(plist)")
                # 
                # Computing area of another part 
                # 
                ensight.part.select_begin(2)
                ensight.variables.evaluate("Area2 = Area(plist)")
                ensight.variables.save_all_constants("/usr/tmp/all_constants")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.save_all_constants({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def save_constants(self, p0: str, p1: str, p2: str, p3: str) -> int:
        """Saves selected constant variable values to a file.
        
        Args:
            p0:
                'filename' name of the file in which to save the constants
        
        Examples:
            ::
        
                # 
                # Activating all variables 
                # 
                ensight.variables.activate_all()
                # 
                # Computing area of one part 
                # 
                ensight.part.select_begin(1)
                ensight.variables.evaluate("Area = Area(plist)")
                # 
                # Computing area of another part 
                # 
                ensight.part.select_begin(2)
                ensight.variables.evaluate("Area2 = Area(plist)")
                # 
                # Selecting the computed area constant to write them out 
                # 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.save_constants({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Variables: select_begin

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.variables.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_byname_begin(self, args: Any) -> int:
        """Selects variables for future use.
        
        Args:
            p0:
                'varname' valid name of a variable
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.variables.select_varname_begin).
                ensight.variables.select_varname_begin("Area ","Area2 ","variables: select_varname_end ","# ","# Saving the areas to a file ","# ","variables: save_constants /usr/tmp/my_constants","# ","# Activating all variables ","# ","variables: activate_all ","# ","# Computing area of one part ","# ","part: select_begin ","1 ")
                ensight.variables.evaluate("Area = Area(plist)")
                # 
                # Computing area of another part 
                # 
                ensight.part.select_begin(2)
                ensight.variables.evaluate("Area2 = Area(plist)")
                # 
                # Selecting the computed area constant to write them out 
                # 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.select_byname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_byname_end(self) -> int:
        """Selects variables for future use.
        
        Args:
            p0:
                'varname' valid name of a variable
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.variables.select_varname_begin).
                ensight.variables.select_varname_begin("Area ","Area2 ","variables: select_varname_end ","# ","# Saving the areas to a file ","# ","variables: save_constants /usr/tmp/my_constants","# ","# Activating all variables ","# ","variables: activate_all ","# ","# Computing area of one part ","# ","part: select_begin ","1 ")
                ensight.variables.evaluate("Area = Area(plist)")
                # 
                # Computing area of another part 
                # 
                ensight.part.select_begin(2)
                ensight.variables.evaluate("Area2 = Area(plist)")
                # 
                # Selecting the computed area constant to write them out 
                # 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.variables.select_byname_end()'''
        return self._session.cmd(cmd)

    def select_varname_begin(self, args: Any) -> int:
        """Variables: select_varname_begin

        """
        cmd = f'''ensight.variables.select_varname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_varname_end(self) -> int:
        """Variables: select_varname_end

        """
        cmd = f'''ensight.variables.select_varname_end()'''
        return self._session.cmd(cmd)

    def set_working(self, p0: str, p1: str) -> int:
        """Variables: set_working

        """
        cmd = f'''ensight.variables.set_working({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)


class varextcfd:
    """Class wrapper for EnSight varextcfd module

    This class acts as a proxy for the EnSight Python module ensight.varextcfd
    """
    def __init__(self, session: Session):
        self._session = session

    def density(self, p0: str) -> int:
        """Set the density basis variable.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'var' name of the density variable
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.density({repr(p0)})'''
        return self._session.cmd(cmd)

    def freestream_density(self, p0: float) -> int:
        """Set the freestream density constant.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'dens' desired value of the freestream density constant
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.freestream_density({repr(p0)})'''
        return self._session.cmd(cmd)

    def freestream_mach(self, p0: float) -> int:
        """Set the freestream mach number constant.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'num' desired value of the freestream mach number constant
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.freestream_mach({repr(p0)})'''
        return self._session.cmd(cmd)

    def freestream_speed_sound(self, p0: float) -> int:
        """Set the freestream speed of sound constant.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'num' desired value of the freestream speed of sound constant
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.freestream_speed_sound({repr(p0)})'''
        return self._session.cmd(cmd)

    def gas_constant(self, p0: float) -> int:
        """Set the gas constant.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'num' desired value of the gas constant
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.gas_constant({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """Delimit the modifications to the extended CFD attributes.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        | These are optional commands which increase performance since all changes are made at one time.
        
        Args:
            p0:
                'varextcfd_command' any of the varextcfd commands
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """Delimit the modifications to the extended CFD attributes.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        | These are optional commands which increase performance since all changes are made at one time.
        
        Args:
            p0:
                'varextcfd_command' any of the varextcfd commands
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.modify_end()'''
        return self._session.cmd(cmd)

    def momentum(self, p0: str) -> int:
        """Set the momentum basis variable.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined. You must define either momentum or velocity for a basis, but not both.
        
        Args:
            p0:
                'var' name of the momentum variable
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.momentum({repr(p0)})'''
        return self._session.cmd(cmd)

    def ratio_of_spec_heat(self, p0: str) -> int:
        """Varextcfd: ratio_of_spec_heat

        """
        cmd = f'''ensight.varextcfd.ratio_of_spec_heat({repr(p0)})'''
        return self._session.cmd(cmd)

    def show_extended(self, p0: str) -> int:
        """Make extended CFD variables available or not.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.  Once the basis variables and constants are defined, and this command makes them available - the variables can be computed when activated or used.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.show_extended({repr(p0)})'''
        return self._session.cmd(cmd)

    def total_energy(self, p0: str) -> int:
        """Set the total_energy basis variable.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.
        
        Args:
            p0:
                'var' name of the total_energy variable
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.momentum("Momentum")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.total_energy({repr(p0)})'''
        return self._session.cmd(cmd)

    def velocity(self, p0: str) -> int:
        """Set the velocity basis variable.
        
        | For extended CFD variables to be computed, the basis variables must be identified and the basis constants defined.  You must define either momentum or velocity for a basis, but not both.
        
        Args:
            p0:
                'var' name of the velocity variable
        
        Examples:
            ::
        
                #
                # Activating all variables in this case
                #
                ensight.variables.activate_all()
                #
                # Making extended variables available
                #
                ensight.varextcfd.show_extended("ON")
                #
                # Setting the basis variables and constants
                #
                ensight.varextcfd.modify_begin()
                ensight.varextcfd.density("Density")
                ensight.varextcfd.velocity("Velocity")
                ensight.varextcfd.total_energy("Energy")
                ensight.varextcfd.ratio_of_spec_heat("1.4000e+00")
                ensight.varextcfd.freestream_mach(1.0000e+00)
                ensight.varextcfd.gas_constant(1.0000e+00)
                ensight.varextcfd.freestream_density(1.0000e+00)
                ensight.varextcfd.freestream_speed_sound(1.0000e+00)
                ensight.varextcfd.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.varextcfd.velocity({repr(p0)})'''
        return self._session.cmd(cmd)


class user:
    """Class wrapper for EnSight user module

    This class acts as a proxy for the EnSight Python module ensight.user
    """
    def __init__(self, session: Session):
        self._session = session

    def replace(self, p0: str) -> int:
        """User: replace

        """
        cmd = f'''ensight.user.replace({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """User: type

        """
        cmd = f'''ensight.user.type({repr(p0)})'''
        return self._session.cmd(cmd)


class tools:
    """Class wrapper for EnSight tools module

    This class acts as a proxy for the EnSight Python module ensight.tools
    """
    def __init__(self, session: Session):
        self._session = session

    def box(self, p0: str) -> int:
        """Turns the box tool on or off.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.tools.box("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.box({repr(p0)})'''
        return self._session.cmd(cmd)

    def cursor(self, p0: str) -> int:
        """Turns the cursor tool on or off.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.tools.cursor("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.cursor({repr(p0)})'''
        return self._session.cmd(cmd)

    def element_blank_domain(self, p0: str) -> int:
        """Determines the domain to blank out elements using the element blank tool.
        
        Args:
            p0:
                '' inside
            p1:
                '' outside
        
        Examples:
            ::
        
                ensight.tools.element_blank_domain("inside")
                ensight.tools.element_blank_domain("outside")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.element_blank_domain({repr(p0)})'''
        return self._session.cmd(cmd)

    def element_blank_layer(self, p0: str) -> int:
        """Determines the domain layer to blank out elements using the element blank tool.
        
        Args:
            p0:
                '' top
            p1:
                '' all
        
        Examples:
            ::
        
                ensight.tools.element_blank_layer("top")
                ensight.tools.element_blank_layer("all")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.element_blank_layer({repr(p0)})'''
        return self._session.cmd(cmd)

    def line(self, p0: str) -> int:
        """Turns the line tool on or off.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.tools.line("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.line({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_normal(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.line_normal({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_restricttosurface(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.line_restricttosurface({repr(p0)})'''
        return self._session.cmd(cmd)

    def plane(self, p0: str) -> int:
        """Turns the plane tool on or off.
        
        Args:
            p0:
                'option'
        
                * ON
                * OFF
                * LINE
                * FILLED
        
        Examples:
            ::
        
                ensight.tools.plane("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.plane({repr(p0)})'''
        return self._session.cmd(cmd)

    def quadric(self, p0: str) -> int:
        """Turns the quadric tool on or off.
        
        Args:
            p0:
                'option'
        
                * CYLINDER
                * SPHERE
                * CONE
                * REVOLUTION
                * NONE
        
        Examples:
            ::
        
                ensight.tools.quadric("SPHERE")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.quadric({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_tool(self, p0: str) -> int:
        """Turns the selection tool on or off.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.tools.select_tool("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tools.select_tool({repr(p0)})'''
        return self._session.cmd(cmd)


class texture:
    """Class wrapper for EnSight texture module

    This class acts as a proxy for the EnSight Python module ensight.texture
    """
    def __init__(self, session: Session):
        self._session = session

    def autoscale(self, p0: str) -> int:
        """Sets the state of temporal autoscaling for the currently selected texture. If enabled, the time limits for the texture will always be the minimum and maximum solution times currently loaded into EnSight. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.texture.select(1)
                ensight.texture.autoscale("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.autoscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def border_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Selects a texture slot for editing. 
        
        Args:
            p0:
                'red_val' red, green, blue components of the color (range 0.0 to 1.0)
            p1:
                'grn_val' red, green, blue components of the color (range 0.0 to 1.0)
            p2:
                'blu_val' red, green, blue components of the color (range 0.0 to 1.0)
        
        Examples:
            ::
        
                ensight.texture.select(1)
                ensight.texture.border_rgb(1,.5,0.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.border_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def border_transparency(self, p0: float) -> int:
        """Sets the transparency value that will be used outside of the texture space when the texture is clamped
        
        Args:
            p0:
                'alpha' A 0 to 1 transparency value.  0 is fully transparent while 1 is fully opaque
        
        Examples:
            ::
        
                ensight.texture.select(1)
                ensight.texture.border_rgb(1,.5,0.)
                ensight.texture.border_transparency(0.)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.border_transparency({repr(p0)})'''
        return self._session.cmd(cmd)

    def clear(self) -> int:
        """Remove the texture from the texture slot. 
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.clear()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.clear()'''
        return self._session.cmd(cmd)

    def compress(self, p0: str) -> int:
        """Sets the internal compression scheme EnSight uses in memory for the currently selected texture. Scenario files will contain textures stored with the selected form of compression. 
        
        Args:
            p0:
                'RAW'
        
                * compression scheme to use.
            p1:
                'RLE'
        
                * compression scheme to use.
            p2:
                'GZIP'
        
                * compression scheme to use.
        
        Examples:
            ::
        
                ensight.texture.select(1)
                ensight.texture.compress("RLE")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.compress({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_type(self, p0: str) -> int:
        """Set the texture to accept color, color+alpha, or just alpha from the loaded image.
        
        Args:
            p0:
                'type'
        
                * rgba
                * rgb
                * a
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.display_type("rgb")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.display_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def frame_limits(self, p0: int, p1: int) -> int:
        """Sets the starting and ending frame numbers for the currently selected texture. These values along with the current EnSight solution time and texture time limits, select which animation frame to display for an animated texture. 
        
        Args:
            p0:
                'start_frame' start and end frames for the texture
            p1:
                'end_frame' start and end frames for the texture
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.frame_limits(0,24)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.frame_limits({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def read(self, p0: str) -> int:
        """Load a texture. 
        
        | Textures must have a resolution of powers of 2.   Any image resolution outside of the acceptable resolution will be truncated.
        
        Args:
            p0:
                'filename' the image filename to be used as the texture
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.read("/tmp/grass.jpg")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.read({repr(p0)})'''
        return self._session.cmd(cmd)

    def select(self, p0: int) -> int:
        """Selects a texture slot for editing. 
        
        Args:
            p0:
                'num' the texture slot for editing (0 to 7 inclusive)
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.read("/tmp/grass.jpg")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.select({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_limits(self, p0: float, p1: float) -> int:
        """Sets the starting and ending solution time for the currently selected texture. These values along with the current EnSight solution time and texture frame limits, select which animation frame to display for an animated texture. Note: if autoscaling is enabled, these values are ignored
        
        Args:
            p0:
                'start_time' start and end times for the texture
            p1:
                'end_time' start and end times for the texture
        
        Examples:
            ::
        
                ensight.texture.select(0)
                ensight.texture.time_limits(0.0,5.163)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.texture.time_limits({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)


class text:
    """Class wrapper for EnSight text module

    This class acts as a proxy for the EnSight Python module ensight.text
    """
    def __init__(self, session: Session):
        self._session = session

    def change_text(self, p0: str) -> int:
        """Replaces the currently selected annotation text. 
        
        Args:
            p0:
                'revised_text' desired revised text
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.change_text("this is the revised text!")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.change_text({repr(p0)})'''
        return self._session.cmd(cmd)

    def code(self, p0: str) -> int:
        """Text: code

        """
        cmd = f'''ensight.text.code({repr(p0)})'''
        return self._session.cmd(cmd)

    def color(self, p0: int) -> int:
        """Text: color

        """
        cmd = f'''ensight.text.color({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """Deletes the currently selected text in the graphics window. 
        
        Examples:
            ::
        
                ensight.text.select_begin(1,2,3)
                ensight.text.delete()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.delete()'''
        return self._session.cmd(cmd)

    def description(self, p0: str) -> int:
        """Text: description

        """
        cmd = f'''ensight.text.description({repr(p0)})'''
        return self._session.cmd(cmd)

    def deselect_all(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.deselect_all()'''
        return self._session.cmd(cmd)

    def justification(self, p0: str) -> int:
        """Specifies the placement of the selected text in the graphics window, in relation to the point specified in the text: location_x and location_y commands.
        
        | The default value for justification is left.
        | Also denotes the point about which the text rotates.
        
        Args:
            p0:
                'justification_type'
        
                * Must have one of the following values:
                * left
                * center
                * right
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.location_x(0.5)
                ensight.text.location_y(0.6)
                ensight.text.justification("left")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.justification({repr(p0)})'''
        return self._session.cmd(cmd)

    def location_x(self, p0: float) -> int:
        """Specifies the x/y coordinate of the selected text in the currently selected viewport.
        
        | The text position can also be in reference to a specific viewport.
        | See "text: relative_viewport" command.
        
        Args:
            p0:
                'coord' A value of 0.0 indicates the left/bottom side of the window, while a value of 1.0 indicates the right/top side.
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.relative_viewport(2)
                ensight.text.location_x(0.5)
                ensight.text.location_y(0.5)
                ensight.text.justification("center")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.location_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def location_y(self, p0: float) -> int:
        """Specifies the x/y coordinate of the selected text in the currently selected viewport.
        
        | The text position can also be in reference to a specific viewport.
        | See "text: relative_viewport" command.
        
        Args:
            p0:
                'coord' A value of 0.0 indicates the left/bottom side of the window, while a value of 1.0 indicates the right/top side.
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.relative_viewport(2)
                ensight.text.location_x(0.5)
                ensight.text.location_y(0.5)
                ensight.text.justification("center")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.location_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def mix_rgb(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Text: mix_rgb

        """
        cmd = f'''ensight.text.mix_rgb({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """Delimit the modifications for text attributes.
        
        | These optional commands can be used to execute a number of attribute changes at one time for better performance.
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.modify_begin()
                ensight.text.rgb(1,0,0)
                ensight.text.location_x(100)
                ensight.text.location_y(20)
                ensight.text.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """Delimit the modifications for text attributes.
        
        | These optional commands can be used to execute a number of attribute changes at one time for better performance.
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.modify_begin()
                ensight.text.rgb(1,0,0)
                ensight.text.location_x(100)
                ensight.text.location_y(20)
                ensight.text.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.modify_end()'''
        return self._session.cmd(cmd)

    def new_or_mod_text(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.new_or_mod_text({repr(p0)})'''
        return self._session.cmd(cmd)

    def new_text(self, p0: str) -> int:
        """Creates new text in the graphics window. 
        
        Args:
            p0:
                'text' desired text
        
        Examples:
            ::
        
                ensight.text.new_text("This is the new text!")
                ensight.text.location_x(0.5)
                ensight.text.location_y(0.6)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.new_text({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin(self, p0: float, p1: float, p2: float) -> int:
        """Text: origin

        """
        cmd = f'''ensight.text.origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def origin_by(self, p0: str) -> int:
        """Text: origin_by

        """
        cmd = f'''ensight.text.origin_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin_frame(self, p0: int) -> int:
        """Text: origin_frame

        """
        cmd = f'''ensight.text.origin_frame({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Text: query_count

        """
        cmd = f'''ensight.text.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Text: query_display_attributes

        """
        cmd = f'''ensight.text.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_selected_objects(self, args: Any) -> int:
        """Text: query_selected_objects

        """
        cmd = f'''ensight.text.query_selected_objects({repr(args)})'''
        return self._session.cmd(cmd)

    def query_text(self, args: Any) -> int:
        """Text: query_text

        """
        cmd = f'''ensight.text.query_text({repr(args)})'''
        return self._session.cmd(cmd)

    def relative_to(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.relative_to({repr(p0)})'''
        return self._session.cmd(cmd)

    def relative_viewport(self, p0: int) -> int:
        """Specifies the viewport to which location of the selected text will be relative, when specified by the text: location_x and location_y commands.
        
        | A value of zero indicates the graphics window.
        
        Args:
            p0:
                'viewport' specifies the viewport
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.relative_viewport(0)
                ensight.text.location_x(0.5)
                ensight.text.location_y(0.6)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.relative_viewport({repr(p0)})'''
        return self._session.cmd(cmd)

    def rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the selected text in the graphics window.
        
        Args:
            p0:
                'red_val' red, green, blue color components, ( 0.0 to 1.0).
            p1:
                'grn_val' red, green, blue color components, ( 0.0 to 1.0).
            p2:
                'blu_val' red, green, blue color components, ( 0.0 to 1.0).
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.rgb(1.0,0,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def rotational_angle(self, p0: float) -> int:
        """Specifies the angle of rotation of the selected text in the graphics window.
        
        | A value of 0 for rotation corresponds to the normal, upright orientation of text, with clockwise rotation at higher values.
        | The text rotates about the justification point.
        
        Args:
            p0:
                'angle' must be within the range of 0.0 to 360.0
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.rotational_angle(45.0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.rotational_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """Text: select_all

        """
        cmd = f'''ensight.text.select_all()'''
        return self._session.cmd(cmd)

    def select_all_invisible(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.select_all_invisible()'''
        return self._session.cmd(cmd)

    def select_all_visible(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.select_all_visible()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Selects one or more text strings in the graphics window as the target for future text: commands 
        
        Args:
            p0:
                'indexN' The text annotation ID
        
        Examples:
            ::
        
                ensight.text.select_begin(1,2)
                ensight.text.rgb(1,0,0)
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.text.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Causes any following text commands to affect the default settings, rather than a particular text object.
        
        | All text commands following text: select_default will affect default settings until a new text object is selected using text: select_begin/select_end. 
        
        Examples:
            ::
        
                ensight.text.select_default()
                ensight.text.visible("OFF")
                ensight.text.rgb(1,0,0)
                ensight.text.select_begin(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.select_default()'''
        return self._session.cmd(cmd)

    def shadow_intensity(self, p0: float) -> int:
        """Text: shadow_intensity

        """
        cmd = f'''ensight.text.shadow_intensity({repr(p0)})'''
        return self._session.cmd(cmd)

    def shadow_offset(self, p0: int) -> int:
        """Text: shadow_offset

        """
        cmd = f'''ensight.text.shadow_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def size(self, p0: int) -> int:
        """Specifies the size of the selected text in the graphics window.
        
        | Text size is specified in arbitrary units, with 0 being the smallest possible text and 100 the largest.
        | The text scales with the size of the graphics window.     
        
        Args:
            p0:
                'size' must be within the range of 0 to 100
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.size(25)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.size({repr(p0)})'''
        return self._session.cmd(cmd)

    def string(self, p0: str) -> int:
        """Text: string

        """
        cmd = f'''ensight.text.string({repr(p0)})'''
        return self._session.cmd(cmd)

    def update(self) -> int:
        """Text: update

        """
        cmd = f'''ensight.text.update()'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Controls the visibility of the selected text in the graphics window. 
        
        | Text is visible by default. 
        
        Args:
            p0:
                'toggle' ON
            p1:
                'toggle' OFF
        
        Examples:
            ::
        
                ensight.text.select_begin(1)
                ensight.text.visible("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.text.visible({repr(p0)})'''
        return self._session.cmd(cmd)


class tensor:
    """Class wrapper for EnSight tensor module

    This class acts as a proxy for the EnSight Python module ensight.tensor
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Delimit the modifications for tensor parts.
        
        | These commands are used to set the attributes for tensor glyph part creation.
        
        Args:
            p0:
                'tensor_command' any of the tensor attribute commands
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.begin()'''
        return self._session.cmd(cmd)

    def color_by(self, p0: str) -> int:
        """Sets the method by which a tensor glyph part is colored.
        
        Args:
            p0:
                'method'
        
                * part
                * direction
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Now selecting the tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And changing to color by part instead of direction
                #
                ensight.part.modify_begin()
                ensight.tensor.color_by("part")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.color_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def compression_line_width(self, p0: int) -> int:
        """Sets the line width (in pixels) that will be used for the compression portion of a tensor glyph if the "tensor: line_width_by" command method is set to "direction".
        
        | If the "tensor: line_width_by" command method is set to "part", the tensor glyph part is line width is set in the same manner as any other part.
        
        Args:
            p0:
                'width' width in pixels for the compression portion of a tensor glyph (range is 1 to 4)
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to make compression
                #  lines 2 pixels wide)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.compression_line_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def compression_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Sets the color that will be used for the compression portion of a tensor glyph if the "tensor: color_by" command method is set to "direction".
        
        | If the "tensor: color_by" command method is set to "part", the tensor glyph part is colored like any other part.
        
        Args:
            p0:
                'red_val' red, green, blue color components for the compression line (0.0 to 1.0)
            p1:
                'grn_val' red, green, blue color components for the compression line (0.0 to 1.0)
            p2:
                'blu_val' red, green, blue color components for the compression line (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to make compression
                #  lines a particular color)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.compression_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Causes a tensor glyph part to be created according to previously set attributes or defaults.
        
        | The selection of parent part(s) is required.
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.create()'''
        return self._session.cmd(cmd)

    def display_compression(self, p0: str) -> int:
        """Specifies whether the compression portion of a tensor glyph will be displayed or not.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (One of which is to have the compression displayed)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Selecting the newly created tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And turning compression portion off - to
                # show how it can be done
                #
                ensight.part.modify_begin()
                ensight.tensor.display_compression("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.display_compression({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_major(self, p0: str) -> int:
        """Specifies whether the major, middle, or minor eigenvectors of a tensor glyph will be displayed. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (Note that all eigenvectors are set to be displayed)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Selecting the newly created tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And turning off the middle eigenvector
                #
                ensight.part.modify_begin()
                ensight.tensor.display_middle("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.display_major({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_middle(self, p0: str) -> int:
        """Specifies whether the major, middle, or minor eigenvectors of a tensor glyph will be displayed. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (Note that all eigenvectors are set to be displayed)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Selecting the newly created tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And turning off the middle eigenvector
                #
                ensight.part.modify_begin()
                ensight.tensor.display_middle("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.display_middle({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_minor(self, p0: str) -> int:
        """Specifies whether the major, middle, or minor eigenvectors of a tensor glyph will be displayed. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (Note that all eigenvectors are set to be displayed)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Selecting the newly created tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And turning off the middle eigenvector
                #
                ensight.part.modify_begin()
                ensight.tensor.display_middle("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.display_minor({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_tension(self, p0: str) -> int:
        """Specifies whether the tension portion of a tensor glyph will be displayed.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (One of which is to have the tension displayed)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Selecting the newly created tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And turning tension portion off - to
                # show how it can be done
                #
                ensight.part.modify_begin()
                ensight.tensor.display_tension("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.display_tension({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for tensor parts.
        
        | These commands are used to set the attributes for tensor glyph part creation.
        
        Args:
            p0:
                'tensor_command' any of the tensor attribute commands
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.end()'''
        return self._session.cmd(cmd)

    def line_width_by(self, p0: str) -> int:
        """Sets the method by which a tensor glyph part's line width is controlled.
        
        Args:
            p0:
                'method'
        
                * part
                * direction
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (Note line width set by direction)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Now selecting the tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And changing to line width to be by part instead of direction
                #
                ensight.part.modify_begin()
                ensight.tensor.line_width_by("part")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.line_width_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale_factor(self, p0: float) -> int:
        """Sets the scale factor to be applied to the tensor glyph.
        
        | The factor is applied to major, middle, and minor eigenvectors.
        
        Args:
            p0:
                'value' the scale factor that to apply to the tensor glyph
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (One of which is the scale factor)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.scale_factor(1.6700e+00)
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
                #
                # Now selecting the tensor glyph part
                #
                ensight.part.select_begin(5)
                #
                # And changing the scale factor back to 1
                #
                ensight.part.modify_begin()
                ensight.tensor.scale_factor(1.0000e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Sets default as the current tensor glyph selection, so subsequent attribute modifications will affect the default.
        
        | When certain attributes will be common to future tensor glyph parts, it is useful to set these once as the default.
        
        Examples:
            ::
        
                #
                # Setting to default
                #
                ensight.tensor.select_default()
                #
                # Setting a few things as defaults
                #
                ensight.part.modify_begin()
                ensight.tensor.scale_factor(1.5000e+00)
                ensight.tensor.display_middle("OFF")
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,0.0000e+00)
                ensight.tensor.tension_rgb(0.0000e+00,0.0000e+00,1.0000e+00)
                ensight.tensor.line_width_by("part")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.select_default()'''
        return self._session.cmd(cmd)

    def tension_line_width(self, p0: int) -> int:
        """Sets the line width (in pixels) that will be used for the tension portion of a tensor glyph if the "tensor: line_width_by" command method is set to "direction".
        
        | If the "tensor: line_width_by" command method is set to "part", the tensor glyph part is line width is set in the same manner as any other part.
        
        Args:
            p0:
                'width' width in pixels for the tension portion of a tensor glyph (range is 1 to 4)
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to make tension
                #  lines 4 pixels wide)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.tension_line_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def tension_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Sets the color that will be used for the tension portion of a tensor glyph if the "tensor: color_by" command method is set to "direction".
        
        | If the "tensor: color_by" command method is set to "part", the tensor glyph part is colored like any other part.
        
        Args:
            p0:
                'red_val' red, green, blue color components for the tension line (0.0 to 1.0)
            p1:
                'grn_val' red, green, blue color components for the tension line (0.0 to 1.0)
            p2:
                'blu_val' red, green, blue color components for the tension line (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to make tension
                #  lines a particular color)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.tension_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def tip_shape(self, p0: str) -> int:
        """Sets the shape of the tips on the tensor glyphs
        
        | The direction of the arrowheads will be towards each for compression and away from each other for tension.
        
        Args:
            p0:
                'shape'
        
                * none
                * normal
                * triangle
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to make triangle arrowhead tips)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.tip_shape({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size(self, p0: float) -> int:
        """Sets the size of the tips on the tensor glyphs
        
        Args:
            p0:
                'size' a relative size factor for tensor glyph tips
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included is the one to set tip size)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.tip_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def tip_size_rep(self, p0: str) -> int:
        """Tensor: tip_size_rep

        """
        cmd = f'''ensight.tensor.tip_size_rep({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Specifies the name of the tensor variable that the tensor glyphs will represent.
        
        Args:
            p0:
                'name' name of the tensor variable
        
        Examples:
            ::
        
                #
                # Activating a tensor variable
                #
                ensight.variables.activate("uniaxial_tensor")
                #
                # Selecting all parts as parents
                #
                ensight.part.select_all()
                #
                # Grouping a bunch of tensor attribute commands
                # (included the one that specifies the name)
                # 
                ensight.tensor.begin()
                ensight.tensor.variable("uniaxial_tensor")
                ensight.tensor.display_compression("ON")
                ensight.tensor.display_tension("ON")
                ensight.tensor.display_major("ON")
                ensight.tensor.display_minor("ON")
                ensight.tensor.display_middle("ON")
                ensight.tensor.tip_shape("triangle")
                ensight.tensor.tip_size(1.0000e-01)
                ensight.tensor.color_by("direction")
                ensight.tensor.compression_rgb(1.0000e+00,0.0000e+00,4.0000e-01)
                ensight.tensor.tension_rgb(0.0000e+00,8.0000e-01,1.0000e+00)
                ensight.tensor.line_width_by("direction")
                ensight.tensor.compression_line_width(2)
                ensight.tensor.tension_line_width(4)
                ensight.tensor.end()
                #
                # Creating the tensor glyph part
                #
                ensight.tensor.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.tensor.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class subset:
    """Class wrapper for EnSight subset module

    This class acts as a proxy for the EnSight Python module ensight.subset
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Delimit the modifications for subset part attributes.
        
        | These commands are used to set the attributes for a subset part creation.
        
        Args:
            p0:
                'subset_commands' any of the subset attribute commands
        
        Examples:
            ::
        
                ensight.subset.begin()
                ensight.subset.begin_subsetdesc()
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'part_num'
                ensight.sendmesg(r"part_num 1 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'nodes'
                ensight.sendmesg(r"nodes ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_1-10'
                ensight.sendmesg(r"1-10 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'elements'
                ensight.sendmesg(r"elements ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_20-30'
                ensight.sendmesg(r"20-30 ")
                ensight.subset.end_subsetdesc()
                ensight.subset.end()
                ensight.subset.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.begin()'''
        return self._session.cmd(cmd)

    def begin_subsetdesc(self) -> int:
        """Encloses the information for parent part number, nodes, and elements for a subset part.
        
        Args:
            p0:
                'num' Parent part number of the subset part. Place it on the line with the keyword "part_num", as shown in the example.
            p1:
                'nodes_string' List of nodes to include in the subset part. Place the keyword "nodes" on a line, then place this string on subsequent lines. Note that the list is a comma separated list of node ids which can also include dash separated ranges of nodes.
            p2:
                'elements_string' List of elements to include in the subset part. Place the keyword "elements" on a line, then place this string on subsequent lines. Note that the list is a comma separated list of element ids which can also include dash separated ranges of elements.
        
        Examples:
            ::
        
                ensight.subset.begin()
                ensight.subset.begin_subsetdesc()
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'part_num'
                ensight.sendmesg(r"part_num 1 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'nodes'
                ensight.sendmesg(r"nodes ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_13,1-10,103,104,200-3000'
                ensight.sendmesg(r"13,1-10,103,104,200-3000 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'elements'
                ensight.sendmesg(r"elements ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_20-30,100-200,355'
                ensight.sendmesg(r"20-30,100-200,355 ")
                ensight.subset.end_subsetdesc()
                ensight.subset.end()
                ensight.subset.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.begin_subsetdesc()'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Creates a subset part according to previously defined attributes or defaults.
        
        Examples:
            ::
        
                ensight.subset.begin()
                ensight.subset.begin_subsetdesc()
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'part_num'
                ensight.sendmesg(r"part_num 1 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'nodes'
                ensight.sendmesg(r"nodes ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_13,1-10,103,104,200-3000'
                ensight.sendmesg(r"13,1-10,103,104,200-3000 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'elements'
                ensight.sendmesg(r"elements ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_20-30,100-200,355'
                ensight.sendmesg(r"20-30,100-200,355 ")
                ensight.subset.end_subsetdesc()
                ensight.subset.end()
                ensight.subset.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.create()'''
        return self._session.cmd(cmd)

    def create_desc(self, args: Any) -> int:
        """Subset: create_desc

        """
        cmd = f'''ensight.subset.create_desc({repr(args)})'''
        return self._session.cmd(cmd)

    def dummy_chng_slot(self, args: Any) -> int:
        """Subset: dummy_chng_slot

        """
        cmd = f'''ensight.subset.dummy_chng_slot({repr(args)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for subset part attributes.
        
        | These commands are used to set the attributes for a subset part creation.
        
        Args:
            p0:
                'subset_commands' any of the subset attribute commands
        
        Examples:
            ::
        
                ensight.subset.begin()
                ensight.subset.begin_subsetdesc()
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'part_num'
                ensight.sendmesg(r"part_num 1 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'nodes'
                ensight.sendmesg(r"nodes ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_1-10'
                ensight.sendmesg(r"1-10 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'elements'
                ensight.sendmesg(r"elements ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_20-30'
                ensight.sendmesg(r"20-30 ")
                ensight.subset.end_subsetdesc()
                ensight.subset.end()
                ensight.subset.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.end()'''
        return self._session.cmd(cmd)

    def end_subsetdesc(self) -> int:
        """Encloses the information for parent part number, nodes, and elements for a subset part.
        
        Args:
            p0:
                'num' Parent part number of the subset part. Place it on the line with the keyword "part_num", as shown in the example.
            p1:
                'nodes_string' List of nodes to include in the subset part. Place the keyword "nodes" on a line, then place this string on subsequent lines. Note that the list is a comma separated list of node ids which can also include dash separated ranges of nodes.
            p2:
                'elements_string' List of elements to include in the subset part. Place the keyword "elements" on a line, then place this string on subsequent lines. Note that the list is a comma separated list of element ids which can also include dash separated ranges of elements.
        
        Examples:
            ::
        
                ensight.subset.begin()
                ensight.subset.begin_subsetdesc()
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'part_num'
                ensight.sendmesg(r"part_num 1 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'nodes'
                ensight.sendmesg(r"nodes ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_13,1-10,103,104,200-3000'
                ensight.sendmesg(r"13,1-10,103,104,200-3000 ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'elements'
                ensight.sendmesg(r"elements ")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute '_20-30,100-200,355'
                ensight.sendmesg(r"20-30,100-200,355 ")
                ensight.subset.end_subsetdesc()
                ensight.subset.end()
                ensight.subset.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.end_subsetdesc()'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Sets to default subset part, so subsequent attribute changes will apply to the defaults. 
        
        Examples:
            ::
        
                ensight.subset.select_default()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(6.0000e-01,0.0000e+00,1.0000e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.subset.select_default()'''
        return self._session.cmd(cmd)


class species:
    """Class wrapper for EnSight species module

    This class acts as a proxy for the EnSight Python module ensight.species
    """
    def __init__(self, session: Session):
        self._session = session

    def select_all(self) -> int:
        """Species: select_all

        """
        cmd = f'''ensight.species.select_all()'''
        return self._session.cmd(cmd)

    def select_byname_begin(self, args: Any) -> int:
        """Species: select_byname_begin

        """
        cmd = f'''ensight.species.select_byname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_byname_end(self) -> int:
        """Species: select_byname_end

        """
        cmd = f'''ensight.species.select_byname_end()'''
        return self._session.cmd(cmd)


class solution_time:
    """Class wrapper for EnSight solution_time module

    This class acts as a proxy for the EnSight Python module ensight.solution_time
    """
    def __init__(self, session: Session):
        self._session = session

    def begin_simtime(self, p0: float) -> int:
        """Sets the solution time to be used as the beginning/ending time for subsequent time use. 
        
        | This is used when the "solution_time: show_as" command is set to "time".  Also, it will be truncated to a solution time directly associated with a time step if "solution_time: update_type" is set to "discrete". 
        | Can be greater/lesser or equal to the smallest/largest time available.
        
        Args:
            p0:
                'time' solution time to use as the beginning/ending time
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.begin_simtime({repr(p0)})'''
        return self._session.cmd(cmd)

    def begin_step(self, p0: int) -> int:
        """Sets the time step to be used as the beginning/ending time step for subsequent time use. 
        
        | This is used when the "solution_time: show_as" command is set to "step".
        | Can be greater/lesser or equal to the smallest/largest time step available.
        
        Args:
            p0:
                'step' time step to use as the beginning/ending time step
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using time steps
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(0)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.begin_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def convergence_value(self, p0: float) -> int:
        """Solution_time: convergence_value

        """
        cmd = f'''ensight.solution_time.convergence_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def current_simtime(self, p0: float) -> int:
        """Sets the current simulation time.  Must be between the beginning time and the ending time.
        
        | This is used when the "solution_time: show_as" command is set to "time".
        
        Args:
            p0:
                'time' The simulation time to use as the current time. If "solution_time: update_type" is "continuous", this can be set to be any time between the beginning and ending times, even if it lies between data points (interpolation will take place).  If the "solution_time: update_type" is "discrete", this should be the time associated with a time step.
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.current_simtime({repr(p0)})'''
        return self._session.cmd(cmd)

    def current_step(self, p0: float) -> int:
        """Sets the current time step.  Must be between the beginning time step and the ending time step.
        
        Args:
            p0:
                'step' The time step to use as the current time step. If "solution_time: update_type" is "continuous", this can be float and thus can be set to be fractionally between time steps (interpolation will take place).  If the "solution_time: update_type" is "discrete", this should be an integer.
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using time steps,
                # but the current is set 40% between steps 2 and 3.
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(2.4)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.current_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def custom_timeline_begin(self, p0: str) -> int:
        """Solution_time: custom_timeline_begin

        """
        cmd = f'''ensight.solution_time.custom_timeline_begin({repr(p0)})'''
        return self._session.cmd(cmd)

    def custom_timeline_end(self, p0: str) -> int:
        """Solution_time: custom_timeline_end

        """
        cmd = f'''ensight.solution_time.custom_timeline_end({repr(p0)})'''
        return self._session.cmd(cmd)

    def custom_timeline_readapply(self, p0: str) -> int:
        """Solution_time: custom_timeline_readapply

        """
        cmd = f'''ensight.solution_time.custom_timeline_readapply({repr(p0)})'''
        return self._session.cmd(cmd)

    def end_simtime(self, p0: float) -> int:
        """Sets the solution time to be used as the beginning/ending time for subsequent time use. 
        
        | This is used when the "solution_time: show_as" command is set to "time".  Also, it will be truncated to a solution time directly associated with a time step if "solution_time: update_type" is set to "discrete". 
        | Can be greater/lesser or equal to the smallest/largest time available.
        
        Args:
            p0:
                'time' solution time to use as the beginning/ending time
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.end_simtime({repr(p0)})'''
        return self._session.cmd(cmd)

    def end_step(self, p0: int) -> int:
        """Sets the time step to be used as the beginning/ending time step for subsequent time use. 
        
        | This is used when the "solution_time: show_as" command is set to "step".
        | Can be greater/lesser or equal to the smallest/largest time step available.
        
        Args:
            p0:
                'step' time step to use as the beginning/ending time step
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using time steps
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(0)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.end_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def increment(self, p0: float) -> int:
        """Sets the number of steps that are moved when the solution time dialog time stepper buttons are clicked.
        
        | This is a user interface attribute.
        
        Args:
            p0:
                'step_by' number of time steps to advance by or decrease by with one click of the solution time stepper buttons
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                # (but at the end it sets the stepper button increment)
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.increment({repr(p0)})'''
        return self._session.cmd(cmd)

    def master_timeline(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.master_timeline({repr(p0)})'''
        return self._session.cmd(cmd)

    def monitor_for_new_steps(self, p0: str) -> int:
        """Solution_time: monitor_for_new_steps

        """
        cmd = f'''ensight.solution_time.monitor_for_new_steps({repr(p0)})'''
        return self._session.cmd(cmd)

    def number_of_cycles(self, p0: int) -> int:
        """Solution_time: #_of_cycles

        """
        cmd = f'''ensight.solution_time.number_of_cycles({repr(p0)})'''
        return self._session.cmd(cmd)

    def play_backward(self) -> int:
        """Causes the model to be displayed backward/forward through time. 
        
        | Is only in effect when the application is idle.
        
        Examples:
            ::
        
                ensight.solution_time.play_backward()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.play_backward()'''
        return self._session.cmd(cmd)

    def play_forward(self) -> int:
        """Causes the model to be displayed backward/forward through time. 
        
        | Is only in effect when the application is idle.
        
        Examples:
            ::
        
                ensight.solution_time.play_backward()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.play_forward()'''
        return self._session.cmd(cmd)

    def play_style(self) -> int:
        """Solution_time: play_style

        """
        cmd = f'''ensight.solution_time.play_style()'''
        return self._session.cmd(cmd)

    def select_all_timesteps(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.select_all_timesteps()'''
        return self._session.cmd(cmd)

    def set_beg_to_min(self) -> int:
        """Solution_time: set_beg_to_min

        """
        cmd = f'''ensight.solution_time.set_beg_to_min()'''
        return self._session.cmd(cmd)

    def set_end_to_max(self) -> int:
        """Solution_time: set_end_to_max

        """
        cmd = f'''ensight.solution_time.set_end_to_max()'''
        return self._session.cmd(cmd)

    def show_as(self, p0: str) -> int:
        """Sets method to use for specifying time - either as solution time directly or as time steps of data. 
        
        Args:
            p0:
                'method'
        
                * step
                * time
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
                #
                # But here we change it to use time steps
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(5)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.show_as({repr(p0)})'''
        return self._session.cmd(cmd)

    def step_backward(self) -> int:
        """Causes the model to be displayed at previous/next time. 
        
        | This command is not generated by the EnSight GUI, but is intended for use with batch or context operations where the time of the first step could vary from model to model.
        
        Examples:
            ::
        
                ensight.solution_time.step_backward()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.step_backward()'''
        return self._session.cmd(cmd)

    def step_forward(self) -> int:
        """Causes the model to be displayed at previous/next time. 
        
        | This command is not generated by the EnSight GUI, but is intended for use with batch or context operations where the time of the first step could vary from model to model.
        
        Examples:
            ::
        
                ensight.solution_time.step_backward()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.step_forward()'''
        return self._session.cmd(cmd)

    def stop(self) -> int:
        """Stops the model from being displayed through time. 
        
        Examples:
            ::
        
                ensight.solution_time.stop()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.stop()'''
        return self._session.cmd(cmd)

    def time_annotation(self, p0: str) -> int:
        """Sets whether time annotation will automatically be displayed on the screen during animation.
        
        | None.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.solution_time.time_annotation("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.time_annotation({repr(p0)})'''
        return self._session.cmd(cmd)

    def timeset_between(self, p0: str) -> int:
        """When the current time lies between the steps of a given timeset, this command sets how to handle the situation in the span. 
        
        Args:
            p0:
                'method'
        
                * undefined
                * interpolate
                * nearest
                * left
                * right
        
        Examples:
            ::
        
                #
                # Selecting the timeset
                #
                ensight.solution_time.timeset_select(2)
                #
                # Setting the timeset span handling methods
                # (Note that we will interpolate if between)
                #
                ensight.solution_time.timeset_leftof("undefined")
                ensight.solution_time.timeset_between("interpolate")
                ensight.solution_time.timeset_rightof("nearest")
                #
                # Update timesets and model display
                #
                ensight.solution_time.timeset_update()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.timeset_between({repr(p0)})'''
        return self._session.cmd(cmd)

    def timeset_leftof(self, p0: str) -> int:
        """When the current time lies before the beginning step of a given timeset, this command sets how to handle the situation. 
        
        | The geometry and each variable can be specified according to its own timeset, with different beginning and ending times and number of steps. These timesets are combined into the solution time range in the solution dialog. But, with this general capability comes the need to know what to do when a current time lies outside the extents of, or between the steps of a given timeset.
        
        Args:
            p0:
                'method'
        
                * undefined
                * nearest
        
        Examples:
            ::
        
                #
                # Selecting the timeset
                #
                ensight.solution_time.timeset_select(2)
                #
                # Setting the timeset span handling methods
                # (Note that we will treat as undefined if left of)
                #
                ensight.solution_time.timeset_leftof("undefined")
                ensight.solution_time.timeset_between("interpolate")
                ensight.solution_time.timeset_rightof("nearest")
                #
                # Update timesets and model display
                #
                ensight.solution_time.timeset_update()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.timeset_leftof({repr(p0)})'''
        return self._session.cmd(cmd)

    def timeset_rightof(self, p0: str) -> int:
        """When the current time lies after the ending step of a given timeset, this command sets how to handle the situation. 
        
        | The geometry and each variable can be specified according to its own timeset, with different beginning and ending times and number of steps. These timesets are combined into the solution time range in the solution dialog. But, with this general capability comes the need to know what to do when a current time lies outside the extents of, or between the steps of a given timeset.
        
        Args:
            p0:
                'method'
        
                * undefined
                * nearest
        
        Examples:
            ::
        
                #
                # Selecting the timeset
                #
                ensight.solution_time.timeset_select(2)
                #
                # Setting the timeset span handling methods
                # (Note that we will treat as nearest if right of)
                #
                ensight.solution_time.timeset_leftof("undefined")
                ensight.solution_time.timeset_between("interpolate")
                ensight.solution_time.timeset_rightof("nearest")
                #
                # Update timesets and model display
                #
                ensight.solution_time.timeset_update()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.timeset_rightof({repr(p0)})'''
        return self._session.cmd(cmd)

    def timeset_select(self, p0: int) -> int:
        """Selects the timeset to modify.
        
        Args:
            p0:
                'ts_num' timeset number
        
        Examples:
            ::
        
                #
                # Selecting the timeset
                #
                ensight.solution_time.timeset_select(2)
                #
                # Setting the timeset span handling methods
                # (Note that we will treat as nearest if right of)
                #
                ensight.solution_time.timeset_leftof("undefined")
                ensight.solution_time.timeset_between("interpolate")
                ensight.solution_time.timeset_rightof("nearest")
                #
                # Update timesets and model display 
                #
                ensight.solution_time.timeset_update()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.timeset_select({repr(p0)})'''
        return self._session.cmd(cmd)

    def timeset_update(self) -> int:
        """Updates the selected timeset and any associated display of the model according to the span handling methods specified. 
        
        Examples:
            ::
        
                #
                # Selecting the timeset
                #
                ensight.solution_time.timeset_select(2)
                #
                # Setting the timeset span handling methods
                # (Note that we will treat as nearest if right of)
                #
                ensight.solution_time.timeset_leftof("undefined")
                ensight.solution_time.timeset_between("interpolate")
                ensight.solution_time.timeset_rightof("nearest")
                #
                # Update timesets and model display
                #
                ensight.solution_time.timeset_update()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.timeset_update()'''
        return self._session.cmd(cmd)

    def update_time_steps(self) -> int:
        """Solution_time: update_time_steps

        """
        cmd = f'''ensight.solution_time.update_time_steps()'''
        return self._session.cmd(cmd)

    def update_to_current(self) -> int:
        """Causes the display and all associated computations of the model to be updated to the currently specified time or step. 
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
                #
                # But here we change it to use time steps
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(5)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.update_to_current()'''
        return self._session.cmd(cmd)

    def update_to_first(self) -> int:
        """Causes the display and all associated computations of the model to be updated to the first time or step of the model. 
        
        | This command is not generated by the EnSight GUI, but is intended for use with batch or context operations where the time of the first step could vary from model to model.
        
        Examples:
            ::
        
                ensight.solution_time.update_to_first()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.update_to_first()'''
        return self._session.cmd(cmd)

    def update_to_last(self) -> int:
        """Causes the display and all associated computations of the model to be updated to the last time or step of the model. 
        
        | This command is not generated by the EnSight GUI, but is intended for use with batch or context operations where the time of the last step could vary from model to model.
        
        Examples:
            ::
        
                ensight.solution_time.update_to_last()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.update_to_last()'''
        return self._session.cmd(cmd)

    def update_type(self, p0: str) -> int:
        """Sets whether times or time steps can be specified between the data steps in the model, thus causing interpolation to be needed.
        
        | This command and "solution_time: show_as" combine to control whether interpolation will be needed.
        
        Args:
            p0:
                'method'
        
                * discrete
                * continuous
        
        Examples:
            ::
        
                #
                # This sets several of the attributes using simulation time
                #
                ensight.solution_time.show_as("time")
                ensight.solution_time.update_type("continuous")
                ensight.solution_time.begin_simtime(0.0000e+00)
                ensight.solution_time.end_simtime(1.6000e+01)
                ensight.solution_time.current_simtime(9.0000e+00)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(2.0000e+00)
                #
                # But here we change it to use time steps
                #
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(0)
                ensight.solution_time.end_step(16)
                ensight.solution_time.current_step(5)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.update_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def use_custom_timeline(self, p0: str) -> int:
        """Solution_time: use_custom_timeline

        """
        cmd = f'''ensight.solution_time.use_custom_timeline({repr(p0)})'''
        return self._session.cmd(cmd)

    def zoomin(self, p0: float, p1: float) -> int:
        """Solution_time: zoomin

        """
        cmd = f'''ensight.solution_time.zoomin({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def zoomout(self) -> int:
        """Resets the begin and end steps (or begin and end simtimes) to the widest possible settings.
        
        | This may be desirable after one has modified (narrowed) the begin and end steps or time for a given temporary purpose.
        
        Examples:
            ::
        
                ensight.solution_time.show_as("step")
                ensight.solution_time.update_type("discrete")
                ensight.solution_time.begin_step(3)
                ensight.solution_time.end_step(12)
                ensight.solution_time.current_step(5)
                ensight.solution_time.update_to_current()
                ensight.solution_time.number_of_cycles(1)
                ensight.solution_time.increment(1.0000e+00)
                #
                # One could load a flipbook or something like 
                # that at this point, using the narrowed range
                # of 3 to 12.  Then could use the next command
                # to get the range back to 0 to 16
                #
                ensight.solution_time.zoomout()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.solution_time.zoomout()'''
        return self._session.cmd(cmd)


class show_info:
    """Class wrapper for EnSight show_info module

    This class acts as a proxy for the EnSight Python module ensight.show_info
    """
    def __init__(self, session: Session):
        self._session = session

    def cursor(self, p0: float, p1: float, p2: float) -> int:
        """Show corresponding part and values of all active variables at the specified x, y, z model location.
        
        | Used in conjunction with the following commands.
        | view_transf: function cursor 
        | view_transf: action translate 
        | view_transf: cursor
        
        Args:
            p0:
                'x-coord' x, y, z  locations of the cursor in model coordinates
            p1:
                'y-coord' x, y, z  locations of the cursor in model coordinates
            p2:
                'z-coord' x, y, z  locations of the cursor in model coordinates
        
        Examples:
            ::
        
                # 
                # Toggle-on and position the cursor tool 
                # 
                ensight.view_transf.function("cursor")
                ensight.tools.cursor("ON")
                ensight.view_transf.action("translate")
                ensight.view_transf.cursor(-1.0000e+00,0.500000,0.500000)
                # 
                # Revert back to global transformation mode 
                # 
                ensight.view_transf.function("global")
                # 
                # Show part and all active variable information at cursor location 
                # 
                ensight.show_info.cursor(-1.0000e+00,0.0000e+00,0.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.show_info.cursor({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def element(self, p0: int) -> int:
        """Query/show the associated part connectivity and values of all active variables for the specified element id label.
        
        Args:
            p0:
                'element_id_number' a valid element id corresponding to the specified part
        
        Examples:
            ::
        
                # 
                # Specify which part 
                # 
                ensight.part.select_begin(1)
                # 
                # from which to show the corresponding element information. 
                # 
                ensight.show_info.element(20)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.show_info.element({repr(p0)})'''
        return self._session.cmd(cmd)

    def ijk(self, p0: float, p1: float, p2: float) -> int:
        """Query/show the associated part connectivity and values of all active variables for the specified i, j, and k location.
        
        | Only applicable for structured parts.
        
        Args:
            p0:
                'i-plane_value' corresponding i, j, k-plane values
            p1:
                'j-plane_value' corresponding i, j, k-plane values
            p2:
                'k-plane_value' corresponding i, j, k-plane values
        
        Examples:
            ::
        
                # 
                # Specify the part ... 
                # 
                ensight.part.select_begin(1)
                # 
                # and active variables ... 
                # 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.show_info.ijk({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def node(self, p0: int) -> int:
        """Query/show the associated part connectivity and values of all active variables for the specified node id label.
        
        Args:
            p0:
                'node_id_number' valid node id corresponding to the specified part
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.variables.select_varname_begin).
                ensight.variables.select_varname_begin("Density ","Energy ","Momentum ","Velo ","variables: select_varname_end ","# ","# at which to show the specified ijk information. ","# ","show_info: ijk 1 41 1","# ","# Specify to show the information of node 8000 of part 1 ","# ","part: select_begin ","1 ")
                ensight.show_info.node(8000)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.show_info.node({repr(p0)})'''
        return self._session.cmd(cmd)

    def part(self, p0: int) -> int:
        """Query/show the associated model information and extent values for the specified part id. 
        
        Args:
            p0:
                'part_id_number' the part GUI number
        
        Examples:
            ::
        
                # 
                # First, select the part ... 
                # 
                ensight.part.select_begin(1)
                # 
                # Then, specify to show its corresponding information. 
                # 
                ensight.show_info.part(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.show_info.part({repr(p0)})'''
        return self._session.cmd(cmd)

    def point(self, p0: float, p1: float, p2: float) -> int:
        """Show_info: point

        """
        cmd = f'''ensight.show_info.point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)


class shock:
    """Class wrapper for EnSight shock module

    This class acts as a proxy for the EnSight Python module ensight.shock
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Delimit the modifications for shock part attributes.
        
        | These commands are used to set the attributtes for a shock part creation.
        
        Args:
            p0:
                'shock_command' "shock: variable" commands
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Surface method
                #
                ensight.shock.begin()
                ensight.shock.variable("Pressure")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Region method
                #
                ensight.shock.begin()
                ensight.shock.variable("none")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.begin()'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Create a shock part with the currently defined attributes using the currently selected 3D part(s).
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s)
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Surface method
                #
                ensight.shock.begin()
                ensight.shock.variable("Pressure")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.create()'''
        return self._session.cmd(cmd)

    def density(self, p0: Any) -> int:
        """Specify the density variable to use in creating/updating a shock part or the default attributes.
        
        | This variable is assigned automatically if the variable name <Density> exists. 
        | Since the computation of separation and attachment lines depend on density, either the density variable must be defined or both the pressure and temperature variables must be defined to obtain the density variable.
        
        Args:
            p0:
                'variable_name' name of the density variable (the default name <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Density")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.density("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.density({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for shock part attributes.
        
        | These commands are used to set the attributtes for a shock part creation.
        
        Args:
            p0:
                'shock_command' "shock: variable" commands
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Surface method
                #
                ensight.shock.begin()
                ensight.shock.variable("Pressure")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Region method
                #
                ensight.shock.begin()
                ensight.shock.variable("none")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.end()'''
        return self._session.cmd(cmd)

    def enthalpy(self, p0: Any) -> int:
        """Specify the enthalpy variable to use in creating/updating a shock part or the default attributes.
        
        | This variable is not needed unless you are computing the shock via the Region method and transient (moving) shocks are specified via the "test: toggle_moving_shock" command.
        
        Args:
            p0:
                'variable_name' name of the enthalpy variable (the default name <none> means to use nothing).
        
        Examples:
            ::
        
                ensight.variables.activate("Enthalpy")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.density("Enthalpy")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.enthalpy({repr(p0)})'''
        return self._session.cmd(cmd)

    def gas_constant(self, args: Any) -> int:
        """Specify the gas constant as a constant value or a variable name to use in creating/updating a shock part or the default attributes.
        
        Args:
            p0:
                'name' scalar field variable name for the gas constant
            p1:
                'value' a constant value (default =1.) for the gas constant
        
        Examples:
            ::
        
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.gas_constant(1.)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.gas_constant({repr(args)})'''
        return self._session.cmd(cmd)

    def mach(self, p0: Any) -> int:
        """Specify the mach variable to use in creating/updating a shock part or the default attributes.
        
        | Although the specification of this variable is optional, if it exists, its specification will save the creation of a temporary variable.  If this variable is not specified or does not exist, it will be created on-the-fly temporarily as needed from dependent density, energy or pressure, velocity or momentum, and ratio of specific heats variables and values.
        
        Args:
            p0:
                'variable_name' name of the mach variable (the default name <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Mach")
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.vortexcore.density("Mach")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.mach({repr(p0)})'''
        return self._session.cmd(cmd)

    def method(self, p0: str) -> int:
        """Specify the algorithm to use for the computation of  the shock part.
        
        | The Surface method requires the specification of a shock threshold variable.  The Region method does not require the specification of a shock threshold variable.
        
        Args:
            p0:
                'algorithm'
        
                * region
                * surface
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.method("region")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.method({repr(p0)})'''
        return self._session.cmd(cmd)

    def momentum(self, p0: Any) -> int:
        """Specify the momentum variable to use in creating/updating a shock part or the default attributes.
        
        | This variable is assigned automatically if the variable name "momentum" exists. 
        | Since the computation of shock depends on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the momentum variable (the default name <none> means to use nothing
        
        Examples:
            ::
        
                ensight.variables.activate("momentum")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.momentum("momentum")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.momentum({repr(p0)})'''
        return self._session.cmd(cmd)

    def pressure(self, p0: Any) -> int:
        """Specify the pressure variable to use in creating/updating a shock part or the default attributes.
        
        | This variable is used throughout the shock calculation. Although the specification of this variable is optional, if it exists, its specification will save the creation of a temporary variable.  If this variable is not specified or does not exist, it will be created on-the-fly temporarily as needed from dependent density, energy, velocity or momentum, and ratio of specific heats variables and values.
        
        Args:
            p0:
                'variable_name' name of the pressure variable (the default name <none> means to use nothing
        
        Examples:
            ::
        
                ensight.variables.activate("Pressure")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.pressure("Pressure")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.pressure({repr(p0)})'''
        return self._session.cmd(cmd)

    def ratio_of_spec_heat(self, args: Any) -> int:
        """Specify the ratio of specific heat constant value or variable name to use in creating/updating a shock part or the default attributes.
        
        Args:
            p0:
                'name' scalar field variable name for the ratio of specific heats
            p1:
                'value' a constant value (default = 1.4) for the ratio of specific heats
        
        Examples:
            ::
        
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.ratio_of_spec_heat(1.4)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.ratio_of_spec_heat({repr(args)})'''
        return self._session.cmd(cmd)

    def region_threshold_max(self, p0: float) -> int:
        """Shock: region_threshold_max

        """
        cmd = f'''ensight.shock.region_threshold_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def region_threshold_min(self, p0: float) -> int:
        """Shock: region_threshold_min

        """
        cmd = f'''ensight.shock.region_threshold_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def region_threshold_value(self, p0: float) -> int:
        """Shock: region_threshold_value

        """
        cmd = f'''ensight.shock.region_threshold_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Specify that the default attributes of the shock part are to be set for all subsequent shock attribute  updates.
        
        Examples:
            ::
        
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.shock.momentum("none")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.select_default()'''
        return self._session.cmd(cmd)

    def specific_gas(self, args: Any) -> int:
        """Shock: specific_gas

        """
        cmd = f'''ensight.shock.specific_gas({repr(args)})'''
        return self._session.cmd(cmd)

    def surface_threshold_max(self, p0: float) -> int:
        """Shock: surface_threshold_max

        """
        cmd = f'''ensight.shock.surface_threshold_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface_threshold_min(self, p0: float) -> int:
        """Shock: surface_threshold_min

        """
        cmd = f'''ensight.shock.surface_threshold_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface_threshold_value(self, p0: float) -> int:
        """Shock: surface_threshold_value

        """
        cmd = f'''ensight.shock.surface_threshold_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def temperature(self, p0: Any) -> int:
        """Specify the temperature variable to use in creating/updating a shock part or the default attributes.
        
        | Although the specification of this variable is optional, if it exists, its specification will save the creation of a temporary variable.  
        | This variable is required for the creation of Density if Density does not exist.  If Density exists, no need to create this variable, unless you would like to use this as the shock creation variable for the Surface method.
        
        Args:
            p0:
                'variable_name' name of the temperature variable (the default name <none> means to use nothing
        
        Examples:
            ::
        
                ensight.variables.activate("Temperature")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.momentum("Temperature")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.temperature({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold(self, p0: Any) -> int:
        """Specify the threshold variable description by which to filter the segments of the selected shock part.
        
        | The default threshold for the Region shock part is "SHK_Threshold". The default threshold for the Region shock part is "SHK_xxx", where xxx is the name of the variable used as the shock creation variable.
        
        Args:
            p0:
                'variable_name' name of the scalar variable by which to filter the vortex core segments
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.threshold("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.threshold({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_filter(self, p0: str) -> int:
        """Specify how to filter out segments of the specified shock part, according to the specified threshold variable and value.
        
        Args:
            p0:
                'option'
        
                * <=
                * >=
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.threshold_filter(">=")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.threshold_filter({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_max(self, p0: float) -> int:
        """Specify the maximum/minimum threshold limit under which to filter the threshold value of the selected shock part(s).
        
        | Max must be greater than the min value, and be a valid threshold variable value. 
        
        Args:
            p0:
                'threshold_value' maximum/minimum threshold variable range limit below/above which to threshold the shock part
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.threshold_min(0.1)
                ensight.shock.threshold_max(10.0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.threshold_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_min(self, p0: float) -> int:
        """Specify the maximum/minimum threshold limit under which to filter the threshold value of the selected shock part(s).
        
        | Max must be greater than the min value, and be a valid threshold variable value. 
        
        Args:
            p0:
                'threshold_value' maximum/minimum threshold variable range limit below/above which to threshold the shock part
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.threshold_min(0.1)
                ensight.shock.threshold_max(10.0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.threshold_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_value(self, p0: float) -> int:
        """Specify the threshold value by which to filter the elements from the selected shock part(s).
        
        | This value is automatically set to a value that should approximate the valid region in which the shock part should exist.  Although for some models, further refinement and adjustment of the threshold min/max values is required. 
        | This value must lie within the threshold variable interval [threshold_min, threshold_max].
        
        Args:
            p0:
                'threshold_value' variable value by which to apply the threshold filter to the shock elements
        
        Examples:
            ::
        
                ensight.part.select_begin(8)
                ensight.part.modify_begin()
                ensight.shock.threshold_value(5.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.threshold_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def total_energy(self, p0: Any) -> int:
        """Specify the total energy variable to use in creating/updating a shock part or the default attributes.
        
        | Although the specification of this variable is optional, if it exists, its specification will save the creation of a temporary variable.  
        | This variable is required for the creation of Pressure if Pressure does not exist.  If Pressure exists, no need to create this variable, unless you would like to use this as the shock creation variable for the Surface method.
        
        Args:
            p0:
                'variable_name' name of the total energy variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("TotalEnergy")
                ensight.vortexcore.select_default()
                ensight.part.modify_begin()
                ensight.shock.velocity("TotalEnergy")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.total_energy({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Specify the variable (i.e Density, Energy, Pressure, or Temperature) in which to create the Surface method shock part(s).
        
        | For the Surface method, this variable is either Density, Energy, Pressure, or Temperature; and this variable must have previously been defined via its respective shock: density, energy, pressure, or temperature definition. 
        | For the Region method, this variable is always pressure, and thus the specification is not needed; thus, <none> is used as the shock variable.
        
        Args:
            p0:
                'variable_name' name of the variable in which to use as the creation variable or the variable in which to apply the gradient calculations for the shock function
        
        Examples:
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Surface method
                #
                ensight.shock.begin()
                ensight.shock.variable("Pressure")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
            ::
        
                #
                # Specify the 3D parent part(s) 
                # from which to create the shock part
                #
                ensight.part.select_begin(1)
                #
                # Compute the shock part by the Region method
                #
                ensight.shock.begin()
                ensight.shock.variable("none")
                ensight.shock.end()
                ensight.shock.create()
                #
                # Now select the newly created shock part 
                # for subsequent operations
                #
                ensight.part.select_begin(5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def velocity(self, p0: Any) -> int:
        """Specify the velocity variable to use in creating/updating a shock part or the default attributes.
        
        | Since the computation of shock depends on velocity, either  the velocity variable must be defined or both the density and  momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the velocity variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Velocity")
                ensight.shock.select_default()
                ensight.part.modify_begin()
                ensight.shock.velocity("Velocity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shock.velocity({repr(p0)})'''
        return self._session.cmd(cmd)


class shell:
    """Class wrapper for EnSight shell module

    This class acts as a proxy for the EnSight Python module ensight.shell
    """
    def __init__(self, session: Session):
        self._session = session

    def replace(self, p0: str) -> int:
        """Shell: replace

        """
        cmd = f'''ensight.shell.replace({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Shell: type

        """
        cmd = f'''ensight.shell.type({repr(p0)})'''
        return self._session.cmd(cmd)


class shape:
    """Class wrapper for EnSight shape module

    This class acts as a proxy for the EnSight Python module ensight.shape
    """
    def __init__(self, session: Session):
        self._session = session

    def arrow_tip_length(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.arrow_tip_length({repr(p0)})'''
        return self._session.cmd(cmd)

    def arrow_tip_size(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.arrow_tip_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.delete()'''
        return self._session.cmd(cmd)

    def description(self, p0: str) -> int:
        """Shape: description

        """
        cmd = f'''ensight.shape.description({repr(p0)})'''
        return self._session.cmd(cmd)

    def deselect_all(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.deselect_all()'''
        return self._session.cmd(cmd)

    def diameter(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.diameter({repr(p0)})'''
        return self._session.cmd(cmd)

    def fill(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.fill({repr(p0)})'''
        return self._session.cmd(cmd)

    def height(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.height({repr(p0)})'''
        return self._session.cmd(cmd)

    def length(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.length({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_width(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.line_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def location_x(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.location_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def location_y(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.location_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.modify_end()'''
        return self._session.cmd(cmd)

    def new_or_mod_shape(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.new_or_mod_shape({repr(p0)})'''
        return self._session.cmd(cmd)

    def new_shape(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.new_shape({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Shape: query_count

        """
        cmd = f'''ensight.shape.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Shape: query_display_attributes

        """
        cmd = f'''ensight.shape.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_selected_objects(self, args: Any) -> int:
        """Shape: query_selected_objects

        """
        cmd = f'''ensight.shape.query_selected_objects({repr(args)})'''
        return self._session.cmd(cmd)

    def rgb(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def rotational_angle(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.rotational_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all()'''
        return self._session.cmd(cmd)

    def select_all_arrows(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all_arrows()'''
        return self._session.cmd(cmd)

    def select_all_circles(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all_circles()'''
        return self._session.cmd(cmd)

    def select_all_invisible(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all_invisible()'''
        return self._session.cmd(cmd)

    def select_all_rectangles(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all_rectangles()'''
        return self._session.cmd(cmd)

    def select_all_visible(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_all_visible()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.shape.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.select_default()'''
        return self._session.cmd(cmd)

    def special1(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.special1({repr(args)})'''
        return self._session.cmd(cmd)

    def special2(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.special2({repr(args)})'''
        return self._session.cmd(cmd)

    def texture_object(self, p0: int) -> int:
        """This command has not yet been completey documented.
        
        | Selects a texture object to be used on the currently selected 2D shape annotation.
        
        Args:
            p0:
                'num' texture number.  Value can be from 0 to 8.  The value of zero disables textures for the annotation.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.texture_object({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def width(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.shape.width({repr(p0)})'''
        return self._session.cmd(cmd)


class set_visenv:
    """Class wrapper for EnSight set_visenv module

    This class acts as a proxy for the EnSight Python module ensight.set_visenv
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Set_visenv: begin

        """
        cmd = f'''ensight.set_visenv.begin()'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Set_visenv: component

        """
        cmd = f'''ensight.set_visenv.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Set_visenv: create

        """
        cmd = f'''ensight.set_visenv.create()'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Set_visenv: end

        """
        cmd = f'''ensight.set_visenv.end()'''
        return self._session.cmd(cmd)

    def offset(self, p0: float) -> int:
        """Set_visenv: offset

        """
        cmd = f'''ensight.set_visenv.offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_from_part(self, p0: int) -> int:
        """Set_visenv: offset_from_part

        """
        cmd = f'''ensight.set_visenv.offset_from_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_scale(self, p0: float) -> int:
        """Set_visenv: offset_scale

        """
        cmd = f'''ensight.set_visenv.offset_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_vector(self, p0: float, p1: float, p2: float) -> int:
        """Set_visenv: offset_vector

        """
        cmd = f'''ensight.set_visenv.offset_vector({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def scale_factor(self, p0: float) -> int:
        """Set_visenv: scale_factor

        """
        cmd = f'''ensight.set_visenv.scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Set_visenv: select_default

        """
        cmd = f'''ensight.set_visenv.select_default()'''
        return self._session.cmd(cmd)

    def sidewall(self, p0: str) -> int:
        """Set_visenv: sidewall

        """
        cmd = f'''ensight.set_visenv.sidewall({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface(self, p0: str) -> int:
        """Set_visenv: surface

        """
        cmd = f'''ensight.set_visenv.surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Set_visenv: type

        """
        cmd = f'''ensight.set_visenv.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def use_surface_normals(self, p0: str) -> int:
        """Set_visenv: use_surface_normals

        """
        cmd = f'''ensight.set_visenv.use_surface_normals({repr(p0)})'''
        return self._session.cmd(cmd)

    def var_type(self, p0: str) -> int:
        """Set_visenv: var_type

        """
        cmd = f'''ensight.set_visenv.var_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Set_visenv: variable

        """
        cmd = f'''ensight.set_visenv.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class set_tdata:
    """Class wrapper for EnSight set_tdata module

    This class acts as a proxy for the EnSight Python module ensight.set_tdata
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Set_tdata: begin

        """
        cmd = f'''ensight.set_tdata.begin()'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Set_tdata: component

        """
        cmd = f'''ensight.set_tdata.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Set_tdata: create

        """
        cmd = f'''ensight.set_tdata.create()'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Set_tdata: end

        """
        cmd = f'''ensight.set_tdata.end()'''
        return self._session.cmd(cmd)

    def offset(self, p0: float) -> int:
        """Set_tdata: offset

        """
        cmd = f'''ensight.set_tdata.offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_from_part(self, p0: int) -> int:
        """Set_tdata: offset_from_part

        """
        cmd = f'''ensight.set_tdata.offset_from_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_scale(self, p0: float) -> int:
        """Set_tdata: offset_scale

        """
        cmd = f'''ensight.set_tdata.offset_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def offset_vector(self, p0: float, p1: float, p2: float) -> int:
        """Set_tdata: offset_vector

        """
        cmd = f'''ensight.set_tdata.offset_vector({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def scale_factor(self, p0: float) -> int:
        """Set_tdata: scale_factor

        """
        cmd = f'''ensight.set_tdata.scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Set_tdata: select_default

        """
        cmd = f'''ensight.set_tdata.select_default()'''
        return self._session.cmd(cmd)

    def sidewall(self, p0: str) -> int:
        """Set_tdata: sidewall

        """
        cmd = f'''ensight.set_tdata.sidewall({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface(self, p0: str) -> int:
        """Set_tdata: surface

        """
        cmd = f'''ensight.set_tdata.surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Set_tdata: type

        """
        cmd = f'''ensight.set_tdata.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def use_surface_normals(self, p0: str) -> int:
        """Set_tdata: use_surface_normals

        """
        cmd = f'''ensight.set_tdata.use_surface_normals({repr(p0)})'''
        return self._session.cmd(cmd)

    def var_type(self, p0: str) -> int:
        """Set_tdata: var_type

        """
        cmd = f'''ensight.set_tdata.var_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Set_tdata: variable

        """
        cmd = f'''ensight.set_tdata.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class sepattach:
    """Class wrapper for EnSight sepattach module

    This class acts as a proxy for the EnSight Python module ensight.sepattach
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Delimit the modifications for separation or attachment line attributes.
        
        | These commands are used to set the attributes for a separation or attachment line part creation.
        
        Examples:
            ::
        
                #
                # Specify the 2D parent part(s) from which
                # to create the separation and attachment lines
                #
                ensight.part.select_begin(2,3)
                #
                # Compute the separation and attachment lines parts
                #
                ensight.sepattach.begin()
                ensight.sepattach.end()
                ensight.sepattach.create()
                #
                # Now select the newly created separation and 
                # attachment line parts for subsequent operations
                #
                ensight.part.select_begin(6,7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.begin()'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Create separation and attachment line parts using the currently selected 2D parts and defined attributes.
        
        | This feature is different from other features in that it creates two parts, i.e. a separation line part, and an attachment line part.  In addition, both of these parts are modified with any command change applied to either one or both of these parts.
        
        Examples:
            ::
        
                #
                # Specify the 2D parent part(s) from which
                # to create the separation and attachment lines
                #
                ensight.part.select_begin(2,3)
                #
                # Compute the separation and attachment lines parts
                #
                ensight.sepattach.begin()
                ensight.sepattach.end()
                ensight.sepattach.create()
                #
                # Now select the newly created separation and 
                # attachment line parts for subsequent operations
                #
                ensight.part.select_begin(6,7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.create()'''
        return self._session.cmd(cmd)

    def density(self, p0: Any) -> int:
        """Specify the density variable to use in creating/updating the default separation and attachment line part attributes and/or the selected separation and attachment line part(s).
        
        | This variable is assigned automatically if the variable name description <Density> exists. Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the density variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Density")
                ensight.sepattach.select_default()
                ensight.part.modify_begin()
                ensight.sepattach.density("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.density({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_offset(self, p0: float) -> int:
        """Specify the offset from the 2D parent part(s) surface from which to display (or lift) the separation and attachment line parts.
        
        | This offset measures in model coordinate units, in the normal direction from the 2D parent part(s) surface(s); and thus, may need to be specified as either a + or - number.
        
        Args:
            p0:
                'offset_value' numerical offset value from the 2D surface, (default = 0.)
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                ensight.sepattach.display_offset(-1.0000e-03)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.display_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for separation or attachment line attributes.
        
        | These commands are used to set the attributes for a separation or attachment line part creation.
        
        Examples:
            ::
        
                #
                # Specify the 2D parent part(s) from which
                # to create the separation and attachment lines
                #
                ensight.part.select_begin(2,3)
                #
                # Compute the separation and attachment lines parts
                #
                ensight.sepattach.begin()
                ensight.sepattach.end()
                ensight.sepattach.create()
                #
                # Now select the newly created separation and 
                # attachment line parts for subsequent operations
                #
                ensight.part.select_begin(6,7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.end()'''
        return self._session.cmd(cmd)

    def method(self, p0: str) -> int:
        """Specify the method, or algorithm, in which to compute the separation and attachment line parts, from either 2D parent part(s) or in recomputing existing 1D separation and attachment line parts.
        
        | Currently only one algorithm offered.
        
        Args:
            p0:
                'option'
        
                * phase_plane
        
        Examples:
            ::
        
                ensight.part.select_begin(6,7)
                ensight.part.modify_begin()
                ensight.sepattach.method("phase_plane")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.method({repr(p0)})'''
        return self._session.cmd(cmd)

    def momentum(self, p0: Any) -> int:
        """Specify the momentum variable to use in creating/updating the default separation and attachment line part attributes and/or the selected separation and attachment line part(s).
        
        | This variable is assigned automatically if the variable name description <Momentum> exists. Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the momentum variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Momentum")
                ensight.sepattach.select_default()
                ensight.part.modify_begin()
                ensight.sepattach.momentum("Momentum")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.momentum({repr(p0)})'''
        return self._session.cmd(cmd)

    def ratio_of_spec_heat(self, args: Any) -> int:
        """Specify the ratio of specific heat constant value or variable name to use in creating/updating the default separation and attachment line attributes and/or selected separation and attachment part(s).
        
        | The <name or value> can be multiple types depending on variable definition.
        
        Args:
            p0:
                'name' scalar field variable name for the ratio of specific heats
            p1:
                'value' constant value (default = 1.4) for the ratio of specific heats
        
        Examples:
            ::
        
                ensight.sepattach.select_default()
                ensight.part.modify_begin()
                ensight.sepattach.ratio_of_spec_heat(1.4)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.ratio_of_spec_heat({repr(args)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Specify that the default attributes of the separation and attachment line parts are to be set for all subsequent separation and attachment line creates and updates.
        
        Examples:
            ::
        
                ensight.sepattach.select_default()
                ensight.part.modify_begin()
                ensight.sepattach.momentum("none")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.select_default()'''
        return self._session.cmd(cmd)

    def threshold(self, p0: Any) -> int:
        """Specify the threshold variable description by which to filter the segments of the selected separation and attachment line parts.
        
        | The default threshold variable for vortex cores is "fx_sep_att_strengh".
        
        Args:
            p0:
                'variable_name' name of the scalar variable by which to filter the vortex core segments
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.sepattach.threshold("Density")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.threshold({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_filter(self, p0: str) -> int:
        """Specify how to filter out segments of the specified separation and attachment line part, according to the specified threshold variable and value.
        
        Args:
            p0:
                'option'
        
                * <=
                * >=
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.sepattach.threshold_filter(">=")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.threshold_filter({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_max(self, p0: float) -> int:
        """Specify the maximum/minimum threshold limit under which to filter the threshold value of the selected separation and attachment line part(s).
        
        | This max must be greater than the min value, and be a valid threshold variable value.  
        
        Args:
            p0:
                'threshold_value' maximum/minimum threshold variable range limit below which to threshold the separation and attachment lines parts
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.sepattach.threshold_max(1.0000e+01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.threshold_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_min(self, p0: float) -> int:
        """Specify the maximum/minimum threshold limit under which to filter the threshold value of the selected separation and attachment line part(s).
        
        | This max must be greater than the min value, and be a valid threshold variable value.  
        
        Args:
            p0:
                'threshold_value' maximum/minimum threshold variable range limit below which to threshold the separation and attachment lines parts
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.sepattach.threshold_max(1.0000e+01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.threshold_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def threshold_value(self, p0: float) -> int:
        """Specify the threshold value by which to filter the segments from the selected separation and attachment line part(s).
        
        | This value is automatically set to the minimum separation and attachment line strength variable value of the separation and attachment line parts.
        
        Args:
            p0:
                'threshold_value' variable value by which to apply the threshold filter to the vortex core segments
        
        Examples:
            ::
        
                ensight.part.select_begin(5)
                ensight.part.modify_begin()
                ensight.sepattach.threshold_value(5.0000e-01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.threshold_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def velocity(self, p0: Any) -> int:
        """Specify the velocity variable to use in creating/updating the default separation and attachment line part attributes and/or the selected separation and attachment line part(s).
        
        | This variable is assigned automatically if the variable name description <Velocity> exists.  Since the computation of separation and attachment lines depend on velocity, either the velocity variable must be defined or both the density and momentum variables must be defined to obtain the velocity variable.
        
        Args:
            p0:
                'variable_name' name of the velocity variable (the default <none> means to use nothing)
        
        Examples:
            ::
        
                ensight.variables.activate("Velocity")
                ensight.sepattach.select_default()
                ensight.part.modify_begin()
                ensight.sepattach.velocity("Velocity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.sepattach.velocity({repr(p0)})'''
        return self._session.cmd(cmd)


class scene:
    """Class wrapper for EnSight scene module

    This class acts as a proxy for the EnSight Python module ensight.scene
    """
    def __init__(self, session: Session):
        self._session = session

    def active(self, p0: str) -> int:
        """Scene: active

        """
        cmd = f'''ensight.scene.active({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_visible(self, p0: str) -> int:
        """Scene: axis_visible

        """
        cmd = f'''ensight.scene.axis_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def environment_map_intensity(self, p0: float) -> int:
        """Scene: environment_map_intensity

        """
        cmd = f'''ensight.scene.environment_map_intensity({repr(p0)})'''
        return self._session.cmd(cmd)

    def environment_map_name(self, args: Any) -> int:
        """Scene: environment_map_name

        """
        cmd = f'''ensight.scene.environment_map_name({repr(args)})'''
        return self._session.cmd(cmd)

    def ground_plane_blendscale(self, p0: float) -> int:
        """Scene: ground_plane_blendscale

        """
        cmd = f'''ensight.scene.ground_plane_blendscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def ground_plane_texscale(self, p0: float) -> int:
        """Scene: ground_plane_texscale

        """
        cmd = f'''ensight.scene.ground_plane_texscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def ground_plane_upvector(self, p0: str) -> int:
        """Scene: ground_plane_upvector

        """
        cmd = f'''ensight.scene.ground_plane_upvector({repr(p0)})'''
        return self._session.cmd(cmd)

    def ground_plane_visible(self, p0: str) -> int:
        """Scene: ground_plane_visible

        """
        cmd = f'''ensight.scene.ground_plane_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """Scene: modify_begin

        """
        cmd = f'''ensight.scene.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """Scene: modify_end

        """
        cmd = f'''ensight.scene.modify_end()'''
        return self._session.cmd(cmd)

    def orient_envmap_to(self, p0: str) -> int:
        """Scene: orient_envmap_to

        """
        cmd = f'''ensight.scene.orient_envmap_to({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin(self, p0: float, p1: float, p2: float) -> int:
        """Scene: origin

        """
        cmd = f'''ensight.scene.origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def radius(self, p0: float) -> int:
        """Scene: radius

        """
        cmd = f'''ensight.scene.radius({repr(p0)})'''
        return self._session.cmd(cmd)

    def reinitialize_to_extents(self) -> int:
        """Scene: reinitialize_to_extents

        """
        cmd = f'''ensight.scene.reinitialize_to_extents()'''
        return self._session.cmd(cmd)

    def rotate_envmap_screenx(self, p0: int) -> int:
        """Scene: rotate_envmap_screenx

        """
        cmd = f'''ensight.scene.rotate_envmap_screenx({repr(p0)})'''
        return self._session.cmd(cmd)

    def rotate_envmap_screeny(self, p0: int) -> int:
        """Scene: rotate_envmap_screeny

        """
        cmd = f'''ensight.scene.rotate_envmap_screeny({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale(self, p0: float) -> int:
        """Scene: scale

        """
        cmd = f'''ensight.scene.scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def setorigin_to_visibleparts(self) -> int:
        """Scene: setorigin_to_visibleparts

        """
        cmd = f'''ensight.scene.setorigin_to_visibleparts()'''
        return self._session.cmd(cmd)

    def up_origin(self, p0: float, p1: float, p2: float) -> int:
        """Scene: up_origin

        """
        cmd = f'''ensight.scene.up_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)


class savegeom:
    """Class wrapper for EnSight savegeom module

    This class acts as a proxy for the EnSight Python module ensight.savegeom
    """
    def __init__(self, session: Session):
        self._session = session

    def begin_step(self, p0: int) -> int:
        """Specify the beginning/ending time step for exporting the selected part(s) and active variable(s).
        
        Args:
            p0:
                'step' the beginning/ending time step in the range I[0,n], where n is the last time step
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.begin_step(0)
                ensight.savegeom.end_step(16)
                ensight.savegeom.step_by(1)
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.begin_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def binary(self, p0: str) -> int:
        """Specify either binary or ASCII as the format for the exported files.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.binary({repr(p0)})'''
        return self._session.cmd(cmd)

    def brick_format(self, p0: str) -> int:
        """Specify the format of the values to write out when using brick format.
        
        | Used in conjunction with savegeom: format brick
        
        Args:
            p0:
                'option'
        
                * bytes
                * floats
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("brick")
                ensight.savegeom.brick_format("floats")
                ensight.savegeom.resolution(128,128,128)
                ensight.savegeom.undefined(-1.2345e-10)
                ensight.savegeom.variable("pressure")
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.brick_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def end_step(self, p0: int) -> int:
        """Specify the beginning/ending time step for exporting the selected part(s) and active variable(s).
        
        Args:
            p0:
                'step' the beginning/ending time step in the range I[0,n], where n is the last time step
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.begin_step(0)
                ensight.savegeom.end_step(16)
                ensight.savegeom.step_by(1)
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.end_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def format(self, p0: str) -> int:
        """Specify the export data file format for the selected part(s) and active variable(s).
        
        | The option is the format of an included internal format usch as case or vrml, or a user-defined format that can be site specific.
        
        Args:
            p0:
                'option'
        
                * Include one of the following:
                * brick
                * case
                * vrml
                * UDWName
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.format({repr(p0)})'''
        return self._session.cmd(cmd)

    def maximum_file_size(self, p0: float) -> int:
        """Specify the maximum file size (in MBs) for exporting time step data into single file format.
        
        | This default value is the maximum file size limit of either 2 Giga-Bytes for 32-bit architecture, or 4 Tera-Bytes for 64-bit architecture machines.
        
        Args:
            p0:
                'size' file size limit in MB (Mega-Bytes)
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("ON")
                ensight.savegeom.maximum_file_size(2147.479980)
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.maximum_file_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def parameters(self, p0: str) -> int:
        """Pass into the User-defined writer a string that can be used to modify the behavior, or supply additional parameters.
        
        | This can be used to provide parameters to a user-defined writer.
        
        Args:
            p0:
                'input_string' up to 200 characters of information that will be passed into the user-defined writer selected.
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("STL")
                ensight.savegeom.parameters("test string")
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.parameters({repr(p0)})'''
        return self._session.cmd(cmd)

    def resolution(self, p0: int, p1: int, p2: int) -> int:
        """Specify the Brick of Values resolution in the x, y, and z directions.
        
        | Used in conjunction with savegeom: format brick
        
        Args:
            p0:
                'x' x, y, z direction resolution
            p1:
                'y' x, y, z direction resolution
            p2:
                'z' x, y, z direction resolution
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("brick")
                ensight.savegeom.brick_format("floats")
                ensight.savegeom.resolution(128,128,128)
                ensight.savegeom.undefined(-1.2345e-10)
                ensight.savegeom.variable("pressure")
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.resolution({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def save_geometric_entities(self, p0: str) -> int:
        """Specify the file name path and prefix for the selected part and active variable data to be exported.
        
        | The exported files will be saved in the current working directory of the server if no path is provided.
        | If the format (as defined by savegeom: format) is VRML, the filename given will be used directly.  If the format is CASE, the multiple files (case, geometry, and variables) are written using the supplied name as the prefix.
        
        Args:
            p0:
                'filename_prefix' directory path and filename prefix to be used for the exported data file
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
            ::
        
                ensight.part.select_begin(1)
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.save_geometric_entities({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all_steps(self) -> int:
        """Specify all time step data of selected parts (geometry) and active variables to be exported to an EnSight case or VRML file(s).
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.select_all_steps()'''
        return self._session.cmd(cmd)

    def select_all_timesteps(self) -> int:
        """Savegeom: select_all_timesteps

        """
        cmd = f'''ensight.savegeom.select_all_timesteps()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Savegeom: select_begin

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.savegeom.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def single_file(self, p0: str) -> int:
        """Specify whether the selected part(s), or geometry, and each active variable will be exported to a single or to separate time step files.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("ON")
                ensight.savegeom.maximum_file_size(2147.479980)
                ensight.savegeom.select_all_steps()
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.single_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def step_by(self, p0: int) -> int:
        """Specify the increment step by which to stride the time steps in exporting the selected part(s) and active variable(s).
        
        Args:
            p0:
                'increment' increment to stride the time steps in the range of the beginning and ending time steps
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("case")
                ensight.savegeom.binary("ON")
                ensight.savegeom.single_file("OFF")
                ensight.savegeom.begin_step(0)
                ensight.savegeom.end_step(16)
                ensight.savegeom.step_by(1)
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.step_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def undefined(self, p0: float) -> int:
        """Specify the value to write out as undefined when using brick format.
        
        | Used in conjunction with savegeom: format brick
        
        Args:
            p0:
                'undef_value' any undefined value is written out as this value
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("brick")
                ensight.savegeom.brick_format("floats")
                ensight.savegeom.resolution(128,128,128)
                ensight.savegeom.undefined(-1.2345e-10)
                ensight.savegeom.variable("pressure")
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.undefined({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: str) -> int:
        """Specify the name of the variable to save when using brick format.
        
        | Used in conjunction with savegeom: format brick
        
        Args:
            p0:
                'var_name' variable name
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.savegeom.format("brick")
                ensight.savegeom.brick_format("floats")
                ensight.savegeom.resolution(128,128,128)
                ensight.savegeom.undefined(-1.2345e-10)
                ensight.savegeom.variable("pressure")
                ensight.savegeom.save_geometric_entities("/tmp/file_prefix")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.savegeom.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class query_interact:
    """Class wrapper for EnSight query_interact module

    This class acts as a proxy for the EnSight Python module ensight.query_interact
    """
    def __init__(self, session: Session):
        self._session = session

    def action(self, p0: str) -> int:
        """Query_interact: action

        """
        cmd = f'''ensight.query_interact.action({repr(p0)})'''
        return self._session.cmd(cmd)

    def coord_report_by_x(self, p0: str) -> int:
        """Query_interact: coord_report_by_x

        """
        cmd = f'''ensight.query_interact.coord_report_by_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def coord_report_by_y(self, p0: str) -> int:
        """Query_interact: coord_report_by_y

        """
        cmd = f'''ensight.query_interact.coord_report_by_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def coord_report_by_z(self, p0: str) -> int:
        """Query_interact: coord_report_by_z

        """
        cmd = f'''ensight.query_interact.coord_report_by_z({repr(p0)})'''
        return self._session.cmd(cmd)

    def create(self, args: Any) -> int:
        """Creates a query using the current settings.
        
        | The parameters vary based on the type of query being used.  (See query_interact: query)
        | Query is performed at location specified or at closest node if query_interact: search closest_node is specified.
        
        Args:
            p0:
                '' 
            p1:
                'screen_x' xy normalized screen coordinates (0.0 to 1.0)
            p2:
                'screen_y' xy normalized screen coordinates (0.0 to 1.0)
            p3:
                'screen_y' xy normalized screen coordinates (0.0 to 1.0)
            p4:
                'screen_y' xy normalized screen coordinates (0.0 to 1.0)
            p5:
                'x_coord' xyz model coordinates
            p6:
                'y_coord' xyz model coordinates
            p7:
                'z_coord' xyz model coordinates
            p8:
                'z_coord' xyz model coordinates
            p9:
                'z_coord' xyz model coordinates
            p10:
                'node_id' node id for query
            p11:
                'node_id' node id for query
            p12:
                'node_id' node id for query
            p13:
                'i_coord' ijk coordinates for query
            p14:
                'j_coord' ijk coordinates for query
            p15:
                'k_coord' ijk coordinates for query
            p16:
                'k_coord' ijk coordinates for query
            p17:
                'k_coord' ijk coordinates for query
            p18:
                'element_id' element id for query
            p19:
                'element_id' element id for query
            p20:
                'element_id' element id for query
            p21:
                'x_coord' xyz model coordinates
            p22:
                'y_coord' xyz model coordinates
            p23:
                'z_coord' xyz model coordinates
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("xyz")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.create({repr(args)})'''
        return self._session.cmd(cmd)

    def display_expansion_factor(self, p0: int) -> int:
        """This command has not yet been documented. 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.display_expansion_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_id(self, p0: str) -> int:
        """Causes the node located for the query to be reported. 
        
        | This command is used with query_interact: search closest_node to get reporting of the actual node that was used for the query.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.search("closest_node")
                ensight.query_interact.display_id("ON")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.display_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_node_number(self, p0: str) -> int:
        """Query_interact: display_node_number

        """
        cmd = f'''ensight.query_interact.display_node_number({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_always_on_top(self, p0: str) -> int:
        """Causes the label written beside the query marker in the graphics window to be rendered on top of any surface that would normally hide or obscure it.
        
        | This attribute is ON by default. 
        
        Args:
            p0:
                'toggle'
        
                * ON 
                * OFF
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.label_always_on_top("ON")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.label_always_on_top({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_decimal_places(self, p0: int) -> int:
        """Query_interact: label_decimal_places

        """
        cmd = f'''ensight.query_interact.label_decimal_places({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_format(self, p0: str) -> int:
        """Query_interact: label_format

        """
        cmd = f'''ensight.query_interact.label_format({repr(p0)})'''
        return self._session.cmd(cmd)

    def label_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the label written next to the query marker in the graphics window.    
        
        Args:
            p0:
                'red_val' red, green, blue contributions of the color within range of  0.0 to 1.0
            p1:
                'grn_val' red, green, blue contributions of the color within range of  0.0 to 1.0
            p2:
                'blu_val' red, green, blue contributions of the color within range of  0.0 to 1.0
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.label_rgb(0,1,1)
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.label_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def label_visible(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.label_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def marker_rgb(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.marker_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def marker_size(self, p0: float) -> int:
        """Query_interact: marker_size

        """
        cmd = f'''ensight.query_interact.marker_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def marker_size_normalized(self, p0: float) -> int:
        """Specify the size of a query marker.
        
        | The default marker scale value is 1.0.
        | A size of 1.0 indicates to use the computed size
        | Values >1 scale the computed size larger while values <1 (but >0) shrink the marker.
        
        Args:
            p0:
                'scale' size of marker
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                # WARNING: following line includes OBSOLETE call (ensight.query_interact.variable).
                ensight.query_interact.variable("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.label_visible("OFF")
                ensight.query_interact.marker_size_normalized(0.5)
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.marker_size_normalized({repr(p0)})'''
        return self._session.cmd(cmd)

    def marker_visible(self, p0: str) -> int:
        """Sets the visibility of the query marker in the graphics window.
        
        | Marker visibility is ON by default.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.label_visible("OFF")
                ensight.query_interact.marker_visible("OFF")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.marker_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def number_displayed(self, p0: int) -> int:
        """Query_interact: #_displayed

        """
        cmd = f'''ensight.query_interact.number_displayed({repr(p0)})'''
        return self._session.cmd(cmd)

    def output(self, args: Any) -> int:
        """Query_interact: output

        """
        cmd = f'''ensight.query_interact.output({repr(args)})'''
        return self._session.cmd(cmd)

    def query(self, p0: str) -> int:
        """Sets the type of query to be performed.
        
        | The exact location of the query, as specified above, may be modified by the query_interact: search command; i.e. if an exact set of coordinates or a cursor position is specified, the actual query may be done at the closest node to this point if query_interact: search closest_node has been specified. 
        
        Args:
            p0:
                'query_type'
        
                * may be any of the following values:
                * surface
                * cursor
                * node
                * ijk
                * element
                * xyz
                * none
                * min
                * max
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.search("closest_node")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.query({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_attributes(self, args: Any) -> int:
        """Query_interact: query_attributes

        """
        cmd = f'''ensight.query_interact.query_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Query_interact: query_count

        """
        cmd = f'''ensight.query_interact.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def request_method(self, p0: str) -> int:
        """Sets the request method for surface pick or cursor-based queries to be on a request or continuous basis.
        
        | In continuous mode, the query will be updated continuously while the mouse or cursor is being moved.
        
        Args:
            p0:
                'method'
        
                * may be any of the following values: 
                * continuous
                * pick
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.request_method("pick")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.request_method({repr(p0)})'''
        return self._session.cmd(cmd)

    def request_mode(self, p0: str) -> int:
        """Query_interact: request_mode

        """
        cmd = f'''ensight.query_interact.request_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def save(self, p0: str) -> int:
        """Specifies the filename into which the Interactive Probe Query Results Table will be saved.
        
        Args:
            p0:
                'filename' filename to receive the results table information
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("xyz")
                ensight.query_interact.number_displayed(3)
                ensight.query_interact.create(12.0,15.1,10.3)
                ensight.query_interact.create(11.0,15.0,10.1)
                ensight.query_interact.create(10.0,15.0,10.3)
                ensight.query_interact.save("/home/users/me/probe.txt")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.save({repr(p0)})'''
        return self._session.cmd(cmd)

    def search(self, p0: str) -> int:
        """Sets the search mode for surface pick or cursor queries.
        
        Args:
            p0:
                'search_mode'
        
                * may be any of the following values:
                * exact
                * closest_node
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                ensight.query_interact.select_varname_begin("pressure")
                ensight.query_interact.query("cursor")
                ensight.query_interact.search("closest_node")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.search({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """Query_interact: select_all

        """
        cmd = f'''ensight.query_interact.select_all()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Query_interact: select_begin

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.query_interact.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Causes any following query_interact: commands to affect the default query settings.    
        
        | All query_interact: commands following query_interact: select_default will affect default settings until a new variable is selected to query using
        | query_interact: select_varname_begin.
        
        Examples:
            ::
        
                ensight.query_interact.select_default()
                ensight.query_interact.marker_visible("OFF")
                ensight.query_interact.marker_rgb(1,0,0)
                ensight.query_interact.select_varname_begin("pressure")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.select_default()'''
        return self._session.cmd(cmd)

    def select_varname_begin(self, args: Any) -> int:
        """Specifies the variables to be queried.
        
        Args:
            p0:
                'varnameN' names of variables to be queried
        
        Examples:
            ::
        
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate pressure")
                #WARNING: the following line failed to translate because the function could not be found in the ensight python module
                #   Actual error: module 'ensight' has no attribute 'variable'
                ensight.sendmesg(r"variable: activate temperature")
                ensight.query_interact.select_varname_begin("pressure","temperature ")
                ensight.query_interact.query("cursor")
                ensight.query_interact.create(12.0,15.1,10.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_interact.select_varname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_varname_default(self) -> int:
        """Query_interact: select_varname_default

        """
        cmd = f'''ensight.query_interact.select_varname_default()'''
        return self._session.cmd(cmd)

    def select_varname_end(self) -> int:
        """Query_interact: select_varname_end

        """
        cmd = f'''ensight.query_interact.select_varname_end()'''
        return self._session.cmd(cmd)

    def type(self, args: Any) -> int:
        """Query_interact: type

        """
        cmd = f'''ensight.query_interact.type({repr(args)})'''
        return self._session.cmd(cmd)

    def update_probe(self, p0: float, p1: float, p2: float) -> int:
        """Query_interact: update_probe

        """
        cmd = f'''ensight.query_interact.update_probe({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Query_interact: variable

        """
        cmd = f'''ensight.query_interact.variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def vector_report_by_mag(self, p0: str) -> int:
        """Query_interact: vector_report_by_mag

        """
        cmd = f'''ensight.query_interact.vector_report_by_mag({repr(p0)})'''
        return self._session.cmd(cmd)

    def vector_report_by_x(self, p0: str) -> int:
        """Query_interact: vector_report_by_x

        """
        cmd = f'''ensight.query_interact.vector_report_by_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def vector_report_by_y(self, p0: str) -> int:
        """Query_interact: vector_report_by_y

        """
        cmd = f'''ensight.query_interact.vector_report_by_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def vector_report_by_z(self, p0: str) -> int:
        """Query_interact: vector_report_by_z

        """
        cmd = f'''ensight.query_interact.vector_report_by_z({repr(p0)})'''
        return self._session.cmd(cmd)


class query_ent_var:
    """Class wrapper for EnSight query_ent_var module

    This class acts as a proxy for the EnSight Python module ensight.query_ent_var
    """
    def __init__(self, session: Session):
        self._session = session

    def auto_plot_checkexisting(self, p0: str) -> int:
        """Specifies to check for existing plotters with the same abscissa when auto plotting query information.
        
        | Only applicable with the "query_ent_var: auto_plot_queries ON" command. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.query_ent_var.auto_plot_checkexisting("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.auto_plot_checkexisting({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_plot_queries(self, p0: str) -> int:
        """Specify that any created query to be plotted automatically.
        
        | See also the "query_ent_var: auto_plot_checkexisting" command. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.query_ent_var.auto_plot_queries("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.auto_plot_queries({repr(p0)})'''
        return self._session.cmd(cmd)

    def begin(self) -> int:
        """Delimit the modifications for query attributes.
        
        | These commands are used to set the attributes for a query creation.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,2.7770e-01,7.7363e-02,1.1348e-02)
                ensight.query_ent_var.line_loc(2,7.6144e-01,1.7007e-01,5.5697e-02)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("Density")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.begin()'''
        return self._session.cmd(cmd)

    def begin_simtime(self, p0: float) -> int:
        """Specify the beginning simuation time to start the query over time.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.  
        | Only applicable with the "query_ent_var: type time" command.
        
        Args:
            p0:
                'time_value' beginning simulation time value (that corresponds to a valid time step) in which to start the query over time
        
        Examples:
            ::
        
                # 
                # Select part 
                # 
                ensight.part.select_begin(2)
                # 
                # Query over time 
                # 
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(84)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(1)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                # 
                # Select resulting plot curve 
                # 
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.begin_simtime({repr(p0)})'''
        return self._session.cmd(cmd)

    def constpart_setparttobegin(self) -> int:
        """Query_ent_var: constpart_setparttobegin

        """
        cmd = f'''ensight.query_ent_var.constpart_setparttobegin()'''
        return self._session.cmd(cmd)

    def constpart_setparttoend(self) -> int:
        """Query_ent_var: constpart_setparttoend

        """
        cmd = f'''ensight.query_ent_var.constpart_setparttoend()'''
        return self._session.cmd(cmd)

    def constpart_sweepbegin(self) -> int:
        """Query_ent_var: constpart_sweepbegin

        """
        cmd = f'''ensight.query_ent_var.constpart_sweepbegin()'''
        return self._session.cmd(cmd)

    def constpart_sweepend(self) -> int:
        """Query_ent_var: constpart_sweepend

        """
        cmd = f'''ensight.query_ent_var.constpart_sweepend()'''
        return self._session.cmd(cmd)

    def constrain(self, p0: str) -> int:
        """Specify the manner in which to constrain the query of the variable.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'option'
        
                * query type Over Time choices are:
                * cursor
                * element
                * ijk
                * max
                * min
                * node
                * scalar
                * query type Distance choices are:
                * 1d_part
                * line_tool
                * spline
        
        Examples:
            ::
        
                # 
                # Modification change: 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.constrain({repr(p0)})'''
        return self._session.cmd(cmd)

    def cursor_loc(self, p0: float, p1: float, p2: float) -> int:
        """Specify the x,y,z coordinates of the cursor location to be queried.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        | Used in conjunction with the "query_ent_var: type time" and the "query_ent_var: constrain cursor" commands.
        
        Args:
            p0:
                'x_coord' specify the x, y, z coordinate locations of the cursor in model space
            p1:
                'y_coord' specify the x, y, z coordinate locations of the cursor in model space
            p2:
                'z_coord' specify the x, y, z coordinate locations of the cursor in model space
        
        Examples:
            ::
        
                # 
                # Specify part on which to perform query 
                # 
                ensight.part.select_begin(2)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(84)
                ensight.query_ent_var.begin_simtime()
                ensight.query_ent_var.end_simtime()
                ensight.query_ent_var.constrain("cursor")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.cursor_loc(1.4870e+00,4.3663e-01,1.1934e+01)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                # 
                # Specify new curve to be current 
                # 
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.cursor_loc({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def data01(self, args: Any) -> int:
        """Query_ent_var: data01

        """
        cmd = f'''ensight.query_ent_var.data01({repr(args)})'''
        return self._session.cmd(cmd)

    def data02(self, args: Any) -> int:
        """Query_ent_var: data02

        """
        cmd = f'''ensight.query_ent_var.data02({repr(args)})'''
        return self._session.cmd(cmd)

    def data03(self, args: Any) -> int:
        """Query_ent_var: data03

        """
        cmd = f'''ensight.query_ent_var.data03({repr(args)})'''
        return self._session.cmd(cmd)

    def data04(self, args: Any) -> int:
        """Query_ent_var: data04

        """
        cmd = f'''ensight.query_ent_var.data04({repr(args)})'''
        return self._session.cmd(cmd)

    def data05(self, args: Any) -> int:
        """Query_ent_var: data05

        """
        cmd = f'''ensight.query_ent_var.data05({repr(args)})'''
        return self._session.cmd(cmd)

    def data06(self, args: Any) -> int:
        """Query_ent_var: data06

        """
        cmd = f'''ensight.query_ent_var.data06({repr(args)})'''
        return self._session.cmd(cmd)

    def description(self, p0: str) -> int:
        """Specify the text description for the query entity.
        
        | This command must lie between a "query_ent_var: begin" and "query_ent_var: end" pair.
        
        Args:
            p0:
                'desc' text description for the query entity
        
        Examples:
            ::
        
                ensight.curve.select_begin(1,"curve:","select_begin","part:","select_begin",2)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("Temp Vs. Time")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(10)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("cursor")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.cursor_loc(1.4870e+00,4.3663e-01,1.1934e+01)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.description({repr(p0)})'''
        return self._session.cmd(cmd)

    def distance(self, p0: str) -> int:
        """Specify how to parameterize the distance of the computed query (also, how the Distance is labeled on the plot).
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        | Only applicable with the "query_ent_var: type distance" command.
        
        Args:
            p0:
                'option'
        
                * arc_length
                * x_arc_length
                * y_arc_length
                * z_arc_length
                * from_origin
                * x_from_origin
                * y_from_origin
                * z_from_origin
        
        Examples:
            ::
        
                # 
                # Modify to parameterize using only the x-component of the arc length 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.distance("x_arc_length")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.distance({repr(p0)})'''
        return self._session.cmd(cmd)

    def distance_in(self, p0: str) -> int:
        """Query_ent_var: distance_in

        """
        cmd = f'''ensight.query_ent_var.distance_in({repr(p0)})'''
        return self._session.cmd(cmd)

    def elem_id(self, p0: int) -> int:
        """Specify the element id used to perform the specified element constrained query.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: type time" and "query_ent_var: constrain element" commands. 
        | Only applicable on element-based variables. 
        | Only applicable with the "query_ent_var: constrain element" and "query_ent_var: type time" commands.
        
        Args:
            p0:
                'element_id_#' valid element id number (0-bias
        
        Examples:
            ::
        
                ensight.part.select_begin(4)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(10)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("element")
                ensight.query_ent_var.sample_by("value")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("NodeToElem")
                ensight.query_ent_var.elem_id(14)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.elem_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for query attributes.
        
        | These commands are used to set the attributes for a query creation.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,2.7770e-01,7.7363e-02,1.1348e-02)
                ensight.query_ent_var.line_loc(2,7.6144e-01,1.7007e-01,5.5697e-02)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("Density")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.end()'''
        return self._session.cmd(cmd)

    def end_simtime(self, p0: float) -> int:
        """Specify the ending simulation time used to stop the query over time.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: type time" command.
        
        Args:
            p0:
                'time_value' ending simulation time value (that corresponds to a time step) at which to stop the computed query over time
        
        Examples:
            ::
        
                # 
                # Select part 
                # 
                ensight.part.select_begin(2)
                # 
                # Query over time 
                # 
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(84)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(1)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                # 
                # Select resulting plot curve 
                # 
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.end_simtime({repr(p0)})'''
        return self._session.cmd(cmd)

    def frame(self, p0: int) -> int:
        """Query_ent_var: frame

        """
        cmd = f'''ensight.query_ent_var.frame({repr(p0)})'''
        return self._session.cmd(cmd)

    def generate_over(self, p0: str) -> int:
        """Specify whether the query is over time or distance.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'type'
        
                * distance
                * time
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("generated")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.begin_simtime(0.0000e+00)
                ensight.query_ent_var.end_simtime(0.1900e+02)
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(139)
                ensight.query_ent_var.variable_1("temperature")
                ensight.query_ent_var.generate_over("time")
                ensight.query_ent_var.variable_2("TIME")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.generate_over({repr(p0)})'''
        return self._session.cmd(cmd)

    def ijk(self, p0: int, p1: int, p2: int) -> int:
        """Specify the ijk location used to perform the specified ijk constrained query.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: constrain ijk" and "query_ent_var: type time" commands.
        
        Args:
            p0:
                'i-plane_#' i, j, and k component values which must lie within the min/max of the i, j, and k range
            p1:
                'j-plane_#' i, j, and k component values which must lie within the min/max of the i, j, and k range
            p2:
                'k-plane_#' i, j, and k component values which must lie within the min/max of the i, j, and k range
        
        Examples:
            ::
        
                ensight.part.select_begin(4)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(10)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("ijk")
                ensight.query_ent_var.sample_by("value")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.ijk(2,4,14)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.ijk({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def line_loc(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Specify the location of the line used for distance queries when the constraint is set to line_tool. 
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'end_point_id' endpoints of the line, either 1 or 2
            p1:
                'x_comp' x , y, or z component of the corresponding line endpoint in model coordinates
            p2:
                'y_comp' x , y, or z component of the corresponding line endpoint in model coordinates
            p3:
                'z_comp' x , y, or z component of the corresponding line endpoint in model coordinates
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,2.7770e-01,7.7363e-02,1.1348e-02)
                ensight.query_ent_var.line_loc(2,7.6144e-01,1.7007e-01,5.5697e-02)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("Density")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.line_loc({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def marker_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specify the color for the visible markers indicating query location.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        | Used only if query_ent_var: marker_visible is on.
        
        Args:
            p0:
                'red_val' red, green, or blue component of color (0. to 1.)
            p1:
                'grn_val' red, green, or blue component of color (0. to 1.)
            p2:
                'blu_val' red, green, or blue component of color (0. to 1.)
        
        Examples:
            ::
        
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.constrain("1d_part")
                ensight.query_ent_var.marker_rgb(1.0000e+00,0.0000e+00,1.0000e+00)
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.marker_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def marker_size(self, p0: float) -> int:
        """Query_ent_var: marker_size

        """
        cmd = f'''ensight.query_ent_var.marker_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def marker_size_normalized(self, p0: float) -> int:
        """Specify the size of a query marker.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        | Used only if query_ent_var:marker_visible is on.
        | A size of 1.0 indicates to use the computed size.
        | Values >1 scale the computed size larger while values <1 (but >0) shrink the marker.
        
        Args:
            p0:
                'size_value' size of the marker
        
        Examples:
            ::
        
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.constrain("1d_part")
                ensight.query_ent_var.marker_size_normalized(2.0000e+00)
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.marker_size_normalized({repr(p0)})'''
        return self._session.cmd(cmd)

    def marker_visible(self, p0: str) -> int:
        """The begin/end construct in which to modify query entity attributes.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | If the query type is distance, then the marker is placed at the location of the origin (starting endpoint).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.constrain("element")
                ensight.query_ent_var.marker_visible("OFF")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.marker_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """Delimit the modifications for query entity attributes.
        
        | These commands are used to set the attributes for a query entity. 
        
        Examples:
            ::
        
                # 
                # Modification change: 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """Delimit the modifications for query entity attributes.
        
        | These commands are used to set the attributes for a query entity. 
        
        Examples:
            ::
        
                # 
                # Modification change: 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.modify_end()'''
        return self._session.cmd(cmd)

    def multiple_segments_by(self, p0: str) -> int:
        """Treat multiple line segments of a distance query as multiple queries, (i.e., reset the distance to 0. for each segment) or as a continuous line.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: type distance" command.
        
        Args:
            p0:
                'option'
        
                * accumulation
                * reset_each
        
        Examples:
            ::
        
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.constrain("1d_part")
                ensight.query_ent_var.multiple_segments_by("reset_each")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.multiple_segments_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def node_id(self, p0: int) -> int:
        """Specify the node id in which to perform the specified node constrained query.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: constrain node" command. Only applicable on node-based variables.
        
        Args:
            p0:
                'node_id_#' node id, or label, number
        
        Examples:
            ::
        
                # 
                # Select part 
                # 
                ensight.part.select_begin(2)
                # 
                # Query over time 
                # 
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(84)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(1)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.node_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def number_of_sample_pts(self, p0: int) -> int:
        """Specify the number of evenly spaced points to sample either along the line tool or over the specified range of time steps.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.  
        | If you specify more or fewer sample points than the number of time steps, EnSight linearly interpolates between the adjoining time steps. 
        | If the query is an FFT sampling, the number of frequencies output will be (a power of two) less than or equal to the number of sample points.
        
        Args:
            p0:
                'total_points' For queries over Distance using the Line Tool, this specifies the number of equally spaced points to query along the line (default = 20).  For queries Over Time, this specifies how many evenly timed moments over the specified range of time steps at which to query. If equal to the number of timesteps then you get a sample at each timestep.
        
        Examples:
            ::
        
                # 
                # Creation example... 
                # 
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,2.7770e-01,7.7363e-02,1.1348e-02)
                ensight.query_ent_var.line_loc(2,7.6144e-01,1.7007e-01,5.5697e-02)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("Density")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
                # 
                # Modification example... 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.number_of_sample_pts({repr(p0)})'''
        return self._session.cmd(cmd)

    def operation(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.operation({repr(p0)})'''
        return self._session.cmd(cmd)

    def operation_factor1(self, p0: float) -> int:
        """Specify the scale factor to apply to the one or two existing queries of an operation query. 
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'scale' value to scale the respective query by
        
        Examples:
            ::
        
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("operation")
                ensight.query_ent_var.operation_factor1(2.0000e+00)
                ensight.query_ent_var.operation_factor2(-1.5000e+01)
                ensight.query_ent_var.operation_query1byname("Distance","vs.","temp","for","line","tool")
                ensight.query_ent_var.operation_query2byname("Time","vs.","temp","for","Node",1)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.operation_factor1({repr(p0)})'''
        return self._session.cmd(cmd)

    def operation_factor2(self, p0: float) -> int:
        """Specify the scale factor to apply to the one or two existing queries of an operation query. 
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'scale' value to scale the respective query by
        
        Examples:
            ::
        
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("operation")
                ensight.query_ent_var.operation_factor1(2.0000e+00)
                ensight.query_ent_var.operation_factor2(-1.5000e+01)
                ensight.query_ent_var.operation_query1byname("Distance","vs.","temp","for","line","tool")
                ensight.query_ent_var.operation_query2byname("Time","vs.","temp","for","Node",1)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.operation_factor2({repr(p0)})'''
        return self._session.cmd(cmd)

    def operation_query1byname(self, args: Any) -> int:
        """Specify the name of the one or two existing queries of an operation query. 
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'name' existing query name
        
        Examples:
            ::
        
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("operation")
                ensight.query_ent_var.operation_factor1(2.0000e+00)
                ensight.query_ent_var.operation_factor2(-1.5000e+01)
                ensight.query_ent_var.operation_query1byname("Distance","vs.","temp","for","line","tool")
                ensight.query_ent_var.operation_query2byname("Time","vs.","temp","for","Node",1)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.operation_query1byname({repr(args)})'''
        return self._session.cmd(cmd)

    def operation_query2byname(self, args: Any) -> int:
        """Specify the name of the one or two existing queries of an operation query. 
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'name' existing query name
        
        Examples:
            ::
        
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("operation")
                ensight.query_ent_var.operation_factor1(2.0000e+00)
                ensight.query_ent_var.operation_factor2(-1.5000e+01)
                ensight.query_ent_var.operation_query1byname("Distance","vs.","temp","for","line","tool")
                ensight.query_ent_var.operation_query2byname("Time","vs.","temp","for","Node",1)
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.operation_query2byname({repr(args)})'''
        return self._session.cmd(cmd)

    def origin(self, p0: float, p1: float, p2: float) -> int:
        """Specify a location which will be used to select the origin of a distance plot when performing the query on a 1D part.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "querey_ent_var: type distance" and "query_ent_var: constrain 1d_part" commands.
        | The end point closest to the origin specified will be used as the "origin" of the query, i.e., where distance = 0.
        | If the ID part is a closed loop (i.e., there are no end points), the closest point on the loop is used as the "origin".
        
        Args:
            p0:
                'x_coord' x, y, or z coordinate value in model coordinates
            p1:
                'y_coord' x, y, or z coordinate value in model coordinates
            p2:
                'z_coord' x, y, or z coordinate value in model coordinates
        
        Examples:
            ::
        
                ensight.query_ent_var.modify_begin()
                ensight.query_ent_var.origin(2.3596e+00,1.8494e+00,1.1773e+01)
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def part_delta_value(self, p0: float) -> int:
        """Query_ent_var: part_delta_value

        """
        cmd = f'''ensight.query_ent_var.part_delta_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def part_id(self, args: Any) -> int:
        """Specify the 1D part number to query when performing a query over distance with a part constraint.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'part_id_#' GUI number of the part
        
        Examples:
            ::
        
                ensight.part.select_begin(4)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.part_id(4)
                ensight.query_ent_var.constrain("1d_part")
                ensight.query_ent_var.distance("arc_length")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.part_id({repr(args)})'''
        return self._session.cmd(cmd)

    def part_idbyname(self, args: Any) -> int:
        """Specify the 1D part name to query when performing a query over distance with a part constraint.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'part_name' GUI name of the part
        
        Examples:
            ::
        
                ensight.part.select_begin("Flow","Field")
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.part_idbyname("Line","Clip")
                ensight.query_ent_var.constrain("1d_part")
                ensight.query_ent_var.distance("arc_length")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.part_idbyname({repr(args)})'''
        return self._session.cmd(cmd)

    def part_max_value(self, p0: float) -> int:
        """Query_ent_var: part_max_value

        """
        cmd = f'''ensight.query_ent_var.part_max_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def part_min_value(self, p0: float) -> int:
        """Query_ent_var: part_min_value

        """
        cmd = f'''ensight.query_ent_var.part_min_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def point_1(self, p0: float, p1: float, p2: float) -> int:
        """Query_ent_var: point_1

        """
        cmd = f'''ensight.query_ent_var.point_1({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def point_2(self, p0: float, p1: float, p2: float) -> int:
        """Query_ent_var: point_2

        """
        cmd = f'''ensight.query_ent_var.point_2({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def query(self) -> int:
        """Specify the creation of a query entity.
        
        | The query is created using the current query attributes.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("distance")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,2.7770e-01,7.7363e-02,1.1348e-02)
                ensight.query_ent_var.line_loc(2,7.6144e-01,1.7007e-01,5.5697e-02)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("Density")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.query()'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Query_ent_var: query_count

        """
        cmd = f'''ensight.query_ent_var.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def query_create_attributes(self, args: Any) -> int:
        """Query_ent_var: query_create_attributes

        """
        cmd = f'''ensight.query_ent_var.query_create_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Query_ent_var: query_display_attributes

        """
        cmd = f'''ensight.query_ent_var.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_object_atwindowxy(self, args: Any) -> int:
        """Query_ent_var: query_object_atwindowxy

        """
        cmd = f'''ensight.query_ent_var.query_object_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_type(self, p0: str) -> int:
        """Specify the type of query to be created.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'type'
        
                * generated
                * operation
                * external
        
        Examples:
            ::
        
                ensight.part.select_all()
                #
                # At line tool over distance query
                #
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("generated")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,-7.5000e-01,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.line_loc(2,1.7500e+00,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.variable_1("temperature")
                ensight.query_ent_var.generate_over("distance")
                ensight.query_ent_var.variable_2("DISTANCE")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.query_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def sample_by(self, p0: str) -> int:
        """Specify how to report values queried over time.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair. 
        | Only applicable with the "query_ent_var: type time" command.
        
        Args:
            p0:
                'option'
        
                * value
                * fft
        
        Examples:
            ::
        
                # 
                # Select part 
                # 
                ensight.part.select_begin(2)
                # 
                # Query over time 
                # 
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.number_of_sample_pts(84)
                ensight.query_ent_var.begin_simtime(2.2300e+02)
                ensight.query_ent_var.end_simtime(4.8800e+02)
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(1)
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.variable).
                ensight.query_ent_var.variable("temp")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                # 
                # Select resulting plot curve 
                # 
                ensight.curve.select_begin(0)
                # 
                # Modified to sample by FFT 
                # 
                ensight.query_ent_var.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.query_ent_var.type).
                ensight.query_ent_var.type("time")
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("fft")
                ensight.query_ent_var.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.sample_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def scalar_value(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.scalar_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def scalar_variable(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.scalar_variable({repr(args)})'''
        return self._session.cmd(cmd)

    def select_all_timesteps(self) -> int:
        """Causes all current timesteps to be selected for querying.
        
        | This command is not generated by EnSight, but can be placed in a command file to generalize it so you do not have to know how many time steps are present.  It can replace the following commands:
        | query_ent_var: begin_simtime <time_value>
        | query_ent_var: end_simtime <time_value>
        | query_ent_var: number_of_sample_pts <total_points>
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("generated")
                ensight.query_ent_var.select_all_timesteps()
                ensight.query_ent_var.constrain("node")
                ensight.query_ent_var.sample_by("value")
                ensight.query_ent_var.node_id(100)
                ensight.query_ent_var.variable_1("Stress")
                ensight.query_ent_var.generate_over("time")
                ensight.query_ent_var.variable_2("TIME")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
                ensight.curve.select_begin(0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.select_all_timesteps()'''
        return self._session.cmd(cmd)

    def spline_id(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.spline_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def spline_name(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.spline_name({repr(args)})'''
        return self._session.cmd(cmd)

    def sweep_build1(self, args: Any) -> int:
        """Query_ent_var: sweep_build1

        """
        cmd = f'''ensight.query_ent_var.sweep_build1({repr(args)})'''
        return self._session.cmd(cmd)

    def sweep_build2(self, args: Any) -> int:
        """Query_ent_var: sweep_build2

        """
        cmd = f'''ensight.query_ent_var.sweep_build2({repr(args)})'''
        return self._session.cmd(cmd)

    def sweep_build3(self, args: Any) -> int:
        """Query_ent_var: sweep_build3

        """
        cmd = f'''ensight.query_ent_var.sweep_build3({repr(args)})'''
        return self._session.cmd(cmd)

    def sweep_build4(self, args: Any) -> int:
        """Query_ent_var: sweep_build4

        """
        cmd = f'''ensight.query_ent_var.sweep_build4({repr(args)})'''
        return self._session.cmd(cmd)

    def time_step_begin(self, p0: float) -> int:
        """Query_ent_var: time_step_begin

        """
        cmd = f'''ensight.query_ent_var.time_step_begin({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_step_end(self, p0: float) -> int:
        """Query_ent_var: time_step_end

        """
        cmd = f'''ensight.query_ent_var.time_step_end({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Query_ent_var: type

        """
        cmd = f'''ensight.query_ent_var.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def update_with_newtimesteps(self, p0: str) -> int:
        """Query_ent_var: update_with_newtimesteps

        """
        cmd = f'''ensight.query_ent_var.update_with_newtimesteps({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, args: Any) -> int:
        """Query_ent_var: variable

        """
        cmd = f'''ensight.query_ent_var.variable({repr(args)})'''
        return self._session.cmd(cmd)

    def variable_1(self, args: Any) -> int:
        """Specify the variables to be queried. The first variable can be any active variable. The second variable can be distance, time, or a second active variable.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'name' name of the active variable. For variable_1 it can be any active variable. For variable_2, it can be DISTANCE if a non-scatter query over distance is being created, TIME if a non-scatter query over time is being created, or any active variable if a scatter query is being created.  If plotted, variable_1 will be the Y-axis variable and varibe_2 will be the X-axis variable.
        
        Examples:
            ::
        
                ensight.part.select_all()
                #
                # At line tool over distance query
                #
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("generated")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,-7.5000e-01,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.line_loc(2,1.7500e+00,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.variable_1("temperature")
                ensight.query_ent_var.generate_over("distance")
                ensight.query_ent_var.variable_2("DISTANCE")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.variable_1({repr(args)})'''
        return self._session.cmd(cmd)

    def variable_1_byname_begin(self, args: Any) -> int:
        """Query_ent_var: variable_1_byname_begin

        """
        cmd = f'''ensight.query_ent_var.variable_1_byname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def variable_1_byname_end(self) -> int:
        """Query_ent_var: variable_1_byname_end

        """
        cmd = f'''ensight.query_ent_var.variable_1_byname_end()'''
        return self._session.cmd(cmd)

    def variable_2(self, args: Any) -> int:
        """Specify the variables to be queried. The first variable can be any active variable. The second variable can be distance, time, or a second active variable.
        
        | This command must lie between either a "query_ent_var: begin" and "query_ent_var: end" pair, or a "query_ent_var: modify_begin" and "query_ent_var: modify_end" pair.
        
        Args:
            p0:
                'name' name of the active variable. For variable_1 it can be any active variable. For variable_2, it can be DISTANCE if a non-scatter query over distance is being created, TIME if a non-scatter query over time is being created, or any active variable if a scatter query is being created.  If plotted, variable_1 will be the Y-axis variable and varibe_2 will be the X-axis variable.
        
        Examples:
            ::
        
                ensight.part.select_all()
                #
                # At line tool over distance query
                #
                ensight.query_ent_var.begin()
                ensight.query_ent_var.description("")
                ensight.query_ent_var.query_type("generated")
                ensight.query_ent_var.number_of_sample_pts(20)
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.constrain("line_tool")
                ensight.query_ent_var.line_loc(1,-7.5000e-01,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.line_loc(2,1.7500e+00,1.1561e+00,1.0000e+00)
                ensight.query_ent_var.variable_1("temperature")
                ensight.query_ent_var.generate_over("distance")
                ensight.query_ent_var.variable_2("DISTANCE")
                ensight.query_ent_var.end()
                ensight.query_ent_var.query()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.query_ent_var.variable_2({repr(args)})'''
        return self._session.cmd(cmd)


class ptrace_emitr:
    """Class wrapper for EnSight ptrace_emitr module

    This class acts as a proxy for the EnSight Python module ensight.ptrace_emitr
    """
    def __init__(self, session: Session):
        self._session = session

    def copy(self, p0: str) -> int:
        """Ptrace_emitr: copy

        """
        cmd = f'''ensight.ptrace_emitr.copy({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """Ptrace_emitr: delete

        """
        cmd = f'''ensight.ptrace_emitr.delete()'''
        return self._session.cmd(cmd)

    def delta_time(self, p0: float) -> int:
        """Ptrace_emitr: delta_time

        """
        cmd = f'''ensight.ptrace_emitr.delta_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def description(self, p0: str) -> int:
        """Ptrace_emitr: description

        """
        cmd = f'''ensight.ptrace_emitr.description({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_delete(self) -> int:
        """Ptrace_emitr: elt_delete

        """
        cmd = f'''ensight.ptrace_emitr.elt_delete()'''
        return self._session.cmd(cmd)

    def elt_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float, p6: float, p7: float, p8: float, p9: float, p10: float) -> int:
        """Ptrace_emitr: elt_net

        """
        cmd = f'''ensight.ptrace_emitr.elt_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)},{repr(p6)},{repr(p7)},{repr(p8)},{repr(p9)},{repr(p10)})'''
        return self._session.cmd(cmd)

    def elt_part(self, p0: int) -> int:
        """Ptrace_emitr: elt_part

        """
        cmd = f'''ensight.ptrace_emitr.elt_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_point(self, p0: float, p1: float, p2: float) -> int:
        """Ptrace_emitr: elt_point

        """
        cmd = f'''ensight.ptrace_emitr.elt_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def elt_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float, p6: float) -> int:
        """Ptrace_emitr: elt_rake

        """
        cmd = f'''ensight.ptrace_emitr.elt_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)},{repr(p6)})'''
        return self._session.cmd(cmd)

    def elt_surface_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float) -> int:
        """Ptrace_emitr: elt_surface_net

        """
        cmd = f'''ensight.ptrace_emitr.elt_surface_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)})'''
        return self._session.cmd(cmd)

    def elt_surface_point(self, p0: float, p1: float) -> int:
        """Ptrace_emitr: elt_surface_point

        """
        cmd = f'''ensight.ptrace_emitr.elt_surface_point({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def elt_surface_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float) -> int:
        """Ptrace_emitr: elt_surface_rake

        """
        cmd = f'''ensight.ptrace_emitr.elt_surface_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """Ptrace_emitr: modify_begin

        """
        cmd = f'''ensight.ptrace_emitr.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """Ptrace_emitr: modify_end

        """
        cmd = f'''ensight.ptrace_emitr.modify_end()'''
        return self._session.cmd(cmd)

    def new(self, p0: str) -> int:
        """Ptrace_emitr: new

        """
        cmd = f'''ensight.ptrace_emitr.new({repr(p0)})'''
        return self._session.cmd(cmd)

    def replaceelt_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float, p6: float, p7: float, p8: float, p9: float, p10: float) -> int:
        """Ptrace_emitr: replaceelt_net

        """
        cmd = f'''ensight.ptrace_emitr.replaceelt_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)},{repr(p6)},{repr(p7)},{repr(p8)},{repr(p9)},{repr(p10)})'''
        return self._session.cmd(cmd)

    def replaceelt_point(self, p0: float, p1: float, p2: float) -> int:
        """Ptrace_emitr: replaceelt_point

        """
        cmd = f'''ensight.ptrace_emitr.replaceelt_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def replaceelt_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float, p6: float) -> int:
        """Ptrace_emitr: replaceelt_rake

        """
        cmd = f'''ensight.ptrace_emitr.replaceelt_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)},{repr(p6)})'''
        return self._session.cmd(cmd)

    def restore(self, p0: str) -> int:
        """Ptrace_emitr: restore

        """
        cmd = f'''ensight.ptrace_emitr.restore({repr(p0)})'''
        return self._session.cmd(cmd)

    def rgb(self, p0: float, p1: float, p2: float) -> int:
        """Ptrace_emitr: rgb

        """
        cmd = f'''ensight.ptrace_emitr.rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def save(self, p0: str) -> int:
        """Ptrace_emitr: save

        """
        cmd = f'''ensight.ptrace_emitr.save({repr(p0)})'''
        return self._session.cmd(cmd)

    def save_all(self, p0: str) -> int:
        """Ptrace_emitr: save_all

        """
        cmd = f'''ensight.ptrace_emitr.save_all({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Ptrace_emitr: select_begin

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.ptrace_emitr.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_emitter_begin(self) -> int:
        """Ptrace_emitr: select_emitter_begin

        """
        cmd = f'''ensight.ptrace_emitr.select_emitter_begin()'''
        return self._session.cmd(cmd)

    def select_emitter_end(self) -> int:
        """Ptrace_emitr: select_emitter_end

        """
        cmd = f'''ensight.ptrace_emitr.select_emitter_end()'''
        return self._session.cmd(cmd)

    def start_time(self, p0: float) -> int:
        """Ptrace_emitr: start_time

        """
        cmd = f'''ensight.ptrace_emitr.start_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Ptrace_emitr: visible

        """
        cmd = f'''ensight.ptrace_emitr.visible({repr(p0)})'''
        return self._session.cmd(cmd)


class ptrace:
    """Class wrapper for EnSight ptrace module

    This class acts as a proxy for the EnSight Python module ensight.ptrace
    """
    def __init__(self, session: Session):
        self._session = session

    def add_bypart(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_bypart({repr(args)})'''
        return self._session.cmd(cmd)

    def add_bypartname(self, p0: str, p1: str, p2: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_bypartname({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def add_default_bypart(self, args: Any) -> int:
        """Ptrace: add_default_bypart

        """
        cmd = f'''ensight.ptrace.add_default_bypart({repr(args)})'''
        return self._session.cmd(cmd)

    def add_default_file(self, p0: str) -> int:
        """Ptrace: add_default_file

        """
        cmd = f'''ensight.ptrace.add_default_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_default_net(self, p0: float, p1: float) -> int:
        """Ptrace: add_default_net

        """
        cmd = f'''ensight.ptrace.add_default_net({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def add_default_pt(self) -> int:
        """Ptrace: add_default_pt

        """
        cmd = f'''ensight.ptrace.add_default_pt()'''
        return self._session.cmd(cmd)

    def add_default_rake(self, p0: float) -> int:
        """Ptrace: add_default_rake

        """
        cmd = f'''ensight.ptrace.add_default_rake({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_default_surface_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float) -> int:
        """Ptrace: add_default_surface_net

        """
        cmd = f'''ensight.ptrace.add_default_surface_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)})'''
        return self._session.cmd(cmd)

    def add_default_surface_pt(self, p0: float, p1: float) -> int:
        """Ptrace: add_default_surface_pt

        """
        cmd = f'''ensight.ptrace.add_default_surface_pt({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def add_default_surface_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float) -> int:
        """Ptrace: add_default_surface_rake

        """
        cmd = f'''ensight.ptrace.add_default_surface_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)})'''
        return self._session.cmd(cmd)

    def add_file(self, p0: str) -> int:
        """Adds emitters (and thus more traces) to the current particle trace part(s) according to the time and locations as defined in the file.
        
        Args:
            p0:
                'filename' The name of the emitter file
        
        Examples:
            ::
        
                #
                # Add emitters to a currently defined particle trace part 3
                # 
                #
                ensight.part.select_begin(3)
                ensight.ptrace.add_file("/tmp/emitter.file")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_net(self, p0: float, p1: float) -> int:
        """Add emitters (and thus more traces) to the current particle trace part(s) from
        
        | Any existing particle trace parts can have emitters added to them. These trace parts must be selected, and the plane tool must be at the new position, before the addition.  The number of additional emitter points will be the product of num_in_x * num_in_y.
        
        Args:
            p0:
                'num_in_x ' number of equally spaced points in the x direction of the plane tool
            p1:
                'num_in_y' number of equally spaced points in the y direction of the plane tool
        
        Examples:
            ::
        
                #
                # Getting the plane tool to the desired location
                #
                ensight.view_transf.plane(1,1.750000,2.700000,0.000000)
                ensight.view_transf.plane(2,13.000000,2.700000,0.000000)
                ensight.view_transf.plane(3,13.000000,9.500000,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 35 traces from the plane tool (becomes part 2)
                #
                ensight.ptrace.create_net(5,7)
                #
                # Moving the plane tool to a new location
                #
                ensight.tools.plane("ON")
                ensight.view_transf.function("plane")
                ensight.view_transf.scale(-0.522802,-1.195307,1.000000)
                ensight.view_transf.translate(-10.588167,-0.218373,0.000000)
                ensight.view_transf.function("global")
                #
                # Selecting the particle trace part to add to
                # and adding the 9 new emitters from which
                # more traces are made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.add_net(3,3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_net({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def add_part(self, p0: int) -> int:
        """Ptrace: add_part

        """
        cmd = f'''ensight.ptrace.add_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_partbyname(self, p0: str) -> int:
        """Ptrace: add_partbyname

        """
        cmd = f'''ensight.ptrace.add_partbyname({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_pt(self) -> int:
        """Adds emitters (and thus more traces) to the current particle trace part(s) from the current location of the cursor (a point).
        
        | Any existing particle trace part can have emitters added to them. These trace parts must be selected, and the cursor must be at the new location, before the addition.
        
        Examples:
            ::
        
                #
                # Getting the cursor to the desired location
                #
                ensight.view_transf.cursor(-0.927830,1.474020,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point (becomes part 2)
                #
                ensight.ptrace.create_pt()
                #
                # Moving the cursor to a new location
                #
                ensight.tools.cursor("ON")
                ensight.view_transf.function("cursor")
                ensight.view_transf.translate(-7.368053,-0.491341,0.000000)
                ensight.view_transf.function("global")
                #
                # Selecting the particle trace part to add to
                # and adding the new emitter from which another
                # trace is made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.add_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_pt()'''
        return self._session.cmd(cmd)

    def add_rake(self, p0: float) -> int:
        """Add emitters (and thus more traces) to the current particle trace part(s) from the current line tool.
        
        | Any existing particle trace part can have emitters added to them. These trace parts must be selected, and the line tool must be at the new position, before the addition.
        
        Args:
            p0:
                'num_points' number of equally spaced points on the line to use as emitters
        
        Examples:
            ::
        
                #
                # Getting the line tool to the desired location
                #
                ensight.view_transf.line(1,9.000000,6.000000,0.000000)
                ensight.view_transf.line(2,30.000000,6.000000,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 10 traces from a line tool (becomes part 2)
                #
                ensight.ptrace.create_rake(10)
                #
                # Moving the line tool to a new location
                #
                ensight.tools.line("ON")
                ensight.view_transf.function("line")
                ensight.view_transf.translate(-4.202520,4.531246,0.000000)
                ensight.view_transf.function("global")
                #
                # Selecting the particle trace part to add to
                # and adding the 6 new emitters from which more
                # traces are made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.add_rake(6)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_rake({repr(p0)})'''
        return self._session.cmd(cmd)

    def add_surface_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float) -> int:
        """Add emitters (and thus more traces) to the current particle trace part(s) from the grid of a screen box pick.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command. 
        | Any existing particle trace parts can have emitters added to them. These trace parts must be selected before the addition. 
        | The number of additional emitter points will be the product of num_in_x * num_in_y.
        
        Args:
            p0:
                'num_in_x' number of equally spaced points in the x direction of the plane tool
            p1:
                'num_in_y' number of equally spaced points in the y direction of the plane tool
            p2:
                'x1' screen x coordinate of the first point on the diagonal of the box (0.0 to 1.0) 
            p3:
                'y1' screen y coordinate of the first point on the diagonal of the box (0.0 to 1.0)
            p4:
                'x2 ' screen x coordinate of the second point on the diagonal of the box (0.0 to 1.0)
            p5:
                'y2' screen y coordinate of the second point on the diagonal of the box (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 35 surface restricted traces from
                # the box selection (becomes part 2)
                #
                ensight.ptrace.create_surface_net(5,7)
                #
                # Selecting the surface restricted particle trace
                # part to add to, and adding the 16 new emitters
                # from which more traces are made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.create_surface_net(4,4,0.114734,0.424963,0.166667,0.362556)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_surface_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)})'''
        return self._session.cmd(cmd)

    def add_surface_pt(self, p0: float, p1: float) -> int:
        """Adds emitters (and thus more traces) to the current surface restricted particle trace part(s) from a screen point pick location.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command.  Any existing surface restricted particle trace part can have emitters added to them. These trace parts must be selected before the addition.
        
        Args:
            p0:
                'screen_x' screen x coordinate (0.0 to 1.0)
            p1:
                'screen_y' screen y coordinate (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Getting the cursor to the desired location
                #
                ensight.view_transf.cursor(-0.927830,1.474020,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating surface restricted trace from a
                # screen location (becomes part 2)
                #
                ensight.ptrace.create_surface_pt(0.148551,0.484398)
                #
                # Selecting the particle trace part to add to
                # and adding a couple of new emitters from which
                # more traces are made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.add_surface_pt(0.136473,0.646360)
                ensight.ptrace.add_surface_pt(0.193237,0.546805)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_surface_pt({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def add_surface_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float) -> int:
        """Add emitters (and thus more traces) to the current surface restricted particle trace part(s) from a screen pick rake location.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command. Any existing particle trace parts can have emitters added to them. These trace parts must be selected before the addition.
        
        Args:
            p0:
                'num_points' number of equally spaced points on the line to use as emitters
            p1:
                'x1' screen x coordinate of the first end of the rake (0.0 to 1.0)
            p2:
                'y1' screen y coordinate of the first end of the rake (0.0 to 1.0)
            p3:
                'x2' screen x coordinate of the second end of the rake (0.0 to 1.0)
            p4:
                'y2' screen y coordinate of the second end of the rake (0.0 to1.0)
        
        Examples:
            ::
        
                #
                # Getting the line tool to the desired location
                #
                ensight.view_transf.line(1,9.000000,6.000000,0.000000)
                ensight.view_transf.line(2,30.000000,6.000000,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 10 surface restricted traces from
                # a rake pick location (becomes part 2)
                #
                ensight.ptrace.create_surface_rake(10,0.117150,0.540862,0.117150,0.442793)
                #
                # Selecting the particle trace part to add to
                # and adding 6 new emitters from which more
                # traces are made
                #
                ensight.part.select_begin(2)
                ensight.ptrace.add_surface_rake(6,0.129227,0.594354,0.188406,0.592868)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.add_surface_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)})'''
        return self._session.cmd(cmd)

    def animate(self, p0: str) -> int:
        """Toggles particle trace animation on or off for selected traces.  
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Selecting the trace(s) to animate
                #
                ensight.part.select_begin(7,8)
                #
                # Turning on the animation for the two selected trace parts
                #
                ensight.part.modify_begin()
                ensight.ptrace.animate("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.animate({repr(p0)})'''
        return self._session.cmd(cmd)

    def arrow_size(self, p0: float) -> int:
        """Specify the size of arrowheads to show along particle traces.
        
        | The size is according to the magnitude of the model coordinates.
        
        Args:
            p0:
                'size' size of the arrowheads shown along each trace
        
        Examples:
            ::
        
                #
                # modifying an existing particle trace that has the default of
                # of 3 normal arrows per trace to be 5 cone arrows.
                #
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.ptrace.arrows("cone")
                ensight.ptrace.number_of_arrows(5)
                ensight.ptrace.arrow_size(0.15)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.arrow_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def arrows(self, p0: str) -> int:
        """Specify the type of arrowheads to show along particle traces.
        
        | None.
        
        Args:
            p0:
                'type'
        
                * none
                * cone
                * normal
                * triangles
        
        Examples:
            ::
        
                #
                # modifying an existing particle trace that has the default of
                # of 3 normal arrows per trace to be 5 cone arrows.
                #
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.ptrace.arrows("cone")
                ensight.ptrace.number_of_arrows(5)
                ensight.ptrace.arrow_size(0.15)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.arrows({repr(p0)})'''
        return self._session.cmd(cmd)

    def begin(self) -> int:
        """Delimit the modifications for particle trace attributes.
        
        | These commands are used to set the attributes for particle trace part creation.
        
        Args:
            p0:
                'ptrace_command' any of the various attribute changing "ptrace:" commands
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                #
                ensight.ptrace.begin()
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.begin()'''
        return self._session.cmd(cmd)

    def color_emission(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Ptrace: color_emission

        """
        cmd = f'''ensight.ptrace.color_emission({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the contribution of the components of the flow field vector variable through which the particle trace will be integrated.
        
        | The normal situation is to have all three set to 1.0, to get the true vector field.
        
        Args:
            p0:
                'x_scal' scale factor to apply to the x, y, z components of the vector
            p1:
                'y_scal' scale factor to apply to the x, y, z components of the vector
            p2:
                'z_scal' scale factor to apply to the x, y, z components of the vector
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the components are being set here)
                #
                ensight.ptrace.begin()
                ensight.ptrace.type("streamline")
                #
                # Create the particle trace with
                # the x and y components of the vector
                #
                ensight.ptrace.component(1.0000e+00,1.0000e+00,0.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def compute_using_periodicity(self, p0: str) -> int:
        """Ptrace: compute_using_periodicity

        """
        cmd = f'''ensight.ptrace.compute_using_periodicity({repr(p0)})'''
        return self._session.cmd(cmd)

    def create_bypart(self, *args, **kwargs) -> Any:
        """Ptrace: create_bypart

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.ptrace.create_bypart({arg_string})"
        return self._session.cmd(cmd)

    def create_bypartname(self, p0: str, p1: str, p2: str) -> int:
        """Create a particle trace from the nodes of a part, where the part is referred to by name.
        
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command. The number of emitter points will be the number of nodes in the part multiplied by the "ptrace: emit_density" value.
        
        Args:
            p0:
                'part_name' name of the part whose nodes will be used as an emitter
            p1:
                'numemitpoints' number of emitters to use.  The minimum of this value and the number of nodes in the part will be used.
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                # WARNING: following line includes OBSOLETE call (ensight.ptrace.emit_density).
                ensight.ptrace.emit_density(1.0000e+00)
                ensight.ptrace.end()
                #
                # Creating traces from all the nodes of the part 
                # entitled "(CASE:Case 1)Clip_line"
                #
                ensight.ptrace.create_bypartname("(CASE:Case","1)Clip_line","100")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_bypartname({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create_default(self) -> int:
        """Ptrace: create_default

        """
        cmd = f'''ensight.ptrace.create_default()'''
        return self._session.cmd(cmd)

    def create_file(self, p0: str) -> int:
        """Create particle traces from the current location of the line tool.
        
        Args:
            p0:
                'filename' The name of the emitter file
        
        Examples:
            ::
        
                #
                # Create particle traces through part 1 by releasing
                # emitters as defined in the given file
                #
                ensight.part.select_begin(1)
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.create_file("/tmp/emitter.file")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def create_net(self, p0: int, p1: int) -> int:
        """Create particle traces from the plane tool.
        
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. 
        | A parent part or parts (containing the flow field) must be selected prior to this command. You need the plane tool to be at the desired location.  
        | The number of emitter points will be the product of num_in_x * num_in_y.
        
        Args:
            p0:
                'num_in_x ' number of equally spaced points in the x direction of the plane tool
            p1:
                'num_in_y ' number of equally spaced points in the y direction of the plane tool
        
        Examples:
            ::
        
                #
                # Getting the plane tool to the desired location
                #
                ensight.view_transf.plane(1,1.750000,2.700000,0.000000)
                ensight.view_transf.plane(2,13.000000,2.700000,0.000000)
                ensight.view_transf.plane(3,13.000000,9.500000,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 35 traces from the plane tool
                #
                ensight.ptrace.create_net(5,7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_net({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def create_node_track(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_node_track()'''
        return self._session.cmd(cmd)

    def create_part(self, p0: int) -> int:
        """Ptrace: create_part

        """
        cmd = f'''ensight.ptrace.create_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def create_partbyname(self, p0: str) -> int:
        """Ptrace: create_partbyname

        """
        cmd = f'''ensight.ptrace.create_partbyname({repr(p0)})'''
        return self._session.cmd(cmd)

    def create_pt(self) -> int:
        """Create a particle trace from the current location of the cursor (a point).
        
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command, and you need the cursor to be at the desired location.
        
        Examples:
            ::
        
                #
                # Getting the cursor to the desired location
                #
                ensight.view_transf.cursor(-0.927830,1.474020,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_pt()'''
        return self._session.cmd(cmd)

    def create_rake(self, p0: int) -> int:
        """Create particle traces from the current location of the line tool.
        
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command, and you need the line tool to be at the desired location.
        
        Args:
            p0:
                'num_points' number of equally spaced points on the line to use as emitters
        
        Examples:
            ::
        
                #
                # Getting the line tool to the desired location
                #
                ensight.view_transf.line(1,9.000000,6.000000,0.000000)
                ensight.view_transf.line(2,30.000000,6.000000,0.000000)
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (others are the current defaults)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 10 traces from a line tool
                #
                ensight.ptrace.create_rake(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_rake({repr(p0)})'''
        return self._session.cmd(cmd)

    def create_surface_net(self, p0: float, p1: float, p2: float, p3: float, p4: float, p5: float) -> int:
        """Create surface restricted particle traces from a screen box pick.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command. 
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command. The number of emitter points will be the product of num_in_x * num_in_y.
        
        Args:
            p0:
                'num_in_x' number of equally spaced points in the x direction of the box pick
            p1:
                'num_in_y' number of equally spaced points in the y direction of the box pick
            p2:
                'x1' screen x coordinate of the first point on the diagonal of the box (0.0 to 1.0)
            p3:
                'y1' screen y coordinate of the first point on the diagonal of the box (0.0 to 1.0)
            p4:
                'x2' screen x coordinate of the second point on the diagonal of the box (0.0 to 1.0)
            p5:
                'y2' screen y coordinate of the second point on the diagonal of the box (0.0 to 1.0)
        
        Examples:
            ::
        
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 35 traces from the box selection
                #
                ensight.ptrace.create_surface_net(5,7)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_surface_net({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)},{repr(p5)})'''
        return self._session.cmd(cmd)

    def create_surface_pt(self, p0: float, p1: float) -> int:
        """Create a surface restricted particle trace from a screen point pick location.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command. 
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command.
        
        Args:
            p0:
                'screen_x' screen x coordinate (0.0 to 1.0)
            p1:
                'screen_y' screen y coordinate (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating surface restricted trace from a screen location
                #
                ensight.ptrace.create_surface_pt(0.148551,0.484398)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_surface_pt({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def create_surface_rake(self, p0: float, p1: float, p2: float, p3: float, p4: float) -> int:
        """Create surface restricted particle traces from a screen pick rake location.
        
        | The "ptrace: surface_restricted" command must be ON prior to this command. 
        | The default attributes and/or any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end" commands are used for the trace creation. A parent part or parts (containing the flow field) must be selected prior to this command.
        
        Args:
            p0:
                'num_points' number of equally spaced points along the rake to use as emitters
            p1:
                'x1' screen x coordinate of the first end of the rake (0.0 to 1.0)
            p2:
                'y1' screen y coordinate of the first end of the rake (0.0 to 1.0)
            p3:
                'x2' screen x coordinate of the second end of the rake (0.0 to 1.0)
            p4:
                'y2' screen y coordinate of the second end of the rake (0.0 to 1.0)
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(1,3,4)
                #
                # Setting some attributes before creation
                # (surface_restricted must be on)
                #
                ensight.ptrace.begin()
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating 10 traces from a screen rake location
                #
                ensight.ptrace.create_surface_rake(10,0.117150,0.540862,0.117150,0.442793)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_surface_rake({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)},{repr(p4)})'''
        return self._session.cmd(cmd)

    def create_varmax_track(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_varmax_track()'''
        return self._session.cmd(cmd)

    def create_varmin_track(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.create_varmin_track()'''
        return self._session.cmd(cmd)

    def default_emit_bypart(self, *args, **kwargs) -> Any:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.ptrace.default_emit_bypart({arg_string})"
        return self._session.cmd(cmd)

    def default_emit_bypartname(self, p0: str, p1: str, p2: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.default_emit_bypartname({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def default_emit_file(self, p0: str) -> int:
        """Set the default filename for file emitters and sets the user interface Emit From option to be File.
        
        Args:
            p0:
                'filename' The default emitter file name
        
        Examples:
            ::
        
                #
                # Set the default file emitter
                #
                ensight.ptrace.default_emit_file("/tmp/emitter.file")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.default_emit_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_emit_net(self, p0: int, p1: int) -> int:
        """Set the default number of x and y grid points for net emitters, and sets the user interface Emit From option to be Plane.
        
        | Mainly used to set the default "Emit From" option in the user interface, but also sets the default number of x and y grid points. Any subsequent particle traces created using a net will use this unless changed specifically.
        
        Args:
            p0:
                'num_in_x' number of emission points to be the default for x direction of net
            p1:
                'num_in_y' number of emission points to be the default for y direction of net
        
        Examples:
            ::
        
                #
                # Set the default number of emission points
                # for nets to be 10 x 12 in this case
                #
                ensight.ptrace.default_emit_net(10,12)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.default_emit_net({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def default_emit_part(self, p0: int) -> int:
        """Ptrace: default_emit_part

        """
        cmd = f'''ensight.ptrace.default_emit_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_emit_partbyname(self, p0: str) -> int:
        """Ptrace: default_emit_partbyname

        """
        cmd = f'''ensight.ptrace.default_emit_partbyname({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_emit_pt(self) -> int:
        """Set the user interface Emit From option to be Cursor.
        
        | Sets the default "Emit From" in the user interface.
        
        Examples:
            ::
        
                ensight.ptrace.default_emit_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.default_emit_pt()'''
        return self._session.cmd(cmd)

    def default_emit_rake(self, p0: int) -> int:
        """Set the default number of emission points for rake emitters, and sets the user interface Emit From option to be Line.
        
        | Mainly used to set the default "Emit From" option in the user interface, but also sets the default number of rake emission points. Any subsequent particle traces created using a rake will use this unless changed specifically.
        
        Args:
            p0:
                'num' the number of emission points to be the default for rakes
        
        Examples:
            ::
        
                #
                # Set the default number of emission points
                # for rakes to be 10 in this case
                #
                ensight.ptrace.default_emit_rake(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.default_emit_rake({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete_emitter(self) -> int:
        """Remove emitters from a particle trace part (and their associated traces).
        
        | The desired emitter for the particle trace part must be selected before this command is issued.
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(2)
                #
                # Selecting the emitter within the part
                # (in this case we will delete the first 3 emitters)
                #
                ensight.ptrace.select_emitter_begin(0,1,2)
                ensight.ptrace.delete_emitter()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.delete_emitter()'''
        return self._session.cmd(cmd)

    def delta_time(self, p0: float) -> int:
        """Specifies the time interval between emissions from the emitters.
        
        | Particles will be traced starting at the current time step or the time specified with ptrace: start_time.  Additional particles will be released every "emit_delta" time units.
        | Most useful for pathline generation.
        
        Args:
            p0:
                'emit_delta' the time interval between emissions. (The default is 0.0, which will cause only the initial emission to take place
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the delta_time is being set here, to emit
                #  every 2.5 time units)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.start_time(1.5000e+01)
                ensight.ptrace.delta_time(2.5000e+00)
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.delta_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def display_offset(self, p0: float) -> int:
        """Sets the distance normal to the surface at which the surface restricted trace will be displayed. This can be used to avoid z-buffer display problems that arise because the trace lies in the same plane as the surface. 
        
        | A positive number moves the trace in the direction of the positive surface normal, while a negative number moves in the opposite direction.
        
        Args:
            p0:
                'offset_distance' the distance normal to the surface at which to display the trace
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the  display_offset for the surface restricted trace
                #  is being set here)
                #
                ensight.ptrace.begin()
                ensight.part.description("Particle trace part")
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable_offset(1.0000e-01)
                ensight.ptrace.display_offset(-0.5000e+00)
                ensight.ptrace.total_time(2.0000e+02)
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.display_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def dummy_chng_slot(self, args: Any) -> int:
        """Ptrace: dummy_chng_slot

        """
        cmd = f'''ensight.ptrace.dummy_chng_slot({repr(args)})'''
        return self._session.cmd(cmd)

    def elt_part(self, p0: int) -> int:
        """Ptrace: elt_part

        """
        cmd = f'''ensight.ptrace.elt_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_partbyname(self, p0: str) -> int:
        """Ptrace: elt_partbyname

        """
        cmd = f'''ensight.ptrace.elt_partbyname({repr(p0)})'''
        return self._session.cmd(cmd)

    def emit_at_current_time(self, p0: str) -> int:
        """Sets the emission time for a particle trace to be current time when the particle trace is created.  The particle trace is also updated whenever time is changed.
        
        | While this flag is ON, the "ptrace: start_time" is not used.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the emit_at_current_time flag is being set here)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.emit_at_current_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def emit_density(self, p0: float) -> int:
        """Ptrace: emit_density

        """
        cmd = f'''ensight.ptrace.emit_density({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Delimit the modifications for particle trace attributes.
        
        | These commands are used to set the attributes for particle trace part creation.
        
        Args:
            p0:
                'ptrace_command' any of the various attribute changing "ptrace:" commands
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                #
                ensight.ptrace.begin()
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.end()'''
        return self._session.cmd(cmd)

    def hide_emission(self, p0: int) -> int:
        """Ptrace: hide_emission

        """
        cmd = f'''ensight.ptrace.hide_emission({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_ballistic_coef(self, p0: float) -> int:
        """If the massed_use_ballistic toggle is ON then this is the ballistic coefficient to use
        
        Args:
            p0:
                'coef' ballistic coefficient
        
        Examples:
            ::
        
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.ptrace.massed_buoyancy("OFF")
                ensight.ptrace.massed_use_ballistic("ON")
                ensight.ptrace.massed_ballistic_coef(0.01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_ballistic_coef({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_buoyancy(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_buoyancy({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_coef_friction(self, p0: float) -> int:
        """Set the coefficient of friction for use with the massed particle rebound capability
        
        Args:
            p0:
                'friction' coefficient of friction
        
        Examples:
            ::
        
                ensight.ptrace.select_default()
                ensight.ptrace.default_emit_pt()
                ensight.view_transf.cursor(7.1,6,0.)
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.ptrace.massed_rebound("ON")
                ensight.ptrace.massed_rebound_wallhits(4)
                ensight.ptrace.massed_coef_restitution(0.8)
                ensight.ptrace.massed_coef_friction(1.000000e-01)
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_coef_friction({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_coef_restitution(self, p0: float) -> int:
        """Set the coefficient of restitution for use with the massed particle rebound capability
        
        Args:
            p0:
                'rebound' coefficient of restitution
        
        Examples:
            ::
        
                ensight.ptrace.select_default()
                ensight.ptrace.default_emit_pt()
                ensight.view_transf.cursor(7.1,6,0.)
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.ptrace.massed_rebound("ON")
                ensight.ptrace.massed_rebound_wallhits(4)
                ensight.ptrace.massed_coef_restitution(0.8)
                ensight.ptrace.massed_coef_friction(1.000000e-01)
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_coef_restitution({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_drag(self, p0: str) -> int:
        """Specify whether the drag force term is used in the massed-particle calculation.
        
        | The default setting is ON.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command. Drag force term in the massed-particle momentum balance equation is computed according to the ptrace: massed_pressure_gradient setting.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle drag force term
                # Specify default drag coefficient function table
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_drag("ON")
                ensight.ptrace.massed_drag_coefficient("none")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_drag({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_drag_coefficient(self, p0: float) -> int:
        """Specify the name of the drag coefficient function table to be used in the drag force term of the massed-particle calculation.
        
        | The default setting is "none".  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is only used when the drag force term "ptrace: massed_drag" is toggled ON. 
        | Also the three options "DragCoefPoly", "DragCoefPower", and "DragCoefTable1", are EnSight User-Defined Math Functions.  These math functions are typically located under $CEI_HOME/ensight92/src/math_functions, and are compiled as libraries by the user, and then dynamically liked via the _UDMF environment variable.
        
        Args:
            p0:
                'table_name' none
            p1:
                'table_name' DragCoefTable1
            p2:
                'table_name' DragCoefPower
            p3:
                'table_name' DragCoefPoly
            p4:
                'table_name' any User-Defined Math Function
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle drag force term
                # Specify default drag coefficient function table
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_drag("ON")
                ensight.ptrace.massed_drag_coefficient("none")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
                #
                # Change the drag coefficient function to use the power formulation
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_drag_coefficient("DragCoefPower")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_drag_coefficient({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_fluid_density(self, p0: float) -> int:
        """Specify the density of the corresponding fluid field where the massed-particles are traced.
        
        | The default setting for this parameter is the constant value of "1.0", with the Fluid Density variable name set to "none".  This indicates that no variable name is used; rather the constant density is used in the calculations instead.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured only when the drag and gravity force terms of the massed-particle momentum balance equation are used.
        
        Args:
            p0:
                'density' the fluid density constant value of the corresponding fluid field
            p1:
                'density' the fluid density constant value of the corresponding fluid field
            p2:
                'density' the fluid density variable name of the corresponding fluid field - defaults to "none" when constant value used
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Specify density scalar field variable name of the fluid.
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_fluid_density("density")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_fluid_density({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_fluid_viscosity(self, p0: float) -> int:
        """Specify the dynamic viscosity of the corresponding fluid field where the massed-particles are traced.
        
        | The default setting for this parameter is the constant value of "1.9620e+05", with the Fluid Dynamic Viscosity variable name set to "none".  This indicates that no variable name is used; rather the constant dynamic viscosity is used in the calculations instead.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured only when the drag force term of the massed-particle momentum balance equation is used.
        
        Args:
            p0:
                'viscosity' the dynamic viscosity constant value of the corresponding fluid field
            p1:
                'viscosity' the dynamic viscosity constant value of the corresponding fluid field
            p2:
                'viscosity' the dynamic viscosity variable name of the corresponding fluid field - defaults to "none" when constant value used
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Specify dynamic viscosity scalar field variable name of the fluid.
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_fluid_viscosity("dynamic_viscosity")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_fluid_viscosity({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_gravity(self, p0: str) -> int:
        """Specify whether the gravity force term is used in the massed-particle calculation.
        
        | The default setting is ON.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  If this command is ON, then the gravity force term in the massed-particle momentum balance equation is computed according to the "ptrace: massed_gravity_vector" setting.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle gravity force term
                # Specify gravity vector
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_gravity("ON")
                ensight.ptrace.massed_gravity_vector("0.00000e+00-9.81000e+00",0.00000e+00)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_gravity({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_gravity_vector(self, p0: float, p1: float, p2: float) -> int:
        """Specify the name of the gravity vector used in the pressure force term of the massed-particle calculation.
        
        | The default setting is <0., -9.81, 0.>.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  
        
        Args:
            p0:
                'gx' the x-component of the gravity vector
            p1:
                'gy' the y-component of the gravity vector
            p2:
                'gz' the z-component of the gravity vector
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle gravity force term
                # Specify the gravity vector
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_gravity("ON")
                ensight.ptrace.massed_gravity_vector("0.00000e+00-9.81000e+00",0.00000e+00)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_gravity_vector({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def massed_initial_use_fluid(self, p0: str) -> int:
        """Specify whether to use the velocity of the fluid at the particle emitter location as the initial velocity of the massed-particle.
        
        | The default value is ON.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured in all terms of the massed-particle momentum balance equation.  If the value of this command is OFF, then the massed-particle emitter will use the velocity specified via the "ptrace: massed_initial_velocity" command.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Do not use the field velocity as the initial particle velocity
                # Specify the initial velocity value for all the massed-particles
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_initial_use_fluid("OFF")
                ensight.ptrace.massed_initial_velocity(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_initial_use_fluid({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_initial_velocity(self, p0: float, p1: float, p2: float) -> int:
        """Specify the initial emitter velocity vector to be used on all the massed-particles.
        
        | The default vector value is <1,1,1>.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured in all terms of the massed-particle momentum balance equation.  The values of this command take effect only if "ptrace: massed_initial_use_fluid" is toggled OFF.
        
        Args:
            p0:
                'vx' the x-component of the initial velocity vector
            p1:
                'vy' the y-component of the initial velocity vector
            p2:
                'vz' the z-component of the initial velocity vector
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Do not use the field velocity as the initial particle velocity
                # Specify the initial velocity value for all the massed-particles
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_initial_use_fluid("OFF")
                ensight.ptrace.massed_initial_velocity(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_initial_velocity({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def massed_particle_density(self, p0: float) -> int:
        """Specify the density of all the massed-particles.
        
        | The default value is 1.0e+03.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured in all terms of the massed-particle momentum balance equation.  Water particle densities are on the order of 1.0e+3, and air partilce densities are on the order of 1.0.
        
        Args:
            p0:
                'density' the density value of all the particles
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Specify density of all the massed particles
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particle_density(1.0000e+03)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_particle_density({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_particle_diameter(self, p0: float) -> int:
        """Specify the diameter of all the massed-particles.
        
        | The default value is 1.0e-03.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  This parameter is figured in all terms of the massed-particle momentum balance equation.  Water particle diameters are on the order of 1.0e-3, and air partilce diameters are on the order of 1.0e-6.
        
        Args:
            p0:
                'diameter' the diameter value of all the particles
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Specify diameter of the massed particle
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particle_diameter(1.0000e-03)
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_particle_diameter({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_particles(self, p0: str) -> int:
        """Enable or disable massed-particle trace calculation.
        
        | The default value is OFF.  The "ptrace: massed_particles" command does not have to be ON in order to specify the other massed-particle commands.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_particles({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_pressure(self, p0: str) -> int:
        """Specify whether the pressure force term is used in the massed-particle calculation.
        
        | The default setting is OFF.  The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  If this command is ON, then the pressure force term in the massed-particle momentum balance equation is computed according to the "ptrace: massed_pressure_gradient" setting.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle pressure force term
                # Specify pressure gradient variable
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_pressure("ON")
                ensight.ptrace.massed_pressure_gradient("grad_pressure")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_pressure({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_pressure_gradient(self, p0: Any) -> int:
        """Specify the name of the pressure gradient variable used in the pressure force term of the massed-particle calculation.
        
        | The "ptrace: massed_particles" command does not have to be ON in order to specify this command.  If "none" is specified, then the pressure force term is ignored in the massed-particle calculation.  The default setting is "none".
        
        Examples:
            ::
        
                #
                # Create a massless point trace
                #
                ensight.part.select_all()
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("velocity")
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
                ensight.part.select_begin(2)
                #
                # Toggle on massed-particle pressure force term
                # Specify pressure gradient variable
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_pressure("ON")
                ensight.ptrace.massed_pressure_gradient("grad_pressure")
                ensight.part.modify_end()
                #
                # Change part to massed trace using current settings
                #
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_pressure_gradient({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_rebound(self, p0: str) -> int:
        """Turn on/off the use of massed particle rebound coefficients.
        
        | Only used if the "ptrace: mass_particles" setting is ON
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.ptrace.select_default()
                ensight.ptrace.default_emit_pt()
                ensight.view_transf.cursor(7.1,6,0.)
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.ptrace.massed_rebound("ON")
                ensight.ptrace.massed_rebound_wallhits(4)
                ensight.ptrace.massed_coef_restitution(0.8)
                ensight.ptrace.massed_coef_friction(1.000000e-01)
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_rebound({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_rebound_fraction(self, p0: float) -> int:
        """If using massed particle restitution this sets a termination criteria.  Only if the rebound velocity as a fraction of the initial impact velocity if greater than this value will the particle continue to be tracked.
        
        | There are other terminating particle trace criteria such as the time limit controlled by "ptrace: total_time" and the fraction of initial impact velocity controlled by "ptrace: mass_rebound_fraction"
        
        Args:
            p0:
                'fraction' the fraction of initial impact velocity
        
        Examples:
            ::
        
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.ptrace.massed_rebound_fraction(.01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_rebound_fraction({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_rebound_wallhits(self, p0: int) -> int:
        """If using massed particle restitution this sets a termination criteria.  Only num_hits number of rebounds will be allowed at which time the particle trace will be terminated
        
        | There are other terminating particle trace criteria such as the time limit controlled by "ptrace: total_time" and the fraction of initial impact velocity controlled by "ptrace: mass_rebound_fraction"
        
        Args:
            p0:
                'num_hits' the number of rebounds that will be computed
        
        Examples:
            ::
        
                ensight.ptrace.select_default()
                ensight.ptrace.default_emit_pt()
                ensight.view_transf.cursor(7.1,6,0.)
                ensight.part.modify_begin()
                ensight.ptrace.massed_particles("ON")
                ensight.ptrace.massed_rebound("ON")
                ensight.ptrace.massed_rebound_wallhits(4)
                ensight.ptrace.massed_coef_restitution(0.8)
                ensight.ptrace.massed_coef_friction(1.000000e-01)
                ensight.part.modify_end()
                ensight.part.select_all()
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_rebound_wallhits({repr(p0)})'''
        return self._session.cmd(cmd)

    def massed_use_ballistic(self, p0: str) -> int:
        """If using massed particle restitution this sets a termination criteria.  Only num_hits number of rebounds will be allowed at which time the particle trace will be terminated
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(2)
                ensight.part.modify_begin()
                ensight.ptrace.massed_buoyancy("OFF")
                ensight.ptrace.massed_use_ballistic("ON")
                ensight.ptrace.massed_ballistic_coef(0.01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.massed_use_ballistic({repr(p0)})'''
        return self._session.cmd(cmd)

    def max_angle(self, p0: float) -> int:
        """Sets the maximum angle between successive particle trace line segments that will trigger a halving of the integration step.
        
        | When a particle trace starts curving, the integration step typically needs to be decreased. This attribute is one of the controls for such adaptation.
        
        Args:
            p0:
                'value' desired maximum angle (in degrees).  If the angle between successive segments is greater than this, the integration step will be halved. The range is 1.0 to 90.0 degrees
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (max_angle is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.min_steps(3)
                ensight.ptrace.min_angle(3.0000e+00)
                ensight.ptrace.max_angle(2.0000e+01)
                ensight.ptrace.rot_angle(3.2000e+01)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.max_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def min_angle(self, p0: float) -> int:
        """Sets the minimum angle between successive particle trace line segments that will trigger a doubling of the integration step.
        
        | When a particle trace is not curving, the integration step can typically be increased. This attribute is one of the controls for such adaptation.
        
        Args:
            p0:
                'value' desired minimum angle (in degrees).  If the angle between successive segments is less than this, the integration step will be doubled. The range is 1.0 to 90.0 degrees
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (min_angle is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.min_steps(3)
                ensight.ptrace.min_angle(3.0000e+00)
                ensight.ptrace.max_angle(2.0000e+01)
                ensight.ptrace.rot_angle(3.2000e+01)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.min_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def min_steps(self, p0: float) -> int:
        """Sets the minimum number of integration steps to perform in each element
        
        | A higher number increases the accuracy of the integration, but is more compute intensive and produces more segments to display.
        
        Args:
            p0:
                'num' desired minimum number of integration steps per element (range is 2 to 20)
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (min_steps being modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.min_steps(3)
                ensight.ptrace.min_angle(3.0000e+00)
                ensight.ptrace.max_angle(2.0000e+01)
                ensight.ptrace.rot_angle(3.2000e+01)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.min_steps({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_bypartemit_byname(self, p0: str, p1: str, p2: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_bypartemit_byname({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def modify_bypartemit_num(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_bypartemit_num({repr(args)})'''
        return self._session.cmd(cmd)

    def modify_emit_totoolloc(self, p0: int, p1: int) -> int:
        """Change the location of the emitter in a particle trace part.
        
        Args:
            p0:
                'part_num' particle trace part number
            p1:
                'emitter' emitter number (0-based)
        
        Examples:
            ::
        
                #
                # Change the location of the tool used for the emitter
                #
                ensight.view_transf.cursor(7.422632,-0.327560,0.000000)
                #
                # modify the trace emitter based on this tool
                # (in this case, it is emitter 0 in part 2
                #
                ensight.ptrace.modify_emit_totoolloc(2,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_emit_totoolloc({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def modify_fileemit_name(self, p0: str) -> int:
        """Change the emitter file name for a file emitter.
        
        Args:
            p0:
                'emitter' Emitter number (0 based)
            p1:
                'filename' The new emitter file name
        
        Examples:
            ::
        
                #
                # Select an existing particle trace part 3
                # 
                #
                ensight.part.select_begin(3)
                # 
                # Change the emitter name for emitter 0
                #
                ensight.ptrace.modify_fileemit_name("0 /tmp/new_emitter.file")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_fileemit_name({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_netemit_points(self, p0: int, p1: int, p2: int) -> int:
        """Change the number of emission points for a particular net emitter in a particle trace part.
        
        Args:
            p0:
                'emitter' emitter number (0-based)
            p1:
                'new_num_in_x' desired new number of emission points for the grid x direction.
            p2:
                'new_num_in_y' desired new number of emission points for the grid y direction
        
        Examples:
            ::
        
                #
                # Selecting an existing particle trace part
                # (which contains some net emitters)
                #
                ensight.part.select_begin(3)
                #
                # Changing the number of points in the
                # first 2 net emitters (emitters 0 and 1)
                # to 5 x 6, and 9 x 15 respectively
                #
                ensight.ptrace.modify_netemit_points(0,5,6)
                ensight.ptrace.modify_netemit_points(1,9,15)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_netemit_points({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def modify_partemit_byname(self, p0: str, p1: str) -> int:
        """Ptrace: modify_partemit_byname

        """
        cmd = f'''ensight.ptrace.modify_partemit_byname({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def modify_partemit_num(self, p0: int, p1: int) -> int:
        """Ptrace: modify_partemit_num

        """
        cmd = f'''ensight.ptrace.modify_partemit_num({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def modify_rakeemit_points(self, p0: int, p1: int) -> int:
        """Change the number of emission points for a particular rake emitter in a particle trace part.
        
        Args:
            p0:
                'emitter' emitter number (0-based
            p1:
                'new_num_pts' desired new number of emission points along the rake
        
        Examples:
            ::
        
                #
                # Selecting an existing particle trace part
                # (which contains a rake emitter)
                #
                ensight.part.select_begin(3)
                #
                # Changing the number of points in the
                # first emitter (emitter 0), to 8
                #
                ensight.ptrace.modify_rakeemit_points(0,8)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.modify_rakeemit_points({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def node_id(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.node_id({repr(args)})'''
        return self._session.cmd(cmd)

    def number_of_arrows(self, p0: int) -> int:
        """Ptrace: #_of_arrows

        """
        cmd = f'''ensight.ptrace.number_of_arrows({repr(p0)})'''
        return self._session.cmd(cmd)

    def pick_surface_oncreatecmd(self, p0: str) -> int:
        """Ptrace: pick_surface_oncreatecmd

        """
        cmd = f'''ensight.ptrace.pick_surface_oncreatecmd({repr(p0)})'''
        return self._session.cmd(cmd)

    def random_color_emissions(self) -> int:
        """Ptrace: random_color_emissions

        """
        cmd = f'''ensight.ptrace.random_color_emissions()'''
        return self._session.cmd(cmd)

    def representation(self, p0: str) -> int:
        """Sets the display representation for a particle trace.
        
        | Use the ribbon or square_tubes representations whenever rotational effects need to be seen. Surface restricted traces can only be displayed in line representation.
        
        Args:
            p0:
                'rep'
        
                * line
                * ribbon
                * square_tubes
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (representation is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.representation("ribbon")
                ensight.ptrace.ribbon_width(2.0000e+00)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.representation({repr(p0)})'''
        return self._session.cmd(cmd)

    def ribbon_width(self, p0: float) -> int:
        """Sets the width for ribbon or square tube particle trace representations.
        
        | This attribute has no effect when using the "line" trace representation.
        
        Args:
            p0:
                'width' the width of the ribbon or square tube
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (ribbon_width is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.representation("square_tubes")
                ensight.ptrace.ribbon_width(2.0000e+00)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.ribbon_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def rot_angle(self, p0: float) -> int:
        """Sets the angle between successive particle trace line segments that will trigger a halving of the integration step.  
        
        | When a particle begins experiencing rotational effects, the integration step typically needs to be decreased. This attribute is one of the controls for such adaptation.
        
        Args:
            p0:
                'value' desired rotational angle (in degrees). If the change in rotation angle is greater than this, the integration step will be halved.  range is 1.0 to 90.0 degrees
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (rot_angle is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.min_steps(3)
                ensight.ptrace.min_angle(3.0000e+00)
                ensight.ptrace.max_angle(2.0000e+01)
                ensight.ptrace.rot_angle(3.2000e+01)
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.rot_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Ptrace: select_begin

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.ptrace.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Sets the currently selected particle trace parts to none, so any following attribute modifications will change the particle trace defaults.
        
        | When particle trace parts are created, the defaults, and any "ptrace:" attribute commands between "ptrace: begin" and "ptrace: end", are used in the creation.
        
        Examples:
            ::
        
                #
                # Setting to default particle traces
                #
                ensight.ptrace.select_default()
                #
                # modifying some attributes
                #
                ensight.part.modify_begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("pathline")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.select_default()'''
        return self._session.cmd(cmd)

    def select_emitname_begin(self) -> int:
        """Ptrace: select_emitname_begin

        """
        cmd = f'''ensight.ptrace.select_emitname_begin()'''
        return self._session.cmd(cmd)

    def select_emitname_end(self) -> int:
        """Ptrace: select_emitname_end

        """
        cmd = f'''ensight.ptrace.select_emitname_end()'''
        return self._session.cmd(cmd)

    def select_emitter_begin(self, *args, **kwargs) -> Any:
        """Select emitters within a particle trace part for the purpose of modifying emitter attributes, deleting, etc.
        
        Args:
            p0:
                'emitterN' emitter numbers (0-based)
        
        Examples:
            ::
        
                #
                # Selecting the parent part(s)
                #
                ensight.part.select_begin(2)
                #
                # Selecting the first 3 emitters within the part
                # for the purpose of deleting them
                #
                ensight.ptrace.select_emitter_begin(0,1,2)
                ensight.ptrace.delete_emitter()
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.ptrace.select_emitter_begin({arg_string})"
        return self._session.cmd(cmd)

    def show_emissions(self) -> int:
        """Ptrace: show_emissions

        """
        cmd = f'''ensight.ptrace.show_emissions()'''
        return self._session.cmd(cmd)

    def start_time(self, p0: float) -> int:
        """Specifies the solution time at which to begin particle emission.
        
        Args:
            p0:
                'emit_time' solution time for particle emission. Must be in the range of valid solution times
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the start_time is being set here)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.start_time(1.5000e+01)
                ensight.ptrace.delta_time(1.0000e+00)
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.start_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface_restricted(self, p0: str) -> int:
        """Toggles trace creation to be surface restricted or not. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the surface_restricted flag is being set here)
                #
                ensight.ptrace.begin()
                ensight.part.description("Particle trace part")
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable_offset(1.0000e-01)
                ensight.ptrace.display_offset(0.5000e+00)
                ensight.ptrace.total_time(2.0000e+02)
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.surface_restricted({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_step_begin(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.time_step_begin({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_step_end(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.time_step_end({repr(p0)})'''
        return self._session.cmd(cmd)

    def total_time(self, p0: float) -> int:
        """Sets the maximum length of time that the particle trace is allowed to continue.
        
        | A particle trace may terminate earlier than this for other reasons, but this limit avoids infinite calculations in recirculation zones.
        
        Args:
            p0:
                'limit' total time limit
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (total_time is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.total_time(2.0000e+02)
                ensight.ptrace.trace_direction("+/-")
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.total_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def trace_direction(self, p0: str) -> int:
        """Sets the integration direction for a particle trace - forward in time, backward in time, or both.
        
        | By setting this option appropriately, one can see where a particle will go if released from the emitter location (the + direction), or one can see the path that a particle took to get to the emitter location (the - direction). 
        
        Args:
            p0:
                'direction'
        
                * +
                * -
                * +/-
        
        Examples:
            ::
        
                #
                # Selecting the trace(s)
                #
                ensight.part.select_begin(7,8)
                #
                # Modifying attributes for the two selected trace parts
                # (trace_direction is modified in here)
                #
                ensight.part.modify_begin()
                ensight.ptrace.total_time(2.0000e+02)
                ensight.ptrace.trace_direction("+/-")
                #
                # Updates the traces with the modified attributes
                #
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.trace_direction({repr(p0)})'''
        return self._session.cmd(cmd)

    def type(self, p0: str) -> int:
        """Sets the type of particle trace that will be created.
        
        | Pathline is only available for transient data cases.
        
        Args:
            p0:
                'option'
        
                * streamline
                * pathline
                * nodetrack
                * variablemintrack
                * variablemaxtrack
        
        Examples:
            ::
        
                #
                # Setting default particle trace variable
                #
                ensight.ptrace.select_default()
                ensight.part.modify_begin()
                ensight.ptrace.variable("VITESSE")
                ensight.part.modify_end()
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the type is being set here)
                #
                ensight.ptrace.begin()
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.type({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Specifies the vector variable to use for the flow field for the particle trace.
        
        Args:
            p0:
                'name' name of the vector variable
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the variable is being set here)
                #
                ensight.ptrace.begin()
                ensight.ptrace.variable("VITESSE")
                ensight.ptrace.type("streamline")
                ensight.ptrace.component(1.0000e+00,1.0000e+00,1.0000e+00)
                ensight.ptrace.representation("line")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable_offset(self, p0: float) -> int:
        """Sets the distance from the surface into the flow field at which the velocity variable will be sampled.  The tangential component of the variable at this offset distance is the field that will be used to trace through for surface restricted traces.
        
        | A positive number moves the distance in the direction of the positive normal of the surface, while a negative number moves in the opposite direction.  If there is only flow on one side of the surface, the program will flip the sign internally.
        | Used only for surface restricted particle traces.
        
        Args:
            p0:
                'offset_distance' distance into the field
        
        Examples:
            ::
        
                #
                # Selecting the parent part
                #
                ensight.part.select_begin(1)
                #
                # Setting some attributes before creation
                # (the variable_offset for the surface_restricted trace
                #  is being set here)
                #
                ensight.ptrace.begin()
                ensight.part.description("Particle trace part")
                ensight.ptrace.surface_restricted("ON")
                ensight.ptrace.variable_offset(1.0000e-01)
                ensight.ptrace.display_offset(0.5000e+00)
                ensight.ptrace.total_time(2.0000e+02)
                ensight.ptrace.emit_at_current_time("ON")
                ensight.ptrace.end()
                #
                # Creating trace from a point
                #
                ensight.ptrace.create_pt()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.ptrace.variable_offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def width_scale_factor(self, p0: float) -> int:
        """Ptrace: width_scale_factor

        """
        cmd = f'''ensight.ptrace.width_scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)


class profile:
    """Class wrapper for EnSight profile module

    This class acts as a proxy for the EnSight Python module ensight.profile
    """
    def __init__(self, session: Session):
        self._session = session

    def begin(self) -> int:
        """Groups profile attribute commands to be applied together before a "profile: create" command.
        
        Args:
            p0:
                'profile_commands' any of the profile attribute commands
        
        Examples:
            ::
        
                ensight.profile.begin()
                ensight.profile.variable("VITESSE")
                ensight.profile.offset(0.0000e+00)
                ensight.profile.scale_factor(1.3603e+00)
                ensight.profile.end()
                ensight.profile.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.begin()'''
        return self._session.cmd(cmd)

    def component(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the contribution of a vector variable to be applied for profile generation.
        
        | If all the scale factors are set to 0.0, the magnitude of the vector will be used (this is the default).
        | Part selection and modify commands are used as needed since profiles are a part type based on a parent part.
        
        Args:
            p0:
                'x_scal' scale factor to apply to the x, y, z components of the vector
            p1:
                'y_scal' scale factor to apply to the x, y, z components of the vector
            p2:
                'z_scal' scale factor to apply to the x, y, z components of the vector
        
        Examples:
            ::
        
                ensight.profile.variable("VITESSE")
                ensight.part.select_begin(3)
                ensight.part.modify_begin()
                #
                # Use the y-component of the vector
                #
                ensight.profile.component(0.0000e+00,1.0000e+00,0.0000e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.component({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def create(self) -> int:
        """Create a profile part with the currently defined attributes using the currently selected parts as parents. 
        
        | The profile part is created using the currently selected parts as parents.  The profile part is creates using  the currently set profile attributes.
        
        Examples:
            ::
        
                #
                # Select parent part
                #
                ensight.part.select_begin(2)
                ensight.profile.begin()
                ensight.profile.variable("VITESSE")
                ensight.profile.offset(0.0000e+00)
                ensight.profile.scale_factor(1.3603e+00)
                ensight.profile.end()
                ensight.profile.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.create()'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Groups profile attribute commands to be applied together before a "profile: create" command.
        
        Args:
            p0:
                'profile_commands' any of the profile attribute commands
        
        Examples:
            ::
        
                ensight.profile.begin()
                ensight.profile.variable("VITESSE")
                ensight.profile.offset(0.0000e+00)
                ensight.profile.scale_factor(1.3603e+00)
                ensight.profile.end()
                ensight.profile.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.end()'''
        return self._session.cmd(cmd)

    def from_point(self, p0: float, p1: float, p2: float) -> int:
        """Profile: from_point

        """
        cmd = f'''ensight.profile.from_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def in_plane(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """Specify the location of the orientation points for profile generation.
        
        | Three points define the plane in which the profile will be projected. The corresponding 4th point is generated and the center of these 4 points determines which direction the profile will projected in the plane.
        
        Args:
            p0:
                'point' must be 1, 2, or 3 (indicating which point is being specified)
        
        Examples:
            ::
        
                #
                #  Select existing profile part
                #
                ensight.part.select_begin(3)
                ensight.part.modify_begin()
                ensight.profile.in_plane(1,1.1977e+00,2.5928e+00,-9.6950e+00)
                ensight.profile.in_plane(2,2.0198e+01,2.5928e+00,-9.6950e+00)
                ensight.profile.in_plane(3,2.0198e+01,9.5655e+00,7.9793e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.in_plane({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def in_plane_1(self, p0: float, p1: float, p2: float) -> int:
        """Profile: in_plane 1

        """
        cmd = f'''ensight.profile.in_plane_1({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def in_plane_2(self, p0: float, p1: float, p2: float) -> int:
        """Profile: in_plane 2

        """
        cmd = f'''ensight.profile.in_plane_2({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def in_plane_3(self, p0: float, p1: float, p2: float) -> int:
        """Profile: in_plane 3

        """
        cmd = f'''ensight.profile.in_plane_3({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def offset(self, p0: float) -> int:
        """Add a value to the variable values before scaling the profile.
        
        | This command has the effect of shifting the profile up or down relative to the parent part(s). 
        
        Args:
            p0:
                'value'  value to add to the variable values before scaling
        
        Examples:
            ::
        
                #
                # Select existing profile part
                #
                ensight.part.select_begin(3)
                ensight.part.modify_begin()
                ensight.profile.offset(1.0000e+00)
                ensight.profile.scale_factor(2.0000e+00)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.offset({repr(p0)})'''
        return self._session.cmd(cmd)

    def scale_factor(self, p0: float) -> int:
        """Apply a scale factor to the variable values of the profile.
        
        Args:
            p0:
                'value' scale factor to apply to the variable values
        
        Examples:
            ::
        
                #
                # Select existing profile part
                #
                ensight.part.select_begin(3)
                ensight.part.modify_begin()
                ensight.profile.offset(3.0000e+00)
                ensight.profile.scale_factor(1.5000e+01)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.scale_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Sets the current profile to none, so that subsequent commands will modify the default profile attributes.
        
        | When profiles are created, the default attributes are used (unless overridden by attribute commands between "profile: begin / end" commands.  This command allows for changing of defaults.
        
        Examples:
            ::
        
                ensight.profile.select_default()
                ensight.profile.offset(0.0000e+00)
                ensight.profile.scale_factor(1.0000e+00)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.select_default()'''
        return self._session.cmd(cmd)

    def var_type(self, p0: str) -> int:
        """Profile: var_type

        """
        cmd = f'''ensight.profile.var_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def variable(self, p0: Any) -> int:
        """Sets the variable to use for profile creation or modification.
        
        Args:
            p0:
                'name' variable name
        
        Examples:
            ::
        
                #
                # Select existing profile part
                #
                ensight.part.select_begin(2)
                ensight.profile.begin()
                ensight.profile.variable("VITESSE")
                ensight.profile.end()
                ensight.profile.create()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.profile.variable({repr(p0)})'''
        return self._session.cmd(cmd)


class prefs:
    """Class wrapper for EnSight prefs module

    This class acts as a proxy for the EnSight Python module ensight.prefs
    """
    def __init__(self, session: Session):
        self._session = session

    def abort_server_operations(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.abort_server_operations({repr(p0)})'''
        return self._session.cmd(cmd)

    def abort_server_time(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.abort_server_time({repr(p0)})'''
        return self._session.cmd(cmd)

    def allmodelusecompdisplace(self, p0: str) -> int:
        """Prefs: allmodelusecompdisplace

        """
        cmd = f'''ensight.prefs.allmodelusecompdisplace({repr(p0)})'''
        return self._session.cmd(cmd)

    def animate_model_axis(self, p0: str) -> int:
        """Prefs: animate_model_axis

        """
        cmd = f'''ensight.prefs.animate_model_axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_contrast_foreground(self, p0: str) -> int:
        """Prefs: auto_contrast_foreground

        """
        cmd = f'''ensight.prefs.auto_contrast_foreground({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_legend_display(self, p0: str) -> int:
        """Will cause the legend to automatically appear when you color a part by a variable.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.auto_legend_replace("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.auto_legend_display({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_legend_replace(self, p0: str) -> int:
        """Preference that will cause legends to be automatically replaced when the current legend is no longer in use (i.e. no parts are colored by the variable) and a  new variable is in use.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.auto_legend_replace("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.auto_legend_replace({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_load_parts(self, p0: str) -> int:
        """Allows you to have EnSight automatically load parts when the data file is read.
        
        Args:
            p0:
                'method'
        
                * Must be one of:
                * all
                * none
        
        Examples:
            ::
        
                ensight.prefs.starting_time_step("last")
                ensight.prefs.auto_load_parts("all")
                ensight.data.binary_files_are("big_endian")
                ensight.data.format("case")
                ensight.data.path("/usr/tmp")
                ensight.data.geometry("car_crash.case")
                ensight.data.read()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.auto_load_parts({repr(p0)})'''
        return self._session.cmd(cmd)

    def balloon_help(self, p0: str) -> int:
        """Prefs: balloon_help

        """
        cmd = f'''ensight.prefs.balloon_help({repr(p0)})'''
        return self._session.cmd(cmd)

    def binary_files_are(self, p0: str) -> int:
        """Prefs: binary_files_are

        """
        cmd = f'''ensight.prefs.binary_files_are({repr(p0)})'''
        return self._session.cmd(cmd)

    def cull_lines(self, p0: str) -> int:
        """Will only draw shared lines between polygons once.  May help performance.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.cull_lines("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.cull_lines({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_data_directory(self, p0: str) -> int:
        """Preference to set the default directory where the user's data resides.
        
        Args:
            p0:
                'directory_name' name of the default directory
        
        Examples:
            ::
        
                ensight.prefs.default_data_directory("/usr/local/bin/ensight92/data/ami")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.default_data_directory({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_data_filefilter(self, p0: str) -> int:
        """Prefs: default_data_filefilter

        """
        cmd = f'''ensight.prefs.default_data_filefilter({repr(p0)})'''
        return self._session.cmd(cmd)

    def default_palette(self, p0: str) -> int:
        """Preference to override the default EnSight color palette with a user predefined palette.
        
        | When EnSight starts, it looks for user defined function color palettes located under                 $CEI_HOME/ensight92/site_preferences/palettes and in the ./palettes directory found in the user's home directory. These files must be named palette_name.cpal, where the palette_name will be the name of the color palette  in the Simple Interface area of the function dialog.
        
        Args:
            p0:
                'predefined_palette_name' palette name
        
        Examples:
            ::
        
                ensight.prefs.default_palette("FASTDefaultPalette")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.default_palette({repr(p0)})'''
        return self._session.cmd(cmd)

    def detailrep_point_res(self, p0: int) -> int:
        """Prefs: detailrep_point_res

        """
        cmd = f'''ensight.prefs.detailrep_point_res({repr(p0)})'''
        return self._session.cmd(cmd)

    def fastdisplay_point_res(self, p0: int) -> int:
        """Allows specification of fraction of nodes to display in fast display-point representation. The default is 1 (indicating all nodes), 2 (would be every other node), 3 (every third node), etc.
        
        | May help performance. 
        
        Args:
            p0:
                'value' >= 1
        
        Examples:
            ::
        
                ensight.view.fast_display("ON")
                ensight.prefs.static_fast_display("ON")
                ensight.prefs.fastdisplay_point_res(2)
                ensight.part.select_begin(1,3,4)
                ensight.part.modify_begin()
                ensight.part.bounding_rep("points")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.fastdisplay_point_res({repr(p0)})'''
        return self._session.cmd(cmd)

    def fastdisplay_sparse_res(self, p0: int) -> int:
        """Allows specification of the percentage of the model geometry that will be displayed. The default is 50. The range is 1-100 where 1 would be sparse and 100 would be full.
        
        | Will help performance but will degrade quality in the graphics window while interactively transforming the model.
        
        Args:
            p0:
                'value' (1-100)
        
        Examples:
            ::
        
                ensight.view.fast_display("ON")
                ensight.prefs.static_fast_display("ON")
                ensight.prefs.fastdisplay_sparse_res(75)
                ensight.part.select_begin(1,3,4)
                ensight.part.modify_begin()
                ensight.part.bounding_rep("sparse_model")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.fastdisplay_sparse_res({repr(p0)})'''
        return self._session.cmd(cmd)

    def frame_mode_allowed(self, p0: str) -> int:
        """Will display Frame as one of the modes along the left side of the EnSight main interface.
        
        | As EnSight reads in model Parts, they are all initially assigned to the same Frame of reference: Frame 0. Frame 0 corresponds to the model coordinate system (defined when the model was created). Using the Frame mode, you can create additional frames, reassign parts to different frames, and specify various attributes of the frames.  By default frame mode is not available because frame mode is an advanced feature not normally used by first time users.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.frame_mode_allowed("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.frame_mode_allowed({repr(p0)})'''
        return self._session.cmd(cmd)

    def function_editor_type(self, p0: str) -> int:
        """Preference to set the default type of interface used for editing in the variable function editor.
        
        Args:
            p0:
                'interface_type'
        
                * must be one of:
                * simple
                * advanced
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.prefs.function_editor_type).
                ensight.prefs.function_editor_type("simple")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.function_editor_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def highlight_textfields(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.highlight_textfields({repr(p0)})'''
        return self._session.cmd(cmd)

    def icon_help_labels(self, p0: str) -> int:
        """Will cause a help label to appear below the mode icons along the left side of the main EnSight interface.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.icon_help_labels("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.icon_help_labels({repr(p0)})'''
        return self._session.cmd(cmd)

    def large_parts_list(self, p0: str) -> int:
        """Will cause a separate, larger parts list dialog (which can be expanded) to be used in place of the normal parts list.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.large_parts_list("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.large_parts_list({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_colorby(self, p0: str) -> int:
        """Specifies whether color palettes will be RGB or textures.
        
        Args:
            p0:
                'option'
        
                * RGB
                * textures
        
        Examples:
            ::
        
                # WARNING: following line includes OBSOLETE call (ensight.prefs.legend_colorby).
                ensight.prefs.legend_colorby("textures")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.legend_colorby({repr(p0)})'''
        return self._session.cmd(cmd)

    def macro_panel(self, p0: str) -> int:
        """Toggles on/off the user defined macro panel. This is normally used with VR devices and user defined input. The macro panel will be displayed in the main graphics window.
        
        | Users define the macro panel layout and actions in the ~/./macros/hum.define file.  An example hum.define file is located at $CEI_HOME/ensight92/src/udi/HUM/hum.define on your client system.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.macro_panel("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.macro_panel({repr(p0)})'''
        return self._session.cmd(cmd)

    def minimize_redraw(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.minimize_redraw({repr(p0)})'''
        return self._session.cmd(cmd)

    def model_axis_location(self, p0: float, p1: float) -> int:
        """Prefs: model_axis_location

        """
        cmd = f'''ensight.prefs.model_axis_location({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def new_data_notification(self, p0: str) -> int:
        """Tells client how to handle dynamic data updates.
        
        | Used in conjunction with the dynamic data interface
        
        Args:
            p0:
                'type'
        
                * auto_update
                * ignore
                * prompt
        
        Examples:
            ::
        
                ensight.prefs.new_data_notification("auto_update")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.new_data_notification({repr(p0)})'''
        return self._session.cmd(cmd)

    def nfaced_decomp_method(self, p0: str) -> int:
        """Prefs: nfaced_decomp_method

        """
        cmd = f'''ensight.prefs.nfaced_decomp_method({repr(p0)})'''
        return self._session.cmd(cmd)

    def number_of_peels(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.number_of_peels({repr(p0)})'''
        return self._session.cmd(cmd)

    def number_of_server_cpus(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.number_of_server_cpus({repr(p0)})'''
        return self._session.cmd(cmd)

    def optimize_geometry(self, p0: str) -> int:
        """Prefs: optimize_geometry

        """
        cmd = f'''ensight.prefs.optimize_geometry({repr(p0)})'''
        return self._session.cmd(cmd)

    def part_panel(self, p0: str) -> int:
        """Toggles on/off the part panel which allows users to select parts to operate on.  Normally used with VR devices and user defined input when the main part list is not visible (ie. Full screen graphics window).  The part panel will be displayed in the main graphics window.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.part_panel("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.part_panel({repr(p0)})'''
        return self._session.cmd(cmd)

    def partlist_details(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.partlist_details({repr(p0)})'''
        return self._session.cmd(cmd)

    def partlist_displayattr(self, p0: str, p1: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.partlist_displayattr({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def partlist_displaycase(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.partlist_displaycase({repr(p0)})'''
        return self._session.cmd(cmd)

    def partlist_displaytree(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.partlist_displaytree({repr(p0)})'''
        return self._session.cmd(cmd)

    def partlist_sort(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.partlist_sort({repr(p0)})'''
        return self._session.cmd(cmd)

    def plane_tool_type(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.plane_tool_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def prompt_on_quit(self, p0: str) -> int:
        """Prefs: prompt_on_quit

        """
        cmd = f'''ensight.prefs.prompt_on_quit({repr(p0)})'''
        return self._session.cmd(cmd)

    def resetlegend_ontimechange(self, p0: str) -> int:
        """Toggles on/off the preference of having the legend ranges update when time is changed or not.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.resetlegend_ontimechange("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.resetlegend_ontimechange({repr(p0)})'''
        return self._session.cmd(cmd)

    def starting_time_step(self, p0: str) -> int:
        """Preference to set the default starting time step for transient data.  When the data is read the first or the last step will be loaded as specified.
        
        Args:
            p0:
                'value'
        
                * must be one of:
                * first
                * last
        
        Examples:
            ::
        
                ensight.prefs.starting_time_step("last")
                ensight.data.binary_files_are("big_endian")
                ensight.data.format("case")
                ensight.data.path("/usr/tmp")
                ensight.data.geometry("car_crash.case")
                ensight.data.read()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.starting_time_step({repr(p0)})'''
        return self._session.cmd(cmd)

    def static_fast_display(self, p0: str) -> int:
        """Will cause the fast display representation to always be displayed when the fast display toggle is on.  If static_fast_display is off (the default), fast display will only be active during a transformation.
        
        | This is a performance enhancing attribute.  This attribute can be used to work with very large models.  Large models can be too slow in full element representation to manipulate (ie. transforming, positioning tools, etc.)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.fast_display("ON")
                ensight.prefs.static_fast_display("ON")
                ensight.part.select_begin(1,3,4)
                ensight.part.modify_begin()
                ensight.part.bounding_rep("points")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.static_fast_display({repr(p0)})'''
        return self._session.cmd(cmd)

    def tool_tips(self, p0: str) -> int:
        """Will cause pop-up help information to appear when the mouse is placed over certain icons while running EnSight.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.tool_tips("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.tool_tips({repr(p0)})'''
        return self._session.cmd(cmd)

    def transparency_resort(self, p0: str) -> int:
        """Prefs: transparency_resort

        """
        cmd = f'''ensight.prefs.transparency_resort({repr(p0)})'''
        return self._session.cmd(cmd)

    def transparency_sort(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.transparency_sort({repr(p0)})'''
        return self._session.cmd(cmd)

    def undo_redo_history_count(self, p0: int) -> int:
        """Prefs: undo_redo_history_count

        """
        cmd = f'''ensight.prefs.undo_redo_history_count({repr(p0)})'''
        return self._session.cmd(cmd)

    def use_continuous_perelem(self, p0: str) -> int:
        """If on, display element variables as per node for the purpose of creating contour (filled or line) images.
        
        | When on, the per element variable is averaged to the nodes using node count weighted algorithm.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                #
                # set the preference to show the per element colored as a per node variable
                ensight.prefs.use_continuous_perelem("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.use_continuous_perelem({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_defined_input(self, p0: str) -> int:
        """Toggles on/off the User Defined Input Device that is linked via a runtime library.  This is normally used with VR devices.
        
        | Steps outlining the implementation of this library and input device are found in the file: $CEI_HOME/ensight92/src/input/README.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.user_defined_input("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_defined_input({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_postranssens(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_postranssens({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_rotatesens(self, p0: float) -> int:
        """Specifies a scalar value that adjusts the sensitivity of rotates when using a User Defined Input Device (i.e. values < 1 are slower, and values > 1 are faster).
        
        | Steps outlining the implementation of the library for input devices are found in the file: $CEI_HOME/ensight92/src/input/README.
        
        Args:
            p0:
                'value' must be > 0.0
        
        Examples:
            ::
        
                ensight.prefs.user_defined_input("ON")
                ensight.prefs.user_input_rotateusing("Position")
                ensight.prefs.user_input_rotatesens(0.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_rotatesens({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_rotateusing(self, p0: str) -> int:
        """Allows selection of the type of rotation mode used for rotate transformations for the User Defined Input Device.
        
        | Steps outlining the implementation of the library for input devices are found in the file: $CEI_HOME/ensight92/src/input/README.
        
        Args:
            p0:
                'rotate_mode'
        
                * must be one of:
                * mixed_mode 
                * direct_mode
        
        Examples:
            ::
        
                ensight.prefs.user_defined_input("ON")
                ensight.prefs.user_input_rotateusing("direct_mode")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_rotateusing({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_rtzlimit(self, args: Any) -> int:
        """Prefs: user_input_rtzlimit

        """
        cmd = f'''ensight.prefs.user_input_rtzlimit({repr(args)})'''
        return self._session.cmd(cmd)

    def user_input_valtranssens(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_valtranssens({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_zoomsens(self, p0: float) -> int:
        """Specifies a value that adjusts the sensitivity of the zoom operation for the User Defined Input Device.
        
        | Steps outlining the implementation of the library for input devices are found in the file: $CEI_HOME/ensight92/src/input/README.
        
        Args:
            p0:
                'value' must be > 0.0  (< 1 slower, > 1 faster)
        
        Examples:
            ::
        
                ensight.prefs.user_defined_input("ON")
                ensight.prefs.user_input_zoomusing("position")
                ensight.prefs.user_input_zoomsens(1.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_zoomsens({repr(p0)})'''
        return self._session.cmd(cmd)

    def user_input_zoomusing(self, p0: str) -> int:
        """Allows selection of the mode used for zoom transformations for the User Defined Input Device.
        
        | Steps outlining the implementation of the library for input devices are found in the file: $CEI_HOME/ensight92/src/input/README.
        
        Args:
            p0:
                'mode'
        
                * must be one of:
                * valuator
                * position
        
        Examples:
            ::
        
                ensight.prefs.user_defined_input("ON")
                ensight.prefs.user_input_zoomusing("position")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.user_input_zoomusing({repr(p0)})'''
        return self._session.cmd(cmd)

    def view_mode_allowed(self, p0: str) -> int:
        """Will display View as one of the modes along the left side of the EnSight main interface.
        
        | View Mode is used to adjust the appearance of Parts in the Graphics Window (Perspective, Static Color, etc.), the visibility and appearance of Labels, to adjust Auxiliary Clipping status, and to toggle visibility of the Global Axis triad. By default, this mode is not available because the attributes are available under the View menu of the main interface.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.prefs.view_mode_allowed("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.prefs.view_mode_allowed({repr(p0)})'''
        return self._session.cmd(cmd)

    def vr_annotation_center(self, p0: float, p1: float, p2: float) -> int:
        """Prefs: vr_annotation_center

        """
        cmd = f'''ensight.prefs.vr_annotation_center({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def vr_annotation_normal(self, p0: float, p1: float, p2: float) -> int:
        """Prefs: vr_annotation_normal

        """
        cmd = f'''ensight.prefs.vr_annotation_normal({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def vr_annotation_scale(self, p0: float, p1: float) -> int:
        """Prefs: vr_annotation_scale

        """
        cmd = f'''ensight.prefs.vr_annotation_scale({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def vr_annotation_up(self, p0: float, p1: float, p2: float) -> int:
        """Prefs: vr_annotation_up

        """
        cmd = f'''ensight.prefs.vr_annotation_up({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def vr_view_center(self, p0: float, p1: float, p2: float) -> int:
        """Prefs: vr_view_center

        """
        cmd = f'''ensight.prefs.vr_view_center({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def vr_view_diagonal(self, p0: float) -> int:
        """Prefs: vr_view_diagonal

        """
        cmd = f'''ensight.prefs.vr_view_diagonal({repr(p0)})'''
        return self._session.cmd(cmd)

    def vr_view_scale(self, p0: float) -> int:
        """Prefs: vr_view_scale

        """
        cmd = f'''ensight.prefs.vr_view_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def vr_view_scalebydiagonal(self, p0: str) -> int:
        """Prefs: vr_view_scalebydiagonal

        """
        cmd = f'''ensight.prefs.vr_view_scalebydiagonal({repr(p0)})'''
        return self._session.cmd(cmd)


class pointpart:
    """Class wrapper for EnSight pointpart module

    This class acts as a proxy for the EnSight Python module ensight.pointpart
    """
    def __init__(self, session: Session):
        self._session = session

    def add_point(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.add_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def begin(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.begin()'''
        return self._session.cmd(cmd)

    def create(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.create({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete_points(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.delete_points()'''
        return self._session.cmd(cmd)

    def edit_point(self, p0: float, p1: float, p2: float) -> int:
        """Pointpart: edit_point

        """
        cmd = f'''ensight.pointpart.edit_point({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def elt_defined_by(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Args:
            p0:
                'option'
        
                * mesh_points_toline
                * mesh_points_totris
                * mesh_points_totris
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.elt_defined_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.end()'''
        return self._session.cmd(cmd)

    def load_from_file(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.load_from_file({repr(p0)})'''
        return self._session.cmd(cmd)

    def point_select_begin(self, *args, **kwargs) -> Any:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.pointpart.point_select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_all_points(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.select_all_points()'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.select_default()'''
        return self._session.cmd(cmd)

    def update_points(self, args: Any) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.pointpart.update_points({repr(args)})'''
        return self._session.cmd(cmd)


class plot:
    """Class wrapper for EnSight plot module

    This class acts as a proxy for the EnSight Python module ensight.plot
    """
    def __init__(self, session: Session):
        self._session = session

    def animate_curves(self, p0: str) -> int:
        """Turns animation of curves with time on or off  for the currently selected plot(s). For use with transient flipbook or keyframe animations.
        
        Args:
            p0:
                'toggle'
        
                * ON  (default)
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.animate_curves("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.animate_curves({repr(p0)})'''
        return self._session.cmd(cmd)

    def auto_scale(self, p0: str) -> int:
        """Plot: auto_scale

        """
        cmd = f'''ensight.plot.auto_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_autoscale(self, p0: str) -> int:
        """Plot: axis_2_autoscale

        """
        cmd = f'''ensight.plot.axis_2_autoscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_labelformat(self, p0: str) -> int:
        """Plot: axis_2_labelformat

        """
        cmd = f'''ensight.plot.axis_2_labelformat({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Plot: axis_2_labelrgb

        """
        cmd = f'''ensight.plot.axis_2_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_2_labelsize(self, p0: int) -> int:
        """Plot: axis_2_labelsize

        """
        cmd = f'''ensight.plot.axis_2_labelsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_labeltype(self, p0: str) -> int:
        """Plot: axis_2_labeltype

        """
        cmd = f'''ensight.plot.axis_2_labeltype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_max(self, p0: float) -> int:
        """Plot: axis_2_max

        """
        cmd = f'''ensight.plot.axis_2_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_min(self, p0: float) -> int:
        """Plot: axis_2_min

        """
        cmd = f'''ensight.plot.axis_2_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_title(self, p0: str) -> int:
        """Plot: axis_2_title

        """
        cmd = f'''ensight.plot.axis_2_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_titlergb(self, p0: float, p1: float, p2: float) -> int:
        """Plot: axis_2_titlergb

        """
        cmd = f'''ensight.plot.axis_2_titlergb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_2_titlesize(self, p0: int) -> int:
        """Plot: axis_2_titlesize

        """
        cmd = f'''ensight.plot.axis_2_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_variable(self, p0: Any) -> int:
        """Plot: axis_2_variable

        """
        cmd = f'''ensight.plot.axis_2_variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_2_visible(self, p0: str) -> int:
        """Plot: axis_2_visible

        """
        cmd = f'''ensight.plot.axis_2_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_auto_layout(self, p0: str) -> int:
        """Plot: axis_auto_layout

        """
        cmd = f'''ensight.plot.axis_auto_layout({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_auto_update(self, p0: str) -> int:
        """Plot: axis_auto_update

        """
        cmd = f'''ensight.plot.axis_auto_update({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_linewidth(self, p0: int) -> int:
        """Sets the axis line width of the currently selected plot(s).
        
        Args:
            p0:
                'width' specifies the width in pixels and can be any value from  1 to 4
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_linewidth(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the axis for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                #
                # Set the plot axis to blue
                #
                ensight.plot.axis_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_swap(self, p0: str) -> int:
        """Plot: axis_swap

        """
        cmd = f'''ensight.plot.axis_swap({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_swap_minmax(self, p0: str) -> int:
        """Swaps the axis min and max values for the specified axis of the currently selected plot.
        
        | By default the values increase along the axis.
        
        Args:
            p0:
                'axis'
        
                * must be either x or y
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_swap_minmax("x")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_swap_minmax({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_title(self, p0: str) -> int:
        """Plot: axis_title

        """
        cmd = f'''ensight.plot.axis_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_titles(self, p0: str) -> int:
        """Plot: axis_titles

        """
        cmd = f'''ensight.plot.axis_titles({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_autoscale(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_autoscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_gridtype(self, p0: str) -> int:
        """Specifies the type of grid that will be drawn for the x/y axis of the currently selected plot.
        
        |  The default grid type is tick.
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following values:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_gridtype("tick")
                ensight.plot.axis_y_gridtype("grid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelformat(self, p0: str) -> int:
        """Sets the format to be used for x/y axis value labels in the currently selected plot.
        
        Args:
            p0:
                'format' may be any valid C language print format string
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelformat("%.2e")
                ensight.plot.axis_y_labelformat("%.3e")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_labelformat({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the x/y axis label for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0.
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0.
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelrgb(0,0,1)
                ensight.plot.axis_y_labelrgb(1,0,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_x_labelsize(self, p0: int) -> int:
        """Sets the size of the x/y axis label text in the currently selected plot.
        
        Args:
            p0:
                'size' label text size; can be any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelsize(10)
                ensight.plot.axis_y_labelsize(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_labelsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_labeltype(self, p0: str) -> int:
        """Specifies how the x/y axis is labeled in the currently selected  plot.
        
        |  The default value for x/y axis label type is all.
        
        Args:
            p0:
                'label_type'
        
                * Can be any of the following values:
                * none
                * all
                * beg_end
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labeltype("none")
                ensight.plot.axis_y_labeltype("beg_end")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_labeltype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_max(self, p0: float) -> int:
        """Sets the maximum value for the x/y axis labels in the currently selected plot.
        
        Args:
            p0:
                'max' max label number on the axis; can be any valid floating-point value
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_max(9.5)
                ensight.plot.axis_y_max(5.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_min(self, p0: float) -> int:
        """Sets the minimum value for the x/y axis labels in the currently selected plot.
        
        Args:
            p0:
                'min' min label number on the axis; can be any valid floating-point value
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_min(1.5)
                ensight.plot.axis_y_min(1.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numgrid(self, p0: float) -> int:
        """Sets the number of grid lines to be used along the x/y axis of the currently selected plot(s).
        
        Args:
            p0:
                'num' number of grid lines along the axis; can be any whole number
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_numgrid(10)
                ensight.plot.axis_y_numgrid(6)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_numsubgrid(self, p0: float) -> int:
        """Sets the number of subgrid lines to be used along the x/y axis of the currently selected plot(s).
        
        | While the argument to this command is a floating-point value, the actual number of grid lines drawn will be truncated to an integer.
        
        Args:
            p0:
                'num' number of subgrid lines (or ticks) to be used between grid lines along an axis; can be any whole number
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_numsubgrid(2)
                ensight.plot.axis_y_numsubgrid(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_origin(self, p0: float) -> int:
        """Sets the value of the x/y axis origin for the currently selected plot(s).
        
        | The default x/y axis origin is 0.
        
        Args:
            p0:
                'origin' x or y location of origin within the plotter; range is the normalized values 0.0 to 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_origin(0.25)
                ensight.plot.axis_y_origin(0.18)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_origin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_scale(self, p0: str) -> int:
        """Selects the type of scale used for the x/y axis of the currently selected plot(s).
        
        |  The default scale is linear. 
        
        Args:
            p0:
                'scale_type'
        
                * one of the following:
                * linear
                * logarithmic
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_scale("logarithmic")
                ensight.plot.axis_y_scale("linear")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_sgridtype(self, p0: str) -> int:
        """Specifies the type of subgrid that will be drawn for the x/y axis of the currently selected  plot.
        
        |  The default subgrid type is none.
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following values:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_sgridtype("tick")
                ensight.plot.axis_y_sgridtype("grid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_size(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_title(self, p0: str) -> int:
        """Sets the title string for the x/y axis of the currently selected plot.
        
        Args:
            p0:
                'title' x/y axis title
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_title("Time in Seconds")
                ensight.plot.axis_y_title("Pressure")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_titlergb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the x/y axis title for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_titlergb(0,0,1)
                ensight.plot.axis_y_titlergb(0,1,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_titlergb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_x_titlesize(self, p0: int) -> int:
        """Sets the size of the x/y axis title in the currently selected plot.
        
        Args:
            p0:
                'size' axis title text size; can be any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_titlesize(10)
                ensight.plot.axis_y_titlesize(12)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_x_visible(self, p0: str) -> int:
        """Controls the visibility of the x/y axis of the currently selected plot(s).
        
        |  Plot axes are visible by default.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_visible("OFF")
                ensight.plot.axis_y_visible("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_x_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_autoscale(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_autoscale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_gridtype(self, p0: str) -> int:
        """Specifies the type of grid that will be drawn for the x/y axis of the currently selected plot.
        
        |  The default grid type is tick.
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following values:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_gridtype("tick")
                ensight.plot.axis_y_gridtype("grid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_gridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelformat(self, p0: str) -> int:
        """Sets the format to be used for x/y axis value labels in the currently selected plot.
        
        Args:
            p0:
                'format' may be any valid C language print format string
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelformat("%.2e")
                ensight.plot.axis_y_labelformat("%.3e")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_labelformat({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labelrgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the x/y axis label for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0.
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0.
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelrgb(0,0,1)
                ensight.plot.axis_y_labelrgb(1,0,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_labelrgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_y_labelsize(self, p0: int) -> int:
        """Sets the size of the x/y axis label text in the currently selected plot.
        
        Args:
            p0:
                'size' label text size; can be any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labelsize(10)
                ensight.plot.axis_y_labelsize(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_labelsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_labeltype(self, p0: str) -> int:
        """Specifies how the x/y axis is labeled in the currently selected  plot.
        
        |  The default value for x/y axis label type is all.
        
        Args:
            p0:
                'label_type'
        
                * Can be any of the following values:
                * none
                * all
                * beg_end
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_labeltype("none")
                ensight.plot.axis_y_labeltype("beg_end")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_labeltype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_max(self, p0: float) -> int:
        """Sets the maximum value for the x/y axis labels in the currently selected plot.
        
        Args:
            p0:
                'max' max label number on the axis; can be any valid floating-point value
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_max(9.5)
                ensight.plot.axis_y_max(5.3)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_max({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_min(self, p0: float) -> int:
        """Sets the minimum value for the x/y axis labels in the currently selected plot.
        
        Args:
            p0:
                'min' min label number on the axis; can be any valid floating-point value
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_min(1.5)
                ensight.plot.axis_y_min(1.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_min({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numgrid(self, p0: float) -> int:
        """Sets the number of grid lines to be used along the x/y axis of the currently selected plot(s).
        
        Args:
            p0:
                'num' number of grid lines along the axis; can be any whole number
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_numgrid(10)
                ensight.plot.axis_y_numgrid(6)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_numgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_numsubgrid(self, p0: float) -> int:
        """Sets the number of subgrid lines to be used along the x/y axis of the currently selected plot(s).
        
        | While the argument to this command is a floating-point value, the actual number of grid lines drawn will be truncated to an integer.
        
        Args:
            p0:
                'num' number of subgrid lines (or ticks) to be used between grid lines along an axis; can be any whole number
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_numsubgrid(2)
                ensight.plot.axis_y_numsubgrid(1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_numsubgrid({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_origin(self, p0: float) -> int:
        """Sets the value of the x/y axis origin for the currently selected plot(s).
        
        | The default x/y axis origin is 0.
        
        Args:
            p0:
                'origin' x or y location of origin within the plotter; range is the normalized values 0.0 to 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_origin(0.25)
                ensight.plot.axis_y_origin(0.18)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_origin({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_scale(self, p0: str) -> int:
        """Selects the type of scale used for the x/y axis of the currently selected plot(s).
        
        |  The default scale is linear. 
        
        Args:
            p0:
                'scale_type'
        
                * one of the following:
                * linear
                * logarithmic
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_scale("logarithmic")
                ensight.plot.axis_y_scale("linear")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_sgridtype(self, p0: str) -> int:
        """Specifies the type of subgrid that will be drawn for the x/y axis of the currently selected  plot.
        
        |  The default subgrid type is none.
        
        Args:
            p0:
                'grid_type'
        
                * Can be any of the following values:
                * none
                * grid
                * tick
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_sgridtype("tick")
                ensight.plot.axis_y_sgridtype("grid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_sgridtype({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_size(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_size({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_title(self, p0: str) -> int:
        """Sets the title string for the x/y axis of the currently selected plot.
        
        Args:
            p0:
                'title' x/y axis title
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_title("Time in Seconds")
                ensight.plot.axis_y_title("Pressure")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_titlergb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the x/y axis title for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_titlergb(0,0,1)
                ensight.plot.axis_y_titlergb(0,1,0)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_titlergb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def axis_y_titlesize(self, p0: int) -> int:
        """Sets the size of the x/y axis title in the currently selected plot.
        
        Args:
            p0:
                'size' axis title text size; can be any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_titlesize(10)
                ensight.plot.axis_y_titlesize(12)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_titlesize({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_variable(self, p0: Any) -> int:
        """Plot: axis_y_variable

        """
        cmd = f'''ensight.plot.axis_y_variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def axis_y_visible(self, p0: str) -> int:
        """Controls the visibility of the x/y axis of the currently selected plot(s).
        
        |  Plot axes are visible by default.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.axis_x_visible("OFF")
                ensight.plot.axis_y_visible("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.axis_y_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def background_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the background RGB color value for the currently selected plot(s).
        
        | Used only if plot: background_type is set to solid.
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.background_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.background_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def background_transparency(self, p0: float) -> int:
        """Plot: background_transparency

        """
        cmd = f'''ensight.plot.background_transparency({repr(p0)})'''
        return self._session.cmd(cmd)

    def background_type(self, p0: str) -> int:
        """Specifies the background type of the currently selected plot.
        
        | The default for plot background type is none.
        
        Args:
            p0:
                'type'
        
                * Can be any of the following values:
                * none
                * solid
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.background_type("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.background_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def border_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the border RGB color value for the currently selected plot(s).
        
        | Used only if plot: border_visible is set to ON.
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.border_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.border_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def border_visible(self, p0: str) -> int:
        """Controls the visibility of the border of the currently selected plot(s).
        
        | Plot borders are visible by default.
        | The border will be drawn according to plot: border_rgb
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.border_visible("ON")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.border_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def curve_title(self, p0: str) -> int:
        """Plot: curve_title

        """
        cmd = f'''ensight.plot.curve_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """Plot: delete

        """
        cmd = f'''ensight.plot.delete()'''
        return self._session.cmd(cmd)

    def delete_plot(self) -> int:
        """Deletes the currently selected plot(s).
        
        Examples:
            ::
        
                ensight.plot.select_begin(1,2,3)
                ensight.plot.delete_plot()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.delete_plot()'''
        return self._session.cmd(cmd)

    def detached_background_rgb(self, p0: float, p1: float, p2: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.detached_background_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def detached_window(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.detached_window({repr(p0)})'''
        return self._session.cmd(cmd)

    def entity_select_begin(self) -> int:
        """Plot: entity_select_begin

        """
        cmd = f'''ensight.plot.entity_select_begin()'''
        return self._session.cmd(cmd)

    def entity_select_end(self) -> int:
        """Plot: entity_select_end

        """
        cmd = f'''ensight.plot.entity_select_end()'''
        return self._session.cmd(cmd)

    def graph_title(self, p0: str) -> int:
        """Plot: graph_title

        """
        cmd = f'''ensight.plot.graph_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def graph_titles(self, p0: str) -> int:
        """Plot: graph_titles

        """
        cmd = f'''ensight.plot.graph_titles({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linetype(self, p0: str) -> int:
        """Specifies the type of grid lines that will be drawn for the currently selected  plot.
        
        | The grid line_type is solid by default.
        
        Args:
            p0:
                'line_type'
        
                * Can be any of the following values:
                * solid
                * dotted
                * dash
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.grid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.grid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_linewidth(self, p0: int) -> int:
        """Sets the grid line width of the currently selected plot(s).
        
        Args:
            p0:
                'width' specifies the line width in pixels of the grid lines, and can be any value from 1 to 4
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.grid_linewidth(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.grid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def grid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the grid for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.grid_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.grid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def group(self, p0: str) -> int:
        """Plot: group

        """
        cmd = f'''ensight.plot.group({repr(p0)})'''
        return self._session.cmd(cmd)

    def height(self, p0: float) -> int:
        """Sets the height of the currently selected plot.
        
        | Plots are drawn in reference to the graphics window.  A value of 1.0 is the height of the window.
        
        Args:
            p0:
                'height' height of plot viewport in normalized coordinates, namely any value between 0 and 1.0, with a value of one corresponding to the height of the graphics window
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.width(0.5)
                ensight.plot.height(0.4)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.height({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_color_by(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_color_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_minmax_origin_x(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_minmax_origin_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_minmax_origin_y(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_minmax_origin_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_minmax_textsize(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_minmax_textsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_minmax_visible(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_minmax_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_origin_x(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_origin_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_origin_y(self, p0: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_origin_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the legend for the currently selected plot(s).
        
        | Used only if plot: legend_visible is ON.
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.legend_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def legend_textsize(self, p0: int) -> int:
        """Sets the size of legend text in the currently selected plot.
        
        Args:
            p0:
                'size' size of legend text; any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.legend_textsize(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_textsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def legend_visible(self, p0: str) -> int:
        """Controls the visibility of the legend for the currently selected plot(s).
        
        |  Plot legends are visible by default. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.legend_visible("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.legend_visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def new_plot(self) -> int:
        """Plot: new_plot

        """
        cmd = f'''ensight.plot.new_plot()'''
        return self._session.cmd(cmd)

    def new_plot_ifnotexist(self, p0: int) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.new_plot_ifnotexist({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin_x(self, p0: float) -> int:
        """Specifies the x/y coordinate of the origin of the selected plot in the graphics window.
        
        | The origin of the plot will be positioned at  this point (x,y) in the graphics window 
        
        Args:
            p0:
                'coord' normalized coordinate of lower left corner of the plot viewport. A value of 0.0 indicates the left/bottom side of the window, while a value of 1.0 indicates the right/top side.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.origin_x(0.5)
                ensight.plot.origin_y(0.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.origin_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def origin_y(self, p0: float) -> int:
        """Specifies the x/y coordinate of the origin of the selected plot in the graphics window.
        
        | The origin of the plot will be positioned at  this point (x,y) in the graphics window 
        
        Args:
            p0:
                'coord' normalized coordinate of lower left corner of the plot viewport. A value of 0.0 indicates the left/bottom side of the window, while a value of 1.0 indicates the right/top side.
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.origin_x(0.5)
                ensight.plot.origin_y(0.5)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.origin_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def plot_activate(self) -> int:
        """Plot: plot_activate

        """
        cmd = f'''ensight.plot.plot_activate()'''
        return self._session.cmd(cmd)

    def plot_desc(self, p0: str) -> int:
        """Plot: plot_desc

        """
        cmd = f'''ensight.plot.plot_desc({repr(p0)})'''
        return self._session.cmd(cmd)

    def plot_title(self, p0: str) -> int:
        """Sets the title string for the currently selected plot.
        
        Args:
            p0:
                'title' plot title
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.plot_title("My Plot Title")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.plot_title({repr(p0)})'''
        return self._session.cmd(cmd)

    def query_count(self, args: Any) -> int:
        """Plot: query_count

        """
        cmd = f'''ensight.plot.query_count({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Plot: query_display_attributes

        """
        cmd = f'''ensight.plot.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_object_atwindowxy(self, args: Any) -> int:
        """Plot: query_object_atwindowxy

        """
        cmd = f'''ensight.plot.query_object_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_objects_atwindowxy(self, args: Any) -> int:
        """Plot: query_objects_atwindowxy

        """
        cmd = f'''ensight.plot.query_objects_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def rescale(self, p0: str) -> int:
        """Plot: rescale

        """
        cmd = f'''ensight.plot.rescale({repr(p0)})'''
        return self._session.cmd(cmd)

    def restore(self, p0: str) -> int:
        """Plot: restore

        """
        cmd = f'''ensight.plot.restore({repr(p0)})'''
        return self._session.cmd(cmd)

    def save(self, p0: str) -> int:
        """Plot: save

        """
        cmd = f'''ensight.plot.save({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """Selects all of the plots in the graphics window as the target for future plot: commands.
        
        Examples:
            ::
        
                ensight.plot.select_all()
                ensight.plot.delete_plot()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.select_all()'''
        return self._session.cmd(cmd)

    def select_axis(self, p0: str) -> int:
        """Plot: select_axis

        """
        cmd = f'''ensight.plot.select_axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Selects one or more plots in the graphics window as the  target for future plot: commands 
        
        Args:
            p0:
                'indexN' plot number (zero based). Up to 10 numbers per line are allowed, but as many lines as needed can be used
        
        Examples:
            ::
        
                ensight.plot.select_begin(1,2)
                ensight.plot.delete_plot()
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.plot.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Plot: select_default

        """
        cmd = f'''ensight.plot.select_default()'''
        return self._session.cmd(cmd)

    def subgrid_linetype(self, p0: str) -> int:
        """Specifies the type of subgrid lines that will be drawn for the currently selected  plot.
        
        | The subgrid line_type is solid by default
        
        Args:
            p0:
                'line_type'
        
                * Can be any of the following values:
                * solid
                * dotted
                * dash
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.subgrid_linetype("solid")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.subgrid_linetype({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_linewidth(self, p0: int) -> int:
        """Sets the subgrid line width of the currently selected plot(s).
        
        Args:
            p0:
                'width' the line width in pixels for subgrid lines (or tics); can be any value from 1 to 4
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.subgrid_linewidth(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.subgrid_linewidth({repr(p0)})'''
        return self._session.cmd(cmd)

    def subgrid_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the subgrid for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.subgrid_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.subgrid_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def time_marker(self, p0: str) -> int:
        """Controls the visibility of the time marker in the selected plot(s). For use with transient flipbook or keyframe animations.
        
        | The time marker is visible by default. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.animate_curves("ON")
                ensight.plot.time_marker("ON")
                ensight.plot.time_marker_rgb(1.0,1.0,0.0)
                ensight.plot.time_marker_style("dotted")
                ensight.plot.time_marker_width(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.time_marker({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_marker_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Controls the color of the time marker in the selected plot(s). For use with transient flipbook or keyframe animations.
        
        | The time marker is white by default. 
        
        Args:
            p0:
                'red_val' red, green, blue contributions of the color (0.0 to 1.0)
            p1:
                'grn_val' red, green, blue contributions of the color (0.0 to 1.0)
            p2:
                'blu_val' red, green, blue contributions of the color (0.0 to 1.0)
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.animate_curves("ON")
                ensight.plot.time_marker("ON")
                ensight.plot.time_marker_rgb(1.0,1.0,0.0)
                ensight.plot.time_marker_style("dotted")
                ensight.plot.time_marker_width(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.time_marker_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def time_marker_style(self, p0: str) -> int:
        """Controls the line style of the time marker in the selected plot(s). For use with transient flipbook or keyframe animations.
        
        | The time marker is solid by default. 
        
        Args:
            p0:
                'style'
        
                * solid
                * dotted
                * dash
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.animate_curves("ON")
                ensight.plot.time_marker("ON")
                ensight.plot.time_marker_rgb(1.0,1.0,0.0)
                ensight.plot.time_marker_style("dotted")
                ensight.plot.time_marker_width(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.time_marker_style({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_marker_value(self, p0: str) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.time_marker_value({repr(p0)})'''
        return self._session.cmd(cmd)

    def time_marker_width(self, p0: int) -> int:
        """Controls the width of the time marker in the selected plot(s). For use with transient flipbook or keyframe animations.
        
        | The time marker is 2 pixels wide by default. 
        
        Args:
            p0:
                'width' number of pixels in width of the marker line
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.animate_curves("ON")
                ensight.plot.time_marker("ON")
                ensight.plot.time_marker_rgb(1.0,1.0,0.0)
                ensight.plot.time_marker_style("dotted")
                ensight.plot.time_marker_width(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.time_marker_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def title_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Specifies the RGB color value of the title for the currently selected plot(s).
        
        Args:
            p0:
                'red_val' red, green, blue color components, must be between 0.0 and 1.0
            p1:
                'grn_val' red, green, blue color components, must be between 0.0 and 1.0
            p2:
                'blu_val' red, green, blue color components, must be between 0.0 and 1.0
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.title_rgb(0,0,1)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.title_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def title_textsize(self, p0: int) -> int:
        """Sets the size of title text in the currently selected plot. 
        
        Args:
            p0:
                'size' size of title text; any value from 1 to 100.0, with a value of one specifying the smallest text and 100 the largest 
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.title_textsize(10)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.title_textsize({repr(p0)})'''
        return self._session.cmd(cmd)

    def unplot_deactivate(self) -> int:
        """Plot: unplot_deactivate

        """
        cmd = f'''ensight.plot.unplot_deactivate()'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Controls the visibility of the selected plot(s) in the graphics window.
        
        | Plots are visible by default. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.visible("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def width(self, p0: float) -> int:
        """Sets the width of the currently selected plot. 
        
        Args:
            p0:
                'width' width of plot viewport in normalized coordinates, namely any value between 0 and 1.0, with a value of 1.0 corresponding to the width of the graphics window
        
        Examples:
            ::
        
                ensight.plot.select_begin(1)
                ensight.plot.width(0.5)
                ensight.plot.height(0.4)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.plot.width({repr(p0)})'''
        return self._session.cmd(cmd)


class part:
    """Class wrapper for EnSight part module

    This class acts as a proxy for the EnSight Python module ensight.part
    """
    def __init__(self, session: Session):
        self._session = session

    def active(self, p0: str) -> int:
        """Activates or deactivates the currently selected part(s).
        
        | When a part is deactivated, the data for that part will not be updated from the server on any future timestep changes, until the part is activated again
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.active("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.active({repr(p0)})'''
        return self._session.cmd(cmd)

    def allow_default_editing(self) -> int:
        """Allow or disallow editing of part defaults.
        
        | This is a command for preferences and is written out in the ensight_allparts_prefs.def file.
        | If the user edits a part attribute when no parts are selected the default is normally edited.  With this toggle OFF the user will no be able to edit part defaults.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.allow_default_editing("OFF")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.allow_default_editing()'''
        return self._session.cmd(cmd)

    def alpha_by(self, p0: str) -> int:
        """Part: alpha_by

        """
        cmd = f'''ensight.part.alpha_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def alpha_by_palette(self, args: Any) -> int:
        """Part: alpha_by_palette

        """
        cmd = f'''ensight.part.alpha_by_palette({repr(args)})'''
        return self._session.cmd(cmd)

    def alpha_by_subpalette(self, args: Any) -> int:
        """Part: alpha_by_subpalette

        """
        cmd = f'''ensight.part.alpha_by_subpalette({repr(args)})'''
        return self._session.cmd(cmd)

    def begin(self) -> int:
        """Part: begin

        """
        cmd = f'''ensight.part.begin()'''
        return self._session.cmd(cmd)

    def blank_elts(self, p0: float, p1: float, p2: float, p3: float) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.blank_elts({repr(p0)},{repr(p1)},{repr(p2)},{repr(p3)})'''
        return self._session.cmd(cmd)

    def bounding_rep(self, p0: str) -> int:
        """Specifies the type of fast-display representation used to for the currently selected part(s).
        
        | For reduced, uses factor as set by part: reduce_polygons_factor <factor>.
        
        Args:
            p0:
                'type'
        
                * Can have any of the following values:
                * OFF
                * box
                * points
                * sparse_model
                * reduced
                * invisible
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.bounding_rep("sparse_model")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.bounding_rep({repr(p0)})'''
        return self._session.cmd(cmd)

    def clear_blanked_elts(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.clear_blanked_elts()'''
        return self._session.cmd(cmd)

    def clearall_blanked_elts(self) -> int:
        """This command has not yet been documented.
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.clearall_blanked_elts()'''
        return self._session.cmd(cmd)

    def clip(self, p0: str) -> int:
        """Turns auxiliary clipping on or off for the currently selected part(s).
        
        | The global toggle for auxiliary clipping must be on - See view: clipping
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.clipping("ON")
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.clip("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.clip({repr(p0)})'''
        return self._session.cmd(cmd)

    def clone(self, p0: int, p1: int) -> int:
        """Part: clone

        """
        cmd = f'''ensight.part.clone({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def clone_byname(self, p0: str, p1: str) -> int:
        """Part: clone_byname

        """
        cmd = f'''ensight.part.clone_byname({repr(p0)},{repr(p1)})'''
        return self._session.cmd(cmd)

    def collect(self, p0: str) -> int:
        """Part: collect

        """
        cmd = f'''ensight.part.collect({repr(p0)})'''
        return self._session.cmd(cmd)

    def colorby_palette(self, args: Any) -> int:
        """Colors the currently selected part(s) based on the value of the specified variable at each node or element (depending on whether data is node or element based) 
        
        Args:
            p0:
                'varname' the name of an existing variable (or the word "none") 
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.colorby_palette("pressure")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.colorby_palette({repr(args)})'''
        return self._session.cmd(cmd)

    def colorby_rgb(self, p0: float, p1: float, p2: float) -> int:
        """Colors the currently selected part(s) using the specified rgb value.
        
        Args:
            p0:
                'red_val' red, green, blue color components (must be between 0.0 and 1.0)
            p1:
                'grn_val' red, green, blue color components (must be between 0.0 and 1.0)
            p2:
                'blu_val' red, green, blue color components (must be between 0.0 and 1.0)
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1.0,0.4,0.0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.colorby_rgb({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def colorby_selected_var(self) -> int:
        """Colors a part by the palette tied to the variable selected in the main variable list.
        
        | Used with the HUM to tie parts selected to variables selected.
        
        Examples:
            ::
        
                ensight.variables.get_mainvarlist_select()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_selected_var()
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.colorby_selected_var()'''
        return self._session.cmd(cmd)

    def colorby_subpalette(self, args: Any) -> int:
        """Part: colorby_subpalette

        """
        cmd = f'''ensight.part.colorby_subpalette({repr(args)})'''
        return self._session.cmd(cmd)

    def copy(self) -> int:
        """Creates a copy of the currently selected part(s).
        
        | The Copy operation creates a dependent copy of the original part.
        | The copy is created on the client and its existence is not known to the EnSight Server process. A copy shares geometric data and variable data with the original part.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.copy()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.copy()'''
        return self._session.cmd(cmd)

    def copy_noframecreate(self) -> int:
        """Part: copy_noframecreate

        """
        cmd = f'''ensight.part.copy_noframecreate()'''
        return self._session.cmd(cmd)

    def create_assign_viewport(self) -> int:
        """Creates a new viewport and assigns the currently selected part(s) to it.
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                ensight.part.create_assign_viewport()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.create_assign_viewport()'''
        return self._session.cmd(cmd)

    def create_assign_viewports(self) -> int:
        """Creates a new viewport for each of the currently selected part(s) and assigns one part to each viewport.
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                ensight.part.create_assign_viewports()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.create_assign_viewports()'''
        return self._session.cmd(cmd)

    def cull_elements(self, p0: str) -> int:
        """Part: cull_elements

        """
        cmd = f'''ensight.part.cull_elements({repr(p0)})'''
        return self._session.cmd(cmd)

    def cut_remove(self) -> int:
        """Part: cut_remove

        """
        cmd = f'''ensight.part.cut_remove()'''
        return self._session.cmd(cmd)

    def cut_split(self) -> int:
        """Part: cut_split

        """
        cmd = f'''ensight.part.cut_split()'''
        return self._session.cmd(cmd)

    def delete(self) -> int:
        """Deletes the currently selected part(s).
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.delete()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.delete()'''
        return self._session.cmd(cmd)

    def description(self, p0: str) -> int:
        """Specifies a description string for the currently selected part.  This string will appear in lists that include the part.
        
        Args:
            p0:
                'desc' name that will show up in the user interface; can be up to 50 characters in length
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.description("compressor inlet")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.description({repr(p0)})'''
        return self._session.cmd(cmd)

    def displace_by(self, p0: Any) -> int:
        """Specifies the variable to be used to displace the nodes and elements of the currently selected part(s).
        
        | The displacement factor can be changed before or after the part: displace_by command is issued.
        
        Args:
            p0:
                'variable_name' name of an activated variable
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.displace_factor(0.9)
                ensight.part.displace_by("pressure")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.displace_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def displace_factor(self, p0: float) -> int:
        """Specifies the displacement factor to be applied to the source variable to calculate displacement for the currently selected part(s).
        
        | The displacement factor can be changed before or after the part: displace_by command is issued.  
        
        Args:
            p0:
                'disp_factor' the scaling factor that will be applied to the displacement values.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.displace_factor(0.9)
                ensight.part.displace_by("pressure")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.displace_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def double_sided(self, p0: str) -> int:
        """Part: double_sided

        """
        cmd = f'''ensight.part.double_sided({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_blanking(self, p0: str) -> int:
        """Specifies whether element blanking is allowed for the part.
        
        Args:
            p0:
                ' toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.elt_blanking("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_blanking({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_logicalop(self, p0: str) -> int:
        """Specifies the logical operation to use for element failure.
        
        Args:
            p0:
                ' operation'
        
                * and
                * or
                * none
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_logicalop({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_op1(self, p0: str) -> int:
        """Specifies the relational operation to use for element failure.
        
        Args:
            p0:
                ' operation'
        
                * >
                * <
                * =
                * !=
                * Not used
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_op1({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_op1value(self, p0: float) -> int:
        """Specifies the values for the operations for element failure.
        
        Args:
            p0:
                ' value' the values 
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_op1value({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_op2(self, p0: str) -> int:
        """Specifies the relational operation to use for element failure.
        
        Args:
            p0:
                ' operation'
        
                * >
                * <
                * =
                * !=
                * Not used
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_op2({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_op2value(self, p0: float) -> int:
        """Specifies the values for the operations for element failure.
        
        Args:
            p0:
                ' value' the values 
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_op2value({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_failure_variable(self, p0: Any) -> int:
        """Specifies the variable to use for element failure.
        
        | Must be a per-element variable.
        
        Args:
            p0:
                ' var_name' the name of the variable to use for element failure
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_variable).
                ensight.part.elt_failure_variable("NodeToElem")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1).
                ensight.part.elt_failure_op1("<")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2).
                ensight.part.elt_failure_op2(">")
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op1value).
                ensight.part.elt_failure_op1value(2.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_op2value).
                ensight.part.elt_failure_op2value(5.00000e-01)
                # WARNING: following line includes OBSOLETE call (ensight.part.elt_failure_logicalop).
                ensight.part.elt_failure_logicalop("or")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_failure_variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_feature_angle(self, p0: float) -> int:
        """Specifies the angle to be used in feature angle element representation for the currently selected part(s).
        
        Args:
            p0:
                ' angle' angle between adjacent polygons, above which the edge will be drawn, below which the edge will not be drawn. the range is 0.0 to 180.0 degrees
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.elt_representation("feature_angle")
                ensight.part.elt_feature_angle(20.0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_feature_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_rep_pointsnormals(self, p0: str) -> int:
        """Allow option to load the given element representation as points + normals.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.modify_begin()
                ensight.part.elt_rep_pointsnormals("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_rep_pointsnormals({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_representation(self, p0: str) -> int:
        """Specifies the type of element representation used for the currently selected part(s).
        
        Args:
            p0:
                'type'
        
                * can have any of the following values:
                * 3D_border_2D_full
                * border
                * feature angle
                * full
                * not_loaded
                * bounding_box
                * 3D_feature_2D_full
                * 3D_notloaded_2D_full
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.elt_representation("full")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_representation({repr(p0)})'''
        return self._session.cmd(cmd)

    def elt_shrink_factor(self, p0: float) -> int:
        """Specifies a scaling factor (fraction) by which to shrink every element toward its centroid.
        
        Args:
            p0:
                'scale_factor' shrinkage factor which must be within the range of 0.0 to 1.0. The default is 0.0 for no shrinkage.  If set to 1.0, elements will completely disappear.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.elt_shrink_factor(0.5)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.elt_shrink_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def end(self) -> int:
        """Part: end

        """
        cmd = f'''ensight.part.end()'''
        return self._session.cmd(cmd)

    def entity_label_elt(self, p0: str) -> int:
        """Turns element labeling on or off for the currently selected part(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.entity_label_elt("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.entity_label_elt({repr(p0)})'''
        return self._session.cmd(cmd)

    def entity_label_node(self, p0: str) -> int:
        """Turns node labeling on or off for the currently selected part(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.entity_label_node("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.entity_label_node({repr(p0)})'''
        return self._session.cmd(cmd)

    def entity_label_part(self, p0: str) -> int:
        """Part: entity_label_part

        """
        cmd = f'''ensight.part.entity_label_part({repr(p0)})'''
        return self._session.cmd(cmd)

    def extract(self) -> int:
        """Creates an extract of the currently selected part(s).
        
        | Extracts a new part from the selected part(s)  using the part representation in effect at the time (full, border, or feature). If more than one part is selected, then they are joined into a single part which is assigned to Frame 0.
        | The part: extract command creates a new part using the geometry of the current representation (what you see is what you get). Extracted parts which are in Full Representation are actual copies of the original, but extracted parts which are in Border Representation are only the shell or boundary of the original.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.extract()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.extract()'''
        return self._session.cmd(cmd)

    def fill_pattern(self, p0: int) -> int:
        """Specifies a fill pattern of variable transparency to be used on the surfaces of the currently selected part(s).
        
        | This command provides a means of simulating surface transparency which requires less computation than true transparency.  Part opaqueness (controlled by the part: opaqueness command) must be 1.0 in order for part: fill_pattern to take effect.
        
        Args:
            p0:
                'pattern_num' must be within the range of  0 to 3.  transparency value of 0 specifies an opaque surface, while a value of 3 specifies a sparse (transparent) fill pattern
        
        Examples:
            ::
        
                ensight.view.hidden_surface("ON")
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.hidden_surface("ON")
                ensight.part.fill_pattern(2)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.fill_pattern({repr(p0)})'''
        return self._session.cmd(cmd)

    def get_mainpartlist_select(self) -> int:
        """Causes the parts highlighted in the main part list to become the currently selected parts.
        
        Examples:
            ::
        
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.mirror_original("OFF")
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.get_mainpartlist_select()'''
        return self._session.cmd(cmd)

    def get_mouseclick_select(self) -> int:
        """Part: get_mouseclick_select

        """
        cmd = f'''ensight.part.get_mouseclick_select()'''
        return self._session.cmd(cmd)

    def group(self, p0: str) -> int:
        """Groups the currently selected parts into a group with the specified name.
        
        Args:
            p0:
                'groupname' name of the group
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                # WARNING: following line includes OBSOLETE call (ensight.part.group).
                ensight.part.group("yinyang")
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.group({repr(p0)})'''
        return self._session.cmd(cmd)

    def hidden_line(self, p0: str) -> int:
        """Causes lines which are behind any portion of the currently selected part(s) to not be drawn.
        
        | The part: hidden_line command also causes the visible drawing lines to be rendered on shaded surfaces of the currently selected part(s).  View: hidden_line ON must be issued in order for  part: hidden_line ON to take effect.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.hidden_line("ON")
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.hidden_line("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.hidden_line({repr(p0)})'''
        return self._session.cmd(cmd)

    def hidden_surface(self, p0: str) -> int:
        """Causes the currently selected part(s) to be drawn with shaded surfaces.
        
        | View: hidden_surface ON must be issued in order for part: hidden_surface ON to take effect. 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.view.hidden_surface("ON")
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.hidden_surface("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.hidden_surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def ijk_axis(self, p0: str) -> int:
        """Part: ijk_axis

        """
        cmd = f'''ensight.part.ijk_axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def ijk_axis_scale(self, p0: float) -> int:
        """Part: ijk_axis_scale

        """
        cmd = f'''ensight.part.ijk_axis_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_ambient(self, p0: float) -> int:
        """Part: light_ambient

        """
        cmd = f'''ensight.part.light_ambient({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_diff(self, p0: float) -> int:
        """Specifies the lighting diffusion value used in shading the surfaces of the currently selected part(s).
        
        Args:
            p0:
                'diffuse' diffuse light value, must be within the range of 0.0 to 1.0
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.light_diff).
                ensight.part.light_diff(0.9)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.light_diff({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_diffuse(self, p0: float) -> int:
        """Part: light_diffuse

        """
        cmd = f'''ensight.part.light_diffuse({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_emissive(self, p0: float) -> int:
        """Part: light_emissive

        """
        cmd = f'''ensight.part.light_emissive({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_h_int(self, p0: float) -> int:
        """Specifies the highlight intensity value used in shading the surfaces of the currently selected part(s).
        
        Args:
            p0:
                'intensity' highlight intensity, must be within the range of 0.0 to 1.0
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.light_h_int).
                ensight.part.light_h_int(0.5)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.light_h_int({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_refraction(self, p0: float) -> int:
        """Part: light_refraction

        """
        cmd = f'''ensight.part.light_refraction({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_shin(self, p0: float) -> int:
        """Specifies the "shinyness" value used in shading the surfaces of the currently selected part(s).
        
        | Highlight intensity (part: light_h_int) must be non-zero for shinyness to have any effect.
        
        Args:
            p0:
                'shiny' "shinyness" value, must be within the range of 1.0 to 100.0 . Lower values specify less shine
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.light_h_int).
                ensight.part.light_h_int(0.9)
                # WARNING: following line includes OBSOLETE call (ensight.part.light_shin).
                ensight.part.light_shin(50.0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.light_shin({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_specular_intensity(self, p0: float) -> int:
        """Part: light_specular_intensity

        """
        cmd = f'''ensight.part.light_specular_intensity({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_specular_reflection(self, p0: float) -> int:
        """Part: light_specular_reflection

        """
        cmd = f'''ensight.part.light_specular_reflection({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_specular_shine(self, p0: float) -> int:
        """Part: light_specular_shine

        """
        cmd = f'''ensight.part.light_specular_shine({repr(p0)})'''
        return self._session.cmd(cmd)

    def light_specular_tint(self, p0: float) -> int:
        """Part: light_specular_tint

        """
        cmd = f'''ensight.part.light_specular_tint({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_hidden_line(self, p0: str) -> int:
        """Part: line_hidden_line

        """
        cmd = f'''ensight.part.line_hidden_line({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_style(self, p0: str) -> int:
        """Specifies the line style used to draw the currently selected part(s).
        
        Args:
            p0:
                'style'
        
                * can have any of the following values:
                * solid
                * dotted
                * dot_dash
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.line_style("dotted")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.line_style({repr(p0)})'''
        return self._session.cmd(cmd)

    def line_width(self, p0: int) -> int:
        """Specifies the line width in pixels used to draw the currently selected part(s).
        
        Args:
            p0:
                'width' pixel width of line; must be within the range of  1 to 4.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.line_width(2)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.line_width({repr(p0)})'''
        return self._session.cmd(cmd)

    def material_base_type(self, p0: str) -> int:
        """Part: material_base_type

        """
        cmd = f'''ensight.part.material_base_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def merge(self) -> int:
        """Merges the currently selected parts into a single part.
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                ensight.part.merge()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.merge()'''
        return self._session.cmd(cmd)

    def mirror_original(self, p0: str) -> int:
        """Turns visibility of the non-mirrored currently selected parts on or off.
        
        | This command is normally used to remove the original image of parts which have been mirrored in one or more dimensions 
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.mirror_z).
                ensight.part.mirror_z("ON")
                ensight.part.mirror_original("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.mirror_original({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_x(self, p0: str) -> int:
        """Part: mirror_x

        """
        cmd = f'''ensight.part.mirror_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_xy(self, p0: str) -> int:
        """Part: mirror_xy

        """
        cmd = f'''ensight.part.mirror_xy({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_xyz(self, p0: str) -> int:
        """Part: mirror_xyz

        """
        cmd = f'''ensight.part.mirror_xyz({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_xz(self, p0: str) -> int:
        """Part: mirror_xz

        """
        cmd = f'''ensight.part.mirror_xz({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_y(self, p0: str) -> int:
        """Part: mirror_y

        """
        cmd = f'''ensight.part.mirror_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_yz(self, p0: str) -> int:
        """Part: mirror_yz

        """
        cmd = f'''ensight.part.mirror_yz({repr(p0)})'''
        return self._session.cmd(cmd)

    def mirror_z(self, p0: str) -> int:
        """Part: mirror_z

        """
        cmd = f'''ensight.part.mirror_z({repr(p0)})'''
        return self._session.cmd(cmd)

    def modify_begin(self) -> int:
        """These commands are used to demarcate part attribute changing commands.  The attributes within them will be changed when the modify_end is reached.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.visibility_node("ON")
                ensight.part.node_type("sphere")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.modify_begin()'''
        return self._session.cmd(cmd)

    def modify_end(self) -> int:
        """These commands are used to demarcate part attribute changing commands.  The attributes within them will be changed when the modify_end is reached.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.visibility_node("ON")
                ensight.part.node_type("sphere")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.modify_end()'''
        return self._session.cmd(cmd)

    def node_detail(self, p0: int) -> int:
        """Sets the detail level for drawing spherical nodes in the currently selected part(s).
        
        | Higher values of level result in more polygons being used to draw the spheres. 
        
        Args:
            p0:
                'level' detail level for the spheres used to represent the nodes; must be within the range of  2 to 10.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.node_type("sphere")
                ensight.part.node_detail(5)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.node_detail({repr(p0)})'''
        return self._session.cmd(cmd)

    def node_scale(self, p0: float) -> int:
        """Sets the scale factor used to determine node size for the currently selected part(s).
        
        Args:
            p0:
                'scale' scaling factor to be applied to the node cross or sphere representation; can be any valid floating point value
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.node_scale(1.5)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.node_scale({repr(p0)})'''
        return self._session.cmd(cmd)

    def node_size_by(self, p0: str) -> int:
        """Selects the source for calculating node size in the currently selected part(s).
        
        Args:
            p0:
                'source_type'
        
                * Can have any of the following values:
                * constant
                * scalar
                * vector_mag
                * vector_xcomp
                * vector_ycomp
                * vector_zcomp
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.node_type("sphere")
                ensight.part.node_size_by("vector_mag")
                ensight.part.node_variable("velocity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.node_size_by({repr(p0)})'''
        return self._session.cmd(cmd)

    def node_type(self, p0: str) -> int:
        """Selects the node representation mode for the currently selected part(s).
        
        Args:
            p0:
                'type'
        
                * dot
                * cross
                * sphere
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.node_type("sphere")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.node_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def node_variable(self, p0: Any) -> int:
        """Specifies the variable to be used in calculating the size of spherical nodes in the currently  selected part(s).
        
        Args:
            p0:
                'variable_name' the name of an activated variable
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.node_type("sphere")
                ensight.part.node_size_by("vector_mag")
                ensight.part.node_variable("velocity")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.node_variable({repr(p0)})'''
        return self._session.cmd(cmd)

    def opacity(self, p0: float) -> int:
        """Part: opacity

        """
        cmd = f'''ensight.part.opacity({repr(p0)})'''
        return self._session.cmd(cmd)

    def opaqueness(self, p0: float) -> int:
        """Specifies the opaqueness of the currently selected part(s).
        
        | A value of 1.0 is fully opaque.
        
        Args:
            p0:
                'value' opaqueness; must be within the range of 0.0 to 1.0
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                # WARNING: following line includes OBSOLETE call (ensight.part.opaqueness).
                ensight.part.opaqueness(0.4)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.opaqueness({repr(p0)})'''
        return self._session.cmd(cmd)

    def periodic_sections(self, args: Any) -> int:
        """Part: periodic_sections

        """
        cmd = f'''ensight.part.periodic_sections({repr(args)})'''
        return self._session.cmd(cmd)

    def predefined_material(self, args: Any) -> int:
        """Part: predefined_material

        """
        cmd = f'''ensight.part.predefined_material({repr(args)})'''
        return self._session.cmd(cmd)

    def query_display_attributes(self, args: Any) -> int:
        """Part: query_display_attributes

        """
        cmd = f'''ensight.part.query_display_attributes({repr(args)})'''
        return self._session.cmd(cmd)

    def query_eltid_atwindowxy(self, args: Any) -> int:
        """Part: query_eltid_atwindowxy

        """
        cmd = f'''ensight.part.query_eltid_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_eltid_atxyz(self, args: Any) -> int:
        """Part: query_eltid_atxyz

        """
        cmd = f'''ensight.part.query_eltid_atxyz({repr(args)})'''
        return self._session.cmd(cmd)

    def query_nodeid_atwindowxy(self, args: Any) -> int:
        """Part: query_nodeid_atwindowxy

        """
        cmd = f'''ensight.part.query_nodeid_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_nodeid_atxyz(self, args: Any) -> int:
        """Part: query_nodeid_atxyz

        """
        cmd = f'''ensight.part.query_nodeid_atxyz({repr(args)})'''
        return self._session.cmd(cmd)

    def query_object_atwindowxy(self, args: Any) -> int:
        """Part: query_object_atwindowxy

        """
        cmd = f'''ensight.part.query_object_atwindowxy({repr(args)})'''
        return self._session.cmd(cmd)

    def query_objects(self, args: Any) -> int:
        """Part: query_objects

        """
        cmd = f'''ensight.part.query_objects({repr(args)})'''
        return self._session.cmd(cmd)

    def query_selected_objects(self, args: Any) -> int:
        """Part: query_selected_objects

        """
        cmd = f'''ensight.part.query_selected_objects({repr(args)})'''
        return self._session.cmd(cmd)

    def recompute_cancel(self, p0: str) -> int:
        """Part: recompute_cancel

        """
        cmd = f'''ensight.part.recompute_cancel({repr(p0)})'''
        return self._session.cmd(cmd)

    def recompute_pending(self, p0: str) -> int:
        """Part: recompute_pending

        """
        cmd = f'''ensight.part.recompute_pending({repr(p0)})'''
        return self._session.cmd(cmd)

    def record_selected(self) -> int:
        """Part: record_selected

        """
        cmd = f'''ensight.part.record_selected()'''
        return self._session.cmd(cmd)

    def record_selected_ifchanged(self) -> int:
        """Part: record_selected_ifchanged

        """
        cmd = f'''ensight.part.record_selected_ifchanged()'''
        return self._session.cmd(cmd)

    def reduce_polygons(self, p0: str) -> int:
        """Reduce the number of polygons for display.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.reduce_polygons_factor(1)
                ensight.part.reduce_polygons("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.reduce_polygons({repr(p0)})'''
        return self._session.cmd(cmd)

    def reduce_polygons_factor(self, p0: int) -> int:
        """Set the polygon reduction factor.
        
        | Used only if reduce_polygons is ON
        | If no polygons were removed during the process the original geometry will be shown.
        
        Args:
            p0:
                'factor' 0 (less) to 10 (more) controlling the number of polygons
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.reduce_polygons_factor(1)
                ensight.part.reduce_polygons("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.reduce_polygons_factor({repr(p0)})'''
        return self._session.cmd(cmd)

    def ref_frame(self, p0: int) -> int:
        """Assigns the currently selected part(s) to the specified reference frame.
        
        Args:
            p0:
                'frame#' an existing reference frame number
        
        Examples:
            ::
        
                ensight.part.select_begin(1,2,5)
                ensight.part.modify_begin()
                ensight.part.ref_frame(2)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.ref_frame({repr(p0)})'''
        return self._session.cmd(cmd)

    def rendering_reflection_id(self, p0: int) -> int:
        """Part: rendering_reflection_id

        """
        cmd = f'''ensight.part.rendering_reflection_id({repr(p0)})'''
        return self._session.cmd(cmd)

    def restore_selected(self) -> int:
        """Restores the selected parts from a previous seleciton using the store_selected command.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.store_selected()
                #
                # EnSight commands here...
                #
                ensight.part.restore_selected()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.restore_selected()'''
        return self._session.cmd(cmd)

    def reverse_normal(self, p0: str) -> int:
        """Part: reverse_normal

        """
        cmd = f'''ensight.part.reverse_normal({repr(p0)})'''
        return self._session.cmd(cmd)

    def select_all(self) -> int:
        """Selects all parts as the target for future part: commands.
        
        Examples:
            ::
        
                ensight.part.select_all()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_all()'''
        return self._session.cmd(cmd)

    def select_all_case(self) -> int:
        """Selects all parts in the current case as the target for future part: commands.
        
        Examples:
            ::
        
                ensight.part.select_all_case()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_all_case()'''
        return self._session.cmd(cmd)

    def select_all_default(self) -> int:
        """Causes any following part editing commands to affect the default settings for all parts of any type.
        
        | All part: commands following part: select_all_default will affect default settings until a new part is selected using part: select_begin/end. 
        
        Examples:
            ::
        
                ensight.part.select_all_default()
                ensight.part.modify_begin()
                ensight.part.mirror_original("OFF")
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_all_default()'''
        return self._session.cmd(cmd)

    def select_begin(self, *args, **kwargs) -> Any:
        """Selects one or more parts as the target for future part: commands 
        
        Args:
            p0:
                'pnN' part number(s).  Up to a maximum of  10 per line, but can use as many lines as needed.
        
        Examples:
            ::
        
                ensight.part.select_begin(1,2)
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.part.select_begin({arg_string})"
        return self._session.cmd(cmd)

    def select_byexpr_begin(self, args: Any) -> int:
        """Selects parts using an expression.
        
        | Is used in command files only, i.e., EnSight does not generate these commands
        
        Args:
            p0:
                'exprN' part expression (partial name with asterisk(s))
        
        Examples:
            ::
        
                ensight.part.select_byexpr_begin("flui*","soli*")
                ensight.part.modify_begin()
                ensight.part.reduce_polygons_factor(1)
                ensight.part.reduce_polygons("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_byexpr_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_byexpr_end(self) -> int:
        """Selects parts using an expression.
        
        | Is used in command files only, i.e., EnSight does not generate these commands
        
        Args:
            p0:
                'exprN' part expression (partial name with asterisk(s))
        
        Examples:
            ::
        
                ensight.part.select_byexpr_begin("flui*","soli*")
                ensight.part.modify_begin()
                ensight.part.reduce_polygons_factor(1)
                ensight.part.reduce_polygons("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_byexpr_end()'''
        return self._session.cmd(cmd)

    def select_byname_begin(self, args: Any) -> int:
        """Selects parts by name.
        
        Args:
            p0:
                'nameN' part name (as opposed to number)
        
        Examples:
            ::
        
                ensight.part.select_byname_begin("impeller","main chamber","exhaust port")
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_byname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_byname_end(self) -> int:
        """Selects parts by name.
        
        Args:
            p0:
                'nameN' part name (as opposed to number)
        
        Examples:
            ::
        
                ensight.part.select_byname_begin("impeller","main chamber","exhaust port")
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_byname_end()'''
        return self._session.cmd(cmd)

    def select_default(self) -> int:
        """Causes any following part editing commands to affect the default settings for all parts belonging to the part type of the next edit command.
        
        | All part editing commands following part: select_default will affect default settings until a new part is selected using part: select_begin/select_end.
        
        Examples:
            ::
        
                ensight.part.select_default()
                ensight.part.modify_begin()
                ensight.part.mirror_original("OFF")
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_default()'''
        return self._session.cmd(cmd)

    def select_invert(self) -> int:
        """Part: select_invert

        """
        cmd = f'''ensight.part.select_invert()'''
        return self._session.cmd(cmd)

    def select_invisible(self) -> int:
        """Causes all parts invisible parts to be highlighted.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.select_invisible()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_invisible()'''
        return self._session.cmd(cmd)

    def select_lastcreatedpart(self) -> int:
        """Selects all of the parts created in the last part-creating operation.
        
        Examples:
            ::
        
                ensight.part.select_lastcreatedpart()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_lastcreatedpart()'''
        return self._session.cmd(cmd)

    def select_lastonecreated(self) -> int:
        """Selects the last single part from the last part-creating operation.
        
        Examples:
            ::
        
                ensight.part.select_lastonecreated()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_lastonecreated()'''
        return self._session.cmd(cmd)

    def select_mainpartlist_all(self) -> int:
        """Causes all parts in the main part list to be highlighted.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.select_mainpartlist_all()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_mainpartlist_all()'''
        return self._session.cmd(cmd)

    def select_partexpr_begin(self, args: Any) -> int:
        """Part: select_partexpr_begin

        """
        cmd = f'''ensight.part.select_partexpr_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_partexpr_end(self) -> int:
        """Part: select_partexpr_end

        """
        cmd = f'''ensight.part.select_partexpr_end()'''
        return self._session.cmd(cmd)

    def select_partname_begin(self, args: Any) -> int:
        """Part: select_partname_begin

        """
        cmd = f'''ensight.part.select_partname_begin({repr(args)})'''
        return self._session.cmd(cmd)

    def select_partname_end(self) -> int:
        """Part: select_partname_end

        """
        cmd = f'''ensight.part.select_partname_end()'''
        return self._session.cmd(cmd)

    def select_showing(self) -> int:
        """Causes all parts showing parts to be highlighted.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.select_showing()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_showing()'''
        return self._session.cmd(cmd)

    def select_visible(self) -> int:
        """Causes all parts visible parts to be highlighted.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.select_visible()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.select_visible()'''
        return self._session.cmd(cmd)

    def shading(self, p0: str) -> int:
        """Specifies the type of surface shading used on the currently selected part(s).
        
        Args:
            p0:
                'type'
        
                * Can have any of the following values:
                * flat
                * gouraud
                * smooth
        
        Examples:
            ::
        
                ensight.view.hidden_surface("ON")
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.hidden_surface("ON")
                ensight.part.shading("gouraud")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.shading({repr(p0)})'''
        return self._session.cmd(cmd)

    def show_selection_inmainlist(self) -> int:
        """Updates the Part List GUI menu to reflect the currently selected part(s).
        
        Examples:
            ::
        
                ensight.view.hidden_surface("ON")
                ensight.part.select_begin(1)
                ensight.part.show_selection_inmainlist()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.show_selection_inmainlist()'''
        return self._session.cmd(cmd)

    def show_sft(self, p0: str) -> int:
        """Part: show_sft

        """
        cmd = f'''ensight.part.show_sft({repr(p0)})'''
        return self._session.cmd(cmd)

    def specify_symmetry_origin(self, p0: str) -> int:
        """Part: specify_symmetry_origin

        """
        cmd = f'''ensight.part.specify_symmetry_origin({repr(p0)})'''
        return self._session.cmd(cmd)

    def store_selected(self) -> int:
        """Stores the selected parts to be used later using the restore_selected command.  Note that this does NOT cause the parts to be selected as the target for future part: commands.
        
        | To make the highlighted parts the currently selected parts, use part: get_mainpartlist_select or part: select_all.
        
        Examples:
            ::
        
                ensight.part.store_selected()
                #
                # EnSight commands here...
                #
                ensight.part.restore_selected()
                ensight.part.get_mainpartlist_select()
                ensight.part.modify_begin()
                ensight.part.colorby_rgb(1,0,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.store_selected()'''
        return self._session.cmd(cmd)

    def surface_fill_pattern(self, p0: int) -> int:
        """Part: surface_fill_pattern

        """
        cmd = f'''ensight.part.surface_fill_pattern({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface_hidden_surface(self, p0: str) -> int:
        """Part: surface_hidden_surface

        """
        cmd = f'''ensight.part.surface_hidden_surface({repr(p0)})'''
        return self._session.cmd(cmd)

    def surface_type(self, p0: str) -> int:
        """Part: surface_type

        """
        cmd = f'''ensight.part.surface_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_angle(self, p0: float) -> int:
        """Specifies the rotational symmetry angle.
        
        | Used only when part: symmetry_type is set to rotational.
        
        Args:
            p0:
                'angle' The angle (in degrees) for the rotation
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                #
                # turn on rotational symmetry about the x axis
                # use 4 instances rotated 90 degrees
                #
                ensight.part.symmetry_type("rotational")
                ensight.part.symmetry_axis("x")
                ensight.part.symmetry_rinstances(4)
                ensight.part.symmetry_angle(90.)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_angle({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_axis(self, p0: str) -> int:
        """Specifies the rotational symmetry axis.
        
        | Used only when part: symmetry_type is set to rotational.
        | The axis is in reference to the part coordinate frame.
        
        Args:
            p0:
                'axis'
        
                * x
                * y
                * z
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                #
                # turn on rotational symmetry about the x axis
                # use 4 instances rotated 90 degrees
                #
                ensight.part.symmetry_type("rotational")
                ensight.part.symmetry_axis("x")
                ensight.part.symmetry_rinstances(4)
                ensight.part.symmetry_angle(90.)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_axis({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_delta(self, p0: float, p1: float, p2: float) -> int:
        """Part: symmetry_delta

        """
        cmd = f'''ensight.part.symmetry_delta({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_x(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_x({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_xy(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_xy({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_xyz(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_xyz({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_xz(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_xz({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_y(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_y({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_yz(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_yz({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_mirror_z(self, p0: str) -> int:
        """Set the flag for visual symmetry mirror images of currently selected parts in the x / y / z / xy / yz / xz / xyz directions.
        
        | The part is reflected about the frame that it is assigned to (part: ref_frame)
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.symmetry_mirror_x("ON")
                ensight.part.symmetry_mirror_y("ON")
                ensight.part.symmetry_mirror_xy("ON")
                ensight.part.symmetry_mirror_xyz("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_mirror_z({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_origin(self, p0: float, p1: float, p2: float) -> int:
        """Part: symmetry_origin

        """
        cmd = f'''ensight.part.symmetry_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def symmetry_rinstances(self, p0: int) -> int:
        """Specifies the rotational instances.
        
        | Used only when part: symmetry_type is set to rotational.
        
        Args:
            p0:
                'num' The number of rotational instances
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                #
                # turn on rotational symmetry about the x axis
                # use 4 instances rotated 90 degrees
                #
                ensight.part.symmetry_type("rotational")
                ensight.part.symmetry_axis("x")
                ensight.part.symmetry_rinstances(4)
                ensight.part.symmetry_angle(90.)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_rinstances({repr(p0)})'''
        return self._session.cmd(cmd)

    def symmetry_type(self, p0: str) -> int:
        """Turn on symmetry display.
        
        Args:
            p0:
                'sym_type'
        
                * mirror
                * rotational
                * none
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                #
                # turn on rotational symmetry about the x axis
                # use 4 instances rotated 90 degrees
                #
                ensight.part.symmetry_type("rotational")
                ensight.part.symmetry_axis("x")
                ensight.part.symmetry_rinstances(4)
                ensight.part.symmetry_angle(90.)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.symmetry_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_coord_type(self, p0: str) -> int:
        """Sets the texture mapping to use a projection or to use two variables describing the s and t vector values.
        
        Args:
            p0:
                'type'
        
                * projection
                * variable
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("projection")
                ensight.part.texture_origin(-1,.2,1)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_coord_type({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_interpolation(self, p0: str) -> int:
        """Sets the texture interpolation mode to use the nearest texture pixel or interpolate.
        
        Args:
            p0:
                'mode'
        
                * nearest
                * linear
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_object(1)
                ensight.part.texture_repeat_mode("clamp")
                ensight.part.texture_interpolation("linear")
                ensight.part.texture_mode("decal")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_interpolation({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_mode(self, p0: str) -> int:
        """Set the texture mode to be used for the part coloring.
        
        Args:
            p0:
                'mode'
        
                * replace
                * decal
                * modulate
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_object(1)
                ensight.part.texture_repeat_mode("clamp")
                ensight.part.texture_mode("decal")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_object(self, p0: int) -> int:
        """Color the selected part by a texture.
        
        Args:
            p0:
                'num' the texture object to color by
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_object(1)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_object({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_origin(self, p0: float, p1: float, p2: float) -> int:
        """Sets the texture origin offset in model space.  This describes the "lower left" corner of the texture in world coordinates.  This is an offset amount if the Projection offset is relative to a node ID.  If not, it is an offset from the world coordinate origin, i.e., it becomes an absolute origin.
        
        | Only used if texture_coord_type is set to projection
        
        Args:
            p0:
                'x_orig' the x coordinate for the texture origin
            p1:
                'y_orig' the y coordinate for the texture origin
            p2:
                'z_orig' the z coordinate for the texture origin
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_origin(-1,.2,1)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_origin({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def texture_origin_nodeid(self, p0: int) -> int:
        """Sets the texture origin offset relative to this node id.
        
        | The texture origin becomes the x/y/z coordinate of this node offset (if any) by the texture_origin command
        | Only used if the texture_coord_type is set to projection
        
        Args:
            p0:
                'node_id' The node id that will be used as the origin offset
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("projection")
                #
                # offset the texture by one unit in the x direction from nodeid 3443
                #
                ensight.part.texture_origin_use("offset_by_nodeid")
                ensight.part.texture_origin_nodeid(3443)
                ensight.part.texture_origin(1,0,0)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_origin_nodeid({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_origin_use(self, p0: str) -> int:
        """Sets how the texture origin and orientation will be defined.
        
        | Only used if the texture_coord_type is set to projection.
        
        Args:
            p0:
                'projection'
        
                * absolute
                * offset_by_nodeid
                * offsetvectors_by_nodeid
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("projection")
                #
                # offset the texture by one unit in the x direction from nodeid 3443
                #
                ensight.part.texture_origin_use("offset_by_nodeid")
                ensight.part.texture_origin_nodeid(3443)
                ensight.part.texture_origin(1,0,0)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_origin_use({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_repeat_mode(self, p0: str) -> int:
        """Indicates that a texture repeats outside of the defined target area or uses the border color.
        
        Args:
            p0:
                'mode'
        
                * repeat
                * clamp
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_object(1)
                ensight.part.texture_repeat_mode("clamp")
                ensight.part.texture_mode("decal")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_repeat_mode({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_sorigin_nodeid(self, p0: int) -> int:
        """Sets the s and t vector orientation according to the node ids described
        
        | Only used if the texture_coord_type is set to projection and the texture_origin_use is set to offsetvectors_by_nodeid
        
        Args:
            p0:
                'node_id' The node id to use to describe the s/t texture direction.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("projection")
                ensight.part.texture_origin_use("offsetvectors_by_nodeid")
                ensight.part.texture_origin_nodeid(3443)
                ensight.part.texture_sorigin_nodeid(4944)
                ensight.part.texture_torigin_nodeid(5998)
                ensight.part.texture_origin(1,0,0)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_sorigin_nodeid({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_svariable(self, p0: Any) -> int:
        """For texture_coord_type set to variable these describe the variables to use for the s/t texture color
        
        | A name of "none" is acceptable - this indicates that a constant s/t coordinate of 0.5 will be used
        
        Args:
            p0:
                'name' s/t variable name
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("variables")
                ensight.part.texture_svariable("norm_temperature")
                ensight.part.texture_tvariable("none")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_svariable({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_svector(self, p0: float, p1: float, p2: float) -> int:
        """Sets the texture s-vector orientation and size.  The s-vector maps to the horizontal direction of the texture.
        
        | Only used if texture_coord_type is set to projection
        
        Args:
            p0:
                'x' s vector x value in world coordinates
            p1:
                'y' s vector y value in world coordinates
            p2:
                'z' s vector z value in world coordinates
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_origin(-1,.2,1)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_svector({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def texture_torigin_nodeid(self, p0: int) -> int:
        """Sets the s and t vector orientation according to the node ids described
        
        | Only used if the texture_coord_type is set to projection and the texture_origin_use is set to offsetvectors_by_nodeid
        
        Args:
            p0:
                'node_id' The node id to use to describe the s/t texture direction.
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("projection")
                ensight.part.texture_origin_use("offsetvectors_by_nodeid")
                ensight.part.texture_origin_nodeid(3443)
                ensight.part.texture_sorigin_nodeid(4944)
                ensight.part.texture_torigin_nodeid(5998)
                ensight.part.texture_origin(1,0,0)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_torigin_nodeid({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_tvariable(self, p0: Any) -> int:
        """For texture_coord_type set to variable these describe the variables to use for the s/t texture color
        
        | A name of "none" is acceptable - this indicates that a constant s/t coordinate of 0.5 will be used
        
        Args:
            p0:
                'name' s/t variable name
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_coord_type("variables")
                ensight.part.texture_svariable("norm_temperature")
                ensight.part.texture_tvariable("none")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_tvariable({repr(p0)})'''
        return self._session.cmd(cmd)

    def texture_tvector(self, p0: float, p1: float, p2: float) -> int:
        """Sets the texture t-vector orientation and size.  The t-vector maps to the vertical direction of the texture.
        
        | Only used if texture_coord_type is set to projection
        
        Args:
            p0:
                'x' t vector x value in world coordinates
            p1:
                'y' t vector y value in world coordinates
            p2:
                'z' t vector z value in world coordinates
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.texture_origin(-1,.2,1)
                ensight.part.texture_svector(2,0,0)
                ensight.part.texture_tvector(0,2,0)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.texture_tvector({repr(p0)},{repr(p1)},{repr(p2)})'''
        return self._session.cmd(cmd)

    def transparency(self, p0: float) -> int:
        """Part: transparency

        """
        cmd = f'''ensight.part.transparency({repr(p0)})'''
        return self._session.cmd(cmd)

    def ungroup(self) -> int:
        """Ungroups the currently selected (grouped) parts.
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                ensight.part.ungroup()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.ungroup()'''
        return self._session.cmd(cmd)

    def updtparts(self, p0: int) -> int:
        """Updates the parent part for the currently selected part(s)
        
        Args:
            p0:
                'parent' part number of the new parent(s)
        
        Examples:
            ::
        
                ensight.part.select_begin(3,5)
                ensight.part.updtparts(2)
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.updtparts({repr(p0)})'''
        return self._session.cmd(cmd)

    def viewport_vis(self, *args, **kwargs) -> Any:
        """Controls visibility of the currently selected part(s) in the specified viewport(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
            p1:
                'vportN'
        
                * viewport numbers in which to modify part visibility
        
        Examples:
            ::
        
                ensight.part.select_begin(1,2,5)
                ensight.part.modify_begin()
                ensight.part.viewport_vis("OFF",1,3)
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        arg_list: List[str] = []
        for arg in args:
            arg_list.append(arg.__repr__())
        for key, value in kwargs.items():
            arg_list.append(f"{key}={value.__repr__()}")
        arg_string = ",".join(arg_list)
        cmd = f"ensight.part.viewport_vis({arg_string})"
        return self._session.cmd(cmd)

    def visibility_elt(self, p0: str) -> int:
        """Turns element visibility on or off for the currently selected part(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.visibility_elt("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.visibility_elt({repr(p0)})'''
        return self._session.cmd(cmd)

    def visibility_line(self, p0: str) -> int:
        """Turns line visibility on or off for the currently selected part(s).
        
        | "Line" refers to the 1D bar elements.
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.visibility_line("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.visibility_line({repr(p0)})'''
        return self._session.cmd(cmd)

    def visibility_node(self, p0: str) -> int:
        """Turns node visibility on or off for the currently selected part(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1)
                ensight.part.modify_begin()
                ensight.part.visibility_node("ON")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.visibility_node({repr(p0)})'''
        return self._session.cmd(cmd)

    def visible(self, p0: str) -> int:
        """Controls the visibility of  the currently selected part(s).
        
        Args:
            p0:
                'toggle'
        
                * ON
                * OFF
        
        Examples:
            ::
        
                ensight.part.select_begin(1,2,5)
                ensight.part.modify_begin()
                ensight.part.visible("OFF")
                ensight.part.modify_end()
        
        Returns:
            zero on success, non-zero on error

        """
        cmd = f'''ensight.part.visible({repr(p0)})'''
        return self._session.cmd(cmd)

    def volume_quality(self, p0: str) -> int:
        """Part: volume_quality

        """
        cmd = f'''ensight.part.volume_quality({repr(p0)})'''
        return self._session.cmd(cmd)


class enums:
    """Class wrapper for EnSight enums module

    This class acts as a proxy for the EnSight Python module ensight.objs.enums

    Attributes:
        ACTIVE (int):
            Instance specific constant

        ADJCOORDSCALEFACTOR (int):
            Instance specific constant

        ADJCOORDTRANSVEC (int):
            Instance specific constant

        ADJCOORDVARSCALEFACTOR (int):
            Instance specific constant

        ADJCOORDXVARIABLE (int):
            Instance specific constant

        ADJCOORDYVARIABLE (int):
            Instance specific constant

        ADJCOORDZVARIABLE (int):
            Instance specific constant

        ALLOW_MRU_UPDATE (int):
            Instance specific constant

        ALPHABY (int):
            Instance specific constant

        ALPHABYPALETTE (int):
            Instance specific constant

        ALPHA_VOLUME_SCALE (int):
            Instance specific constant

        AMBIENT_COMPONENT (int):
            Instance specific constant

        ANGLE (int):
            Instance specific constant

        ANIMATE (int):
            Instance specific constant

        ANIMATECURVES (int):
            Instance specific constant

        ANIMATING (int):
            Instance specific constant

        ANIMDELTA (int):
            Instance specific constant

        ANIMOBJS (int):
            Instance specific constant

        ANNOTATIONTEXTID (int):
            Instance specific constant

        ANNOTINDEX (int):
            Instance specific constant

        ANNOTS (int):
            Instance specific constant

        ANNOTTYPE (int):
            Instance specific constant

        ANNOT_2D_SPACE (int):
            Instance specific constant

        ANNOT_3D_SPACE (int):
            Instance specific constant

        ANNOT_SHAPE_ARROW (int):
            Instance specific constant

        ANNOT_SHAPE_CIRCLE (int):
            Instance specific constant

        ANNOT_SHAPE_RECT (int):
            Instance specific constant

        ANNO_ARROW (int):
            Instance specific constant

        ANNO_DIAL (int):
            Instance specific constant

        ANNO_GAUGE (int):
            Instance specific constant

        ANNO_LGND (int):
            Instance specific constant

        ANNO_LINE (int):
            Instance specific constant

        ANNO_LOGO (int):
            Instance specific constant

        ANNO_SHAPE (int):
            Instance specific constant

        ANNO_TEXT (int):
            Instance specific constant

        ANSYS_DRAW_LOGO (int):
            Instance specific constant

        ANSYS_FLAG_ALPHA (int):
            Instance specific constant

        ANSYS_FLAG_BETA (int):
            Instance specific constant

        ANSYS_VERSION (int):
            Instance specific constant

        ANSYS_VERSION_STRING (int):
            Instance specific constant

        ANTIALIAS_FILTER_ALGORITHM (int):
            Instance specific constant

        ANTIALIAS_MODE (int):
            Instance specific constant

        ANTIALIAS_NUM_SAMPLES (int):
            Instance specific constant

        ANTIALIAS_PARAM_COMPRESSION (int):
            Instance specific constant

        ANTIALIAS_PARAM_GAMMA (int):
            Instance specific constant

        ANTIALIAS_PARAM_SMOOTH (int):
            Instance specific constant

        APPENDLOCATIONVALUE (int):
            Instance specific constant

        ARLOC_ELTC (int):
            Instance specific constant

        ARLOC_NODE (int):
            Instance specific constant

        ARLOC_VERT (int):
            Instance specific constant

        ARROWATTACH (int):
            Instance specific constant

        ARROWHEAD (int):
            Instance specific constant

        ARROWLOCATION (int):
            Instance specific constant

        ARROWS (int):
            Instance specific constant

        ARROWSIZE (int):
            Instance specific constant

        ARROWTIPLENGTH (int):
            Instance specific constant

        ARROWTIPSIZE (int):
            Instance specific constant

        ARROWTYPE (int):
            Instance specific constant

        ARROWWIDTH (int):
            Instance specific constant

        ARROW_3D_FORCES (int):
            Instance specific constant

        ARROW_3D_MOMENTS (int):
            Instance specific constant

        ARROW_3D_QUERY_LOCAT (int):
            Instance specific constant

        ARROW_3D_XYZ_LOCAT (int):
            Instance specific constant

        ARROW_ALL (int):
            Instance specific constant

        ARROW_COMP (int):
            Instance specific constant

        ARROW_NORM (int):
            Instance specific constant

        ARROW_SHAFT_LINE (int):
            Instance specific constant

        ARROW_SHAFT_SOLID (int):
            Instance specific constant

        ARROW_TAIL_AT_POINT (int):
            Instance specific constant

        ARROW_TANG (int):
            Instance specific constant

        ARROW_TIP_AT_POINT (int):
            Instance specific constant

        ARRW_CURV (int):
            Instance specific constant

        ARRW_FIXD (int):
            Instance specific constant

        ARRW_RECT (int):
            Instance specific constant

        ASSIGNED_CURVE_TO_YLEFT (int):
            Instance specific constant

        ASSIGNED_CURVE_TO_YRIGHT (int):
            Instance specific constant

        ASSIGNTOYAXIS (int):
            Instance specific constant

        ATRACE_COLBY_CALC (int):
            Instance specific constant

        ATRACE_COLBY_CONST (int):
            Instance specific constant

        ATRACE_HEAD_ARROW (int):
            Instance specific constant

        ATRACE_HEAD_NONE (int):
            Instance specific constant

        ATRACE_HEAD_SPHERE (int):
            Instance specific constant

        ATRACE_SIZE_CONST (int):
            Instance specific constant

        ATRACE_SIZE_SCALAR (int):
            Instance specific constant

        ATRACE_SIZE_VEC_MAG (int):
            Instance specific constant

        ATRACE_SIZE_VEC_X (int):
            Instance specific constant

        ATRACE_SIZE_VEC_Y (int):
            Instance specific constant

        ATRACE_SIZE_VEC_Z (int):
            Instance specific constant

        AUTOSCALE (int):
            Instance specific constant

        AUTOSIZE (int):
            Instance specific constant

        AUXCLIPPING (int):
            Instance specific constant

        AUX_GEOM_NORMAL_INWARD (int):
            Instance specific constant

        AUX_GEOM_NORMAL_OUTWARD (int):
            Instance specific constant

        AUX_GEOM_SHAPE_BOX (int):
            Instance specific constant

        AXESVISIBLE (int):
            Instance specific constant

        AXIS (int):
            Instance specific constant

        AXIS2AUTOSCALE (int):
            Instance specific constant

        AXIS2LABELFORMAT (int):
            Instance specific constant

        AXIS2LABELRGB (int):
            Instance specific constant

        AXIS2LABELSIZE (int):
            Instance specific constant

        AXIS2LABELTYPE (int):
            Instance specific constant

        AXIS2MAX (int):
            Instance specific constant

        AXIS2MIN (int):
            Instance specific constant

        AXIS2TITLE (int):
            Instance specific constant

        AXIS2TITLERGB (int):
            Instance specific constant

        AXIS2TITLESIZE (int):
            Instance specific constant

        AXIS2VISIBLE (int):
            Instance specific constant

        AXISAUTOLAYOUT (int):
            Instance specific constant

        AXISAUTOUPDATE (int):
            Instance specific constant

        AXISGLOBAL (int):
            Instance specific constant

        AXISHEIGHT (int):
            Instance specific constant

        AXISLINEWIDTH (int):
            Instance specific constant

        AXISLOCAL (int):
            Instance specific constant

        AXISMODEL (int):
            Instance specific constant

        AXISMODEL_ANIMATE (int):
            Instance specific constant

        AXISMODEL_LOCATION (int):
            Instance specific constant

        AXISRGB (int):
            Instance specific constant

        AXISSWAP (int):
            Instance specific constant

        AXISWIDTH (int):
            Instance specific constant

        AXISXAUTOSCALE (int):
            Instance specific constant

        AXISXDISPLAYONEDGE (int):
            Instance specific constant

        AXISXFORMAT (int):
            Instance specific constant

        AXISXGRIDEXTENTLOC (int):
            Instance specific constant

        AXISXGRIDTYPE (int):
            Instance specific constant

        AXISXLABELAXISLOC (int):
            Instance specific constant

        AXISXLABELEXTENTLOC (int):
            Instance specific constant

        AXISXLABELFILTER (int):
            Instance specific constant

        AXISXLABELFORMAT (int):
            Instance specific constant

        AXISXLABELRGB (int):
            Instance specific constant

        AXISXLABELSIZE (int):
            Instance specific constant

        AXISXLABELTYPE (int):
            Instance specific constant

        AXISXMAX (int):
            Instance specific constant

        AXISXMIN (int):
            Instance specific constant

        AXISXNUMGRID (int):
            Instance specific constant

        AXISXNUMGRIDLOG (int):
            Instance specific constant

        AXISXNUMSUBGRID (int):
            Instance specific constant

        AXISXNUMSUBGRIDLOG (int):
            Instance specific constant

        AXISXORIG (int):
            Instance specific constant

        AXISXORIGIN (int):
            Instance specific constant

        AXISXSCALE (int):
            Instance specific constant

        AXISXSGRIDTYPE (int):
            Instance specific constant

        AXISXSIZE (int):
            Instance specific constant

        AXISXSUBTICK (int):
            Instance specific constant

        AXISXTICK (int):
            Instance specific constant

        AXISXTITLE (int):
            Instance specific constant

        AXISXTITLERGB (int):
            Instance specific constant

        AXISXTITLESIZE (int):
            Instance specific constant

        AXISXVISIBLE (int):
            Instance specific constant

        AXISXYMAXZMAX (int):
            Instance specific constant

        AXISXYMAXZMIN (int):
            Instance specific constant

        AXISXYMINZMAX (int):
            Instance specific constant

        AXISXYMINZMIN (int):
            Instance specific constant

        AXISYAUTOSCALE (int):
            Instance specific constant

        AXISYDISPLAYONEDGE (int):
            Instance specific constant

        AXISYFORMAT (int):
            Instance specific constant

        AXISYGRIDEXTENTLOC (int):
            Instance specific constant

        AXISYGRIDTYPE (int):
            Instance specific constant

        AXISYLABELAXISLOC (int):
            Instance specific constant

        AXISYLABELEXTENTLOC (int):
            Instance specific constant

        AXISYLABELFILTER (int):
            Instance specific constant

        AXISYLABELFORMAT (int):
            Instance specific constant

        AXISYLABELRGB (int):
            Instance specific constant

        AXISYLABELSIZE (int):
            Instance specific constant

        AXISYLABELTYPE (int):
            Instance specific constant

        AXISYMAX (int):
            Instance specific constant

        AXISYMIN (int):
            Instance specific constant

        AXISYNUMGRID (int):
            Instance specific constant

        AXISYNUMGRIDLOG (int):
            Instance specific constant

        AXISYNUMSUBGRID (int):
            Instance specific constant

        AXISYNUMSUBGRIDLOG (int):
            Instance specific constant

        AXISYORIG (int):
            Instance specific constant

        AXISYORIGIN (int):
            Instance specific constant

        AXISYSCALE (int):
            Instance specific constant

        AXISYSGRIDTYPE (int):
            Instance specific constant

        AXISYSIZE (int):
            Instance specific constant

        AXISYSUBTICK (int):
            Instance specific constant

        AXISYTICK (int):
            Instance specific constant

        AXISYTITLE (int):
            Instance specific constant

        AXISYTITLERGB (int):
            Instance specific constant

        AXISYTITLESIZE (int):
            Instance specific constant

        AXISYVISIBLE (int):
            Instance specific constant

        AXISYYMAXZMAX (int):
            Instance specific constant

        AXISYYMAXZMIN (int):
            Instance specific constant

        AXISYYMINZMAX (int):
            Instance specific constant

        AXISYYMINZMIN (int):
            Instance specific constant

        AXISZDISPLAYONEDGE (int):
            Instance specific constant

        AXISZFORMAT (int):
            Instance specific constant

        AXISZGRIDEXTENTLOC (int):
            Instance specific constant

        AXISZGRIDTYPE (int):
            Instance specific constant

        AXISZLABELAXISLOC (int):
            Instance specific constant

        AXISZLABELEXTENTLOC (int):
            Instance specific constant

        AXISZLABELFILTER (int):
            Instance specific constant

        AXISZLABELRGB (int):
            Instance specific constant

        AXISZMAX (int):
            Instance specific constant

        AXISZMIN (int):
            Instance specific constant

        AXISZNUMGRID (int):
            Instance specific constant

        AXISZNUMSUBGRID (int):
            Instance specific constant

        AXISZSGRIDTYPE (int):
            Instance specific constant

        AXISZSUBTICK (int):
            Instance specific constant

        AXISZTICK (int):
            Instance specific constant

        AXISZTITLE (int):
            Instance specific constant

        AXISZTITLESIZE (int):
            Instance specific constant

        AXISZYMAXZMAX (int):
            Instance specific constant

        AXISZYMAXZMIN (int):
            Instance specific constant

        AXISZYMINZMAX (int):
            Instance specific constant

        AXISZYMINZMIN (int):
            Instance specific constant

        AXI_TYPE_EXTRUDE (int):
            Instance specific constant

        AXI_TYPE_ROTATE (int):
            Instance specific constant

        BACKGROUND (int):
            Instance specific constant

        BACKGROUNDIMAGE (int):
            Instance specific constant

        BACKGROUNDIMAGENAME (int):
            Instance specific constant

        BACKGROUNDRGB (int):
            Instance specific constant

        BACKGROUNDTRANSPARENCY (int):
            Instance specific constant

        BACKGROUNDTYPE (int):
            Instance specific constant

        BEGINSIMTIME (int):
            Instance specific constant

        BIGHANDRANGE (int):
            Instance specific constant

        BIGHANDRGB (int):
            Instance specific constant

        BLANKINGALGORITHM (int):
            Instance specific constant

        BLANKINGCLIPALG (int):
            Instance specific constant

        BLANKINGTHRESHOLD (int):
            Instance specific constant

        BLANKINGVARIABLE1 (int):
            Instance specific constant

        BLANKINGVARIABLE2 (int):
            Instance specific constant

        BLENDLEVELS (int):
            Instance specific constant

        BLENDPOSITION2 (int):
            Instance specific constant

        BLENDPOSITION3 (int):
            Instance specific constant

        BLENDPOSITION4 (int):
            Instance specific constant

        BLENDRGB1 (int):
            Instance specific constant

        BLENDRGB2 (int):
            Instance specific constant

        BLENDRGB3 (int):
            Instance specific constant

        BLENDRGB4 (int):
            Instance specific constant

        BLENDRGB5 (int):
            Instance specific constant

        BORDER (int):
            Instance specific constant

        BORDERCOLOR (int):
            Instance specific constant

        BORDERREP (int):
            Instance specific constant

        BORDERRGB (int):
            Instance specific constant

        BORDERVISIBLE (int):
            Instance specific constant

        BORD_FULL (int):
            Instance specific constant

        BOTH_ARRW (int):
            Instance specific constant

        BOUNDARYFLAGXMAX (int):
            Instance specific constant

        BOUNDARYFLAGXMIN (int):
            Instance specific constant

        BOUNDARYFLAGYMAX (int):
            Instance specific constant

        BOUNDARYFLAGYMIN (int):
            Instance specific constant

        BOUNDARYFLAGZMAX (int):
            Instance specific constant

        BOUNDARYFLAGZMIN (int):
            Instance specific constant

        BOUNDINGBOX (int):
            Instance specific constant

        BOUNDINGREP (int):
            Instance specific constant

        BOUNDING_BOX (int):
            Instance specific constant

        BOUNDS (int):
            Instance specific constant

        BOXAXISX (int):
            Instance specific constant

        BOXAXISY (int):
            Instance specific constant

        BOXAXISZ (int):
            Instance specific constant

        BOXLENGTH (int):
            Instance specific constant

        BOXORIGIN (int):
            Instance specific constant

        BOX_DRAW_BOX (int):
            Instance specific constant

        BOX_DRAW_MODEL (int):
            Instance specific constant

        BOX_DRAW_NOTHING (int):
            Instance specific constant

        BOX_DRAW_POINTS (int):
            Instance specific constant

        BOX_DRAW_REDUCED (int):
            Instance specific constant

        BOX_DRAW_SPARSE_MODEL (int):
            Instance specific constant

        C1_POINTS (int):
            Instance specific constant

        C2_POINTS (int):
            Instance specific constant

        C3_POINTS (int):
            Instance specific constant

        C4_POINTS (int):
            Instance specific constant

        CALC_0D (int):
            Instance specific constant

        CALC_1D (int):
            Instance specific constant

        CALC_2D (int):
            Instance specific constant

        CALC_3D (int):
            Instance specific constant

        CALC_CASEID (int):
            Instance specific constant

        CALC_COMPONENT (int):
            Instance specific constant

        CALC_HINTS_MASK (int):
            Instance specific constant

        CALC_MASS_PTRACE (int):
            Instance specific constant

        CALC_NODEID (int):
            Instance specific constant

        CALC_PARTID (int):
            Instance specific constant

        CALC_TIMESTEP (int):
            Instance specific constant

        CALC_VAL_BOOLEAN (int):
            Instance specific constant

        CALC_VAL_ENUM (int):
            Instance specific constant

        CALC_VAL_FLOAT (int):
            Instance specific constant

        CALC_VAL_INT (int):
            Instance specific constant

        CALC_VAL_MASK (int):
            Instance specific constant

        CALC_VAR_ACTIVE (int):
            Instance specific constant

        CALC_VAR_CONST (int):
            Instance specific constant

        CALC_VAR_CONSTPPART (int):
            Instance specific constant

        CALC_VAR_CONSTPPOPT (int):
            Instance specific constant

        CALC_VAR_COORDS (int):
            Instance specific constant

        CALC_VAR_ELEMENT (int):
            Instance specific constant

        CALC_VAR_MASK (int):
            Instance specific constant

        CALC_VAR_MATERIAL (int):
            Instance specific constant

        CALC_VAR_NODAL (int):
            Instance specific constant

        CALC_VAR_NONEOK (int):
            Instance specific constant

        CALC_VAR_OBJECT (int):
            Instance specific constant

        CALC_VAR_PARTLIST (int):
            Instance specific constant

        CALC_VAR_SCALAR (int):
            Instance specific constant

        CALC_VAR_SCLCLPX (int):
            Instance specific constant

        CALC_VAR_SPECIES (int):
            Instance specific constant

        CALC_VAR_TENSOR (int):
            Instance specific constant

        CALC_VAR_TIME (int):
            Instance specific constant

        CALC_VAR_VECCLPX (int):
            Instance specific constant

        CALC_VAR_VECTOR (int):
            Instance specific constant

        CALC_VIEWPORT (int):
            Instance specific constant

        CAMERAS (int):
            Instance specific constant

        CAMERA_LENS_NORMAL (int):
            Instance specific constant

        CAMERA_LENS_VIEW_PYRAMID (int):
            Instance specific constant

        CAMERA_LOOK_AT_FORWARD (int):
            Instance specific constant

        CAMERA_LOOK_AT_NODE (int):
            Instance specific constant

        CAMERA_LOOK_AT_PLANE_TOOL (int):
            Instance specific constant

        CAMERA_LOOK_AT_SPLINE (int):
            Instance specific constant

        CAMERA_LOOK_AT_XYZ (int):
            Instance specific constant

        CAMERA_LOOK_FROM_NODE (int):
            Instance specific constant

        CAMERA_LOOK_FROM_PLANE_TOOL (int):
            Instance specific constant

        CAMERA_LOOK_FROM_SPLINE (int):
            Instance specific constant

        CAMERA_LOOK_FROM_XYZ (int):
            Instance specific constant

        CASELINKING (int):
            Instance specific constant

        CASENUMBER (int):
            Instance specific constant

        CASES (int):
            Instance specific constant

        CASE_LINKING_LABELS (int):
            Instance specific constant

        CASTS_SHADOWS (int):
            Instance specific constant

        CELLCOMPNUM (int):
            Instance specific constant

        CELLTYPE (int):
            Instance specific constant

        CELLVOLUMEFRACTION (int):
            Instance specific constant

        CENTROID (int):
            Instance specific constant

        CFD_VAR (int):
            Instance specific constant

        CHANGEALLOWED (int):
            Instance specific constant

        CHILDREN (int):
            Instance specific constant

        CLICKNGO_HANDLE_VISIBILITY (int):
            Instance specific constant

        CLIP (int):
            Instance specific constant

        CLIPBLANKINGVARIABLE (int):
            Instance specific constant

        CLIPLCTW (int):
            Instance specific constant

        CLIPLINEPT1 (int):
            Instance specific constant

        CLIPLINEPT2 (int):
            Instance specific constant

        CLIPPERIODICFLAGX (int):
            Instance specific constant

        CLIPPERIODICFLAGY (int):
            Instance specific constant

        CLIPPLANEPT1 (int):
            Instance specific constant

        CLIPPLANEPT2 (int):
            Instance specific constant

        CLIPPLANEPT3 (int):
            Instance specific constant

        CLIPTYPE (int):
            Instance specific constant

        CLIP_CHOICE_BETWEEN (int):
            Instance specific constant

        CLIP_CHOICE_GREATER (int):
            Instance specific constant

        CLIP_CHOICE_LESS (int):
            Instance specific constant

        CLIP_DOMAIN_CRINKLY (int):
            Instance specific constant

        CLIP_DOMAIN_IN (int):
            Instance specific constant

        CLIP_DOMAIN_INOUT (int):
            Instance specific constant

        CLIP_DOMAIN_INTER (int):
            Instance specific constant

        CLIP_DOMAIN_OUT (int):
            Instance specific constant

        CLIP_DOMAIN_RECT (int):
            Instance specific constant

        CLIP_DOMAIN_VOLUME (int):
            Instance specific constant

        CLIP_PLANE_FINITE (int):
            Instance specific constant

        CLIP_PLANE_INFINITE (int):
            Instance specific constant

        CMDLANG_REFERENCE (int):
            Instance specific constant

        COLOR (int):
            Instance specific constant

        COLORBY (int):
            Instance specific constant

        COLORBYPALETTE (int):
            Instance specific constant

        COLORBYPROJECTION (int):
            Instance specific constant

        COLORBYRGB (int):
            Instance specific constant

        COLORS_PER_LEVEL (int):
            Instance specific constant

        COLOR_SPACE (int):
            Instance specific constant

        COMPONENT (int):
            Instance specific constant

        COMPONENTNUMINCELL (int):
            Instance specific constant

        COMPOSITEMATRIX (int):
            Instance specific constant

        COMPRESSION (int):
            Instance specific constant

        COMPRESSIONLINEWIDTH (int):
            Instance specific constant

        COMPRESSIONRGB (int):
            Instance specific constant

        COMPRESSION_GZ (int):
            Instance specific constant

        COMPRESSION_JPEG (int):
            Instance specific constant

        COMPRESSION_NONE (int):
            Instance specific constant

        COMPRESSION_RLE (int):
            Instance specific constant

        COMPUTED (int):
            Instance specific constant

        COMPUTEUSINGPERIODICITY (int):
            Instance specific constant

        CONEANGLE (int):
            Instance specific constant

        CONEAXISVECT (int):
            Instance specific constant

        CONEENDPOINT (int):
            Instance specific constant

        CONEORIGIN (int):
            Instance specific constant

        CONNECT_TIMEOUT (int):
            Instance specific constant

        CONSTANTRGB (int):
            Instance specific constant

        CONSTANT_VALUE (int):
            Instance specific constant

        CONSTRAINDISTANCE (int):
            Instance specific constant

        CONSTRAINT (int):
            Instance specific constant

        CONSTRAINTIME (int):
            Instance specific constant

        CONTOUR_LABEL_HORIZ (int):
            Instance specific constant

        CONTOUR_LABEL_TANGN (int):
            Instance specific constant

        CONTROLPOINTS (int):
            Instance specific constant

        COOLINGCHANNELCOMP (int):
            Instance specific constant

        CORE (int):
            Instance specific constant

        CORE2DTRANSFORM (int):
            Instance specific constant

        CORETRANSFORM (int):
            Instance specific constant

        CREATE_REPORT_TEMPLATE (int):
            Instance specific constant

        CT_BOX (int):
            Instance specific constant

        CT_CONE (int):
            Instance specific constant

        CT_CYLD (int):
            Instance specific constant

        CT_GENQ (int):
            Instance specific constant

        CT_IJK (int):
            Instance specific constant

        CT_LINE (int):
            Instance specific constant

        CT_PART (int):
            Instance specific constant

        CT_PLNE (int):
            Instance specific constant

        CT_REVO (int):
            Instance specific constant

        CT_RTZ (int):
            Instance specific constant

        CT_SPHR (int):
            Instance specific constant

        CT_SPLINE (int):
            Instance specific constant

        CT_XYZ (int):
            Instance specific constant

        CULLELEMENTS (int):
            Instance specific constant

        CULL_BACK_FACE (int):
            Instance specific constant

        CULL_FRONT_FACE (int):
            Instance specific constant

        CULL_NO_FACE (int):
            Instance specific constant

        CURRENT (int):
            Instance specific constant

        CURRENTCASE (int):
            Instance specific constant

        CURRENTFRAME (int):
            Instance specific constant

        CURRENTGUI (int):
            Instance specific constant

        CURSORLOC (int):
            Instance specific constant

        CURVE_LINE_CONNECT (int):
            Instance specific constant

        CURVE_LINE_NONE (int):
            Instance specific constant

        CURVE_LINE_SMOOTH (int):
            Instance specific constant

        CURVE_MARKER_CIRCLE (int):
            Instance specific constant

        CURVE_MARKER_DOT (int):
            Instance specific constant

        CURVE_MARKER_NONE (int):
            Instance specific constant

        CURVE_MARKER_SQUARE (int):
            Instance specific constant

        CURVE_MARKER_TRIANGLE (int):
            Instance specific constant

        CVF_ATTRDEP_CHAIN_AND (int):
            Instance specific constant

        CVF_ATTRDEP_CHAIN_MASK (int):
            Instance specific constant

        CVF_ATTRDEP_CHAIN_OR (int):
            Instance specific constant

        CVF_ATTRDEP_CHAIN_XOR (int):
            Instance specific constant

        CVF_ATTRDEP_LEN_FOR (int):
            Instance specific constant

        CVF_ATTRDEP_LEN_OF (int):
            Instance specific constant

        CVF_ATTRDEP_MASK_OP (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_AND (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_EQ (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_GT (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_LT (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_MASK (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_NOT (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_OR (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_VALUE (int):
            Instance specific constant

        CVF_ATTRDEP_SENS_XOR (int):
            Instance specific constant

        CVF_ATTR_BIT_FLAGS (int):
            Instance specific constant

        CVF_ATTR_BOOL (int):
            Instance specific constant

        CVF_ATTR_COLOR_RGB (int):
            Instance specific constant

        CVF_ATTR_COLOR_RGBA (int):
            Instance specific constant

        CVF_ATTR_ENUM (int):
            Instance specific constant

        CVF_ATTR_FLOAT (int):
            Instance specific constant

        CVF_ATTR_FONT (int):
            Instance specific constant

        CVF_ATTR_GREATER (int):
            Instance specific constant

        CVF_ATTR_HAS_ENUMS (int):
            Instance specific constant

        CVF_ATTR_HAS_RANGE (int):
            Instance specific constant

        CVF_ATTR_IMAGE (int):
            Instance specific constant

        CVF_ATTR_INT (int):
            Instance specific constant

        CVF_ATTR_INT64 (int):
            Instance specific constant

        CVF_ATTR_LESS (int):
            Instance specific constant

        CVF_ATTR_NO_MAXIMUM (int):
            Instance specific constant

        CVF_ATTR_NO_MINIMUM (int):
            Instance specific constant

        CVF_ATTR_OBJPTR (int):
            Instance specific constant

        CVF_ATTR_PSTRING (int):
            Instance specific constant

        CVF_ATTR_PTR (int):
            Instance specific constant

        CVF_ATTR_READONLY (int):
            Instance specific constant

        CVF_ATTR_SOBJPTR (int):
            Instance specific constant

        CVF_ATTR_STRING (int):
            Instance specific constant

        CVF_ATTR_USERFLG_MASK (int):
            Instance specific constant

        CVF_ATTR_VARID (int):
            Instance specific constant

        CVF_CP_UTF8 (int):
            Instance specific constant

        CVF_FONT_BOLD (int):
            Instance specific constant

        CVF_FONT_DEMILIGHT (int):
            Instance specific constant

        CVF_FONT_ITALIC (int):
            Instance specific constant

        CVF_FONT_LIGHT (int):
            Instance specific constant

        CVF_FONT_NARROW (int):
            Instance specific constant

        CVF_FONT_OBLIQUE (int):
            Instance specific constant

        CVF_FONT_REGULAR (int):
            Instance specific constant

        CVF_FONT_ROMAN (int):
            Instance specific constant

        CVF_FONT_THIN (int):
            Instance specific constant

        CVF_GFX_RAM_UNKNOWN (int):
            Instance specific constant

        CVF_HILITE_METHOD_GEOMETRY (int):
            Instance specific constant

        CVF_HILITE_METHOD_IMAGE (int):
            Instance specific constant

        CVF_JLC_APPCMDLINE (int):
            Instance specific constant

        CVF_JLC_CWD (int):
            Instance specific constant

        CVF_JLC_HOSTNAME (int):
            Instance specific constant

        CVF_JLC_LAUNCHCFGNAME (int):
            Instance specific constant

        CVF_JLC_LAUNCHMETHOD (int):
            Instance specific constant

        CVF_JLC_LAUNCHOPT (int):
            Instance specific constant

        CVF_JLC_NAME (int):
            Instance specific constant

        CVF_JLC_NNODES (int):
            Instance specific constant

        CVF_JLC_RSH (int):
            Instance specific constant

        CVF_JLC_RSHOPT (int):
            Instance specific constant

        CVF_JLC_RSHPORT (int):
            Instance specific constant

        CVF_JLC_RUSERNAME (int):
            Instance specific constant

        CVF_JLC_TIMEOUT (int):
            Instance specific constant

        CVF_LANG_UNKNOWN (int):
            Instance specific constant

        CVF_PALETTE_UNDEFINED_AS_ZERO_VALUE (int):
            Instance specific constant

        CVF_PALETTE_UNDEFINED_BY_INVISIBLE (int):
            Instance specific constant

        CVF_PALETTE_UNDEFINED_BY_PART_COLOR (int):
            Instance specific constant

        CVF_PALETTE_UNDEFINED_BY_UNDEF_COLOR (int):
            Instance specific constant

        CYLDAXISVECT (int):
            Instance specific constant

        CYLDENDPOINT (int):
            Instance specific constant

        CYLDORIGIN (int):
            Instance specific constant

        CYLDRADIUS (int):
            Instance specific constant

        DATA_BIGENDIAN (int):
            Instance specific constant

        DATA_LITTLEENDIAN (int):
            Instance specific constant

        DATA_NATIVE (int):
            Instance specific constant

        DEFAULTANNOTS (int):
            Instance specific constant

        DEFAULTPARTS (int):
            Instance specific constant

        DEFAULTPLOT (int):
            Instance specific constant

        DEFAULTPOLYLINE (int):
            Instance specific constant

        DEFAULTQUERY (int):
            Instance specific constant

        DEFAULTREADERID (int):
            Instance specific constant

        DEFAULTVARIABLE (int):
            Instance specific constant

        DEFAULTVPORT (int):
            Instance specific constant

        DEFAULT_3DANNOT_FONTSIZE (int):
            Instance specific constant

        DEFAULT_ANNOT_FONTFAMILY (int):
            Instance specific constant

        DEFAULT_ANNOT_FONTSTYLE (int):
            Instance specific constant

        DEFAULT_CORE_FONTFAMILY (int):
            Instance specific constant

        DEFAULT_CORE_FONTSCALE (int):
            Instance specific constant

        DEFAULT_CORE_FONTSTYLE (int):
            Instance specific constant

        DEFAULT_JLC (int):
            Instance specific constant

        DEFAULT_SYMBOL_FONTFAMILY (int):
            Instance specific constant

        DEFAULT_SYMBOL_FONTSTYLE (int):
            Instance specific constant

        DEFAULT_VALUE (float):
            Instance specific constant

        DEGREE (int):
            Instance specific constant

        DELAY_REFRESH (int):
            Instance specific constant

        DELTA (int):
            Instance specific constant

        DELTATIME (int):
            Instance specific constant

        DENSITY (int):
            Instance specific constant

        DESCRIPTION (int):
            Instance specific constant

        DIAMETER (int):
            Instance specific constant

        DIFFUSE_COMPONENT (int):
            Instance specific constant

        DIMENSION (int):
            Instance specific constant

        DIMENSION2 (int):
            Instance specific constant

        DIMENSION2STEP (int):
            Instance specific constant

        DIMENSION3 (int):
            Instance specific constant

        DIMENSION3STEP (int):
            Instance specific constant

        DIMENSIONS (int):
            Instance specific constant

        DIRECTION (int):
            Instance specific constant

        DIRECTIONVECTOR (int):
            Instance specific constant

        DIRENTRY_DIR (int):
            Instance specific constant

        DIRENTRY_READABLE (int):
            Instance specific constant

        DIRENTRY_SYMLINK (int):
            Instance specific constant

        DIRENTRY_WRITABLE (int):
            Instance specific constant

        DISPLACEBY (int):
            Instance specific constant

        DISPLACEFACTOR (int):
            Instance specific constant

        DISPLAYCOMPRESSION (int):
            Instance specific constant

        DISPLAYMAJOR (int):
            Instance specific constant

        DISPLAYMIDDLE (int):
            Instance specific constant

        DISPLAYMINOR (int):
            Instance specific constant

        DISPLAYOFFSET (int):
            Instance specific constant

        DISPLAYTENSION (int):
            Instance specific constant

        DISPLAYUNDEFINED (int):
            Instance specific constant

        DISPLAY_THEME (int):
            Instance specific constant

        DISPLAY_THEME_NONE (int):
            Instance specific constant

        DISPLAY_THEME_PRINTCOLORS (int):
            Instance specific constant

        DISTANCE (int):
            Instance specific constant

        DISTANCE_SCALE (int):
            Instance specific constant

        DISTRIBUTION (int):
            Instance specific constant

        DOMAIN (int):
            Instance specific constant

        DOMAINBOX (int):
            Instance specific constant

        DOMAINXYZRTZLINE (int):
            Instance specific constant

        DOUBLESIDED (int):
            Instance specific constant

        DTA_BLOCK (int):
            Instance specific constant

        EDIT_TARGET (int):
            Instance specific constant

        ELEMCOUNT (int):
            Instance specific constant

        ELEMID (int):
            Instance specific constant

        ELE_FAILED_EQUAL (int):
            Instance specific constant

        ELE_FAILED_GREATER (int):
            Instance specific constant

        ELE_FAILED_LESS (int):
            Instance specific constant

        ELE_FAILED_LOGIC_AND (int):
            Instance specific constant

        ELE_FAILED_LOGIC_NONE (int):
            Instance specific constant

        ELE_FAILED_LOGIC_OR (int):
            Instance specific constant

        ELE_FAILED_NOT_EQUAL (int):
            Instance specific constant

        ELTBLANKING (int):
            Instance specific constant

        ELTDEFINEDBY (int):
            Instance specific constant

        ELTFEATUREANGLE (int):
            Instance specific constant

        ELTFILTER1ACTIVE (int):
            Instance specific constant

        ELTFILTER1TESTOP (int):
            Instance specific constant

        ELTFILTER1TESTVALUE (int):
            Instance specific constant

        ELTFILTER1TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER1TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER1VARCOMP (int):
            Instance specific constant

        ELTFILTER1VARIABLE (int):
            Instance specific constant

        ELTFILTER2ACTIVE (int):
            Instance specific constant

        ELTFILTER2LOGICALOP (int):
            Instance specific constant

        ELTFILTER2TESTOP (int):
            Instance specific constant

        ELTFILTER2TESTVALUE (int):
            Instance specific constant

        ELTFILTER2TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER2TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER2VARCOMP (int):
            Instance specific constant

        ELTFILTER2VARIABLE (int):
            Instance specific constant

        ELTFILTER3ACTIVE (int):
            Instance specific constant

        ELTFILTER3LOGICALOP (int):
            Instance specific constant

        ELTFILTER3TESTOP (int):
            Instance specific constant

        ELTFILTER3TESTVALUE (int):
            Instance specific constant

        ELTFILTER3TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER3TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER3VARCOMP (int):
            Instance specific constant

        ELTFILTER3VARIABLE (int):
            Instance specific constant

        ELTFILTER4ACTIVE (int):
            Instance specific constant

        ELTFILTER4LOGICALOP (int):
            Instance specific constant

        ELTFILTER4TESTOP (int):
            Instance specific constant

        ELTFILTER4TESTVALUE (int):
            Instance specific constant

        ELTFILTER4TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER4TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER4VARCOMP (int):
            Instance specific constant

        ELTFILTER4VARIABLE (int):
            Instance specific constant

        ELTFILTER5ACTIVE (int):
            Instance specific constant

        ELTFILTER5LOGICALOP (int):
            Instance specific constant

        ELTFILTER5TESTOP (int):
            Instance specific constant

        ELTFILTER5TESTVALUE (int):
            Instance specific constant

        ELTFILTER5TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER5TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER5VARCOMP (int):
            Instance specific constant

        ELTFILTER5VARIABLE (int):
            Instance specific constant

        ELTFILTER6ACTIVE (int):
            Instance specific constant

        ELTFILTER6LOGICALOP (int):
            Instance specific constant

        ELTFILTER6TESTOP (int):
            Instance specific constant

        ELTFILTER6TESTVALUE (int):
            Instance specific constant

        ELTFILTER6TESTVARCOMP (int):
            Instance specific constant

        ELTFILTER6TESTVARIABLE (int):
            Instance specific constant

        ELTFILTER6VARCOMP (int):
            Instance specific constant

        ELTFILTER6VARIABLE (int):
            Instance specific constant

        ELTREPPOINTSNORMALS (int):
            Instance specific constant

        ELTREPRESENTATION (int):
            Instance specific constant

        ELTSHRINKFACTOR (int):
            Instance specific constant

        EMISSIVE_COMPONENT (int):
            Instance specific constant

        EMITATCURRENTTIME (int):
            Instance specific constant

        EMITTERS (int):
            Instance specific constant

        ENDPOINT (int):
            Instance specific constant

        ENDSIMTIME (int):
            Instance specific constant

        ENSHELL_LOG (int):
            Instance specific constant

        ENSJLC_DR_EPILOGUE (int):
            Instance specific constant

        ENSJLC_DR_NAME (int):
            Instance specific constant

        ENSJLC_DR_PROLOGUE (int):
            Instance specific constant

        ENSJLC_HUB_EPILOGUE (int):
            Instance specific constant

        ENSJLC_HUB_NAME (int):
            Instance specific constant

        ENSJLC_HUB_PROLOGUE (int):
            Instance specific constant

        ENSJLC_SERVER_EPILOGUE (int):
            Instance specific constant

        ENSJLC_SERVER_NAME (int):
            Instance specific constant

        ENSJLC_SERVER_PROLOGUE (int):
            Instance specific constant

        ENSJLC_SOS_EPILOGUE (int):
            Instance specific constant

        ENSJLC_SOS_NAME (int):
            Instance specific constant

        ENSJLC_SOS_PROLOGUE (int):
            Instance specific constant

        ENSMODEL_FLUSH_ALL (int):
            Instance specific constant

        ENSMODEL_FLUSH_FEATURES (int):
            Instance specific constant

        ENSMODEL_FLUSH_MODELS (int):
            Instance specific constant

        ENSMODEL_FLUSH_NONE (int):
            Instance specific constant

        ENSMODEL_SHOW_ANNOTS (int):
            Instance specific constant

        ENSMODEL_SHOW_ANY (int):
            Instance specific constant

        ENSMODEL_SHOW_CALCTOOLS (int):
            Instance specific constant

        ENSMODEL_SHOW_CASES (int):
            Instance specific constant

        ENSMODEL_SHOW_FRAMES (int):
            Instance specific constant

        ENSMODEL_SHOW_NONE (int):
            Instance specific constant

        ENSMODEL_SHOW_PLOTTERS (int):
            Instance specific constant

        ENSMODEL_SHOW_QUERIES (int):
            Instance specific constant

        ENSMODEL_SHOW_VARS (int):
            Instance specific constant

        ENSMODEL_SHOW_VIEWPORTS (int):
            Instance specific constant

        ENSMODEL_UPDATE_ATTR_UPDATE (int):
            Instance specific constant

        ENSMODEL_UPDATE_CTOR (int):
            Instance specific constant

        ENSMODEL_UPDATE_DTOR (int):
            Instance specific constant

        ENSMODEL_UPDATE_SELECTION (int):
            Instance specific constant

        ENSMODEL_UPDATE_SELECTION_FED (int):
            Instance specific constant

        ENS_ATTR_EMITTERLIST (int):
            Instance specific constant

        ENS_ATTR_ENSLEGENDOBJ (int):
            Instance specific constant

        ENS_ATTR_ENSPARTOBJ (int):
            Instance specific constant

        ENS_ATTR_ENSPLOTOBJ (int):
            Instance specific constant

        ENS_ATTR_ENSVARCOMP (int):
            Instance specific constant

        ENS_ATTR_ENSVAROBJ (int):
            Instance specific constant

        ENS_ATTR_MATRIX44 (int):
            Instance specific constant

        ENS_ATTR_METADATATYPE (int):
            Instance specific constant

        ENS_ATTR_METATAG_BASE (int):
            Instance specific constant

        ENS_ATTR_OBJECT_DTOR (int):
            Instance specific constant

        ENS_ATTR_PALETTEOBJ (int):
            Instance specific constant

        ENS_ATTR_PYDICTIONARY (int):
            Instance specific constant

        ENS_ATTR_PYDICTLIST (int):
            Instance specific constant

        ENS_ATTR_PYOBJECT (int):
            Instance specific constant

        ENS_ATTR_QUATERNION (int):
            Instance specific constant

        ENS_ATTR_SOURCEOBJ (int):
            Instance specific constant

        ENS_ATTR_STATEOBJ (int):
            Instance specific constant

        ENS_ATTR_TEXTUREOBJ (int):
            Instance specific constant

        ENS_ATTR_USERDEF_BASE (int):
            Instance specific constant

        ENS_ATTR_VAR_CONST (int):
            Instance specific constant

        ENS_ATTR_VAR_CONST_PER_PART (int):
            Instance specific constant

        ENS_ATTR_VAR_COORD (int):
            Instance specific constant

        ENS_ATTR_VAR_ELEM (int):
            Instance specific constant

        ENS_ATTR_VAR_FILTER (int):
            Instance specific constant

        ENS_ATTR_VAR_MODEL (int):
            Instance specific constant

        ENS_ATTR_VAR_NODE (int):
            Instance specific constant

        ENS_ATTR_VAR_NONE_ILLEGAL (int):
            Instance specific constant

        ENS_ATTR_VAR_SCALAR (int):
            Instance specific constant

        ENS_ATTR_VAR_SCLCOMPLEX (int):
            Instance specific constant

        ENS_ATTR_VAR_TENSOR (int):
            Instance specific constant

        ENS_ATTR_VAR_TIME (int):
            Instance specific constant

        ENS_ATTR_VAR_VCTCOMPLEX (int):
            Instance specific constant

        ENS_ATTR_VAR_VECTOR (int):
            Instance specific constant

        ENS_DEFPATH_CMDPLY (int):
            Instance specific constant

        ENS_DEFPATH_CMDREC (int):
            Instance specific constant

        ENS_DEFPATH_GBLMACRO (int):
            Instance specific constant

        ENS_DEFPATH_IMAGE (int):
            Instance specific constant

        ENS_DEFPATH_LCLMACRO (int):
            Instance specific constant

        ENS_DEFPATH_MISC (int):
            Instance specific constant

        ENS_DEFPATH_PYEDIT (int):
            Instance specific constant

        ENS_DEFPATH_REMOTE (int):
            Instance specific constant

        ENS_DEFPATH_SCENARIO (int):
            Instance specific constant

        ENS_DEFPATH_TEXTURE (int):
            Instance specific constant

        ENS_DEFPATH_VIDEO (int):
            Instance specific constant

        ENS_DETAILS (int):
            Instance specific constant

        ENS_FEATURE_ACTIONBAR (int):
            Instance specific constant

        ENS_FEATURE_FDEWIDGET (int):
            Instance specific constant

        ENS_FEATURE_FEATUREBAR (int):
            Instance specific constant

        ENS_KIND (int):
            Instance specific constant

        ENS_MAINWIN (int):
            Instance specific constant

        ENS_MAINWINMENUS (int):
            Instance specific constant

        ENS_MATERIAL (int):
            Instance specific constant

        ENS_PANELPARENT (int):
            Instance specific constant

        ENS_PARENT_PART (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_0 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_1 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_2 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_3 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_4 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_5 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_6 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_7 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_8 (int):
            Instance specific constant

        ENS_PLIST_KEY_SEL_9 (int):
            Instance specific constant

        ENS_SYMMETRY_AXIS (int):
            Instance specific constant

        ENS_SYMMETRY_COUNT (int):
            Instance specific constant

        ENS_TURBO_ANNO (int):
            Instance specific constant

        ENS_TURBO_STAGE (int):
            Instance specific constant

        ENS_TURBO_VDIM (int):
            Instance specific constant

        ENS_TURBO_VIEW (int):
            Instance specific constant

        ENS_TURBO_VPORT (int):
            Instance specific constant

        ENS_UNITS_DIMS (int):
            Instance specific constant

        ENS_UNITS_LABEL (int):
            Instance specific constant

        ENS_UNITS_SYSTEM_NAME (int):
            Instance specific constant

        ENS_VAR_CASE (int):
            Instance specific constant

        ENS_VAR_CONSTANT (int):
            Instance specific constant

        ENS_VAR_CONSTANT_PER_PART (int):
            Instance specific constant

        ENS_VAR_COORDS (int):
            Instance specific constant

        ENS_VAR_ELEM (int):
            Instance specific constant

        ENS_VAR_ENOD (int):
            Instance specific constant

        ENS_VAR_NODE (int):
            Instance specific constant

        ENS_VAR_SCALAR (int):
            Instance specific constant

        ENS_VAR_SCALAR_COMPLEX (int):
            Instance specific constant

        ENS_VAR_TENSOR (int):
            Instance specific constant

        ENS_VAR_TIME_FUNC (int):
            Instance specific constant

        ENS_VAR_UNKNOWN (int):
            Instance specific constant

        ENS_VAR_VECTOR (int):
            Instance specific constant

        ENS_VAR_VECTOR_COMPLEX (int):
            Instance specific constant

        ENTHALPY (int):
            Instance specific constant

        ENTITYLABELELT (int):
            Instance specific constant

        ENTITYLABELNODE (int):
            Instance specific constant

        EPSILON (int):
            Instance specific constant

        EQUATION (int):
            Instance specific constant

        EXIST_CASE (int):
            Instance specific constant

        EXPRESSION (int):
            Instance specific constant

        EXTENTS (int):
            Instance specific constant

        E_FORMAT (int):
            Instance specific constant

        FACEAREAFRACTION (int):
            Instance specific constant

        FACEXMAXGRID (int):
            Instance specific constant

        FACEXMAXGRIDFILTER (int):
            Instance specific constant

        FACEXMAXSUBGRID (int):
            Instance specific constant

        FACEXMINGRID (int):
            Instance specific constant

        FACEXMINGRIDFILTER (int):
            Instance specific constant

        FACEXMINSUBGRID (int):
            Instance specific constant

        FACEYMAXGRID (int):
            Instance specific constant

        FACEYMAXGRIDFILTER (int):
            Instance specific constant

        FACEYMAXSUBGRID (int):
            Instance specific constant

        FACEYMINGRID (int):
            Instance specific constant

        FACEYMINGRIDFILTER (int):
            Instance specific constant

        FACEYMINSUBGRID (int):
            Instance specific constant

        FACEZMAXGRID (int):
            Instance specific constant

        FACEZMAXGRIDFILTER (int):
            Instance specific constant

        FACEZMAXSUBGRID (int):
            Instance specific constant

        FACEZMINGRID (int):
            Instance specific constant

        FACEZMINGRIDFILTER (int):
            Instance specific constant

        FACEZMINSUBGRID (int):
            Instance specific constant

        FALSE (int):
            Instance specific constant

        FASTDISPLAY (int):
            Instance specific constant

        FEATURE_ANGLE (int):
            Instance specific constant

        FEATURE_FULL (int):
            Instance specific constant

        FEA_VAR (int):
            Instance specific constant

        FILENAME (int):
            Instance specific constant

        FILL (int):
            Instance specific constant

        FILLPATTERN (int):
            Instance specific constant

        FLIPBOOKS (int):
            Instance specific constant

        FLOATINGZCLIP (int):
            Instance specific constant

        FLOW3DINFO (int):
            Instance specific constant

        FNC_BAND (int):
            Instance specific constant

        FNC_CONST (int):
            Instance specific constant

        FNC_CONTIN (int):
            Instance specific constant

        FNC_LIMCOL (int):
            Instance specific constant

        FNC_LIMVIS (int):
            Instance specific constant

        FNC_LINEAR (int):
            Instance specific constant

        FNC_LOG (int):
            Instance specific constant

        FNC_NOLIMIT (int):
            Instance specific constant

        FNC_QUAD (int):
            Instance specific constant

        FONTFAMILIES (int):
            Instance specific constant

        FORMAT (int):
            Instance specific constant

        FRAMES (int):
            Instance specific constant

        FRAME_DURATION (int):
            Instance specific constant

        FRST_ARRW (int):
            Instance specific constant

        FULL (int):
            Instance specific constant

        FULLSCREEN (int):
            Instance specific constant

        FX_SEPNATT_PARALLEL_VECTOR (int):
            Instance specific constant

        FX_SEPNATT_PHASE_PLANE (int):
            Instance specific constant

        FX_SHOCK_REGION (int):
            Instance specific constant

        FX_SHOCK_SURFACE (int):
            Instance specific constant

        FX_VCORE_EIGENANALYSIS (int):
            Instance specific constant

        FX_VCORE_VORTICITY (int):
            Instance specific constant

        F_FORMAT (int):
            Instance specific constant

        GASCONSTANT (int):
            Instance specific constant

        GENERATEOVER (int):
            Instance specific constant

        GENERATION_PENDING (int):
            Instance specific constant

        GEOMETRICTYPE (int):
            Instance specific constant

        GEOMETRY_FORM (int):
            Instance specific constant

        GEOM_CONN_CHANGE (int):
            Instance specific constant

        GEOM_COORD_CHANGE (int):
            Instance specific constant

        GEOM_NO_CHANGE (int):
            Instance specific constant

        GLASS_MATERIAL (int):
            Instance specific constant

        GLOBALAXISLOCATION (int):
            Instance specific constant

        GLOBALAXISVISIBLE (int):
            Instance specific constant

        GLOBALAXISXLABEL (int):
            Instance specific constant

        GLOBALAXISYLABEL (int):
            Instance specific constant

        GLOBALAXISZLABEL (int):
            Instance specific constant

        GRIDLINETYPE (int):
            Instance specific constant

        GRIDLINEWIDTH (int):
            Instance specific constant

        GRIDPTS (int):
            Instance specific constant

        GRIDRGB (int):
            Instance specific constant

        GROUND_ACTIVE (int):
            Instance specific constant

        GROUND_BLENDSCALE (int):
            Instance specific constant

        GROUND_TEXSCALE (int):
            Instance specific constant

        GROUND_UPDIR (int):
            Instance specific constant

        GROUPS (int):
            Instance specific constant

        GRP_COLLAPSE (int):
            Instance specific constant

        GRP_EXPAND (int):
            Instance specific constant

        HANDLES_ENABLED (int):
            Instance specific constant

        HANDLE_UNDEFINED_VALUE (int):
            Instance specific constant

        HAS0DELEMENTS (int):
            Instance specific constant

        HAS1DELEMENTS (int):
            Instance specific constant

        HAS2DELEMENTS (int):
            Instance specific constant

        HAS3DELEMENTS (int):
            Instance specific constant

        HASTRANSPARENT (int):
            Instance specific constant

        HEADDETAIL (int):
            Instance specific constant

        HEADSCALE (int):
            Instance specific constant

        HEADSIZEBY (int):
            Instance specific constant

        HEADTYPE (int):
            Instance specific constant

        HEADVARIABLE (int):
            Instance specific constant

        HEIGHT (int):
            Instance specific constant

        HIDDENLINE (int):
            Instance specific constant

        HIDDENLINE_RGB (int):
            Instance specific constant

        HIDDENLINE_USE_RGB (int):
            Instance specific constant

        HIDDENSURFACE (int):
            Instance specific constant

        HILITE_BACK_COLOR_FILL (int):
            Instance specific constant

        HILITE_METHOD (int):
            Instance specific constant

        HILITE_SELECT_COLOR (int):
            Instance specific constant

        HILITE_SELECT_COLOR_FILL (int):
            Instance specific constant

        HILITE_TARGET_COLOR (int):
            Instance specific constant

        HILITE_TARGET_COLOR_FILL (int):
            Instance specific constant

        HISTO_SCALE (int):
            Instance specific constant

        HTML (int):
            Instance specific constant

        ICON_SIZE (int):
            Instance specific constant

        ID (int):
            Instance specific constant

        IJK (int):
            Instance specific constant

        IJKAXIS (int):
            Instance specific constant

        IJKAXISSCALE (int):
            Instance specific constant

        IJKSCALE (int):
            Instance specific constant

        IMAGE (int):
            Instance specific constant

        INDEX (int):
            Instance specific constant

        INPLANE1 (int):
            Instance specific constant

        INPLANE2 (int):
            Instance specific constant

        INPLANE3 (int):
            Instance specific constant

        INTENSITY (int):
            Instance specific constant

        INTERACTIVEAUTODELTA (int):
            Instance specific constant

        INTERACTIVERANGEMAX (int):
            Instance specific constant

        INTERACTIVERANGEMIN (int):
            Instance specific constant

        INTERACTIVESTEP (int):
            Instance specific constant

        INTERACTIVEXMAX (int):
            Instance specific constant

        INTERACTIVEXMIN (int):
            Instance specific constant

        INTERACTIVEYMAX (int):
            Instance specific constant

        INTERACTIVEYMIN (int):
            Instance specific constant

        INTERACTIVEZMAX (int):
            Instance specific constant

        INTERACTIVEZMIN (int):
            Instance specific constant

        INTERP (int):
            Instance specific constant

        INT_QUERY_ELEMID (int):
            Instance specific constant

        INT_QUERY_EXACT (int):
            Instance specific constant

        INT_QUERY_IJK (int):
            Instance specific constant

        INT_QUERY_MAX (int):
            Instance specific constant

        INT_QUERY_MIN (int):
            Instance specific constant

        INT_QUERY_NODE (int):
            Instance specific constant

        INT_QUERY_NODEID (int):
            Instance specific constant

        INT_QUERY_NONE (int):
            Instance specific constant

        INT_QUERY_POINT (int):
            Instance specific constant

        INT_QUERY_SURFACE (int):
            Instance specific constant

        INT_QUERY_XYZ (int):
            Instance specific constant

        ISGROUP (int):
            Instance specific constant

        ISO_SURF_SOLID (int):
            Instance specific constant

        ISO_SURF_SURFACE (int):
            Instance specific constant

        JLCS (int):
            Instance specific constant

        JOBINFO (int):
            Instance specific constant

        JUSTIFICATION (int):
            Instance specific constant

        KEYFRAMEDATA (int):
            Instance specific constant

        LABELALWAYSONTOP (int):
            Instance specific constant

        LABELAUTOVISIBLE (int):
            Instance specific constant

        LABELCOUNT (int):
            Instance specific constant

        LABELCUSTOMVISIBLE (int):
            Instance specific constant

        LABELDECIMALPLACES (int):
            Instance specific constant

        LABELFORMAT (int):
            Instance specific constant

        LABELOFFSET (int):
            Instance specific constant

        LABELORIENTATION (int):
            Instance specific constant

        LABELRGB (int):
            Instance specific constant

        LABELSIZE (int):
            Instance specific constant

        LABELSIZE2D (int):
            Instance specific constant

        LABELSIZE3D (int):
            Instance specific constant

        LABELSPACING (int):
            Instance specific constant

        LABELTEXT (int):
            Instance specific constant

        LABELTEXTID (int):
            Instance specific constant

        LABELVISIBLE (int):
            Instance specific constant

        LANGUAGE_INFO (int):
            Instance specific constant

        LAST_DATA_RELOAD (int):
            Instance specific constant

        LEGEND (int):
            Instance specific constant

        LEGENDCOLORBY (int):
            Instance specific constant

        LEGENDMINMAXORIGINX (int):
            Instance specific constant

        LEGENDMINMAXORIGINY (int):
            Instance specific constant

        LEGENDMINMAXTEXTSIZE (int):
            Instance specific constant

        LEGENDMINMAXVISIBLE (int):
            Instance specific constant

        LEGENDORIGINX (int):
            Instance specific constant

        LEGENDORIGINY (int):
            Instance specific constant

        LEGENDRGB (int):
            Instance specific constant

        LEGENDTEXTSIZE (int):
            Instance specific constant

        LEGENDTITLE (int):
            Instance specific constant

        LEGENDTYPE (int):
            Instance specific constant

        LEGENDVISIBLE (int):
            Instance specific constant

        LEGEND_CONT (int):
            Instance specific constant

        LEGEND_DISC (int):
            Instance specific constant

        LEGEND_LEFT (int):
            Instance specific constant

        LEGEND_RIGHT (int):
            Instance specific constant

        LEGEND_TITLE_BOTTOM (int):
            Instance specific constant

        LEGEND_TITLE_TOP (int):
            Instance specific constant

        LEGEND_TITLE_VISOFF (int):
            Instance specific constant

        LEGEND_TXT_VISOFF (int):
            Instance specific constant

        LENGTH (int):
            Instance specific constant

        LENS (int):
            Instance specific constant

        LEVELRGB (int):
            Instance specific constant

        LEVELS (int):
            Instance specific constant

        LEVELSVISIBLE (int):
            Instance specific constant

        LEVELS_AND_COLORS (int):
            Instance specific constant

        LEVELS_LOCK (int):
            Instance specific constant

        LIGHT1AZIMUTH (int):
            Instance specific constant

        LIGHT1ELEVATION (int):
            Instance specific constant

        LIGHT1POSITION (int):
            Instance specific constant

        LIGHT2INTENSITY (int):
            Instance specific constant

        LIGHTAMBIENT (int):
            Instance specific constant

        LIGHTDIFF (int):
            Instance specific constant

        LIGHTDIFFUSE (int):
            Instance specific constant

        LIGHTEMISSIVE (int):
            Instance specific constant

        LIGHTHINT (int):
            Instance specific constant

        LIGHTREFRACTION (int):
            Instance specific constant

        LIGHTSHIN (int):
            Instance specific constant

        LIGHTSOURCES (int):
            Instance specific constant

        LIGHTSPECULARINTENSITY (int):
            Instance specific constant

        LIGHTSPECULARREFLECTION (int):
            Instance specific constant

        LIGHTSPECULARSHINE (int):
            Instance specific constant

        LIGHTSPECULARTINT (int):
            Instance specific constant

        LIGHT_AREA_ENV (int):
            Instance specific constant

        LIGHT_AREA_QUAD (int):
            Instance specific constant

        LIGHT_AT_CAMERA (int):
            Instance specific constant

        LIGHT_DIRECTIONAL (int):
            Instance specific constant

        LIGHT_ENV_TEXNUM (int):
            Instance specific constant

        LIGHT_POINT (int):
            Instance specific constant

        LIGHT_QUAD_SIZE (int):
            Instance specific constant

        LIGHT_QUAD_XDIR (int):
            Instance specific constant

        LIGHT_SOURCE_ABSOLUTE (int):
            Instance specific constant

        LIGHT_SOURCE_RELATIVE (int):
            Instance specific constant

        LIGHT_SPOT (int):
            Instance specific constant

        LIGHT_TYPE (int):
            Instance specific constant

        LIMITFRINGES (int):
            Instance specific constant

        LIMIT_FRINGES (int):
            Instance specific constant

        LINESTYLE (int):
            Instance specific constant

        LINETYPE (int):
            Instance specific constant

        LINEWIDTH (int):
            Instance specific constant

        LINEWIDTHBY (int):
            Instance specific constant

        LINE_DOTDSH (int):
            Instance specific constant

        LINE_DOTTED (int):
            Instance specific constant

        LINE_SOLID (int):
            Instance specific constant

        LINKED (int):
            Instance specific constant

        LINK_GROUP1 (int):
            Instance specific constant

        LITTLEHAND (int):
            Instance specific constant

        LITTLEHANDRANGE (int):
            Instance specific constant

        LITTLEHANDRGB (int):
            Instance specific constant

        LOCATION (int):
            Instance specific constant

        LOCATIONX (int):
            Instance specific constant

        LOCATIONX1 (int):
            Instance specific constant

        LOCATIONX2 (int):
            Instance specific constant

        LOCATIONY (int):
            Instance specific constant

        LOCATIONY1 (int):
            Instance specific constant

        LOCATIONY2 (int):
            Instance specific constant

        LOCK_DIRECTION (int):
            Instance specific constant

        LOGO_DATA (int):
            Instance specific constant

        LOOKATPOINT (int):
            Instance specific constant

        LOOKAT_NODE_ID (int):
            Instance specific constant

        LOOKAT_OPTION (int):
            Instance specific constant

        LOOKAT_PART_ID (int):
            Instance specific constant

        LOOKAT_SPLINE_ID (int):
            Instance specific constant

        LOOKAT_SPLINE_VALUE (int):
            Instance specific constant

        LOOKAT_XYZ (int):
            Instance specific constant

        LOOKFROMPOINT (int):
            Instance specific constant

        LPARTNUMELE (int):
            Instance specific constant

        LPARTPARENT (int):
            Instance specific constant

        LPARTS (int):
            Instance specific constant

        LPARTS_OFF (int):
            Instance specific constant

        LPARTS_ON (int):
            Instance specific constant

        LPARTS_SELECTIVE (int):
            Instance specific constant

        MACH (int):
            Instance specific constant

        MACHINEARCH (int):
            Instance specific constant

        MARKER (int):
            Instance specific constant

        MARKERRGB (int):
            Instance specific constant

        MARKERSCALE (int):
            Instance specific constant

        MARKERSIZENORMALIZED (int):
            Instance specific constant

        MARKERVISIBLE (int):
            Instance specific constant

        MARKER_COLOR (int):
            Instance specific constant

        MARKER_CROSS (int):
            Instance specific constant

        MARKER_DOT (int):
            Instance specific constant

        MARKER_SCREENSPACE_SURFACE (int):
            Instance specific constant

        MARKER_SIZE_CONSTANT (int):
            Instance specific constant

        MARKER_SIZE_SCALAR (int):
            Instance specific constant

        MARKER_SIZE_VECMAG (int):
            Instance specific constant

        MARKER_SIZE_VECXCOMP (int):
            Instance specific constant

        MARKER_SIZE_VECYCOMP (int):
            Instance specific constant

        MARKER_SIZE_VECZCOMP (int):
            Instance specific constant

        MARKER_SPHER (int):
            Instance specific constant

        MARKER_WIDTH (int):
            Instance specific constant

        MASSEDBALLISTICCOEF (int):
            Instance specific constant

        MASSEDBUOYANCY (int):
            Instance specific constant

        MASSEDCOEFFRICTION (int):
            Instance specific constant

        MASSEDCOEFRESTITUTION (int):
            Instance specific constant

        MASSEDDRAG (int):
            Instance specific constant

        MASSEDDRAGCOEFFICIENT (int):
            Instance specific constant

        MASSEDDRAGCOEFFICIENTVAL (int):
            Instance specific constant

        MASSEDFLUIDDENSITY (int):
            Instance specific constant

        MASSEDFLUIDDENSITYVAL (int):
            Instance specific constant

        MASSEDFLUIDVISCOSITY (int):
            Instance specific constant

        MASSEDFLUIDVISCOSITYVAL (int):
            Instance specific constant

        MASSEDGRAVITY (int):
            Instance specific constant

        MASSEDGRAVITYVECTOR (int):
            Instance specific constant

        MASSEDINITIALUSEFLUID (int):
            Instance specific constant

        MASSEDINITIALVELOCITY (int):
            Instance specific constant

        MASSEDPARTICLEDENSITY (int):
            Instance specific constant

        MASSEDPARTICLEDIAMETER (int):
            Instance specific constant

        MASSEDPARTICLES (int):
            Instance specific constant

        MASSEDPRESSURE (int):
            Instance specific constant

        MASSEDPRESSUREGRADIENT (int):
            Instance specific constant

        MASSEDREBOUND (int):
            Instance specific constant

        MASSEDREBOUNDFRACTION (int):
            Instance specific constant

        MASSEDREBOUNDWALLHITS (int):
            Instance specific constant

        MASSEDUSEBALLISTIC (int):
            Instance specific constant

        MATERIALBASETYPE (int):
            Instance specific constant

        MATERIALDESCRIPTION (int):
            Instance specific constant

        MATERIALS (int):
            Instance specific constant

        MATRIX (int):
            Instance specific constant

        MATTE_MATERIAL (int):
            Instance specific constant

        MAX (int):
            Instance specific constant

        MAXANGLE (int):
            Instance specific constant

        MAXIMUM (int):
            Instance specific constant

        MAXTIME (int):
            Instance specific constant

        MAX_MARKERS (int):
            Instance specific constant

        MAX_TRACK (int):
            Instance specific constant

        MESHPLANE (int):
            Instance specific constant

        MESHPLANEIJK (int):
            Instance specific constant

        MESHPLANERTZ (int):
            Instance specific constant

        MESHPLANEXYZ (int):
            Instance specific constant

        MESHRESOLUTION (int):
            Instance specific constant

        MESHTYPE (int):
            Instance specific constant

        MESH_2D (int):
            Instance specific constant

        MESH_2D_X (int):
            Instance specific constant

        MESH_2D_Y (int):
            Instance specific constant

        MESH_2D_Z (int):
            Instance specific constant

        MESH_3D (int):
            Instance specific constant

        MESH_LINE (int):
            Instance specific constant

        MESH_NONE (int):
            Instance specific constant

        MESH_SLICEI (int):
            Instance specific constant

        MESH_SLICEJ (int):
            Instance specific constant

        MESH_SLICEK (int):
            Instance specific constant

        MESH_SLICE_RTZ_R (int):
            Instance specific constant

        MESH_SLICE_RTZ_T (int):
            Instance specific constant

        MESH_SLICE_RTZ_Z (int):
            Instance specific constant

        MESH_SLICE_X (int):
            Instance specific constant

        MESH_SLICE_Y (int):
            Instance specific constant

        MESH_SLICE_Z (int):
            Instance specific constant

        MESH_TRIS (int):
            Instance specific constant

        METADATA (int):
            Instance specific constant

        METALLICPAINT_MATERIAL (int):
            Instance specific constant

        METAL_MATERIAL (int):
            Instance specific constant

        METHOD (int):
            Instance specific constant

        MFNTS_JUMP_TO_END (int):
            Instance specific constant

        MFNTS_OFF (int):
            Instance specific constant

        MFNTS_STAY_AT_CURRENT (int):
            Instance specific constant

        MIN (int):
            Instance specific constant

        MINANGLE (int):
            Instance specific constant

        MINIMUM (int):
            Instance specific constant

        MINMAX (int):
            Instance specific constant

        MINMAXCONST (int):
            Instance specific constant

        MINSTEPS (int):
            Instance specific constant

        MIN_TRACK (int):
            Instance specific constant

        MIRRORORIGINAL (int):
            Instance specific constant

        MIRROR_MATERIAL (int):
            Instance specific constant

        MI_ALG_SMOOTH (int):
            Instance specific constant

        MI_ALG_YOUNGS (int):
            Instance specific constant

        MI_TYPE_DOMAIN (int):
            Instance specific constant

        MI_TYPE_INTERFACE (int):
            Instance specific constant

        MODEL_RECORD_CMD_LANG_GLOBAL (int):
            Instance specific constant

        MODEL_RECORD_CMD_LANG_HONOR (int):
            Instance specific constant

        MODEL_RECORD_CMD_LANG_OFF (int):
            Instance specific constant

        MODEL_RECORD_CMD_LANG_ON (int):
            Instance specific constant

        MOMENTUM (int):
            Instance specific constant

        MOUSE_ACTION_NONE (int):
            Instance specific constant

        MOUSE_BTN_ALL (int):
            Instance specific constant

        MOUSE_BTN_LEFT (int):
            Instance specific constant

        MOUSE_BTN_LEFT_MIDDLE (int):
            Instance specific constant

        MOUSE_BTN_LEFT_RIGHT (int):
            Instance specific constant

        MOUSE_BTN_MIDDLE (int):
            Instance specific constant

        MOUSE_BTN_RIGHT (int):
            Instance specific constant

        MOUSE_BTN_RIGHT_MIDDLE (int):
            Instance specific constant

        MOUSE_NORMAL_ACTION (int):
            Instance specific constant

        MOUSE_PICK_ACTION (int):
            Instance specific constant

        MOUSE_PICK_BLANK_ELEMENTS (int):
            Instance specific constant

        MOUSE_PICK_CURSOR (int):
            Instance specific constant

        MOUSE_PICK_PART (int):
            Instance specific constant

        MOUSE_PICK_PART_OPTIONS (int):
            Instance specific constant

        MOUSE_PICK_TRANSFORM_CENTER (int):
            Instance specific constant

        MOUSE_ROTATE (int):
            Instance specific constant

        MOUSE_SELECT_TOOL (int):
            Instance specific constant

        MOUSE_TRANSLATE (int):
            Instance specific constant

        MOUSE_USER_DEFINED (int):
            Instance specific constant

        MOUSE_ZOOM (int):
            Instance specific constant

        MOUSE_ZOOMBAND (int):
            Instance specific constant

        MRU (int):
            Instance specific constant

        MULTIPLEPULSES (int):
            Instance specific constant

        MULTIPLESEGMENTSBY (int):
            Instance specific constant

        NEGATIVE_SURFACE_DIRECTION (int):
            Instance specific constant

        NEG_TIME (int):
            Instance specific constant

        NLEVELS (int):
            Instance specific constant

        NODEDETAIL (int):
            Instance specific constant

        NODEID (int):
            Instance specific constant

        NODEMAX (int):
            Instance specific constant

        NODEMIN (int):
            Instance specific constant

        NODERANGESTEPI (int):
            Instance specific constant

        NODERANGESTEPJ (int):
            Instance specific constant

        NODERANGESTEPK (int):
            Instance specific constant

        NODESCALE (int):
            Instance specific constant

        NODESIZEBY (int):
            Instance specific constant

        NODESTEP (int):
            Instance specific constant

        NODETYPE (int):
            Instance specific constant

        NODEVARIABLE (int):
            Instance specific constant

        NODE_LOCK (int):
            Instance specific constant

        NODE_TRACKS (int):
            Instance specific constant

        NORMAL (int):
            Instance specific constant

        NORMALIZEDWIDTH (int):
            Instance specific constant

        NORMALIZEX (int):
            Instance specific constant

        NORMALIZEY (int):
            Instance specific constant

        NORMALSPOINT (int):
            Instance specific constant

        NOTLOAD_FULL (int):
            Instance specific constant

        NOT_LOADED (int):
            Instance specific constant

        NO_ARRW (int):
            Instance specific constant

        NO_TRACKING (int):
            Instance specific constant

        NUMCONTROLPOINTS (int):
            Instance specific constant

        NUMDISPLAYED (int):
            Instance specific constant

        NUMFRAMES (int):
            Instance specific constant

        NUMOFARROWS (int):
            Instance specific constant

        NUMOFLEVELS (int):
            Instance specif