# Библиотека для работы с API Topvisor

Эта библиотека предоставляет удобный интерфейс для работы с API Topvisor в Python. 
В текущей версии поддерживаются только GET-методы API, а также следующие сервисы: `projects`, `positions` и `snapshots`. 
Функционал библиотеки будет постепенно расширяться.

## Инициализация клиента
Для начала вам нужно создать экземпляр класса `Topvisor`, передав в него ваш `user_id` и `api_key`.

```python
from pytopvisor.topvisor import Topvisor

topvisor = Topvisor(user_id="your_user_id", api_key="your_api_key")
```
- **user_id**: Ваш идентификатор пользователя в Topvisor (строка или целое число).
- **api_key**: Ваш API-ключ, полученный в настройках аккаунта Topvisor (строка).

## Выполнение операций
Библиотека использует метод `run_task` для выполнения запросов к API. Поддерживаются следующие операции:

- **get_projects**: извлечение списка проектов.
- **get_competitors**: извлечение списка конкурентов для указанного проекта.
- **get_history**: извлечение истории проверок позиций.
- **get_summary**: извлечение сводки по позициям за две даты.
- **get_summary_chart**: извлечение данных для графика сводки.
- **get_snapshots_history**: извлечение истории снимков (сниппетов) за указанный период или даты.

### Получение списка проектов (`get_projects`)
Извлекает список всех проектов, доступных для вашего аккаунта.

```python
projects = topvisor.run_task(
    "get_projects",
    show_site_stat=False,
    show_searchers_and_regions=0,  
    include_positions_summary=False  
)
```
- **show_site_stat**: Показывать статистику сайта (логическое значение, опционально).
- **show_searchers_and_regions**: Показывать поисковые системы и регионы (целое число: 1 — да, 0 — нет, опционально).
- **include_positions_summary**: Включать сводку по позициям (логическое значение, опционально).
- 
### Получение списка конкурентов (`get_competitors`)
Извлекает список конкурентов для указанного проекта.
```python
competitors = topvisor.run_task(
    "get_competitors",
    project_id=12345,
    only_enabled=True,
    include_project=False
)
```

- **project_id**: Идентификатор проекта (целое число, обязательно).
- **only_enabled**: Показывать только активных конкурентов (логическое значение, опционально).
- **include_project**: Включать сам проект в список (логическое значение, опционально).

### Получение истории проверок позиций (`get_positions_history`)

```python
history = topvisor.run_task(
    "get_positions_history",
    project_id=12345,
    regions_indexes=[643],
    date1="2023-01-01",
    date2="2023-01-31",
    competitors_ids=None,
    type_range=2,
    count_dates=None,
    only_exists_first_date=False,
    show_headers=False,
    show_visitors=False,
    show_top_by_depth=0,
    positions_fields=None,
    filter_by_dynamic=None,
    filter_by_positions=None,
)
```

- **project_id**: Идентификатор проекта (целое число, обязательно).
- **regions_indexes**: Список индексов регионов (список целых чисел, обязательно).
- **dates**: Список конкретных дат (список строк в формате "YYYY-MM-DD", обязательный, но взаимоисключающий с date1/date2).
- **date1**: Начальная дата периода (строка в формате "YYYY-MM-DD", опционально).
- **date2**: Конечная дата периода (строка в формате "YYYY-MM-DD", опционально, требуется с date1).
- **competitors_ids**: Список идентификаторов конкурентов (список целых чисел, опционально).
- **type_range**: Тип диапазона дат (целое число: 0-7 или 100, опционально).
- **count_dates**: Максимальное количество возвращаемых дат (целое число, до 31, опционально).
- **only_exists_first_date**: Учитывать только фразы, присутствующие в первой проверке (логическое значение, опционально).
- **show_headers**: Добавить заголовки результатов (логическое значение, опционально).
- **show_visitors**: Добавить данные о визитах (логическое значение, опционально).
- **show_top_by_depth**: Глубина для данных по ТОПу (целое число, опционально).
- **positions_fields**: Список полей данных позиций (список строк, по умолчанию None).
- **filter_by_dynamic**: Фильтр по динамике позиций (список строк, по умолчанию None).
- **filter_by_positions**: Фильтр по диапазонам позиций (список списков целых чисел, по умолчанию None).

### Получение сводки по позициям (`get_positions_summary`)
Извлекает сводку по позициям ключевых фраз за две даты.

```python
summary = topvisor.run_task(
    "get_positions_summary",
    project_id=12345,
    region_index=643,
    dates=["2023-01-01", "2023-01-31"],
    competitor_id=123,
    only_exists_first_date=True,
    show_dynamics=True,
    show_tops=True,
    show_avg=True,
    show_visibility=True,
    show_median=True
)
```

- **project_id**: Идентификатор проекта (целое число, обязательно).
- **region_index**: Индекс региона (целое число, обязательно).
- **dates**: Список из двух дат для сравнения (список строк в формате "YYYY-MM-DD", обязательно).
- **competitor_id**: Идентификатор конкурента (целое число, по умолчанию None).
- **only_exists_first_date**: Учитывать фразы, присутствующие в обеих датах (логическое значение, по умолчанию None).
- **show_dynamics**: Добавить динамику позиций (логическое значение, по умолчанию None).
- **show_tops**: Добавить данные по ТОПам (логическое значение, по умолчанию None).
- **show_avg**: Добавить среднюю позицию (логическое значение, по умолчанию None).
- **show_visibility**: Добавить видимость (логическое значение, по умолчанию None).
- **show_median**: Добавить медианную позицию (логическое значение, по умолчанию None).


### Получение данных для графика сводки (`get_positions_summary_chart`)
Извлекает данные для построения графика сводки позиций за период.
```python
summary_chart = topvisor.run_task(
    "get_positions_summary_chart",
    project_id=12345,
    region_index=643,
    date1="2023-01-01",
    date2="2023-01-31",
    competitors_ids=[123, 456],
    type_range=2,
    only_exists_first_date=True,
    show_tops=True,
    show_avg=True,
    show_visibility=True
)
```

- **project_id**: Идентификатор проекта (целое число, обязательно).
- **region_index**: Индекс региона (целое число, обязательно).
- **dates**: Список конкретных дат (список строк в формате "YYYY-MM-DD", обязательный, но взаимоисключающий с date1/date2).
- **date1**: Начальная дата периода (строка в формате "YYYY-MM-DD", опционально).
- **date2**: Конечная дата периода (строка в формате "YYYY-MM-DD", опционально, требуется с date1).
- **competitors_ids**: Список идентификаторов конкурентов (список целых чисел, опционально).
- **type_range**: Тип диапазона дат (целое число: 0-7 или 100, опционально).
- **only_exists_first_date**: Учитывать фразы, присутствующие в обеих датах (логическое значение, по умолчанию None).
- **show_tops**: Добавить данные по ТОПам (логическое значение, по умолчанию None).
- **show_avg**: Добавить среднюю позицию (логическое значение, по умолчанию None).
- **show_visibility**: Добавить видимость (логическое значение, по умолчанию None).

### Получение истории снимков (`get_snapshots_history`)

Извлекает данные для построения графика сводки позиций за период.
```python
snapshots = topvisor.run_task(
    "get_snapshots_history",
    project_id=5288721,
    region_index=30,
    dates=["2025-02-26", "2025-02-27", "2025-02-28"],
    type_range=2,
    count_dates=10,
    show_exists_dates=True,
    show_ams=True,
    positions_fields=["url", "domain", "snippet_title", "snippet_body"],
)
```

- **project_id**: Идентификатор проекта (целое число, обязательно).
- **region_index**: Индекс региона (целое число, обязательно).
- **dates**: Список конкретных дат (список строк в формате "YYYY-MM-DD", обязательный, но взаимоисключающий с date1/date2).
- **date1**: Начальная дата периода (строка в формате "YYYY-MM-DD", опционально).
- **date2**: Конечная дата периода (строка в формате "YYYY-MM-DD", опционально, требуется с date1).
- **type_range**: Тип диапазона дат (целое число: 0-7 или 100, опционально).
- **count_dates**: Максимальное количество возвращаемых дат (целое число, до 31, по умолчанию None).
- **show_exists_dates**: Добавить даты с существующими проверками (логическое значение, по умолчанию None)
- **show_ams**: Добавить индекс шторма между проверками (логическое значение, по умолчанию None).
- **positions_fields**: Список полей данных снимков (список строк, по умолчанию ["url", "domain", "snippet_title", "snippet_body"]).
