"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSageMakerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const constructs_1 = require("constructs");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @summary The ApiGatewayToSageMakerEndpoint class.
 */
class ApiGatewayToSageMakerEndpoint extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSageMakerEndpoint class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSageMakerEndpointProps} props - user provided props for the construct.
     * @since 1.68.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup the API Gateway
        [this.apiGateway, this.apiGatewayCloudWatchRole, this.apiGatewayLogGroup] = defaults.GlobalRestApi(this, props.apiGatewayProps, props.logGroupProps);
        // Setup the API Gateway role
        if (props.apiGatewayExecutionRole !== undefined) {
            this.apiGatewayRole = props.apiGatewayExecutionRole;
        }
        else {
            this.apiGatewayRole = new iam.Role(this, 'api-gateway-role', {
                assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com')
            });
            // Setup the IAM policy for SageMaker endpoint
            const invokePolicy = new iam.Policy(this, 'InvokeEndpointPolicy', {
                statements: [
                    new iam.PolicyStatement({
                        actions: ['sagemaker:InvokeEndpoint'],
                        resources: [`arn:${aws_cdk_lib_1.Aws.PARTITION}:sagemaker:${aws_cdk_lib_1.Aws.REGION}:${aws_cdk_lib_1.Aws.ACCOUNT_ID}:endpoint/${props.endpointName}`]
                    })
                ]
            });
            invokePolicy.attachToRole(this.apiGatewayRole);
        }
        // Setup request validation
        const requestValidator = this.apiGateway.addRequestValidator('request-validator', {
            requestValidatorName: 'request-param-validator',
            // Setting this property to true makes sure the following are validated:
            // - Required request parameters in the URI
            // - Query string
            // - Headers
            validateRequestParameters: true
        });
        // Setup method and integration responses
        const methodResponses = [
            { statusCode: '200' },
            { statusCode: '500' },
            { statusCode: '400' }
        ];
        const integResponses = [];
        if (props.responseMappingTemplate !== undefined) {
            integResponses.push({
                statusCode: '200',
                responseTemplates: { 'application/json': props.responseMappingTemplate }
            });
        }
        else {
            integResponses.push({ statusCode: '200' });
        }
        integResponses.push({ statusCode: '500', selectionPattern: '5\\d{2}' }, { statusCode: '400', selectionPattern: '4\\d{2}' });
        // The SageMaker integration can be added either at the root of the API (GET https://execute-api.amazonaws.com/{some-param}),
        // or as a sub-resource (GET https://execute-api.amazonaws.com/inference/{some-param}).
        // The following lines will make sure only the necessary resources are created.
        let apiResource = this.apiGateway.root;
        if (props.resourceName !== undefined) {
            apiResource = apiResource.addResource(props.resourceName);
        }
        apiResource = apiResource.addResource(props.resourcePath);
        // Setup API Gateway method
        defaults.addProxyMethodToApiResource({
            service: 'runtime.sagemaker',
            path: `endpoints/${props.endpointName}/invocations`,
            apiGatewayRole: this.apiGatewayRole,
            apiMethod: 'GET',
            apiResource,
            requestValidator,
            requestTemplate: props.requestMappingTemplate,
            awsIntegrationProps: {
                options: { integrationResponses: integResponses }
            },
            methodOptions: { methodResponses }
        });
    }
}
exports.ApiGatewayToSageMakerEndpoint = ApiGatewayToSageMakerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSageMakerEndpoint[_a] = { fqn: "@aws-solutions-constructs/aws-apigateway-sagemakerendpoint.ApiGatewayToSageMakerEndpoint", version: "2.7.0" };
//# sourceMappingURL=data:application/json;base64,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