/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, ProjectOptions } from "projen";
/**
 * Options for the smithy model project
 */
export interface SmithyModelOptions extends ProjectOptions {
    /**
     * The namespace of the service, eg com.mycompany
     */
    readonly serviceNamespace: string;
    /**
     * The name of the service, eg MyService
     */
    readonly serviceName: string;
}
/**
 * A project which contains a hello-world Smithy model
 */
export declare class SmithyModelProject extends Project {
    constructor(options: SmithyModelOptions);
}
