"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayPythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_python_project_1 = require("./open-api-gateway-python-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 */
class SmithyApiGatewayPythonProject extends open_api_gateway_python_project_1.OpenApiGatewayPythonProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayPythonProject = SmithyApiGatewayPythonProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayPythonProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject", version: "0.12.34" };
//# sourceMappingURL=data:application/json;base64,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