# MLPerf Automations and Scripts

[![License](https://img.shields.io/badge/License-Apache%202.0-green)](LICENSE.md)
[![Downloads](https://static.pepy.tech/badge/cm4mlops)](https://pepy.tech/project/cm4mlops)
[![CM Script Automation Test](https://github.com/mlcommons/mlperf-automations/actions/workflows/test-cm-script-features.yml/badge.svg)](https://github.com/mlcommons/mlperf-automations/actions/workflows/test-cm-script-features.yml)
[![MLPerf Inference ABTF POC Test](https://github.com/mlcommons/mlperf-automations/actions/workflows/test-mlperf-inference-abtf-poc.yml/badge.svg)](https://github.com/mlcommons/mlperf-automations/actions/workflows/test-mlperf-inference-abtf-poc.yml)

Welcome to the **MLPerf Automations and Scripts** repository! This repository provides tools, automations, and scripts to facilitate running MLPerf benchmarks, with a primary focus on **MLPerf Inference benchmarks**.

The automations build upon and extend the powerful [Collective Mind (CM) script automations](https://github.com/mlcommons/cm4mlops/tree/main/automation/script) to streamline benchmarking and workflow processes.


---

## 🚀 Key Features
- **Automated Benchmarking** – Simplifies running MLPerf Inference benchmarks with minimal manual intervention.
- **Modular and Extensible** – Easily extend the scripts to support additional benchmarks and configurations.
- **Seamless Integration** – Compatible with Docker, cloud environments, and local machines.
- **Collective Mind (CM) Integration** – Utilizes the CM framework to enhance reproducibility and automation.

---

## 🧰 Collective Mind (CM) Automations

The **Collective Mind (CM)** framework is a Python-based package offering both CLI and API support for creating and managing automations. CM automations enhance ML workflows by simplifying complex tasks such as Docker container management and caching.

### Core Automations
- **Script Automation** – Automates script execution across different environments.
- **Cache Management** – Manages reusable cached results to accelerate workflow processes.

Learn more about CM in the [CM4MLOps documentation](https://github.com/mlcommons/cm4mlops).


---

## 🤝 Contributing
We welcome contributions from the community! To contribute:
1. Submit pull requests (PRs) to the **`dev`** branch.
2. Review our [CONTRIBUTORS.md](here) for guidelines and best practices.
3. Explore more about MLPerf Inference automation in the official [MLPerf Inference Documentation](https://docs.mlcommons.org/inference/).

Your contributions help drive the project forward!

---

## 📰 News
Stay tuned for upcoming updates and announcements.

---

## 📄 License
This project is licensed under the [Apache 2.0 License](LICENSE.md).

---

## 💡 Acknowledgments and Funding
This project is made possible through the generous support of:
- [OctoML](https://octoml.ai)
- [cKnowledge.org](https://cKnowledge.org)
- [cTuning Foundation](https://cTuning.org)
- [MLCommons](https://mlcommons.org)

We appreciate their contributions and sponsorship!

---

Thank you for your interest and support in MLPerf Automations and Scripts!
