# coding: utf-8

"""
    Client Portal Web API

    Client Poral Web API  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ib_web_api.api_client import ApiClient


class OrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def iserver_account_account_id_order_order_id_delete(self, account_id, order_id, **kwargs):  # noqa: E501
        """Cancel Order  # noqa: E501

        Cancels an open order. Must call /iserver/accounts endpoint prior to cancelling an order. Use /iservers/account/orders endpoint to review open-order(s) and get latest order status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_order_id_delete(account_id, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account id, or fa group if deleting a group order (required)
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: InlineResponse20029
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_order_order_id_delete_with_http_info(account_id, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_order_order_id_delete_with_http_info(account_id, order_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_order_order_id_delete_with_http_info(self, account_id, order_id, **kwargs):  # noqa: E501
        """Cancel Order  # noqa: E501

        Cancels an open order. Must call /iserver/accounts endpoint prior to cancelling an order. Use /iservers/account/orders endpoint to review open-order(s) and get latest order status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_order_id_delete_with_http_info(account_id, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account id, or fa group if deleting a group order (required)
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: InlineResponse20029
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_order_order_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_order_order_id_delete`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `iserver_account_account_id_order_order_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/order/{orderId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20029',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_account_id_order_order_id_post(self, body, account_id, order_id, **kwargs):  # noqa: E501
        """Modify Order  # noqa: E501

        Modifies an open order. Must call /iserver/accounts endpoint prior to modifying an order. Use /iservers/account/orders endpoint to review open-order(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_order_id_post(body, account_id, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModifyOrder body: modify-order request (required)
        :param str account_id: account id, or fa group if modifying a group order (required)
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: list[InlineResponse20028]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_order_order_id_post_with_http_info(body, account_id, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_order_order_id_post_with_http_info(body, account_id, order_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_order_order_id_post_with_http_info(self, body, account_id, order_id, **kwargs):  # noqa: E501
        """Modify Order  # noqa: E501

        Modifies an open order. Must call /iserver/accounts endpoint prior to modifying an order. Use /iservers/account/orders endpoint to review open-order(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_order_id_post_with_http_info(body, account_id, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModifyOrder body: modify-order request (required)
        :param str account_id: account id, or fa group if modifying a group order (required)
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: list[InlineResponse20028]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_order_order_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_account_id_order_order_id_post`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_order_order_id_post`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `iserver_account_account_id_order_order_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/order/{orderId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20028]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_account_id_order_post(self, body, account_id, **kwargs):  # noqa: E501
        """Place Order (Deprecated)  # noqa: E501

        This endpoint is going to be deprecated, you can use /iserver/account/{accountId}/orders, just pass one order in the array, the order structure will be same. Please note here, sometimes this endpoint alone can't make sure you submit the order successfully, you could receive some questions in the response, you have to to answer them in order to submit the order successfully. You can use \"/iserver/reply/{replyid}\" endpoint to answer questions   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_post(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order request info (required)
        :param str account_id: account id (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_order_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_order_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_order_post_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Place Order (Deprecated)  # noqa: E501

        This endpoint is going to be deprecated, you can use /iserver/account/{accountId}/orders, just pass one order in the array, the order structure will be same. Please note here, sometimes this endpoint alone can't make sure you submit the order successfully, you could receive some questions in the response, you have to to answer them in order to submit the order successfully. You can use \"/iserver/reply/{replyid}\" endpoint to answer questions   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_post_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order request info (required)
        :param str account_id: account id (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_order_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_account_id_order_post`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_order_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20025]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_account_id_order_whatif_post(self, body, account_id, **kwargs):  # noqa: E501
        """Preview Order (Deprecated)  # noqa: E501

        This end-point is going to be deprecated, you can use /iserver/account/{accountId}/orders/whatif, just pass one order in the array, the order structure will be same. This endpoint allows you to preview order without actually submitting the order and you can get commission information in the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_whatif_post(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order info (required)
        :param str account_id: account id (required)
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_order_whatif_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_order_whatif_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_order_whatif_post_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Preview Order (Deprecated)  # noqa: E501

        This end-point is going to be deprecated, you can use /iserver/account/{accountId}/orders/whatif, just pass one order in the array, the order structure will be same. This endpoint allows you to preview order without actually submitting the order and you can get commission information in the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_order_whatif_post_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order info (required)
        :param str account_id: account id (required)
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_order_whatif_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_account_id_order_whatif_post`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_order_whatif_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/order/whatif', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20027',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_account_id_orders_post(self, body, account_id, **kwargs):  # noqa: E501
        """Place Orders  # noqa: E501

        When connected to an IServer Brokerage Session, this endpoint will allow you to submit orders.  CP WEB API supports various advanced orderTypes, for additional details and examples refer to [IBKR Quant Blog](https://www.tradersinsight.news/category/ibkr-quant-news/programming_languages/rest-development/).   * Bracket - Attach additional opposite-side order(s) by using a single **cOID** sent with the parent and set the same value for **parentId** in each child order(s).   * Cash Quantity -  Send orders using monetary value by specifying **cashQty** instead of quantity, e.g. cashQty: 200. The endpoint /iserver/contract/rules returns list of valid orderTypes in cqtTypes.   * Currency Conversion - Convert cash from one currency to another by including **isCcyConv** = **true**. To specify the cash quantity use **fxQTY** instead of quantity, e.g. fxQTY: 100.   * Fractional - Contracts that support fractional shares can be traded by specifying **quantity** as a float, e.g. quantity: 0.001. The endpoint /iserver/contract/rules returns a list of valid orderTypes in fraqTypes.   * IB Algos - Attached user-defined settings to your trades by using any of IBKR's Algo Orders. Use the endpoint /iserver/contract/{conid}/algos to identify the available strategies for a contract.   * One-Cancels-All (OCA) - Group multiple unrelated orders by passing order request info in an array and including **isSingleGroup = true** for each order. All orders will be assigned the same oca_group_id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_orders_post(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountIdOrdersBody body: order request info (required)
        :param str account_id: account id (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_orders_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_orders_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_orders_post_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Place Orders  # noqa: E501

        When connected to an IServer Brokerage Session, this endpoint will allow you to submit orders.  CP WEB API supports various advanced orderTypes, for additional details and examples refer to [IBKR Quant Blog](https://www.tradersinsight.news/category/ibkr-quant-news/programming_languages/rest-development/).   * Bracket - Attach additional opposite-side order(s) by using a single **cOID** sent with the parent and set the same value for **parentId** in each child order(s).   * Cash Quantity -  Send orders using monetary value by specifying **cashQty** instead of quantity, e.g. cashQty: 200. The endpoint /iserver/contract/rules returns list of valid orderTypes in cqtTypes.   * Currency Conversion - Convert cash from one currency to another by including **isCcyConv** = **true**. To specify the cash quantity use **fxQTY** instead of quantity, e.g. fxQTY: 100.   * Fractional - Contracts that support fractional shares can be traded by specifying **quantity** as a float, e.g. quantity: 0.001. The endpoint /iserver/contract/rules returns a list of valid orderTypes in fraqTypes.   * IB Algos - Attached user-defined settings to your trades by using any of IBKR's Algo Orders. Use the endpoint /iserver/contract/{conid}/algos to identify the available strategies for a contract.   * One-Cancels-All (OCA) - Group multiple unrelated orders by passing order request info in an array and including **isSingleGroup = true** for each order. All orders will be assigned the same oca_group_id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_orders_post_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountIdOrdersBody body: order request info (required)
        :param str account_id: account id (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_orders_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_account_id_orders_post`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_orders_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20025]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_account_id_orders_whatif_post(self, body, account_id, **kwargs):  # noqa: E501
        """Preview Orders  # noqa: E501

        This endpoint allows you to preview order without actually submitting the order and you can get commission information in the response. Also supports bracket orders.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_orders_whatif_post(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrdersWhatifBody body: order info (required)
        :param str account_id: account id (required)
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_account_id_orders_whatif_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_account_id_orders_whatif_post_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_account_id_orders_whatif_post_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Preview Orders  # noqa: E501

        This endpoint allows you to preview order without actually submitting the order and you can get commission information in the response. Also supports bracket orders.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_account_id_orders_whatif_post_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrdersWhatifBody body: order info (required)
        :param str account_id: account id (required)
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_account_id_orders_whatif_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_account_id_orders_whatif_post`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `iserver_account_account_id_orders_whatif_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/{accountId}/orders/whatif', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20027',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_order_status_order_id_get(self, order_id, **kwargs):  # noqa: E501
        """Order Status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_order_status_order_id_get(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_order_status_order_id_get_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_order_status_order_id_get_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def iserver_account_order_status_order_id_get_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Order Status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_order_status_order_id_get_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Customer order id, use /iservers/account/orders endpoint to query orderId. (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_order_status_order_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `iserver_account_order_status_order_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/order/status/{orderId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_orders_fa_group_post(self, body, fa_group, **kwargs):  # noqa: E501
        """Place Orders for FA  # noqa: E501

        Financial Advisors can use this endpoint to place an order for a specified group. To place an order for a specified account use the endpoint /iserver/account/{accountId}/order. More information about groups can be found in the [TWS Users' Guide:](https://guides.interactivebrokers.com/twsguide/twsguide.htm#usersguidebook/financialadvisors/create_an_account_group_for_share_allocation.htm).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_orders_fa_group_post(body, fa_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order request info (required)
        :param str fa_group: financial advisor group (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_orders_fa_group_post_with_http_info(body, fa_group, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_orders_fa_group_post_with_http_info(body, fa_group, **kwargs)  # noqa: E501
            return data

    def iserver_account_orders_fa_group_post_with_http_info(self, body, fa_group, **kwargs):  # noqa: E501
        """Place Orders for FA  # noqa: E501

        Financial Advisors can use this endpoint to place an order for a specified group. To place an order for a specified account use the endpoint /iserver/account/{accountId}/order. More information about groups can be found in the [TWS Users' Guide:](https://guides.interactivebrokers.com/twsguide/twsguide.htm#usersguidebook/financialadvisors/create_an_account_group_for_share_allocation.htm).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_orders_fa_group_post_with_http_info(body, fa_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderRequest body: order request info (required)
        :param str fa_group: financial advisor group (required)
        :return: list[InlineResponse20025]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fa_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_orders_fa_group_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_account_orders_fa_group_post`")  # noqa: E501
        # verify the required parameter 'fa_group' is set
        if ('fa_group' not in params or
                params['fa_group'] is None):
            raise ValueError("Missing the required parameter `fa_group` when calling `iserver_account_orders_fa_group_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fa_group' in params:
            path_params['faGroup'] = params['fa_group']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/orders/{faGroup}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20025]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_account_orders_get(self, **kwargs):  # noqa: E501
        """Live Orders  # noqa: E501

        The endpoint is meant to be used in polling mode, e.g. requesting every x seconds. The response will contain two objects, one is notification, the other is orders. Orders is the list of live orders (cancelled, filled, submitted). Notifications contains information about execute orders as they happen, see status field. To receive streaming live orders the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_orders_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filters: list of filters separated by comma
        :return: InlineResponse20024
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_account_orders_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.iserver_account_orders_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def iserver_account_orders_get_with_http_info(self, **kwargs):  # noqa: E501
        """Live Orders  # noqa: E501

        The endpoint is meant to be used in polling mode, e.g. requesting every x seconds. The response will contain two objects, one is notification, the other is orders. Orders is the list of live orders (cancelled, filled, submitted). Notifications contains information about execute orders as they happen, see status field. To receive streaming live orders the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_account_orders_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filters: list of filters separated by comma
        :return: InlineResponse20024
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_account_orders_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filters' in params:
            query_params.append(('Filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/account/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20024',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_reply_replyid_post(self, body, replyid, **kwargs):  # noqa: E501
        """Place Order Reply  # noqa: E501

        Reply to questions when placing orders and submit orders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_reply_replyid_post(body, replyid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplyReplyidBody body: Answer to question (required)
        :param str replyid: Please use the \"id\" from the response of \"Place Order\" endpoint (required)
        :return: list[InlineResponse20026]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_reply_replyid_post_with_http_info(body, replyid, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_reply_replyid_post_with_http_info(body, replyid, **kwargs)  # noqa: E501
            return data

    def iserver_reply_replyid_post_with_http_info(self, body, replyid, **kwargs):  # noqa: E501
        """Place Order Reply  # noqa: E501

        Reply to questions when placing orders and submit orders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_reply_replyid_post_with_http_info(body, replyid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplyReplyidBody body: Answer to question (required)
        :param str replyid: Please use the \"id\" from the response of \"Place Order\" endpoint (required)
        :return: list[InlineResponse20026]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'replyid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_reply_replyid_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_reply_replyid_post`")  # noqa: E501
        # verify the required parameter 'replyid' is set
        if ('replyid' not in params or
                params['replyid'] is None):
            raise ValueError("Missing the required parameter `replyid` when calling `iserver_reply_replyid_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'replyid' in params:
            path_params['replyid'] = params['replyid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/reply/{replyid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20026]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
