# coding: utf-8

"""
    Client Portal Web API

    Client Poral Web API  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ib_web_api.api_client import ApiClient


class MarketDataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def hmds_history_get(self, conid, period, **kwargs):  # noqa: E501
        """Market Data History (Beta)  # noqa: E501

        Using a direct connection to the market data farm, will provide a list of historical market data for given conid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.hmds_history_get(conid, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conid: contract id (required)
        :param str period: Time period for history request.    * min: Minutes   * h: Hours   * d: Days   * w: Weeks   * m: Months   * y: Years  (required)
        :param str bar: Duration of time for each candlestick bar.   * min: Minutes   * h: Hours   * d: Days   * w: Weeks   * m: Months 
        :param bool outside_rth: For contracts that support it, will determine if history data includes outside of regular trading hours.
        :return: HistoryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.hmds_history_get_with_http_info(conid, period, **kwargs)  # noqa: E501
        else:
            (data) = self.hmds_history_get_with_http_info(conid, period, **kwargs)  # noqa: E501
            return data

    def hmds_history_get_with_http_info(self, conid, period, **kwargs):  # noqa: E501
        """Market Data History (Beta)  # noqa: E501

        Using a direct connection to the market data farm, will provide a list of historical market data for given conid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.hmds_history_get_with_http_info(conid, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conid: contract id (required)
        :param str period: Time period for history request.    * min: Minutes   * h: Hours   * d: Days   * w: Weeks   * m: Months   * y: Years  (required)
        :param str bar: Duration of time for each candlestick bar.   * min: Minutes   * h: Hours   * d: Days   * w: Weeks   * m: Months 
        :param bool outside_rth: For contracts that support it, will determine if history data includes outside of regular trading hours.
        :return: HistoryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'period', 'bar', 'outside_rth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hmds_history_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `hmds_history_get`")  # noqa: E501
        # verify the required parameter 'period' is set
        if ('period' not in params or
                params['period'] is None):
            raise ValueError("Missing the required parameter `period` when calling `hmds_history_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conid' in params:
            query_params.append(('conid', params['conid']))  # noqa: E501
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'bar' in params:
            query_params.append(('bar', params['bar']))  # noqa: E501
        if 'outside_rth' in params:
            query_params.append(('outsideRth', params['outside_rth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/hmds/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_marketdata_conid_unsubscribe_get(self, conid, **kwargs):  # noqa: E501
        """Market Data Cancel (Single)  # noqa: E501

        Cancel market data for given conid. To cancel all market data request(s), see /iserver/marketdata/unsubscribeall.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_conid_unsubscribe_get(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :return: InlineResponse20031
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_marketdata_conid_unsubscribe_get_with_http_info(conid, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_marketdata_conid_unsubscribe_get_with_http_info(conid, **kwargs)  # noqa: E501
            return data

    def iserver_marketdata_conid_unsubscribe_get_with_http_info(self, conid, **kwargs):  # noqa: E501
        """Market Data Cancel (Single)  # noqa: E501

        Cancel market data for given conid. To cancel all market data request(s), see /iserver/marketdata/unsubscribeall.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_conid_unsubscribe_get_with_http_info(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :return: InlineResponse20031
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_marketdata_conid_unsubscribe_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_marketdata_conid_unsubscribe_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conid' in params:
            path_params['conid'] = params['conid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/marketdata/{conid}/unsubscribe', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20031',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_marketdata_history_get(self, conid, period, **kwargs):  # noqa: E501
        """Market Data History  # noqa: E501

        Get historical market Data for given conid, length of data is controlled by 'period' and 'bar'. Formatted as: min=minute, h=hour, d=day, w=week, m=month, y=year e.g. period =1y with bar =1w returns 52 data points (Max of 1000 data points supported). **Note**: There's a limit of 5 concurrent requests. Excessive requests will return a 'Too many requests' status 429 response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_history_get(conid, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :param str period: available time period-- {1-30}min, {1-8}h, {1-1000}d, {1-792}w, {1-182}m, {1-15}y (required)
        :param str exchange: Exchange of the conid (e.g. ISLAND, NYSE, etc.). Default value is empty which corresponds to primary exchange of the conid.
        :param str bar: possible value-- 1min, 2min, 3min, 5min, 10min, 15min, 30min, 1h, 2h, 3h, 4h, 8h, 1d, 1w, 1m
        :param bool outside_rth: For contracts that support it, will determine if historical data includes outside of regular trading hours.
        :return: HistoryData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_marketdata_history_get_with_http_info(conid, period, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_marketdata_history_get_with_http_info(conid, period, **kwargs)  # noqa: E501
            return data

    def iserver_marketdata_history_get_with_http_info(self, conid, period, **kwargs):  # noqa: E501
        """Market Data History  # noqa: E501

        Get historical market Data for given conid, length of data is controlled by 'period' and 'bar'. Formatted as: min=minute, h=hour, d=day, w=week, m=month, y=year e.g. period =1y with bar =1w returns 52 data points (Max of 1000 data points supported). **Note**: There's a limit of 5 concurrent requests. Excessive requests will return a 'Too many requests' status 429 response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_history_get_with_http_info(conid, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :param str period: available time period-- {1-30}min, {1-8}h, {1-1000}d, {1-792}w, {1-182}m, {1-15}y (required)
        :param str exchange: Exchange of the conid (e.g. ISLAND, NYSE, etc.). Default value is empty which corresponds to primary exchange of the conid.
        :param str bar: possible value-- 1min, 2min, 3min, 5min, 10min, 15min, 30min, 1h, 2h, 3h, 4h, 8h, 1d, 1w, 1m
        :param bool outside_rth: For contracts that support it, will determine if historical data includes outside of regular trading hours.
        :return: HistoryData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'period', 'exchange', 'bar', 'outside_rth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_marketdata_history_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_marketdata_history_get`")  # noqa: E501
        # verify the required parameter 'period' is set
        if ('period' not in params or
                params['period'] is None):
            raise ValueError("Missing the required parameter `period` when calling `iserver_marketdata_history_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conid' in params:
            query_params.append(('conid', params['conid']))  # noqa: E501
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'bar' in params:
            query_params.append(('bar', params['bar']))  # noqa: E501
        if 'outside_rth' in params:
            query_params.append(('outsideRth', params['outside_rth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/marketdata/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_marketdata_snapshot_get(self, conids, **kwargs):  # noqa: E501
        """Market Data  # noqa: E501

        Get Market Data for the given conid(s). The endpoint will return by default bid, ask, last, change, change pct, close, listing exchange. See response fields for a list of available fields that can be request via fields argument. The endpoint /iserver/accounts must be called prior to /iserver/marketdata/snapshot. For derivative contracts the endpoint /iserver/secdef/search must be called first. First /snapshot endpoint call for given conid will initiate the market data request.  To receive all available fields the /snapshot endpoint will need to be called several times. To receive streaming market data the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_snapshot_get(conids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conids: list of conids separated by comma (required)
        :param int since: time period since which updates are required. uses epoch time with milliseconds.
        :param str fields: list of fields separated by comma
        :return: list[InlineResponse20030]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_marketdata_snapshot_get_with_http_info(conids, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_marketdata_snapshot_get_with_http_info(conids, **kwargs)  # noqa: E501
            return data

    def iserver_marketdata_snapshot_get_with_http_info(self, conids, **kwargs):  # noqa: E501
        """Market Data  # noqa: E501

        Get Market Data for the given conid(s). The endpoint will return by default bid, ask, last, change, change pct, close, listing exchange. See response fields for a list of available fields that can be request via fields argument. The endpoint /iserver/accounts must be called prior to /iserver/marketdata/snapshot. For derivative contracts the endpoint /iserver/secdef/search must be called first. First /snapshot endpoint call for given conid will initiate the market data request.  To receive all available fields the /snapshot endpoint will need to be called several times. To receive streaming market data the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_snapshot_get_with_http_info(conids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conids: list of conids separated by comma (required)
        :param int since: time period since which updates are required. uses epoch time with milliseconds.
        :param str fields: list of fields separated by comma
        :return: list[InlineResponse20030]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conids', 'since', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_marketdata_snapshot_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conids' is set
        if ('conids' not in params or
                params['conids'] is None):
            raise ValueError("Missing the required parameter `conids` when calling `iserver_marketdata_snapshot_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conids' in params:
            query_params.append(('conids', params['conids']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/marketdata/snapshot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20030]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_marketdata_unsubscribeall_get(self, **kwargs):  # noqa: E501
        """Market Data Cancel (All)  # noqa: E501

        Cancel all market data request(s). To cancel market data for given conid, see /iserver/marketdata/{conid}/unsubscribe.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_unsubscribeall_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20032
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_marketdata_unsubscribeall_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.iserver_marketdata_unsubscribeall_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def iserver_marketdata_unsubscribeall_get_with_http_info(self, **kwargs):  # noqa: E501
        """Market Data Cancel (All)  # noqa: E501

        Cancel all market data request(s). To cancel market data for given conid, see /iserver/marketdata/{conid}/unsubscribe.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_marketdata_unsubscribeall_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20032
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_marketdata_unsubscribeall_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/marketdata/unsubscribeall', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20032',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def md_snapshot_get(self, conids, **kwargs):  # noqa: E501
        """Market Data Snapshot (Beta)  # noqa: E501

        Get a snapshot of Market Data for the given conid(s).See response for a list of available fields that can be requested from the fields argument. Must be connected to a brokerage session before can query snapshot data. First /snapshot endpoint call for given conid(s) will initiate the market data request, make an additional request to receive field values back. To receive all available fields the /snapshot endpoint will need to be called several times. To receive streaming market data the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.md_snapshot_get(conids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conids: List of conids comma separated. Optional exchange and instrument type can be specified.   * conid: IBKR Contract Identifier   * exchange: Exchange or venue   * instrType: Instrument Type supported values: CS (Stocks), OPT (Options), FUT (Futures), FOP (Future Options), WAR (Warrants), BOND (Bonds), FUND (Mutual Funds), CASH (Forex), CFD (Contract for difference), IND (Index)  (required)
        :param str fields: list of fields separated by comma
        :return: MarketData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.md_snapshot_get_with_http_info(conids, **kwargs)  # noqa: E501
        else:
            (data) = self.md_snapshot_get_with_http_info(conids, **kwargs)  # noqa: E501
            return data

    def md_snapshot_get_with_http_info(self, conids, **kwargs):  # noqa: E501
        """Market Data Snapshot (Beta)  # noqa: E501

        Get a snapshot of Market Data for the given conid(s).See response for a list of available fields that can be requested from the fields argument. Must be connected to a brokerage session before can query snapshot data. First /snapshot endpoint call for given conid(s) will initiate the market data request, make an additional request to receive field values back. To receive all available fields the /snapshot endpoint will need to be called several times. To receive streaming market data the endpoint /ws can be used. Refer to [Streaming WebSocket Data](https://interactivebrokers.github.io/cpwebapi/RealtimeSubscription.html) for details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.md_snapshot_get_with_http_info(conids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conids: List of conids comma separated. Optional exchange and instrument type can be specified.   * conid: IBKR Contract Identifier   * exchange: Exchange or venue   * instrType: Instrument Type supported values: CS (Stocks), OPT (Options), FUT (Futures), FOP (Future Options), WAR (Warrants), BOND (Bonds), FUND (Mutual Funds), CASH (Forex), CFD (Contract for difference), IND (Index)  (required)
        :param str fields: list of fields separated by comma
        :return: MarketData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conids', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method md_snapshot_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conids' is set
        if ('conids' not in params or
                params['conids'] is None):
            raise ValueError("Missing the required parameter `conids` when calling `md_snapshot_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conids' in params:
            query_params.append(('conids', params['conids']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/md/snapshot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarketData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
