# coding: utf-8

"""
    Client Portal Web API

    Client Poral Web API  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ib_web_api.api_client import ApiClient


class ContractApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def iserver_contract_conid_algos_get(self, conid, **kwargs):  # noqa: E501
        """IB Algo Params  # noqa: E501

        Returns supported IB Algos for contract. Must be called a second time to query the list of available parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_algos_get(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: IBKR contract identifier (required)
        :param str algos: List of algo ids delimited by \";\" to filter by. Max of 8 algos ids can be specified.
        :param str add_description: Whether or not to add algo descriptions to response. Set to 1 for yes, 0 for no.
        :param str add_params: Whether or not to show algo parameters.  Set to 1 for yes, 0 for no.
        :return: list[InlineResponse20035]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_contract_conid_algos_get_with_http_info(conid, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_contract_conid_algos_get_with_http_info(conid, **kwargs)  # noqa: E501
            return data

    def iserver_contract_conid_algos_get_with_http_info(self, conid, **kwargs):  # noqa: E501
        """IB Algo Params  # noqa: E501

        Returns supported IB Algos for contract. Must be called a second time to query the list of available parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_algos_get_with_http_info(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: IBKR contract identifier (required)
        :param str algos: List of algo ids delimited by \";\" to filter by. Max of 8 algos ids can be specified.
        :param str add_description: Whether or not to add algo descriptions to response. Set to 1 for yes, 0 for no.
        :param str add_params: Whether or not to show algo parameters.  Set to 1 for yes, 0 for no.
        :return: list[InlineResponse20035]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'algos', 'add_description', 'add_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_contract_conid_algos_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_contract_conid_algos_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conid' in params:
            path_params['conid'] = params['conid']  # noqa: E501

        query_params = []
        if 'algos' in params:
            query_params.append(('algos', params['algos']))  # noqa: E501
        if 'add_description' in params:
            query_params.append(('addDescription', params['add_description']))  # noqa: E501
        if 'add_params' in params:
            query_params.append(('addParams', params['add_params']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/contract/{conid}/algos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20035]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_contract_conid_info_and_rules_get(self, conid, is_buy, **kwargs):  # noqa: E501
        """Info and Rules  # noqa: E501

        Returns both contract info and rules from a single endpoint. For only contract rules, use the endpoint /iserver/contract/rules. For only contract info, use the endpoint /iserver/contract/{conid}/info.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_info_and_rules_get(conid, is_buy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: IBKR contract identifier (required)
        :param bool is_buy: Side of the market rules apply too. Set to **true** for Buy Orders, set to **false** for Sell Orders (required)
        :return: InlineResponse20037
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_contract_conid_info_and_rules_get_with_http_info(conid, is_buy, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_contract_conid_info_and_rules_get_with_http_info(conid, is_buy, **kwargs)  # noqa: E501
            return data

    def iserver_contract_conid_info_and_rules_get_with_http_info(self, conid, is_buy, **kwargs):  # noqa: E501
        """Info and Rules  # noqa: E501

        Returns both contract info and rules from a single endpoint. For only contract rules, use the endpoint /iserver/contract/rules. For only contract info, use the endpoint /iserver/contract/{conid}/info.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_info_and_rules_get_with_http_info(conid, is_buy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: IBKR contract identifier (required)
        :param bool is_buy: Side of the market rules apply too. Set to **true** for Buy Orders, set to **false** for Sell Orders (required)
        :return: InlineResponse20037
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'is_buy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_contract_conid_info_and_rules_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_contract_conid_info_and_rules_get`")  # noqa: E501
        # verify the required parameter 'is_buy' is set
        if ('is_buy' not in params or
                params['is_buy'] is None):
            raise ValueError("Missing the required parameter `is_buy` when calling `iserver_contract_conid_info_and_rules_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conid' in params:
            path_params['conid'] = params['conid']  # noqa: E501

        query_params = []
        if 'is_buy' in params:
            query_params.append(('isBuy', params['is_buy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/contract/{conid}/info-and-rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20037',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_contract_conid_info_get(self, conid, **kwargs):  # noqa: E501
        """Contract Details  # noqa: E501

        Using the Contract Identifier get contract info. You can use this to prefill your order before you submit an order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_info_get(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_contract_conid_info_get_with_http_info(conid, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_contract_conid_info_get_with_http_info(conid, **kwargs)  # noqa: E501
            return data

    def iserver_contract_conid_info_get_with_http_info(self, conid, **kwargs):  # noqa: E501
        """Contract Details  # noqa: E501

        Using the Contract Identifier get contract info. You can use this to prefill your order before you submit an order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_conid_info_get_with_http_info(conid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id (required)
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_contract_conid_info_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_contract_conid_info_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conid' in params:
            path_params['conid'] = params['conid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/contract/{conid}/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_contract_rules_post(self, body, **kwargs):  # noqa: E501
        """Contract Rules  # noqa: E501

        Returns trading related rules for a specific contract and side. For both contract info and rules use the endpoint /iserver/contract/{conid}/info-and-rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_rules_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContractRulesBody body: (required)
        :return: InlineResponse20036
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_contract_rules_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_contract_rules_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def iserver_contract_rules_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Contract Rules  # noqa: E501

        Returns trading related rules for a specific contract and side. For both contract info and rules use the endpoint /iserver/contract/{conid}/info-and-rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_contract_rules_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContractRulesBody body: (required)
        :return: InlineResponse20036
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_contract_rules_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_contract_rules_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/contract/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20036',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_secdef_info_get(self, conid, sectype, **kwargs):  # noqa: E501
        """Secdef Info  # noqa: E501

        Provides Contract Details of Futures, Options, Warrants, Cash and CFDs based on conid. To get the strike price for Options/Warrants use \"/iserver/secdef/strikes\" endpoint. Must call /secdef/search for the underlying contract first.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_info_get(conid, sectype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: underlying contract id (required)
        :param str sectype: FUT/OPT/WAR/CASH/CFD (required)
        :param str month: contract month, only required for FUT/OPT/WAR in the format MMMYY, example JAN00
        :param str exchange: optional, default is SMART
        :param float strike: optional, only required for OPT/WAR
        :param str right: C for call, P for put
        :return: list[SecdefInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_secdef_info_get_with_http_info(conid, sectype, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_secdef_info_get_with_http_info(conid, sectype, **kwargs)  # noqa: E501
            return data

    def iserver_secdef_info_get_with_http_info(self, conid, sectype, **kwargs):  # noqa: E501
        """Secdef Info  # noqa: E501

        Provides Contract Details of Futures, Options, Warrants, Cash and CFDs based on conid. To get the strike price for Options/Warrants use \"/iserver/secdef/strikes\" endpoint. Must call /secdef/search for the underlying contract first.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_info_get_with_http_info(conid, sectype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: underlying contract id (required)
        :param str sectype: FUT/OPT/WAR/CASH/CFD (required)
        :param str month: contract month, only required for FUT/OPT/WAR in the format MMMYY, example JAN00
        :param str exchange: optional, default is SMART
        :param float strike: optional, only required for OPT/WAR
        :param str right: C for call, P for put
        :return: list[SecdefInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'sectype', 'month', 'exchange', 'strike', 'right']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_secdef_info_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_secdef_info_get`")  # noqa: E501
        # verify the required parameter 'sectype' is set
        if ('sectype' not in params or
                params['sectype'] is None):
            raise ValueError("Missing the required parameter `sectype` when calling `iserver_secdef_info_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conid' in params:
            query_params.append(('conid', params['conid']))  # noqa: E501
        if 'sectype' in params:
            query_params.append(('sectype', params['sectype']))  # noqa: E501
        if 'month' in params:
            query_params.append(('month', params['month']))  # noqa: E501
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501
        if 'strike' in params:
            query_params.append(('strike', params['strike']))  # noqa: E501
        if 'right' in params:
            query_params.append(('right', params['right']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/secdef/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SecdefInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_secdef_search_post(self, body, **kwargs):  # noqa: E501
        """Search by Symbol or Name  # noqa: E501

        Search by underlying symbol or company name. Relays back what derivative contract(s) it has. This endpoint must be called before using /secdef/info. If company name is specified will only receive limited response: conid, companyName, companyHeader and symbol.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_search_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecdefSearchBody body: Symbol or Company Name to be searched (required)
        :return: list[InlineResponse20033]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_secdef_search_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_secdef_search_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def iserver_secdef_search_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search by Symbol or Name  # noqa: E501

        Search by underlying symbol or company name. Relays back what derivative contract(s) it has. This endpoint must be called before using /secdef/info. If company name is specified will only receive limited response: conid, companyName, companyHeader and symbol.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_search_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecdefSearchBody body: Symbol or Company Name to be searched (required)
        :return: list[InlineResponse20033]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_secdef_search_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `iserver_secdef_search_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/secdef/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20033]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def iserver_secdef_strikes_get(self, conid, sectype, month, **kwargs):  # noqa: E501
        """Search Strikes  # noqa: E501

        Query strikes for Options/Warrants. For the conid of the underlying contract, available contract months and exchanges use \"/iserver/secdef/search\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_strikes_get(conid, sectype, month, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id of the underlying contract (required)
        :param str sectype: OPT/WAR (required)
        :param str month: contract month (required)
        :param str exchange: optional, default is SMART
        :return: InlineResponse20034
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.iserver_secdef_strikes_get_with_http_info(conid, sectype, month, **kwargs)  # noqa: E501
        else:
            (data) = self.iserver_secdef_strikes_get_with_http_info(conid, sectype, month, **kwargs)  # noqa: E501
            return data

    def iserver_secdef_strikes_get_with_http_info(self, conid, sectype, month, **kwargs):  # noqa: E501
        """Search Strikes  # noqa: E501

        Query strikes for Options/Warrants. For the conid of the underlying contract, available contract months and exchanges use \"/iserver/secdef/search\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.iserver_secdef_strikes_get_with_http_info(conid, sectype, month, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conid: contract id of the underlying contract (required)
        :param str sectype: OPT/WAR (required)
        :param str month: contract month (required)
        :param str exchange: optional, default is SMART
        :return: InlineResponse20034
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conid', 'sectype', 'month', 'exchange']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method iserver_secdef_strikes_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conid' is set
        if ('conid' not in params or
                params['conid'] is None):
            raise ValueError("Missing the required parameter `conid` when calling `iserver_secdef_strikes_get`")  # noqa: E501
        # verify the required parameter 'sectype' is set
        if ('sectype' not in params or
                params['sectype'] is None):
            raise ValueError("Missing the required parameter `sectype` when calling `iserver_secdef_strikes_get`")  # noqa: E501
        # verify the required parameter 'month' is set
        if ('month' not in params or
                params['month'] is None):
            raise ValueError("Missing the required parameter `month` when calling `iserver_secdef_strikes_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'conid' in params:
            query_params.append(('conid', params['conid']))  # noqa: E501
        if 'sectype' in params:
            query_params.append(('sectype', params['sectype']))  # noqa: E501
        if 'month' in params:
            query_params.append(('month', params['month']))  # noqa: E501
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/iserver/secdef/strikes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20034',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trsrv_futures_get(self, symbols, **kwargs):  # noqa: E501
        """Security Futures by Symbol  # noqa: E501

        Returns a list of non-expired future contracts for given symbol(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_futures_get(symbols, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str symbols: list of case-sensitive symbols separated by comma (required)
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trsrv_futures_get_with_http_info(symbols, **kwargs)  # noqa: E501
        else:
            (data) = self.trsrv_futures_get_with_http_info(symbols, **kwargs)  # noqa: E501
            return data

    def trsrv_futures_get_with_http_info(self, symbols, **kwargs):  # noqa: E501
        """Security Futures by Symbol  # noqa: E501

        Returns a list of non-expired future contracts for given symbol(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_futures_get_with_http_info(symbols, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str symbols: list of case-sensitive symbols separated by comma (required)
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['symbols']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trsrv_futures_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'symbols' is set
        if ('symbols' not in params or
                params['symbols'] is None):
            raise ValueError("Missing the required parameter `symbols` when calling `trsrv_futures_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbols' in params:
            query_params.append(('symbols', params['symbols']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/trsrv/futures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trsrv_secdef_post(self, body, **kwargs):  # noqa: E501
        """Secdef by Conid  # noqa: E501

        Returns a list of security definitions for the given conids  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_secdef_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TrsrvSecdefBody body: request body (required)
        :return: Secdef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trsrv_secdef_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trsrv_secdef_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trsrv_secdef_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Secdef by Conid  # noqa: E501

        Returns a list of security definitions for the given conids  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_secdef_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TrsrvSecdefBody body: request body (required)
        :return: Secdef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trsrv_secdef_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trsrv_secdef_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/trsrv/secdef', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Secdef',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trsrv_secdef_schedule_get(self, asset_class, symbol, **kwargs):  # noqa: E501
        """Get trading schedule for symbol  # noqa: E501

        Returns the trading schedule up to a month for the requested contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_secdef_schedule_get(asset_class, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_class: specify the asset class of the contract. Available values-- Stock: STK, Option: OPT, Future: FUT, Contract For Difference: CFD, Warrant: WAR, Forex: SWP, Mutual Fund: FND, Bond: BND, Inter-Commodity Spreads: ICS  (required)
        :param str symbol: Underlying Symbol for specified contract, for example 'AAPL' for US Stock - Apple Inc. (required)
        :param str exchange: Native exchange for contract, for example 'NASDAQ' for US Stock - Apple Inc.
        :param str exchange_filter: Response only returns trading schedule for specified exchange
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trsrv_secdef_schedule_get_with_http_info(asset_class, symbol, **kwargs)  # noqa: E501
        else:
            (data) = self.trsrv_secdef_schedule_get_with_http_info(asset_class, symbol, **kwargs)  # noqa: E501
            return data

    def trsrv_secdef_schedule_get_with_http_info(self, asset_class, symbol, **kwargs):  # noqa: E501
        """Get trading schedule for symbol  # noqa: E501

        Returns the trading schedule up to a month for the requested contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_secdef_schedule_get_with_http_info(asset_class, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_class: specify the asset class of the contract. Available values-- Stock: STK, Option: OPT, Future: FUT, Contract For Difference: CFD, Warrant: WAR, Forex: SWP, Mutual Fund: FND, Bond: BND, Inter-Commodity Spreads: ICS  (required)
        :param str symbol: Underlying Symbol for specified contract, for example 'AAPL' for US Stock - Apple Inc. (required)
        :param str exchange: Native exchange for contract, for example 'NASDAQ' for US Stock - Apple Inc.
        :param str exchange_filter: Response only returns trading schedule for specified exchange
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_class', 'symbol', 'exchange', 'exchange_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trsrv_secdef_schedule_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_class' is set
        if ('asset_class' not in params or
                params['asset_class'] is None):
            raise ValueError("Missing the required parameter `asset_class` when calling `trsrv_secdef_schedule_get`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in params or
                params['symbol'] is None):
            raise ValueError("Missing the required parameter `symbol` when calling `trsrv_secdef_schedule_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'asset_class' in params:
            query_params.append(('assetClass', params['asset_class']))  # noqa: E501
        if 'symbol' in params:
            query_params.append(('symbol', params['symbol']))  # noqa: E501
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501
        if 'exchange_filter' in params:
            query_params.append(('exchangeFilter', params['exchange_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/trsrv/secdef/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trsrv_stocks_get(self, symbols, **kwargs):  # noqa: E501
        """Security Stocks by Symbol  # noqa: E501

        Returns an object contains all stock contracts for given symbol(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_stocks_get(symbols, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str symbols: list of upper-sensitive symbols separated by comma (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trsrv_stocks_get_with_http_info(symbols, **kwargs)  # noqa: E501
        else:
            (data) = self.trsrv_stocks_get_with_http_info(symbols, **kwargs)  # noqa: E501
            return data

    def trsrv_stocks_get_with_http_info(self, symbols, **kwargs):  # noqa: E501
        """Security Stocks by Symbol  # noqa: E501

        Returns an object contains all stock contracts for given symbol(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trsrv_stocks_get_with_http_info(symbols, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str symbols: list of upper-sensitive symbols separated by comma (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['symbols']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trsrv_stocks_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'symbols' is set
        if ('symbols' not in params or
                params['symbols'] is None):
            raise ValueError("Missing the required parameter `symbols` when calling `trsrv_stocks_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbols' in params:
            query_params.append(('symbols', params['symbols']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/trsrv/stocks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2007',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
