# ib-web-api
Client Poral Web API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 202303101433
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ib_web_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ib_web_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import ib_web_api
from ib_web_api.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))

try:
    # PnL for the selected account
    api_response = api_instance.iserver_account_pnl_partitioned_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->iserver_account_pnl_partitioned_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))
body = ib_web_api.SetAccount() # SetAccount | account id

try:
    # Switch Account
    api_response = api_instance.iserver_account_post(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->iserver_account_post: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))

try:
    # Brokerage Accounts
    api_response = api_instance.iserver_accounts_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->iserver_accounts_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))
account_id = 'account_id_example' # str | account id

try:
    # Account Ledger
    api_response = api_instance.portfolio_account_id_ledger_get(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_account_id_ledger_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))
account_id = 'account_id_example' # str | account id

try:
    # Account Information
    api_response = api_instance.portfolio_account_id_meta_get(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_account_id_meta_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))
account_id = 'account_id_example' # str | account id

try:
    # Account Summary
    api_response = api_instance.portfolio_account_id_summary_get(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_account_id_summary_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))

try:
    # Portfolio Accounts
    api_response = api_instance.portfolio_accounts_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_accounts_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))
page = 'page_example' # str | 

try:
    # List of Sub-Accounts (Large Accounts)
    api_response = api_instance.portfolio_subaccounts2_get(page)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_subaccounts2_get: %s\n" % e)

# create an instance of the API class
api_instance = ib_web_api.AccountApi(ib_web_api.ApiClient(configuration))

try:
    # List of Sub-Accounts
    api_response = api_instance.portfolio_subaccounts_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->portfolio_subaccounts_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:5000/v1/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**iserver_account_pnl_partitioned_get**](docs/AccountApi.md#iserver_account_pnl_partitioned_get) | **GET** /iserver/account/pnl/partitioned | PnL for the selected account
*AccountApi* | [**iserver_account_post**](docs/AccountApi.md#iserver_account_post) | **POST** /iserver/account | Switch Account
*AccountApi* | [**iserver_accounts_get**](docs/AccountApi.md#iserver_accounts_get) | **GET** /iserver/accounts | Brokerage Accounts
*AccountApi* | [**portfolio_account_id_ledger_get**](docs/AccountApi.md#portfolio_account_id_ledger_get) | **GET** /portfolio/{accountId}/ledger | Account Ledger
*AccountApi* | [**portfolio_account_id_meta_get**](docs/AccountApi.md#portfolio_account_id_meta_get) | **GET** /portfolio/{accountId}/meta | Account Information
*AccountApi* | [**portfolio_account_id_summary_get**](docs/AccountApi.md#portfolio_account_id_summary_get) | **GET** /portfolio/{accountId}/summary | Account Summary
*AccountApi* | [**portfolio_accounts_get**](docs/AccountApi.md#portfolio_accounts_get) | **GET** /portfolio/accounts | Portfolio Accounts
*AccountApi* | [**portfolio_subaccounts2_get**](docs/AccountApi.md#portfolio_subaccounts2_get) | **GET** /portfolio/subaccounts2 | List of Sub-Accounts (Large Accounts)
*AccountApi* | [**portfolio_subaccounts_get**](docs/AccountApi.md#portfolio_subaccounts_get) | **GET** /portfolio/subaccounts | List of Sub-Accounts
*AlertApi* | [**iserver_account_account_id_alert_post**](docs/AlertApi.md#iserver_account_account_id_alert_post) | **POST** /iserver/account/{accountId}/alert | Create or modify alert
*AlertApi* | [**iserver_account_alertid_get**](docs/AlertApi.md#iserver_account_alertid_get) | **GET** /iserver/account/alert/:id | Get details of an alert
*AlertApi* | [**iserver_account_mta_get**](docs/AlertApi.md#iserver_account_mta_get) | **GET** /iserver/account/mta | Get MTA alert
*AlertApi* | [**iserver_accountaccount_id_alert_activate_post**](docs/AlertApi.md#iserver_accountaccount_id_alert_activate_post) | **POST** /iserver/account/:accountId/alert/activate | Activate or deactivate an alert
*AlertApi* | [**iserver_accountaccount_id_alertalert_id_delete**](docs/AlertApi.md#iserver_accountaccount_id_alertalert_id_delete) | **DELETE** /iserver/account/:accountId/alert/:alertId | Delete an alert
*AlertApi* | [**iserver_accountaccount_id_alerts_get**](docs/AlertApi.md#iserver_accountaccount_id_alerts_get) | **GET** /iserver/account/:accountId/alerts | Get a list of available alerts
*CCPBetaApi* | [**ccp_account_get**](docs/CCPBetaApi.md#ccp_account_get) | **GET** /ccp/account | Brokerage Accounts
*CCPBetaApi* | [**ccp_auth_init_post**](docs/CCPBetaApi.md#ccp_auth_init_post) | **POST** /ccp/auth/init | Start CCP Session
*CCPBetaApi* | [**ccp_auth_response_post**](docs/CCPBetaApi.md#ccp_auth_response_post) | **POST** /ccp/auth/response | Complete CCP Session
*CCPBetaApi* | [**ccp_order_delete**](docs/CCPBetaApi.md#ccp_order_delete) | **DELETE** /ccp/order | Delete Order
*CCPBetaApi* | [**ccp_order_post**](docs/CCPBetaApi.md#ccp_order_post) | **POST** /ccp/order | Submit Order
*CCPBetaApi* | [**ccp_order_put**](docs/CCPBetaApi.md#ccp_order_put) | **PUT** /ccp/order | Update Order
*CCPBetaApi* | [**ccp_orders_get**](docs/CCPBetaApi.md#ccp_orders_get) | **GET** /ccp/orders | Order Status
*CCPBetaApi* | [**ccp_positions_get**](docs/CCPBetaApi.md#ccp_positions_get) | **GET** /ccp/positions | Positions
*CCPBetaApi* | [**ccp_status_get**](docs/CCPBetaApi.md#ccp_status_get) | **GET** /ccp/status | CCP Status
*CCPBetaApi* | [**ccp_trades_get**](docs/CCPBetaApi.md#ccp_trades_get) | **GET** /ccp/trades | Trades
*ContractApi* | [**iserver_contract_conid_algos_get**](docs/ContractApi.md#iserver_contract_conid_algos_get) | **GET** /iserver/contract/{conid}/algos | IB Algo Params
*ContractApi* | [**iserver_contract_conid_info_and_rules_get**](docs/ContractApi.md#iserver_contract_conid_info_and_rules_get) | **GET** /iserver/contract/{conid}/info-and-rules | Info and Rules
*ContractApi* | [**iserver_contract_conid_info_get**](docs/ContractApi.md#iserver_contract_conid_info_get) | **GET** /iserver/contract/{conid}/info | Contract Details
*ContractApi* | [**iserver_contract_rules_post**](docs/ContractApi.md#iserver_contract_rules_post) | **POST** /iserver/contract/rules | Contract Rules
*ContractApi* | [**iserver_secdef_info_get**](docs/ContractApi.md#iserver_secdef_info_get) | **GET** /iserver/secdef/info | Secdef Info
*ContractApi* | [**iserver_secdef_search_post**](docs/ContractApi.md#iserver_secdef_search_post) | **POST** /iserver/secdef/search | Search by Symbol or Name
*ContractApi* | [**iserver_secdef_strikes_get**](docs/ContractApi.md#iserver_secdef_strikes_get) | **GET** /iserver/secdef/strikes | Search Strikes
*ContractApi* | [**trsrv_futures_get**](docs/ContractApi.md#trsrv_futures_get) | **GET** /trsrv/futures | Security Futures by Symbol
*ContractApi* | [**trsrv_secdef_post**](docs/ContractApi.md#trsrv_secdef_post) | **POST** /trsrv/secdef | Secdef by Conid
*ContractApi* | [**trsrv_secdef_schedule_get**](docs/ContractApi.md#trsrv_secdef_schedule_get) | **GET** /trsrv/secdef/schedule | Get trading schedule for symbol
*ContractApi* | [**trsrv_stocks_get**](docs/ContractApi.md#trsrv_stocks_get) | **GET** /trsrv/stocks | Security Stocks by Symbol
*FYIApi* | [**fyi_deliveryoptions_device_id_delete**](docs/FYIApi.md#fyi_deliveryoptions_device_id_delete) | **DELETE** /fyi/deliveryoptions/{deviceId} | Delete a device
*FYIApi* | [**fyi_deliveryoptions_device_post**](docs/FYIApi.md#fyi_deliveryoptions_device_post) | **POST** /fyi/deliveryoptions/device | Enable/Disable device option
*FYIApi* | [**fyi_deliveryoptions_email_put**](docs/FYIApi.md#fyi_deliveryoptions_email_put) | **PUT** /fyi/deliveryoptions/email | Enable/Disable email option
*FYIApi* | [**fyi_deliveryoptions_get**](docs/FYIApi.md#fyi_deliveryoptions_get) | **GET** /fyi/deliveryoptions | Get delivery options
*FYIApi* | [**fyi_disclaimer_typecode_get**](docs/FYIApi.md#fyi_disclaimer_typecode_get) | **GET** /fyi/disclaimer/{typecode} | Get disclaimer for a certain kind of fyi
*FYIApi* | [**fyi_disclaimer_typecode_put**](docs/FYIApi.md#fyi_disclaimer_typecode_put) | **PUT** /fyi/disclaimer/{typecode} | Mark disclaimer read
*FYIApi* | [**fyi_notifications_get**](docs/FYIApi.md#fyi_notifications_get) | **GET** /fyi/notifications | Get a list of notifications
*FYIApi* | [**fyi_notifications_more_get**](docs/FYIApi.md#fyi_notifications_more_get) | **GET** /fyi/notifications/more | Get more notifications based on a certain one
*FYIApi* | [**fyi_notifications_notification_id_put**](docs/FYIApi.md#fyi_notifications_notification_id_put) | **PUT** /fyi/notifications/{notificationId} | Get a list of notifications
*FYIApi* | [**fyi_settings_get**](docs/FYIApi.md#fyi_settings_get) | **GET** /fyi/settings | Get a list of subscriptions
*FYIApi* | [**fyi_settings_typecode_post**](docs/FYIApi.md#fyi_settings_typecode_post) | **POST** /fyi/settings/{typecode} | Enable/Disable certain subscription
*FYIApi* | [**fyi_unreadnumber_get**](docs/FYIApi.md#fyi_unreadnumber_get) | **GET** /fyi/unreadnumber | Get unread number of fyis. The HTTP method POST is also supported.
*MarketDataApi* | [**hmds_history_get**](docs/MarketDataApi.md#hmds_history_get) | **GET** /hmds/history | Market Data History (Beta)
*MarketDataApi* | [**iserver_marketdata_conid_unsubscribe_get**](docs/MarketDataApi.md#iserver_marketdata_conid_unsubscribe_get) | **GET** /iserver/marketdata/{conid}/unsubscribe | Market Data Cancel (Single)
*MarketDataApi* | [**iserver_marketdata_history_get**](docs/MarketDataApi.md#iserver_marketdata_history_get) | **GET** /iserver/marketdata/history | Market Data History
*MarketDataApi* | [**iserver_marketdata_snapshot_get**](docs/MarketDataApi.md#iserver_marketdata_snapshot_get) | **GET** /iserver/marketdata/snapshot | Market Data
*MarketDataApi* | [**iserver_marketdata_unsubscribeall_get**](docs/MarketDataApi.md#iserver_marketdata_unsubscribeall_get) | **GET** /iserver/marketdata/unsubscribeall | Market Data Cancel (All)
*MarketDataApi* | [**md_snapshot_get**](docs/MarketDataApi.md#md_snapshot_get) | **GET** /md/snapshot | Market Data Snapshot (Beta)
*OrderApi* | [**iserver_account_account_id_order_order_id_delete**](docs/OrderApi.md#iserver_account_account_id_order_order_id_delete) | **DELETE** /iserver/account/{accountId}/order/{orderId} | Cancel Order
*OrderApi* | [**iserver_account_account_id_order_order_id_post**](docs/OrderApi.md#iserver_account_account_id_order_order_id_post) | **POST** /iserver/account/{accountId}/order/{orderId} | Modify Order
*OrderApi* | [**iserver_account_account_id_order_post**](docs/OrderApi.md#iserver_account_account_id_order_post) | **POST** /iserver/account/{accountId}/order | Place Order (Deprecated)
*OrderApi* | [**iserver_account_account_id_order_whatif_post**](docs/OrderApi.md#iserver_account_account_id_order_whatif_post) | **POST** /iserver/account/{accountId}/order/whatif | Preview Order (Deprecated)
*OrderApi* | [**iserver_account_account_id_orders_post**](docs/OrderApi.md#iserver_account_account_id_orders_post) | **POST** /iserver/account/{accountId}/orders | Place Orders
*OrderApi* | [**iserver_account_account_id_orders_whatif_post**](docs/OrderApi.md#iserver_account_account_id_orders_whatif_post) | **POST** /iserver/account/{accountId}/orders/whatif | Preview Orders
*OrderApi* | [**iserver_account_order_status_order_id_get**](docs/OrderApi.md#iserver_account_order_status_order_id_get) | **GET** /iserver/account/order/status/{orderId} | Order Status
*OrderApi* | [**iserver_account_orders_fa_group_post**](docs/OrderApi.md#iserver_account_orders_fa_group_post) | **POST** /iserver/account/orders/{faGroup} | Place Orders for FA
*OrderApi* | [**iserver_account_orders_get**](docs/OrderApi.md#iserver_account_orders_get) | **GET** /iserver/account/orders | Live Orders
*OrderApi* | [**iserver_reply_replyid_post**](docs/OrderApi.md#iserver_reply_replyid_post) | **POST** /iserver/reply/{replyid} | Place Order Reply
*PnLApi* | [**iserver_account_pnl_partitioned_get**](docs/PnLApi.md#iserver_account_pnl_partitioned_get) | **GET** /iserver/account/pnl/partitioned | PnL for the selected account
*PortfolioApi* | [**portfolio_account_id_allocation_get**](docs/PortfolioApi.md#portfolio_account_id_allocation_get) | **GET** /portfolio/{accountId}/allocation | Account Allocation
*PortfolioApi* | [**portfolio_account_id_ledger_get**](docs/PortfolioApi.md#portfolio_account_id_ledger_get) | **GET** /portfolio/{accountId}/ledger | Account Ledger
*PortfolioApi* | [**portfolio_account_id_meta_get**](docs/PortfolioApi.md#portfolio_account_id_meta_get) | **GET** /portfolio/{accountId}/meta | Account Information
*PortfolioApi* | [**portfolio_account_id_position_conid_get**](docs/PortfolioApi.md#portfolio_account_id_position_conid_get) | **GET** /portfolio/{accountId}/position/{conid} | Position by Conid
*PortfolioApi* | [**portfolio_account_id_positions_invalidate_post**](docs/PortfolioApi.md#portfolio_account_id_positions_invalidate_post) | **POST** /portfolio/{accountId}/positions/invalidate | Invalidates the backend cache of the Portfolio
*PortfolioApi* | [**portfolio_account_id_positions_page_id_get**](docs/PortfolioApi.md#portfolio_account_id_positions_page_id_get) | **GET** /portfolio/{accountId}/positions/{pageId} | Portfolio Positions
*PortfolioApi* | [**portfolio_account_id_summary_get**](docs/PortfolioApi.md#portfolio_account_id_summary_get) | **GET** /portfolio/{accountId}/summary | Account Summary
*PortfolioApi* | [**portfolio_accounts_get**](docs/PortfolioApi.md#portfolio_accounts_get) | **GET** /portfolio/accounts | Portfolio Accounts
*PortfolioApi* | [**portfolio_allocation_post**](docs/PortfolioApi.md#portfolio_allocation_post) | **POST** /portfolio/allocation | Account Alloction (All Accounts)
*PortfolioApi* | [**portfolio_positions_conid_get**](docs/PortfolioApi.md#portfolio_positions_conid_get) | **GET** /portfolio/positions/{conid} | Positions by Conid
*PortfolioApi* | [**portfolio_subaccounts2_get**](docs/PortfolioApi.md#portfolio_subaccounts2_get) | **GET** /portfolio/subaccounts2 | List of Sub-Accounts (Large Accounts)
*PortfolioApi* | [**portfolio_subaccounts_get**](docs/PortfolioApi.md#portfolio_subaccounts_get) | **GET** /portfolio/subaccounts | List of Sub-Accounts
*PortfolioAnalystApi* | [**pa_performance_post**](docs/PortfolioAnalystApi.md#pa_performance_post) | **POST** /pa/performance | Account Performance
*PortfolioAnalystApi* | [**pa_summary_post**](docs/PortfolioAnalystApi.md#pa_summary_post) | **POST** /pa/summary | Account Balance&#x27;s Summary (Deprecated)
*PortfolioAnalystApi* | [**pa_transactions_post**](docs/PortfolioAnalystApi.md#pa_transactions_post) | **POST** /pa/transactions | Position&#x27;s Transaction History
*ScannerApi* | [**hmds_scanner_post**](docs/ScannerApi.md#hmds_scanner_post) | **POST** /hmds/scanner | Run Scanner (Beta)
*ScannerApi* | [**iserver_scanner_params_get**](docs/ScannerApi.md#iserver_scanner_params_get) | **GET** /iserver/scanner/params | Scanner Parameters
*ScannerApi* | [**iserver_scanner_run_post**](docs/ScannerApi.md#iserver_scanner_run_post) | **POST** /iserver/scanner/run | Scanner Run
*SessionApi* | [**iserver_auth_status_post**](docs/SessionApi.md#iserver_auth_status_post) | **POST** /iserver/auth/status | Authentication Status
*SessionApi* | [**iserver_reauthenticate_post**](docs/SessionApi.md#iserver_reauthenticate_post) | **POST** /iserver/reauthenticate | Tries to re-authenticate to Brokerage
*SessionApi* | [**logout_post**](docs/SessionApi.md#logout_post) | **POST** /logout | Ends the current session
*SessionApi* | [**sso_validate_get**](docs/SessionApi.md#sso_validate_get) | **GET** /sso/validate | Validate SSO
*SessionApi* | [**tickle_post**](docs/SessionApi.md#tickle_post) | **POST** /tickle | Ping the server to keep the session open
*StreamingApi* | [**ws_post**](docs/StreamingApi.md#ws_post) | **POST** /ws | Websocket Endpoint
*TradesApi* | [**iserver_account_trades_get**](docs/TradesApi.md#iserver_account_trades_get) | **GET** /iserver/account/trades | List of Trades for the selected account

## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountIdOrdersBody](docs/AccountIdOrdersBody.md)
 - [AccountParent](docs/AccountParent.md)
 - [Accounts](docs/Accounts.md)
 - [AlertActivateBody](docs/AlertActivateBody.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AlertResponse](docs/AlertResponse.md)
 - [AlertrequestConditions](docs/AlertrequestConditions.md)
 - [AlertresponseConditions](docs/AlertresponseConditions.md)
 - [Allocation](docs/Allocation.md)
 - [AllocationInner](docs/AllocationInner.md)
 - [AuthInitBody](docs/AuthInitBody.md)
 - [AuthResponseBody](docs/AuthResponseBody.md)
 - [AuthStatus](docs/AuthStatus.md)
 - [CalendarRequest](docs/CalendarRequest.md)
 - [CalendarRequestDate](docs/CalendarRequestDate.md)
 - [CalendarRequestFilters](docs/CalendarRequestFilters.md)
 - [Contract](docs/Contract.md)
 - [ContractRules](docs/ContractRules.md)
 - [ContractRulesBody](docs/ContractRulesBody.md)
 - [DeliveryoptionsDeviceBody](docs/DeliveryoptionsDeviceBody.md)
 - [Events](docs/Events.md)
 - [EventsInner](docs/EventsInner.md)
 - [Futures](docs/Futures.md)
 - [FuturesInner](docs/FuturesInner.md)
 - [HistoryData](docs/HistoryData.md)
 - [HistoryResult](docs/HistoryResult.md)
 - [HistorydataData](docs/HistorydataData.md)
 - [HistoryresultBars](docs/HistoryresultBars.md)
 - [HistoryresultBarsData](docs/HistoryresultBarsData.md)
 - [HmdsScannerBody](docs/HmdsScannerBody.md)
 - [HmdsscannerFilters](docs/HmdsscannerFilters.md)
 - [Inds](docs/Inds.md)
 - [IndsInner](docs/IndsInner.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20012AcctList](docs/InlineResponse20012AcctList.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20015Metadata](docs/InlineResponse20015Metadata.md)
 - [InlineResponse20015Subaccounts](docs/InlineResponse20015Subaccounts.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse20018](docs/InlineResponse20018.md)
 - [InlineResponse20019](docs/InlineResponse20019.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse20020](docs/InlineResponse20020.md)
 - [InlineResponse20021](docs/InlineResponse20021.md)
 - [InlineResponse20022](docs/InlineResponse20022.md)
 - [InlineResponse20023](docs/InlineResponse20023.md)
 - [InlineResponse20024](docs/InlineResponse20024.md)
 - [InlineResponse20024Orders](docs/InlineResponse20024Orders.md)
 - [InlineResponse20025](docs/InlineResponse20025.md)
 - [InlineResponse20026](docs/InlineResponse20026.md)
 - [InlineResponse20027](docs/InlineResponse20027.md)
 - [InlineResponse20027Amount](docs/InlineResponse20027Amount.md)
 - [InlineResponse20027Equity](docs/InlineResponse20027Equity.md)
 - [InlineResponse20028](docs/InlineResponse20028.md)
 - [InlineResponse20029](docs/InlineResponse20029.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse20030](docs/InlineResponse20030.md)
 - [InlineResponse20031](docs/InlineResponse20031.md)
 - [InlineResponse20032](docs/InlineResponse20032.md)
 - [InlineResponse20033](docs/InlineResponse20033.md)
 - [InlineResponse20034](docs/InlineResponse20034.md)
 - [InlineResponse20035](docs/InlineResponse20035.md)
 - [InlineResponse20036](docs/InlineResponse20036.md)
 - [InlineResponse20036CanTradeAcctIds](docs/InlineResponse20036CanTradeAcctIds.md)
 - [InlineResponse20036CqtTypes](docs/InlineResponse20036CqtTypes.md)
 - [InlineResponse20036FraqTypes](docs/InlineResponse20036FraqTypes.md)
 - [InlineResponse20036IbalgoTypes](docs/InlineResponse20036IbalgoTypes.md)
 - [InlineResponse20036OrderDefaults](docs/InlineResponse20036OrderDefaults.md)
 - [InlineResponse20036OrderTypes](docs/InlineResponse20036OrderTypes.md)
 - [InlineResponse20036OrderTypesOutside](docs/InlineResponse20036OrderTypesOutside.md)
 - [InlineResponse20036Rules](docs/InlineResponse20036Rules.md)
 - [InlineResponse20036String](docs/InlineResponse20036String.md)
 - [InlineResponse20036TifTypes](docs/InlineResponse20036TifTypes.md)
 - [InlineResponse20037](docs/InlineResponse20037.md)
 - [InlineResponse20037Rules](docs/InlineResponse20037Rules.md)
 - [InlineResponse20038](docs/InlineResponse20038.md)
 - [InlineResponse20038FilterList](docs/InlineResponse20038FilterList.md)
 - [InlineResponse20038InstrumentList](docs/InlineResponse20038InstrumentList.md)
 - [InlineResponse20038LocationTree](docs/InlineResponse20038LocationTree.md)
 - [InlineResponse20038Locations](docs/InlineResponse20038Locations.md)
 - [InlineResponse20038ScanTypeList](docs/InlineResponse20038ScanTypeList.md)
 - [InlineResponse20039](docs/InlineResponse20039.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse20040](docs/InlineResponse20040.md)
 - [InlineResponse2004E](docs/InlineResponse2004E.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2005Schedules](docs/InlineResponse2005Schedules.md)
 - [InlineResponse2005Sessions](docs/InlineResponse2005Sessions.md)
 - [InlineResponse2005TradingTimes](docs/InlineResponse2005TradingTimes.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse4001](docs/InlineResponse4001.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [IservercontractconidalgosParameters](docs/IservercontractconidalgosParameters.md)
 - [IserversecdefsearchSections](docs/IserversecdefsearchSections.md)
 - [Ledger](docs/Ledger.md)
 - [MarketData](docs/MarketData.md)
 - [ModifyOrder](docs/ModifyOrder.md)
 - [Notifications](docs/Notifications.md)
 - [NotificationsInner](docs/NotificationsInner.md)
 - [Order](docs/Order.md)
 - [OrderData](docs/OrderData.md)
 - [OrderRequest](docs/OrderRequest.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderdataWarnings](docs/OrderdataWarnings.md)
 - [OrdersWhatifBody](docs/OrdersWhatifBody.md)
 - [PaPerformanceBody](docs/PaPerformanceBody.md)
 - [PaSummaryBody](docs/PaSummaryBody.md)
 - [PaTransactionsBody](docs/PaTransactionsBody.md)
 - [Performance](docs/Performance.md)
 - [PerformanceCps](docs/PerformanceCps.md)
 - [PerformanceCpsData](docs/PerformanceCpsData.md)
 - [PerformanceNav](docs/PerformanceNav.md)
 - [PerformanceTpps](docs/PerformanceTpps.md)
 - [PortfolioAllocationBody](docs/PortfolioAllocationBody.md)
 - [Position](docs/Position.md)
 - [PositionData](docs/PositionData.md)
 - [PositionInner](docs/PositionInner.md)
 - [ReplyReplyidBody](docs/ReplyReplyidBody.md)
 - [ScannerParams](docs/ScannerParams.md)
 - [ScannerResult](docs/ScannerResult.md)
 - [ScannerparamsFilter](docs/ScannerparamsFilter.md)
 - [ScannerresultContracts](docs/ScannerresultContracts.md)
 - [ScannerresultContractsContract](docs/ScannerresultContractsContract.md)
 - [Secdef](docs/Secdef.md)
 - [SecdefInfo](docs/SecdefInfo.md)
 - [SecdefInner](docs/SecdefInner.md)
 - [SecdefSearchBody](docs/SecdefSearchBody.md)
 - [SetAccount](docs/SetAccount.md)
 - [SettingsTypecodeBody](docs/SettingsTypecodeBody.md)
 - [StatsData](docs/StatsData.md)
 - [Stocks](docs/Stocks.md)
 - [StocksInner](docs/StocksInner.md)
 - [Summary](docs/Summary.md)
 - [SystemError](docs/SystemError.md)
 - [Trade](docs/Trade.md)
 - [Transactions](docs/Transactions.md)
 - [TransactionsTransactions](docs/TransactionsTransactions.md)
 - [TrsrvSecdefBody](docs/TrsrvSecdefBody.md)
 - [Wagers](docs/Wagers.md)
 - [WagersInner](docs/WagersInner.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


