from enum import Enum


class AllowedType(str, Enum):
    """
    https://github.com/ocpi/ocpi/blob/2.2.1/mod_tokens.asciidoc#141-allowedtype-enum
    """
    # This Token is allowed to charge (at this location).
    allowed = 'ALLOWED'
    # This Token is blocked.
    blocked = 'BLOCKED'
    # This Token has expired.
    expired = 'EXPIRED'
    # This Token belongs to an account that has not enough credits to charge (at the given location).
    no_credit = 'NO_CREDIT'
    # Token is valid, but is not allowed to charge at the given location.
    not_allowed = 'NOT_ALLOWED'


class TokenType(str, Enum):
    """
    https://github.com/ocpi/ocpi/blob/2.2.1/mod_tokens.asciidoc#144-tokentype-enum
    """
    # One time use Token ID generated by a server (or App.)
    # The eMSP uses this to bind a Session to a customer, probably an app user.
    ad_hoc_user = 'AD_HOC_USER'
    # Token ID generated by a server (or App.) to identify a user of an App.
    # The same user uses the same Token for every Session.
    app_user = 'APP_USER'
    # Other type of token
    other = 'OTHER'
    # RFID Token
    rfid = 'RFID'


class WhitelistType(str, Enum):
    """
    https://github.com/ocpi/ocpi/blob/2.2.1/mod_tokens.asciidoc#145-whitelisttype-enum
    """
    always = 'ALWAYS'
    allowed = 'ALLOWED'
    allowed_offline = 'ALLOWED_OFFLINE'
    never = 'NEVER'
