# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .._models import BaseModel
from .shared.file_type import FileType

__all__ = ["CompletionResponse", "Choice", "ChoiceMessage", "ChoiceCitation"]


class ChoiceMessage(BaseModel):
    content: str
    """The content of the message"""

    role: Literal["assistant"]
    """The role of the message sender"""


class ChoiceCitation(BaseModel):
    file_type: FileType
    """The type of the source file"""

    text: str
    """The relevant text from the cited source"""

    url: str
    """URL of the cited source"""

    page_number: Optional[int] = None
    """Page number for paginated documents like PDFs.

    Set to 0 for sources without page numbers
    """


class Choice(BaseModel):
    finish_reason: str
    """The reason why the model stopped generating tokens"""

    index: int
    """The index of this completion choice"""

    message: ChoiceMessage

    citations: Optional[List[ChoiceCitation]] = None
    """Array of citations when citation parameter is true"""


class CompletionResponse(BaseModel):
    choices: List[Choice]
    """The completion choices generated by the model"""

    created: int
    """The Unix timestamp (in seconds) of when the completion was created"""
