# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    created_at: datetime
    plan_id: StrictStr
    current_billing_period_start: datetime
    current_billing_period_end: datetime
    expert: Optional[StrictBool] = None
    avatar_url: Optional[StrictStr] = None
    recipes_count: StrictInt
    interested_applications: Optional[List[StrictStr]] = None
    company_name: Optional[StrictStr]
    location: Optional[StrictStr]
    last_seen: Optional[datetime] = None
    contact_phone: Optional[StrictStr] = None
    contact_email: Optional[StrictStr] = None
    about_me: Optional[StrictStr] = None
    email: StrictStr
    phone: Optional[StrictStr] = None
    active_recipes_count: StrictInt
    root_folder_id: StrictInt
    __properties: ClassVar[List[str]] = ["id", "name", "created_at", "plan_id", "current_billing_period_start", "current_billing_period_end", "expert", "avatar_url", "recipes_count", "interested_applications", "company_name", "location", "last_seen", "contact_phone", "contact_email", "about_me", "email", "phone", "active_recipes_count", "root_folder_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if company_name (nullable) is None
        # and model_fields_set contains the field
        if self.company_name is None and "company_name" in self.model_fields_set:
            _dict['company_name'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if last_seen (nullable) is None
        # and model_fields_set contains the field
        if self.last_seen is None and "last_seen" in self.model_fields_set:
            _dict['last_seen'] = None

        # set to None if contact_phone (nullable) is None
        # and model_fields_set contains the field
        if self.contact_phone is None and "contact_phone" in self.model_fields_set:
            _dict['contact_phone'] = None

        # set to None if contact_email (nullable) is None
        # and model_fields_set contains the field
        if self.contact_email is None and "contact_email" in self.model_fields_set:
            _dict['contact_email'] = None

        # set to None if about_me (nullable) is None
        # and model_fields_set contains the field
        if self.about_me is None and "about_me" in self.model_fields_set:
            _dict['about_me'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "created_at": obj.get("created_at"),
            "plan_id": obj.get("plan_id"),
            "current_billing_period_start": obj.get("current_billing_period_start"),
            "current_billing_period_end": obj.get("current_billing_period_end"),
            "expert": obj.get("expert"),
            "avatar_url": obj.get("avatar_url"),
            "recipes_count": obj.get("recipes_count"),
            "interested_applications": obj.get("interested_applications"),
            "company_name": obj.get("company_name"),
            "location": obj.get("location"),
            "last_seen": obj.get("last_seen"),
            "contact_phone": obj.get("contact_phone"),
            "contact_email": obj.get("contact_email"),
            "about_me": obj.get("about_me"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "active_recipes_count": obj.get("active_recipes_count"),
            "root_folder_id": obj.get("root_folder_id")
        })
        return _obj


