# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ExportManifestResponseResult(BaseModel):
    """
    ExportManifestResponseResult
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    last_exported_at: Optional[datetime]
    created_at: datetime
    updated_at: datetime
    deleted_at: Optional[datetime]
    project_path: StrictStr
    status: StrictStr
    __properties: ClassVar[List[str]] = ["id", "name", "last_exported_at", "created_at", "updated_at", "deleted_at", "project_path", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportManifestResponseResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if last_exported_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_exported_at is None and "last_exported_at" in self.model_fields_set:
            _dict['last_exported_at'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deleted_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportManifestResponseResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "last_exported_at": obj.get("last_exported_at"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "deleted_at": obj.get("deleted_at"),
            "project_path": obj.get("project_path"),
            "status": obj.get("status")
        })
        return _obj


