# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from workato_platform_cli.client.workato_api.models.data_table_relation import DataTableRelation
from typing import Optional, Set
from typing_extensions import Self

class DataTableColumnRequest(BaseModel):
    """
    DataTableColumnRequest
    """ # noqa: E501
    type: StrictStr = Field(description="The data type of the column")
    name: StrictStr = Field(description="The name of the column")
    optional: StrictBool = Field(description="Whether the column is optional")
    field_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Unique UUID of the column")
    hint: Optional[StrictStr] = Field(default=None, description="Tooltip hint for users")
    default_value: Optional[Any] = Field(default=None, description="Default value matching the column type")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata")
    multivalue: Optional[StrictBool] = Field(default=None, description="Whether the column accepts multi-value input")
    relation: Optional[DataTableRelation] = None
    __properties: ClassVar[List[str]] = ["type", "name", "optional", "field_id", "hint", "default_value", "metadata", "multivalue", "relation"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['boolean', 'date', 'date_time', 'integer', 'number', 'string', 'file', 'relation']):
            raise ValueError("must be one of enum values ('boolean', 'date', 'date_time', 'integer', 'number', 'string', 'file', 'relation')")
        return value

    @field_validator('field_id')
    def field_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataTableColumnRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of relation
        if self.relation:
            _dict['relation'] = self.relation.to_dict()
        # set to None if default_value (nullable) is None
        # and model_fields_set contains the field
        if self.default_value is None and "default_value" in self.model_fields_set:
            _dict['default_value'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataTableColumnRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "optional": obj.get("optional"),
            "field_id": obj.get("field_id"),
            "hint": obj.get("hint"),
            "default_value": obj.get("default_value"),
            "metadata": obj.get("metadata"),
            "multivalue": obj.get("multivalue"),
            "relation": DataTableRelation.from_dict(obj["relation"]) if obj.get("relation") is not None else None
        })
        return _obj


