# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiClientCreateRequest(BaseModel):
    """
    ApiClientCreateRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the client")
    description: Optional[StrictStr] = Field(default=None, description="Description of the client")
    project_id: Optional[StrictInt] = Field(default=None, description="ID of the project to create the client in")
    api_portal_id: Optional[StrictInt] = Field(default=None, description="ID of the API portal to assign the client")
    email: Optional[StrictStr] = Field(default=None, description="Email address for the client (required if api_portal_id provided)")
    api_collection_ids: List[StrictInt] = Field(description="IDs of API collections to assign to the client")
    api_policy_id: Optional[StrictInt] = Field(default=None, description="ID of the API policy to apply")
    auth_type: StrictStr = Field(description="Authentication method")
    jwt_method: Optional[StrictStr] = Field(default=None, description="JWT signing method (required when auth_type is jwt)")
    jwt_secret: Optional[StrictStr] = Field(default=None, description="HMAC shared secret or RSA public key (required when auth_type is jwt)")
    oidc_issuer: Optional[StrictStr] = Field(default=None, description="Discovery URL for OIDC identity provider")
    oidc_jwks_uri: Optional[StrictStr] = Field(default=None, description="JWKS URL for OIDC identity provider")
    access_profile_claim: Optional[StrictStr] = Field(default=None, description="JWT claim key for access profile identification")
    required_claims: Optional[List[StrictStr]] = Field(default=None, description="List of claims to enforce")
    allowed_issuers: Optional[List[StrictStr]] = Field(default=None, description="List of allowed issuers")
    mtls_enabled: Optional[StrictBool] = Field(default=None, description="Whether mutual TLS is enabled")
    validation_formula: Optional[StrictStr] = Field(default=None, description="Formula to validate client certificates")
    cert_bundle_ids: Optional[List[StrictInt]] = Field(default=None, description="Certificate bundle IDs for mTLS")
    __properties: ClassVar[List[str]] = ["name", "description", "project_id", "api_portal_id", "email", "api_collection_ids", "api_policy_id", "auth_type", "jwt_method", "jwt_secret", "oidc_issuer", "oidc_jwks_uri", "access_profile_claim", "required_claims", "allowed_issuers", "mtls_enabled", "validation_formula", "cert_bundle_ids"]

    @field_validator('auth_type')
    def auth_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['token', 'jwt', 'oauth2', 'oidc']):
            raise ValueError("must be one of enum values ('token', 'jwt', 'oauth2', 'oidc')")
        return value

    @field_validator('jwt_method')
    def jwt_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['hmac', 'rsa']):
            raise ValueError("must be one of enum values ('hmac', 'rsa')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiClientCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiClientCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "project_id": obj.get("project_id"),
            "api_portal_id": obj.get("api_portal_id"),
            "email": obj.get("email"),
            "api_collection_ids": obj.get("api_collection_ids"),
            "api_policy_id": obj.get("api_policy_id"),
            "auth_type": obj.get("auth_type"),
            "jwt_method": obj.get("jwt_method"),
            "jwt_secret": obj.get("jwt_secret"),
            "oidc_issuer": obj.get("oidc_issuer"),
            "oidc_jwks_uri": obj.get("oidc_jwks_uri"),
            "access_profile_claim": obj.get("access_profile_claim"),
            "required_claims": obj.get("required_claims"),
            "allowed_issuers": obj.get("allowed_issuers"),
            "mtls_enabled": obj.get("mtls_enabled"),
            "validation_formula": obj.get("validation_formula"),
            "cert_bundle_ids": obj.get("cert_bundle_ids")
        })
        return _obj


