# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Dict
from typing_extensions import Annotated
from workato_platform_cli.client.workato_api.models.success_response import SuccessResponse
from workato_platform_cli.client.workato_api.models.upsert_project_properties_request import UpsertProjectPropertiesRequest

from workato_platform_cli.client.workato_api.api_client import ApiClient, RequestSerialized
from workato_platform_cli.client.workato_api.api_response import ApiResponse
from workato_platform_cli.client.workato_api.rest import RESTResponseType


class PropertiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def list_project_properties(
        self,
        prefix: Annotated[StrictStr, Field(description="Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned. ")],
        project_id: Annotated[StrictInt, Field(description="Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Dict[str, str]:
        """List project properties

        Returns a list of project-level properties belonging to a specific project in a customer workspace that matches a project_id you specify. You must also include a prefix. For example, if you provide the prefix salesforce_sync., any project property with a name beginning with salesforce_sync., such as salesforce_sync.admin_email, with the project_id you provided is returned. 

        :param prefix: Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned.  (required)
        :type prefix: str
        :param project_id: Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties.  (required)
        :type project_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_project_properties_serialize(
            prefix=prefix,
            project_id=project_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, str]",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_project_properties_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned. ")],
        project_id: Annotated[StrictInt, Field(description="Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Dict[str, str]]:
        """List project properties

        Returns a list of project-level properties belonging to a specific project in a customer workspace that matches a project_id you specify. You must also include a prefix. For example, if you provide the prefix salesforce_sync., any project property with a name beginning with salesforce_sync., such as salesforce_sync.admin_email, with the project_id you provided is returned. 

        :param prefix: Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned.  (required)
        :type prefix: str
        :param project_id: Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties.  (required)
        :type project_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_project_properties_serialize(
            prefix=prefix,
            project_id=project_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, str]",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_project_properties_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned. ")],
        project_id: Annotated[StrictInt, Field(description="Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List project properties

        Returns a list of project-level properties belonging to a specific project in a customer workspace that matches a project_id you specify. You must also include a prefix. For example, if you provide the prefix salesforce_sync., any project property with a name beginning with salesforce_sync., such as salesforce_sync.admin_email, with the project_id you provided is returned. 

        :param prefix: Returns properties that contain the prefix you provided. For example, if the prefix is salesforce_sync. the property salesforce_sync.admin_email is returned.  (required)
        :type prefix: str
        :param project_id: Returns project-level properties that match the project_id you specify. If this parameter is not present, this call returns environment properties.  (required)
        :type project_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_project_properties_serialize(
            prefix=prefix,
            project_id=project_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, str]",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_project_properties_serialize(
        self,
        prefix,
        project_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if prefix is not None:
            
            _query_params.append(('prefix', prefix))
            
        if project_id is not None:
            
            _query_params.append(('project_id', project_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def upsert_project_properties(
        self,
        project_id: Annotated[StrictInt, Field(description="Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties. ")],
        upsert_project_properties_request: UpsertProjectPropertiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SuccessResponse:
        """Upsert project properties

        Upserts project properties belonging to a specific project in a customer workspace that matches a project_id you specify. This endpoint maps to properties based on the names you provide in the request.  ## Property Limits - Maximum number of project properties per project: 1,000 - Maximum length of project property name: 100 characters - Maximum length of project property value: 1,024 characters 

        :param project_id: Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties.  (required)
        :type project_id: int
        :param upsert_project_properties_request: (required)
        :type upsert_project_properties_request: UpsertProjectPropertiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upsert_project_properties_serialize(
            project_id=project_id,
            upsert_project_properties_request=upsert_project_properties_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "ValidationError",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def upsert_project_properties_with_http_info(
        self,
        project_id: Annotated[StrictInt, Field(description="Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties. ")],
        upsert_project_properties_request: UpsertProjectPropertiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SuccessResponse]:
        """Upsert project properties

        Upserts project properties belonging to a specific project in a customer workspace that matches a project_id you specify. This endpoint maps to properties based on the names you provide in the request.  ## Property Limits - Maximum number of project properties per project: 1,000 - Maximum length of project property name: 100 characters - Maximum length of project property value: 1,024 characters 

        :param project_id: Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties.  (required)
        :type project_id: int
        :param upsert_project_properties_request: (required)
        :type upsert_project_properties_request: UpsertProjectPropertiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upsert_project_properties_serialize(
            project_id=project_id,
            upsert_project_properties_request=upsert_project_properties_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "ValidationError",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def upsert_project_properties_without_preload_content(
        self,
        project_id: Annotated[StrictInt, Field(description="Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties. ")],
        upsert_project_properties_request: UpsertProjectPropertiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upsert project properties

        Upserts project properties belonging to a specific project in a customer workspace that matches a project_id you specify. This endpoint maps to properties based on the names you provide in the request.  ## Property Limits - Maximum number of project properties per project: 1,000 - Maximum length of project property name: 100 characters - Maximum length of project property value: 1,024 characters 

        :param project_id: Provide the project ID that contains the project properties you plan to upsert. If this parameter is not present, this call upserts environment properties.  (required)
        :type project_id: int
        :param upsert_project_properties_request: (required)
        :type upsert_project_properties_request: UpsertProjectPropertiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upsert_project_properties_serialize(
            project_id=project_id,
            upsert_project_properties_request=upsert_project_properties_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "ValidationError",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _upsert_project_properties_serialize(
        self,
        project_id,
        upsert_project_properties_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if project_id is not None:
            
            _query_params.append(('project_id', project_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if upsert_project_properties_request is not None:
            _body_params = upsert_project_properties_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


