/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class ConditionEraSqlBuilder<T extends ConditionEra>
extends CriteriaSqlBuilder<T> {
    private static final String CONDITION_ERA_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/conditionEra.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return CONDITION_ERA_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.condition_concept_id";
            }
            case ERA_OCCURRENCES: {
                return "C.condition_occurrence_count";
            }
            case DURATION: {
                return "(DATEDIFF(d,C.condition_era_start_date, C.condition_era_end_date))";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Condition Era:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        String codesetClause = "";
        if (((ConditionEra)criteria).codesetId != null) {
            codesetClause = String.format("where ce.condition_concept_id in (SELECT concept_id from  #Codesets where codeset_id = %d)", ((ConditionEra)criteria).codesetId);
        }
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)codesetClause);
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((ConditionEra)criteria).first != null && ((ConditionEra)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY ce.person_id ORDER BY ce.condition_era_start_date, ce.condition_era_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((ConditionEra)criteria).ageAtStart != null || ((ConditionEra)criteria).ageAtEnd != null || ((ConditionEra)criteria).gender != null && ((ConditionEra)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((ConditionEra)criteria).eraStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.condition_era_start_date", ((ConditionEra)criteria).eraStartDate));
        }
        if (((ConditionEra)criteria).eraEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.condition_era_end_date", ((ConditionEra)criteria).eraEndDate));
        }
        if (((ConditionEra)criteria).occurrenceCount != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.condition_occurrence_count", ((ConditionEra)criteria).occurrenceCount));
        }
        if (((ConditionEra)criteria).eraLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.condition_era_start_date, C.condition_era_end_date)", ((ConditionEra)criteria).eraLength));
        }
        if (((ConditionEra)criteria).ageAtStart != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.condition_era_start_date) - P.year_of_birth", ((ConditionEra)criteria).ageAtStart));
        }
        if (((ConditionEra)criteria).ageAtEnd != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.condition_era_end_date) - P.year_of_birth", ((ConditionEra)criteria).ageAtEnd));
        }
        if (((ConditionEra)criteria).gender != null && ((ConditionEra)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ConditionEra)criteria).gender), (String)",")));
        }
        return whereClauses;
    }
}

