/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;

public class AttributeCheckerFactory
extends BaseCheckerFactory {
    private static final String WARNING_EMPTY_VALUE = "%s in the %s does not have attributes";

    private AttributeCheckerFactory(WarningReporter reporter, String groupName) {
        super(reporter, groupName);
    }

    public static AttributeCheckerFactory getFactory(WarningReporter reporter, String groupName) {
        return new AttributeCheckerFactory(reporter, groupName);
    }

    @Override
    protected Consumer<Criteria> getCheck(Criteria criteria) {
        return c -> {};
    }

    @Override
    protected Consumer<DemographicCriteria> getCheck(DemographicCriteria criteria) {
        Consumer<DemographicCriteria> result = c -> this.checkAttribute("demographic", criteria.age, criteria.gender, criteria.race, criteria.ethnicity, criteria.occurrenceStartDate, criteria.occurrenceEndDate);
        return result;
    }

    private void checkAttribute(String criteriaName, Object ... attributes) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName);
        boolean hasValue = Arrays.stream(attributes).anyMatch(a -> Objects.nonNull(a));
        if (!hasValue) {
            warning.accept(WARNING_EMPTY_VALUE);
        }
    }
}

