import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Body of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#body Function#body}
    */
    readonly body: string;
    /**
    * Automatically drop objects that depend on the function (such as operators or triggers), and in turn all objects that depend on those objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#drop_cascade Function#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * Name of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#name Function#name}
    */
    readonly name: string;
    /**
    * Function return type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#returns Function#returns}
    */
    readonly returns?: string;
    /**
    * Schema where the function is located. If not specified, the provider default schema is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#schema Function#schema}
    */
    readonly schema?: string;
    /**
    * arg block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#arg Function#arg}
    */
    readonly arg?: FunctionArg[] | cdktf.IResolvable;
}
export interface FunctionArg {
    /**
    * An expression to be used as default value if the parameter is not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#default Function#default}
    */
    readonly default?: string;
    /**
    * The argument mode. One of: IN, OUT, INOUT, or VARIADIC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#mode Function#mode}
    */
    readonly mode?: string;
    /**
    * The argument name. The name may be required for some languages or depending on the argument mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#name Function#name}
    */
    readonly name?: string;
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#type Function#type}
    */
    readonly type: string;
}
export declare function functionArgToTerraform(struct?: FunctionArg | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/function postgresql_function}
*/
export declare class Function extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/function postgresql_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionConfig
    */
    constructor(scope: Construct, id: string, config: FunctionConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _returns?;
    get returns(): string;
    set returns(value: string);
    resetReturns(): void;
    get returnsInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _arg?;
    get arg(): FunctionArg[] | cdktf.IResolvable;
    set arg(value: FunctionArg[] | cdktf.IResolvable);
    resetArg(): void;
    get argInput(): cdktf.IResolvable | FunctionArg[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
