# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.8
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import List
from pydantic import BaseModel, Field, StrictBool, conlist
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.noticeboard_entry_type import NoticeboardEntryType
from empire_platform_api_public_client.models.secondary_market_capacity_price_mtu import SecondaryMarketCapacityPriceMtu

class SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails
    """
    type: NoticeboardEntryType = Field(...)
    timescale: AuctionTimescale = Field(...)
    mtu_size: MtuSize = Field(..., alias="mtuSize")
    delivery_day: date = Field(..., alias="deliveryDay", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    direction: BorderDirection = Field(...)
    expires_at: datetime = Field(..., alias="expiresAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    mtus: conlist(SecondaryMarketCapacityPriceMtu) = Field(...)
    is_own: StrictBool = Field(..., alias="isOwn")
    __properties = ["type", "timescale", "mtuSize", "deliveryDay", "direction", "expiresAt", "mtus", "isOwn"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mtus (list)
        _items = []
        if self.mtus:
            for _item in self.mtus:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtus'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails.parse_obj(obj)

        _obj = SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails.parse_obj({
            "type": obj.get("type"),
            "timescale": obj.get("timescale"),
            "mtu_size": obj.get("mtuSize"),
            "delivery_day": obj.get("deliveryDay"),
            "direction": obj.get("direction"),
            "expires_at": obj.get("expiresAt"),
            "mtus": [SecondaryMarketCapacityPriceMtu.from_dict(_item) for _item in obj.get("mtus")] if obj.get("mtus") is not None else None,
            "is_own": obj.get("isOwn")
        })
        return _obj


