# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.8
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.date_time_period import DateTimePeriod
from empire_platform_api_public_client.models.mtu_period import MtuPeriod
from empire_platform_api_public_client.models.public_auction_status import PublicAuctionStatus

class PublicAuction(BaseModel):
    """
    PublicAuction
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId", description="Generated display identifier")
    product_type: AuctionProductType = Field(..., alias="productType")
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    status: PublicAuctionStatus = Field(...)
    processing: StrictBool = Field(...)
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    bidding_period: DateTimePeriod = Field(..., alias="biddingPeriod")
    name: StrictStr = Field(..., description="Human readable name")
    offered_capacity: Optional[StrictInt] = Field(None, alias="offeredCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["id", "displayId", "productType", "borderDirection", "status", "processing", "deliveryPeriod", "biddingPeriod", "name", "offeredCapacity"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PublicAuction:
        """Create an instance of PublicAuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bidding_period
        if self.bidding_period:
            _dict['biddingPeriod'] = self.bidding_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PublicAuction:
        """Create an instance of PublicAuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PublicAuction.parse_obj(obj)

        _obj = PublicAuction.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "product_type": obj.get("productType"),
            "border_direction": obj.get("borderDirection"),
            "status": obj.get("status"),
            "processing": obj.get("processing"),
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "bidding_period": DateTimePeriod.from_dict(obj.get("biddingPeriod")) if obj.get("biddingPeriod") is not None else None,
            "name": obj.get("name"),
            "offered_capacity": obj.get("offeredCapacity")
        })
        return _obj


